/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.TaskUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.DebitNoteRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.DebitNoteServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.DebitNoteServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PayedOrderDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelInstallmentOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiChannelInstallmentOrderMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.GeneralRegxs;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.math.BigDecimal;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import sinosoftgz.utils.data.DateUtils;

public class StanderDebitNoteHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderDebitNoteHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    ApisBusiChannelInstallmentOrderMapper apisBusiChannelInstallmentOrderMapper;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    ApisBusinessService apisBusinessService;
    @Autowired
    TaskUtil taskUtil;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        request.getHeader().setBusinessKey(UUID.fastUUID().toString().replaceAll("-", ""));
        request.getDebitNoteRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        this.verifyNull(request);
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        DebitNoteRequestDTO debitNoteRequestDTO = request.getDebitNoteRequest().getRequestBody();
        ApisBusiChannelInstallmentOrder busiChannelInstallmentOrder = this.verifyOthers(request);
        this.updateApisBusiChannelInstallmentOrder(request, busiChannelInstallmentOrder);
        DebitNoteServiceResponse debitNoteServiceResponse = this.packedDebitNoteServiceResponse(busiChannelInstallmentOrder);
        this.taskUtil.asyncPayNotifyToSales(busiChannelInstallmentOrder);
        return StanderResponse.builder().header(request.getHeader()).debitNoteServiceResponse(debitNoteServiceResponse).build();
    }

    private void updateApisBusiChannelInstallmentOrder(StanderRequest request, ApisBusiChannelInstallmentOrder busiChannelInstallmentOrder) {
        DebitNoteRequestDTO debitNoteRequestDTO = request.getDebitNoteRequest().getRequestBody();
        ApisBusiChannelInstallmentOrder channelInstallmentOrder = new ApisBusiChannelInstallmentOrder();
        channelInstallmentOrder.setId(busiChannelInstallmentOrder.getId());
        UpdateWrapper updateWrapper = new UpdateWrapper((Object)channelInstallmentOrder);
        busiChannelInstallmentOrder.setCurrentPremium(debitNoteRequestDTO.getCurrentPremium());
        busiChannelInstallmentOrder.setPayTime(debitNoteRequestDTO.getPayTime().toInstant().atZone(ZoneOffset.ofHours(8)).toLocalDateTime());
        busiChannelInstallmentOrder.setOrderNo(debitNoteRequestDTO.getOrderNo());
        this.apisBusiChannelInstallmentOrderMapper.update((Object)busiChannelInstallmentOrder, (Wrapper)updateWrapper);
    }

    public DebitNoteServiceResponse packedDebitNoteServiceResponse(ApisBusiChannelInstallmentOrder busiChannelInstallmentOrder) throws ApisBusinessException {
        DebitNoteServiceResponse debitNoteServiceResponse = DebitNoteServiceResponse.builder().build();
        debitNoteServiceResponse.setResponseHead(ResponseHeadDTO.builder().status(1).appCode(ChannelErrorCodeEnum.ERR_C10002.getKey()).appMessage(ChannelErrorCodeEnum.ERR_C10002.getValue()).build());
        DebitNoteServiceResponseDTO responseBody = DebitNoteServiceResponseDTO.builder().build();
        responseBody.setPayCount(busiChannelInstallmentOrder.getPayCount());
        responseBody.setPolicyRef(busiChannelInstallmentOrder.getPolicyNo());
        BigDecimal sumPremium = this.apisBusiChannelInstallmentOrderMapper.getSumPremium(responseBody.getPolicyRef());
        responseBody.setTotalPremium(ObjectUtil.isNotEmpty((Object)sumPremium) ? sumPremium : new BigDecimal(0));
        List apisBusiChannelInstallmentOrderList = this.apisBusiChannelInstallmentOrderMapper.getPayedOrderList(responseBody.getPolicyRef());
        ArrayList<PayedOrderDTO> payOrderList = new ArrayList<PayedOrderDTO>();
        for (ApisBusiChannelInstallmentOrder channelInstallmentOrder : apisBusiChannelInstallmentOrderList) {
            PayedOrderDTO payedOrderDTO = PayedOrderDTO.builder().build();
            BeanUtils.copyProperties((Object)channelInstallmentOrder, (Object)payedOrderDTO);
            payedOrderDTO.setCurrentPayNo(String.valueOf(channelInstallmentOrder.getCurrentPayNo()));
            payedOrderDTO.setPayTime(channelInstallmentOrder.getPayTime());
            payOrderList.add(payedOrderDTO);
        }
        responseBody.setPayedOrderList(payOrderList);
        debitNoteServiceResponse.setResponseBody(responseBody);
        return debitNoteServiceResponse;
    }

    public void verifyNull(StanderRequest request) throws ApisBusinessException {
        HashMap resultMap = new HashMap();
        String[] debitNoteArray = new String[]{"PolicyNo", "OrderNo", "ChannelCode", "PayCount", "PayTime", "CurrentPremium", "CurrentPayNo"};
        Object[] debitNoteEnumArray = new Object[]{ErrorNullValueCodeEnum.ERR_N80003, ErrorNullValueCodeEnum.ERR_N80001, ErrorNullValueCodeEnum.ERR_N80002, ErrorNullValueCodeEnum.ERR_N80004, ErrorNullValueCodeEnum.ERR_N80005, ErrorNullValueCodeEnum.ERR_N80006, ErrorNullValueCodeEnum.ERR_N80007};
        DebitNoteRequestDTO debitNoteRequest = request.getDebitNoteRequest().getRequestBody();
        this.dataCompletionUtil.checkNotNull((Object)debitNoteRequest, debitNoteArray, debitNoteEnumArray, resultMap);
        if (resultMap.size() > 0) {
            ErrorNullValueCodeEnum errorNullValueCodeEnum = (ErrorNullValueCodeEnum)DataCompletionUtil.castToClass(ErrorNullValueCodeEnum.class, resultMap.get(1));
            this.log.error("\n\u6263\u6b3e\u901a\u77e5 \u6821\u9a8c\u4e0d\u901a\u8fc7\uff1a{}", (Object)errorNullValueCodeEnum.getValue());
            throw ApisDataCompletionException.builder().errorCode(errorNullValueCodeEnum.getKey()).message(errorNullValueCodeEnum.getValue()).build();
        }
    }

    public ApisBusiChannelInstallmentOrder verifyOthers(StanderRequest request) throws ApisBusinessException {
        DebitNoteRequestDTO debitNoteRequestDTO = request.getDebitNoteRequest().getRequestBody();
        this.verifyPolicyStatus(request);
        Date payTime = debitNoteRequestDTO.getPayTime();
        if (!DateUtils.dateToStr((Date)payTime, (String)"yyyyMMddHHmmss").matches(GeneralRegxs.DateFormat)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10009.getValue().replaceFirst("##", "payTime").replace("##", "yyyyMMddHHmmss"), ChannelErrorCodeEnum.ERR_C10009.getKey());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_no", (Object)debitNoteRequestDTO.getOrderNo());
        List list = this.apisBusiChannelInstallmentOrderMapper.selectList((Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)list) || list.size() > 0) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10289.getValue(), ChannelErrorCodeEnum.ERR_C10289.getKey());
        }
        QueryWrapper queryWrapperT = new QueryWrapper();
        queryWrapperT.eq((Object)"policy_no", (Object)debitNoteRequestDTO.getPolicyNo());
        queryWrapperT.eq((Object)"current_pay_no", (Object)debitNoteRequestDTO.getCurrentPayNo());
        queryWrapperT.eq((Object)"channel_code", (Object)debitNoteRequestDTO.getChannelCode());
        queryWrapperT.eq((Object)"creator", (Object)request.getHeader().getUserCode());
        ApisBusiChannelInstallmentOrder busiChannelInstallmentOrder = (ApisBusiChannelInstallmentOrder)this.apisBusiChannelInstallmentOrderMapper.selectOne((Wrapper)queryWrapperT);
        if (ObjectUtil.isEmpty((Object)busiChannelInstallmentOrder)) {
            this.log.warn("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5206\u671f\u4fe1\u606f");
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10290.getValue(), ChannelErrorCodeEnum.ERR_C10290.getKey());
        }
        if (Integer.parseInt(debitNoteRequestDTO.getPayCount()) != busiChannelInstallmentOrder.getPayCount()) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10327.getValue(), ChannelErrorCodeEnum.ERR_C10327.getKey());
        }
        if (ObjectUtil.isNotEmpty((Object)busiChannelInstallmentOrder.getPayTime())) {
            this.log.warn("\u8be5\u671f\u6b21\u8d39\u7528\u5df2\u7ecf\u7f34\u6e05");
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10292.getValue().replaceFirst("##", debitNoteRequestDTO.getPolicyNo()).replace("##", String.valueOf(debitNoteRequestDTO.getCurrentPayNo())), ChannelErrorCodeEnum.ERR_C10292.getKey());
        }
        QueryWrapper queryWrapperTs = new QueryWrapper();
        queryWrapperTs.eq((Object)"policy_no", (Object)debitNoteRequestDTO.getPolicyNo());
        queryWrapperTs.eq((Object)"channel_code", (Object)debitNoteRequestDTO.getChannelCode());
        queryWrapperTs.apply(" current_pay_no<{0} and pay_time is null", new Object[]{debitNoteRequestDTO.getCurrentPayNo()});
        List rlist = this.apisBusiChannelInstallmentOrderMapper.selectList((Wrapper)queryWrapperTs);
        if (ObjectUtil.isNotEmpty((Object)rlist) && rlist.size() > 0) {
            this.log.error(ChannelErrorCodeEnum.ERR_C10309.getValue());
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10309.getValue(), ChannelErrorCodeEnum.ERR_C10309.getKey());
        }
        if (debitNoteRequestDTO.getCurrentPremium().compareTo(busiChannelInstallmentOrder.getCurrentPremium()) != 0) {
            this.log.error(ChannelErrorCodeEnum.ERR_C10291.getValue());
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10291.getValue(), ChannelErrorCodeEnum.ERR_C10291.getKey());
        }
        return busiChannelInstallmentOrder;
    }

    private void verifyPolicyStatus(StanderRequest request) throws ApisBusinessException {
        DebitNoteRequestDTO debitNoteRequestDTO = request.getDebitNoteRequest().getRequestBody();
        PolicyDetailServiceRequest policyDetailServiceRequest = PolicyDetailServiceRequest.builder().build();
        policyDetailServiceRequest.setRequestHead(request.getDebitNoteRequest().getRequestHead());
        PolicyDetailRequestDTO requestBody = PolicyDetailRequestDTO.builder().build();
        requestBody.setPolicyNo(debitNoteRequestDTO.getPolicyNo());
        requestBody.setBusinessNature2("all");
        requestBody.setOperateCode(request.getHeader().getUserCode());
        policyDetailServiceRequest.setRequestBody(requestBody);
        request.setPolicyDetailServiceRequest(policyDetailServiceRequest);
        StanderResponse policyDetail = this.apisBusinessService.execute("policyDetail", request);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"policy_no", (Object)debitNoteRequestDTO.getPolicyNo());
        if (ObjectUtil.isNotEmpty((Object)policyDetail) && 1 == policyDetail.getPolicyDetailResponse().getResponseHead().getStatus()) {
            if (ObjectUtil.isNotEmpty((Object)policyDetail.getPolicyDetailResponse().getResponseBody().getPolicy())) {
                String policyStatus = policyDetail.getPolicyDetailResponse().getResponseBody().getPolicy().getMain().getPolicyStatus();
                if ("2".equals(policyStatus)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10127.getValue(), ChannelErrorCodeEnum.ERR_C10127.getKey());
                }
                if ("3".equals(policyStatus)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10025.getValue(), ChannelErrorCodeEnum.ERR_C10025.getKey());
                }
            } else {
                ApisBusiChannelOrder apisBusiChannelOrder = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
                if (ObjectUtil.isEmpty((Object)apisBusiChannelOrder) || !"04".equals(apisBusiChannelOrder.getStatus())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10287.getValue(), ChannelErrorCodeEnum.ERR_C10287.getKey());
                }
            }
        } else {
            ApisBusiChannelOrder apisBusiChannelOrder = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
            if (ObjectUtil.isEmpty((Object)apisBusiChannelOrder) || !"04".equals(apisBusiChannelOrder.getStatus())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10287.getValue(), ChannelErrorCodeEnum.ERR_C10287.getKey());
            }
        }
    }
}

