/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.executor.CommonsValidateUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.EmployeeImageUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.FxqCustomerCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.QuotePriceValidate;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RiskManagementCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.ThyroidUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.ZybxRiskManagementCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyNoGetRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyNoGetRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiReqmsgLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.constants.ApisCommonConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderEmployeeQuotePriceHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderEmployeeQuotePriceHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    HttpRequestService httpRequestService;
    @Autowired
    QuotePriceValidate quotePriceValidate;
    @Autowired
    ThyroidUtil thyroidUtil;
    @Autowired
    ApisBusiReqmsgLogMapper apisBusiReqmsgLogMapper;
    @Autowired
    private RiskManagementCheckUtil riskManagementCheckUtil;
    @Autowired
    private CommonsValidateUtil commonsValidateUtil;
    private ZybxRiskManagementCheckUtil zybxRiskManagementCheckUtil;
    @Autowired
    private FxqCustomerCheckUtil fxqCustomerCheckUtil;
    @Autowired
    private EmployeeImageUploadUtil employeeImageUploadUtil;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    private final String REQUEST_ENTITY_QUOTEPRICE = "quotePriceServiceRequest";
    private final String RESPONSE_ENTITY_QUOTEPRICE = "policyListQueryResponse";
    private final String RESPONSE_ENTITY_PLOICYNOGET = "policyNoGetResponse";
    private final String RESPONSE_ENTITY_PLOICYSUBMIT = "policySubmitResponse";
    private static String EMPLOYEE_COUNT_FLAG = "employee_count_flag";
    private static final String CLAUSE_LIABILITY_KEY_WORD = "\u6761\u6b3e\u8d23\u4efb\u4fe1\u606f\u4e2d";
    public static Map<String, String> underWriteFlagMap = new HashMap();

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        TimeInterval timer = DateUtil.timer();
        request.getQuotePriceServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        BaseApisParamUtil.verificationRequest((StanderRequest)request, (String)"quotePriceServiceRequest");
        this.dataCompletionUtil.verifyRepeatRequest(request);
        this.employeeImageUploadUtil.dataCompletion(request);
        MainDTO mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        request.getQuotePriceServiceRequest().getRequestHead().setConsumerSeqNo(request.getHeader().getUserCode() + mainDTO.getOrderNo());
        this.log.warn("\u6570\u636e\u8865\u5168\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.employeeImageUploadUtil.validateRquest(request);
        this.log.warn("\u51fa\u5355\u89c4\u5219\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.log.warn("\u4fdd\u8d39\u8ba1\u7b97\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().setPlanList(null);
        this.dataCompletionUtil.riskDataCompletion(request);
        this.dataCompletionUtil.fxqDataCompletion(request);
        this.commonsValidateUtil.executorValidate(request, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        QuotePriceServiceResponse quotePriceServiceResponse;
        block34: {
            if (ObjectUtils.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getEmployeeInformation())) {
                List itemEmployeeDTOS = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getEmployeeInformation().getEmployeeInformationList();
                ApisChannelConfigs channelConfigsCondition = new ApisChannelConfigs();
                channelConfigsCondition.setConfigCode(EMPLOYEE_COUNT_FLAG);
                channelConfigsCondition.setChannelCode(request.getHeader().getChannelCode());
                String employeeCount = null;
                ApisChannelConfigs channelConfigs = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
                if (ObjectUtil.isNotEmpty((Object)channelConfigs)) {
                    employeeCount = channelConfigs.getConfigValue();
                }
                request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getEmployeeInformation().setIsExistImgId(ApisCommonConstantsEnum.MASTER_POLICY_FALSE.getKey());
                if (StringUtils.isBlank((CharSequence)employeeCount)) {
                    employeeCount = "50";
                }
                if (itemEmployeeDTOS.size() > Integer.parseInt(employeeCount)) {
                    request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getEmployeeInformation().setIsExistImgId(ApisCommonConstantsEnum.MASTER_POLICY_TRUE.getKey());
                    String fileAddress = this.employeeImageUploadUtil.employeeListUpload(JSON.toJSONString((Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getEmployeeInformation()), request.getHeader().getBusinessKey(), request);
                    if (StringUtils.isBlank((CharSequence)fileAddress)) {
                        throw ApisDataCompletionException.builder().errorCode(ErrorNullValueCodeEnum.ERR_N11001.getKey()).message("\u96c7\u5458\u6e05\u5355\u4e0a\u4f20\u5f71\u50cf\u5931\u8d25").build();
                    }
                    request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getEmployeeInformation().setEmployeeInformationList(null);
                    request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getEmployeeInformation().setAutoSubmit(ApisCommonConstantsEnum.MASTER_POLICY_TRUE.getKey());
                    request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getEmployeeInformation().setImgId(fileAddress);
                    request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getEmployeeInformation().setIsExistImgId(ApisCommonConstantsEnum.MASTER_POLICY_TRUE.getKey());
                }
            }
            ApisBusiChannelOrder apisBusinessChannelOrder = new ApisBusiChannelOrder();
            apisBusinessChannelOrder.setRequestTime(LocalDateTime.now());
            apisBusinessChannelOrder.setCreateTime(new Date());
            quotePriceServiceResponse = QuotePriceServiceResponse.builder().build();
            Double sumPremium = null;
            Double sumAmount = null;
            MainDTO mainDTO = MainDTO.builder().build();
            try {
                apisBusinessChannelOrder.setStatus("01");
                String businessNo = "";
                String policyStatus = "70";
                Date startTime = new Date();
                StanderResponse quotePriceResponse = this.coreInsureApi.quotePrice(request);
                BaseApisParamUtil.verificationResponse((StanderResponse)quotePriceResponse, (String)"policyListQueryResponse");
                mainDTO = quotePriceResponse.getPolicyListQueryResponse().getResponseBody().getMain();
                MainDTO requestMainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
                if (StringUtils.isEmpty((CharSequence)requestMainDTO.getJFeeFlag())) {
                    requestMainDTO.setJFeeFlag(mainDTO.getJFeeFlag());
                }
                if (StringUtils.isEmpty((CharSequence)requestMainDTO.getStepFlag())) {
                    requestMainDTO.setStepFlag(this.dataCompletionUtil.getStepFlag(request.getHeader().getUserCode()));
                }
                apisBusinessChannelOrder.setPayType(mainDTO.getJFeeFlag());
                if (StringUtils.isNotEmpty((CharSequence)requestMainDTO.getOutPaymentType()) && "0".equals(mainDTO.getJFeeFlag())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10471.getValue(), ChannelErrorCodeEnum.ERR_C10471.getKey());
                }
                sumPremium = mainDTO.getSumPremium();
                sumAmount = mainDTO.getSumAmount();
                StanderResponse policySubmitResponse = null;
                apisBusinessChannelOrder.setProposalTime(LocalDateTime.now());
                apisBusinessChannelOrder.setProposalNo(mainDTO.getProposalNo());
                mainDTO.setOutPaymentType(requestMainDTO.getOutPaymentType() == null ? "" : requestMainDTO.getOutPaymentType());
                apisBusinessChannelOrder.setStatus("02");
                request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().setSumPremium(mainDTO.getSumPremium());
                apisBusinessChannelOrder.setNotifyUrl(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getNotifyUrl());
                apisBusinessChannelOrder.setGiftType(mainDTO.getGiftType());
                Map map = this.policyNoGetService(apisBusinessChannelOrder, request, mainDTO);
                String obj = (String)DataCompletionUtil.castToClass(String.class, map.get("policyStatus"));
                policyStatus = StringUtils.isEmpty((CharSequence)obj) ? "70" : obj;
                businessNo = (String)DataCompletionUtil.castToClass(String.class, map.get("businessNo"));
                if ("0".equals(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getEmployeeInformation().getIsExistImgId())) {
                    String underWriteFlag;
                    String prePayFlag;
                    QuotePriceDTO quotePriceDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
                    if (ObjectUtils.isNotEmpty((Object)quotePriceDTO.getFileList())) {
                        this.employeeImageUploadUtil.syncUpload(quotePriceDTO.getFileList(), request.getHeader().getUserCode(), mainDTO.getProposalNo());
                        quotePriceDTO.setImageList(null);
                    }
                    if ("0".equals(requestMainDTO.getJFeeFlag())) {
                        if ("1".equals(requestMainDTO.getStepFlag())) {
                            policySubmitResponse = this.coreInsureApi.policySubmit(this.dataCompletionUtil.packagePolicyConfirmRequestData(mainDTO, request, businessNo, "P"));
                            BaseApisParamUtil.verificationResponse((StanderResponse)policySubmitResponse, (String)"policySubmitResponse");
                            businessNo = policySubmitResponse.getPolicySubmitResponse().getResponseBody().getBusinessNo();
                            if (StringUtils.isEmpty((CharSequence)businessNo) || businessNo.startsWith("T")) {
                                businessNo = (String)DataCompletionUtil.castToClass(String.class, map.get("businessNo"));
                            }
                            policyStatus = StringUtils.isNotEmpty((CharSequence)requestMainDTO.getOutPaymentType()) && "1".equals(mainDTO.getJFeeFlag()) ? "70" : ("1".equals(prePayFlag = policySubmitResponse.getPolicySubmitResponse().getResponseBody().getPrePayFlag()) || "0".equals(mainDTO.getJFeeFlag()) ? "70" : "60");
                        }
                    } else if ("1".equals(requestMainDTO.getJFeeFlag()) && "1".equals(requestMainDTO.getStepFlag())) {
                        policySubmitResponse = this.coreInsureApi.policySubmit(this.dataCompletionUtil.packagePolicyConfirmRequestData(mainDTO, request, (String)DataCompletionUtil.castToClass(String.class, map.get("businessNo")), "P"));
                        BaseApisParamUtil.verificationResponse((StanderResponse)policySubmitResponse, (String)"policySubmitResponse");
                        businessNo = policySubmitResponse.getPolicySubmitResponse().getResponseBody().getBusinessNo();
                        if (StringUtils.isEmpty((CharSequence)businessNo) || businessNo.startsWith("T")) {
                            businessNo = (String)DataCompletionUtil.castToClass(String.class, map.get("businessNo"));
                        }
                        policyStatus = StringUtils.isNotEmpty((CharSequence)requestMainDTO.getOutPaymentType()) && "1".equals(mainDTO.getJFeeFlag()) ? "70" : ("1".equals(prePayFlag = policySubmitResponse.getPolicySubmitResponse().getResponseBody().getPrePayFlag()) || "0".equals(mainDTO.getJFeeFlag()) ? "70" : "60");
                    }
                    if (!"1".equals(underWriteFlag = policySubmitResponse.getPolicySubmitResponse().getResponseBody().getUnderwriteFlag()) && !"3".equals(underWriteFlag)) {
                        policyStatus = (String)underWriteFlagMap.get(underWriteFlag);
                    }
                } else {
                    policyStatus = "14";
                }
                if (StringUtils.isNotEmpty((CharSequence)businessNo)) {
                    apisBusinessChannelOrder.setPolicyNo(businessNo);
                    apisBusinessChannelOrder.setPolicyTime(LocalDateTime.now());
                    if ("70".equals(policyStatus)) {
                        apisBusinessChannelOrder.setStatus("04");
                    }
                    if (ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPayPlanList()) && request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPayPlanList().size() > 1) {
                        this.dataCompletionUtil.insertInstallmentOrder(request, businessNo);
                    }
                    if (ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getIsThyriod()) && request.getQuotePriceServiceRequest().getRequestBody().getIsThyriod().booleanValue()) {
                        this.thyroidUtil.updateAddressMsg(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getFLThyroidDTO().getSerialNumber(), request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getRiskInfo(), businessNo);
                    }
                }
                ResponseHeadDTO responseHeadDTO = ResponseHeadDTO.builder().build();
                responseHeadDTO.setConsumerSeqNo(request.getQuotePriceServiceRequest().getRequestHead().getConsumerSeqNo());
                QuotePriceServiceResponseDTO responseBody = QuotePriceServiceResponseDTO.builder().build();
                if (StringUtils.isNotEmpty((CharSequence)businessNo)) {
                    responseBody.setPolicyStatus(policyStatus);
                    responseBody.setTotalPremium(sumPremium);
                    String agencyPolicyRef = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getOrderNo();
                    responseBody.setAgencyPolicyRef(agencyPolicyRef);
                    responseBody.setBusinessNo(businessNo);
                    responseBody.setSumAmount(sumAmount);
                    responseBody.setProposalNo(mainDTO.getProposalNo());
                    responseBody.setInsuredPremiumList(this.dataCompletionUtil.packagedInsuredPremiumList(request));
                    if (ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCompanyInfo())) {
                        responseBody.setCompanyInfo(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCompanyInfo());
                    }
                    if (ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPayPlanList()) && request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPayPlanList().size() > 1) {
                        responseBody.setPayPlanList(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPayPlanList());
                    }
                    responseBody.setEffectiveDate(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getStartDate());
                    responseBody.setExpireDate(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getEndDate());
                    quotePriceServiceResponse.setResponseBody(responseBody);
                    responseHeadDTO.setStatus(1);
                    quotePriceServiceResponse.setResponseHead(responseHeadDTO);
                    this.dataCompletionUtil.insertReqMsg(request, quotePriceServiceResponse, businessNo, "2");
                    if (policyStatus.equals("70")) {
                        this.apisBusiReqmsgLogMapper.deleteApisBusiReqmsgLog(businessNo, "1");
                    }
                    break block34;
                }
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10054.getValue(), ChannelErrorCodeEnum.ERR_C10054.getKey());
            }
            catch (ApisBusinessException e) {
                String errMsg = e.getMessage();
                if (errMsg.indexOf(CLAUSE_LIABILITY_KEY_WORD) != -1) {
                    String rationCode = ((ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getGoodsCode();
                    String rationName = ((ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getGoodsName();
                    errMsg = "" + rationName + "\u3010" + rationCode + "\u3011\u4ea7\u54c1\u6b63\u5feb\u9a6c\u52a0\u97ad\u4e0a\u67b6\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8d2d\u4e70\u3002";
                }
                throw new ApisBusinessException(errMsg, e.getErrorCode());
            }
            finally {
                apisBusinessChannelOrder.setFinishedTime(LocalDateTime.now());
                if (ObjectUtil.isNotEmpty(sumPremium)) {
                    apisBusinessChannelOrder.setPremium(new BigDecimal(sumPremium));
                }
                if (ObjectUtil.isNotEmpty((Object)mainDTO.getSumAmount())) {
                    apisBusinessChannelOrder.setAmount(new BigDecimal(mainDTO.getSumAmount()));
                }
                Date startDate = new Date();
                this.dataCompletionUtil.insertApisBusinessChannelOrder(request, apisBusinessChannelOrder);
                this.log.warn("\u65b0\u589e\u6e20\u9053\u8ba2\u5355\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
            }
        }
        return StanderResponse.builder().header(request.getHeader()).quotePriceServiceResponse(quotePriceServiceResponse).build();
    }

    public Map policyNoGetService(ApisBusiChannelOrder apisBusiChannelOrder, StanderRequest request, MainDTO mainDTO) throws ApisBusinessException {
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        String businessNo = "";
        if (StringUtils.isNotEmpty((CharSequence)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getPolicyRef())) {
            businessNo = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getPolicyRef();
        } else {
            StanderResponse policyNoGetResponse = this.coreInsureApi.policyNoGet(StanderRequest.builder().header(request.getHeader()).policyNoGetRequest(PolicyNoGetRequest.builder().requestHead(request.getQuotePriceServiceRequest().getRequestHead()).requestBody(PolicyNoGetRequestDTO.builder().proposalNo(mainDTO.getProposalNo()).build()).build()).build());
            BaseApisParamUtil.verificationResponse((StanderResponse)policyNoGetResponse, (String)"policyNoGetResponse");
            businessNo = policyNoGetResponse.getPolicyNoGetResponse().getResponseBody().getPrePolicyNo();
        }
        apisBusiChannelOrder.setStatus("05");
        resultMap.put("businessNo", businessNo);
        if ("1".equals(mainDTO.getJFeeFlag())) {
            resultMap.put("policyStatus", "60");
        } else {
            resultMap.put("policyStatus", "30");
        }
        this.dataCompletionUtil.insertReqMsg(request, null, businessNo, "1");
        return resultMap;
    }

    static {
        underWriteFlagMap.put("2", "12");
        underWriteFlagMap.put("4", "14");
        underWriteFlagMap.put("5", "15");
    }
}

