/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl.EPolicyDownServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PrintQueryVoucherImgURLRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PrintQueryVoucherImgURLRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationMainService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderEmployeeVoucherHandler
implements BusinessHandler {
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    private ApisPfpRationMainService apisPfpRationMainService;
    @Autowired
    private DataCompletionUtil dataCompletionUtil;
    @Autowired
    private EPolicyDownServiceImpl ePolicyDownService;
    private static final String POLICY_RES_TYPE_URL = "Url";
    private static final String POLICY_RES_TYPE_STREAM = "DataStream";
    private static final String DECLARATION_VOUCHER_REQUEST = "declarationVoucherRequest";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        BaseApisParamUtil.verificationRequest((StanderRequest)request, (String)DECLARATION_VOUCHER_REQUEST);
        if (ObjectUtil.isEmpty((Object)request.getHeader())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "header"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)request.getHeader().getChannelCode())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "channelCode"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)request.getHeader().getUserCode())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "userCode"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)request.getHeader().getBusinessKey())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "businessKey"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        PrintQueryVoucherImgURLRequest printQueryVoucherImgUrlRequest = request.getPrintQueryVoucherImgUrlRequest();
        PrintQueryVoucherImgURLRequestDTO dvRequestBody = printQueryVoucherImgUrlRequest.getRequestBody();
        if (ObjectUtil.isEmpty((Object)dvRequestBody.getPolicyNo())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "policyNo"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)dvRequestBody.getType())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "type"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)dvRequestBody.getRepsType())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "repsType"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)dvRequestBody.getServiceNo()) && ObjectUtil.isEmpty((Object)dvRequestBody.getVoucherNo())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "VoucherNo,ServiceNo\u540c\u65f6"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        this.dataCompletionUtil.getPolicyDetailWithoutInsureds(request, dvRequestBody.getPolicyNo(), false);
        printQueryVoucherImgUrlRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        dvRequestBody.setBusinessNo(dvRequestBody.getPolicyNo());
        if (StringUtils.isNotBlank((CharSequence)dvRequestBody.getVoucherNo())) {
            ArrayList<String> voucherNos = new ArrayList<String>();
            voucherNos.add(dvRequestBody.getVoucherNo());
            dvRequestBody.setVoucherNos(voucherNos);
        }
        request.setPrintQueryVoucherImgUrlRequest(printQueryVoucherImgUrlRequest);
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        return this.coreInsureApi.printQueryVoucherImgUrl(request);
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        if (response == null || response.getPrintQueryImgUrlResponse() == null) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00002.getKey(), ErrorNullValueCodeEnum.ERR_N00002.getValue());
        }
        if (ObjectUtil.isNotEmpty((Object)response.getPrintQueryImgUrlResponse().getResponseBody()) && POLICY_RES_TYPE_URL.equals(request.getPrintQueryVoucherImgUrlRequest().getRequestBody().getRepsType())) {
            response.getDeclarationVoucherResponse().getResponseBody().setVoucherUrl(this.ePolicyDownService.aesEncryptEmpVoucherUrl(response.getPrintQueryImgUrlResponse().getResponseBody().getImgUrl()));
        }
        return response;
    }
}

