/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.executor.CommonsValidateUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.QuotePriceValidate;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.BusinessConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InvoiceInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemCargoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemKindDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RiskInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponsePP;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiReqmsgLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.RiskCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderFreightHYQuotePriceHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderFreightHYQuotePriceHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    QuotePriceValidate quotePriceValidate;
    @Autowired
    ApisBusiReqmsgLogMapper apisBusiReqmsgLogMapper;
    @Autowired
    private CommonsValidateUtil commonsValidateUtil;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    private static String MIN_PREMIUM_AGENT_CODE = "min_premium_agent_code";
    private static String operator_code_default = "BR200098_01";
    private final String REQUEST_ENTITY_QUOTEPRICE = "quotePriceServiceRequest";
    private final String RESPONSE_ENTITY_QUOTEPRICE = "policyListQueryResponse";
    private static final String CLAUSE_LIABILITY_KEY_WORD = "\u6761\u6b3e\u8d23\u4efb\u4fe1\u606f\u4e2d";
    private static final String INVOICE_TYPE_SPECIAL_TICKET = "2";
    private static final String INVOICE_TYPE_ELECTRONIC_TICKET = "1";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        TimeInterval timer = DateUtil.timer();
        request.getQuotePriceServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        BaseApisParamUtil.verificationRequest((StanderRequest)request, (String)"quotePriceServiceRequest");
        this.dataCompletionUtil.verifyRepeatRequest(request);
        this.validNull(request);
        request.getQuotePriceServiceRequest().getRequestBody().setIsOptional(Boolean.valueOf(true));
        this.dataCompletionUtil.dataCompletion(request);
        MainDTO mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        request.getQuotePriceServiceRequest().getRequestHead().setConsumerSeqNo(request.getHeader().getUserCode() + mainDTO.getOrderNo());
        this.log.warn("\u6570\u636e\u8865\u5168\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        if (StringUtils.isBlank((CharSequence)((AppliClientDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getAppliClient().get(0)).getMobile()) && StringUtils.isBlank((CharSequence)((AppliClientDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getAppliClient().get(0)).getContactPhone())) {
            ((AppliClientDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getAppliClient().get(0)).setMobile(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getInvoiceInfo().getMobilePhone());
            ((AppliClientDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getAppliClient().get(0)).setContactPhone(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getInvoiceInfo().getMobilePhone());
        }
        this.quotePriceValidate.validateRquest(request);
        this.log.warn("\u51fa\u5355\u89c4\u5219\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.dataCompletionUtil.settleInsuredFlag(request);
        this.dataCompletionUtil.calculateTotalPremium(request);
        ApisChannelConfigs channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setConfigCode(MIN_PREMIUM_AGENT_CODE);
        String operateCodeConfig = null;
        Double sumPremium = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getSumPremium();
        String operateCode = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getOperateCode();
        ApisChannelConfigs channelConfigs = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        if (ObjectUtil.isNotEmpty((Object)channelConfigs)) {
            operateCodeConfig = channelConfigs.getConfigValue();
        }
        if (ObjectUtil.isEmpty(operateCodeConfig)) {
            operateCodeConfig = operator_code_default;
        }
        if (operateCodeConfig.equals(operateCode) && sumPremium < 50.0) {
            request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().setSumPremium(Double.valueOf(50.0));
        }
        ItemCargoDTO itemCargoDTO = (ItemCargoDTO)((ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getItemCargo().get(0);
        if (StringUtils.isBlank((CharSequence)mainDTO.getMarineType())) {
            if (RiskCodeEnum.RISK_0013.getCode().equals(mainDTO.getRiskCode())) {
                mainDTO.setMarineType("31");
            } else if (RiskCodeEnum.RISK_0018.getCode().equals(mainDTO.getRiskCode())) {
                mainDTO.setMarineType("21");
            } else if (RiskCodeEnum.RISK_0019.getCode().equals(mainDTO.getRiskCode())) {
                mainDTO.setMarineType("13");
            } else if (RiskCodeEnum.RISK_0020.getCode().equals(mainDTO.getRiskCode())) {
                mainDTO.setMarineType("31");
            } else if (RiskCodeEnum.RISK_0021.getCode().equals(mainDTO.getRiskCode())) {
                mainDTO.setMarineType("13");
            } else if (RiskCodeEnum.RISK_0022.getCode().equals(mainDTO.getRiskCode())) {
                mainDTO.setMarineType("31");
            } else if (RiskCodeEnum.RISK_0023.getCode().equals(mainDTO.getRiskCode())) {
                mainDTO.setMarineType("31");
            }
        }
        if ("21".equals(mainDTO.getMarineType()) && INVOICE_TYPE_ELECTRONIC_TICKET.equals(itemCargoDTO.getConveyanceType())) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(mainDTO.getStartDate());
            calendar.add(5, BusinessConstants.GENERAL_CORRECT_APPLICATION_MAX);
            long time1 = calendar.getTimeInMillis();
            if (time1 < mainDTO.getInputDate().getTime()) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10706.getValue(), ChannelErrorCodeEnum.ERR_C10706.getKey());
            }
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(mainDTO.getInputDate());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            if (mainDTO.getStartDate().getTime() < calendar.getTime().getTime()) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10707.getValue(), ChannelErrorCodeEnum.ERR_C10707.getKey());
            }
        }
        this.log.warn("\u4fdd\u8d39\u8ba1\u7b97\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().setPlanList(null);
        this.dataCompletionUtil.riskDataCompletion(request);
        this.dataCompletionUtil.fxqDataCompletion(request);
        this.commonsValidateUtil.executorValidate(request, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        QuotePriceServiceResponse quotePriceServiceResponse;
        block19: {
            ApisBusiChannelOrder apisBusinessChannelOrder = new ApisBusiChannelOrder();
            apisBusinessChannelOrder.setRequestTime(LocalDateTime.now());
            apisBusinessChannelOrder.setCreateTime(new Date());
            quotePriceServiceResponse = QuotePriceServiceResponse.builder().build();
            Double sumPremium = null;
            MainDTO mainDTO = MainDTO.builder().build();
            try {
                apisBusinessChannelOrder.setStatus("01");
                String businessNo = "";
                String policyStatus = "02";
                StanderResponse quotePriceResponse = this.coreInsureApi.quotePrice(request);
                BaseApisParamUtil.verificationResponse((StanderResponse)quotePriceResponse, (String)"policyListQueryResponse");
                mainDTO = quotePriceResponse.getPolicyListQueryResponse().getResponseBody().getMain();
                MainDTO requestMainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
                if (StringUtils.isEmpty((CharSequence)requestMainDTO.getJFeeFlag())) {
                    requestMainDTO.setJFeeFlag(mainDTO.getJFeeFlag());
                }
                request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getInvoiceInfo().setInvoiceAmount(mainDTO.getSumPremium());
                if (StringUtils.isEmpty((CharSequence)requestMainDTO.getStepFlag())) {
                    requestMainDTO.setStepFlag(this.dataCompletionUtil.getStepFlag(request.getHeader().getUserCode()));
                }
                apisBusinessChannelOrder.setPayType(mainDTO.getJFeeFlag());
                if (StringUtils.isNotEmpty((CharSequence)requestMainDTO.getOutPaymentType()) && "0".equals(mainDTO.getJFeeFlag())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10471.getValue(), ChannelErrorCodeEnum.ERR_C10471.getKey());
                }
                sumPremium = mainDTO.getSumPremium();
                apisBusinessChannelOrder.setProposalTime(LocalDateTime.now());
                apisBusinessChannelOrder.setProposalNo(mainDTO.getProposalNo());
                mainDTO.setOutPaymentType(requestMainDTO.getOutPaymentType() == null ? "" : requestMainDTO.getOutPaymentType());
                request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().setProposalNo(mainDTO.getProposalNo());
                apisBusinessChannelOrder.setStatus("02");
                apisBusinessChannelOrder.setGiftType(mainDTO.getGiftType());
                businessNo = mainDTO.getProposalNo();
                if (StringUtils.isNotEmpty((CharSequence)businessNo)) {
                    apisBusinessChannelOrder.setPolicyTime(LocalDateTime.now());
                    apisBusinessChannelOrder.setStatus("02");
                    apisBusinessChannelOrder.setProposalNo(businessNo);
                    if (ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPayPlanList()) && request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPayPlanList().size() > 1) {
                        this.dataCompletionUtil.insertInstallmentOrder(request, businessNo);
                    }
                }
                ResponseHeadDTO responseHeadDTO = ResponseHeadDTO.builder().build();
                responseHeadDTO.setConsumerSeqNo(request.getQuotePriceServiceRequest().getRequestHead().getConsumerSeqNo());
                QuotePriceServiceResponseDTO responseBody = QuotePriceServiceResponseDTO.builder().build();
                if (StringUtils.isNotEmpty((CharSequence)businessNo)) {
                    responseBody.setPolicyStatus(policyStatus);
                    responseBody.setTotalPremium(sumPremium);
                    String agencyPolicyRef = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getOrderNo();
                    responseBody.setAgencyPolicyRef(agencyPolicyRef);
                    responseBody.setBusinessNo(businessNo);
                    responseBody.setProposalNo(mainDTO.getProposalNo());
                    responseBody.setInsuredPremiumList(this.dataCompletionUtil.packagedInsuredPremiumList(request));
                    if (ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCompanyInfo())) {
                        responseBody.setCompanyInfo(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCompanyInfo());
                    }
                    if (ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPayPlanList()) && request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPayPlanList().size() > 1) {
                        responseBody.setPayPlanList(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPayPlanList());
                    }
                    responseBody.setEffectiveDate(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getStartDate());
                    responseBody.setExpireDate(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getEndDate());
                    quotePriceServiceResponse.setResponseBody(responseBody);
                    responseHeadDTO.setStatus(1);
                    quotePriceServiceResponse.setResponseHead(responseHeadDTO);
                    if (ObjectUtils.isNotEmpty((Object)responseBody.getTotalPremium())) {
                        request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().setSumPremium(responseBody.getTotalPremium());
                    }
                    this.dataCompletionUtil.insertReqMsg(request, quotePriceServiceResponse, businessNo, INVOICE_TYPE_SPECIAL_TICKET);
                    ResponsePP response = this.coreInsureApi.freightHyQuotePricePp(request.getQuotePriceServiceRequest());
                    if (!"200001".equals(response.getResultCode())) {
                        this.log.error("\u540c\u6b65PP\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)response.getData());
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10654.getValue(), ChannelErrorCodeEnum.ERR_C10654.getKey());
                    }
                    if (policyStatus.equals("70")) {
                        this.apisBusiReqmsgLogMapper.deleteApisBusiReqmsgLog(businessNo, INVOICE_TYPE_ELECTRONIC_TICKET);
                    }
                    break block19;
                }
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10054.getValue(), ChannelErrorCodeEnum.ERR_C10054.getKey());
            }
            catch (ApisBusinessException e) {
                String errMsg = e.getMessage();
                if (errMsg.indexOf(CLAUSE_LIABILITY_KEY_WORD) != -1) {
                    String rationCode = ((ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getGoodsCode();
                    String rationName = ((ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getGoodsName();
                    errMsg = "" + rationName + "\u3010" + rationCode + "\u3011\u4ea7\u54c1\u6b63\u5feb\u9a6c\u52a0\u97ad\u4e0a\u67b6\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8d2d\u4e70\u3002";
                }
                throw new ApisBusinessException(errMsg, e.getErrorCode());
            }
            finally {
                apisBusinessChannelOrder.setFinishedTime(LocalDateTime.now());
                if (ObjectUtil.isNotEmpty(sumPremium)) {
                    apisBusinessChannelOrder.setPremium(new BigDecimal(sumPremium));
                }
                if (ObjectUtil.isNotEmpty((Object)mainDTO.getSumAmount())) {
                    apisBusinessChannelOrder.setAmount(new BigDecimal(mainDTO.getSumAmount()));
                }
                Date startDate = new Date();
                this.dataCompletionUtil.insertApisBusinessChannelOrder(request, apisBusinessChannelOrder);
                this.log.warn("\u65b0\u589e\u6e20\u9053\u8ba2\u5355\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
            }
        }
        return StanderResponse.builder().header(request.getHeader()).quotePriceServiceResponse(quotePriceServiceResponse).build();
    }

    public void validNull(StanderRequest standerRequest) throws ApisBusinessException {
        InvoiceInfoDTO invoiceInfoDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getInvoiceInfo();
        ItemCargoDTO itemCargoDTO = (ItemCargoDTO)((ItemMainDTO)standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getItemCargo().get(0);
        RiskInfoDTO riskInfo = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getRiskInfo();
        if (StringUtils.isBlank((CharSequence)itemCargoDTO.getItemDetailCode())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "itemDetailCode"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (itemCargoDTO.getStartDate() == null) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u8d77\u8fd0\u65e5\u671f"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isBlank((CharSequence)itemCargoDTO.getConveyanceType())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "conveyanceType"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isBlank((CharSequence)itemCargoDTO.getStartSiteCountryCode())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "startSiteCountryCode"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (!"CHN".equals(itemCargoDTO.getStartSiteCountryCode())) {
            if (StringUtils.isBlank((CharSequence)itemCargoDTO.getStartSitePortCode())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "startSitePortCode"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isBlank((CharSequence)itemCargoDTO.getStartSitePortName())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "startSitePortName"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if ("9999".equals(itemCargoDTO.getStartSitePortCode()) && StringUtils.isBlank((CharSequence)itemCargoDTO.getStartNameDesc())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "startNameDesc"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
        }
        if (StringUtils.isBlank((CharSequence)itemCargoDTO.getTargetSiteCountryCode())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "targetSiteCountryCode"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if ("CHN".equals(itemCargoDTO.getTargetSiteCountryCode())) {
            if (StringUtils.isBlank((CharSequence)itemCargoDTO.getTargetNameDesc())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "targetNameDesc"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
        } else {
            if (StringUtils.isBlank((CharSequence)itemCargoDTO.getTargetSitePortCode())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "targetSitePortCode"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isBlank((CharSequence)itemCargoDTO.getTargetSitePortName())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "targetSitePortName"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if ("9999".equals(itemCargoDTO.getTargetSitePortCode()) && StringUtils.isBlank((CharSequence)itemCargoDTO.getTargetNameDesc())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "targetNameDesc"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
        }
        if (StringUtils.isBlank((CharSequence)itemCargoDTO.getQuantity())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "quantity"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (itemCargoDTO.getCargoValue() == null) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "cargoValue"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (invoiceInfoDTO == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)invoiceInfoDTO.getInvoiceType())) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)invoiceInfoDTO.getCustomerType())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "customerType"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isBlank((CharSequence)invoiceInfoDTO.getInvoiceHeadType())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "invoiceHeadType"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isBlank((CharSequence)invoiceInfoDTO.getInvoiceHead())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "invoiceHead"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if ("02".equals(invoiceInfoDTO.getInvoiceHeadType()) && StringUtils.isBlank((CharSequence)invoiceInfoDTO.getInvoiceTaxpayerId())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "invoiceTaxpayerId"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (INVOICE_TYPE_SPECIAL_TICKET.equals(invoiceInfoDTO.getInvoiceType()) && StringUtils.isBlank((CharSequence)invoiceInfoDTO.getInvoiceAddress())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "invoiceAddress"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (INVOICE_TYPE_SPECIAL_TICKET.equals(invoiceInfoDTO.getInvoiceType()) && StringUtils.isBlank((CharSequence)invoiceInfoDTO.getInvoicePhone())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "invoicePhone"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (INVOICE_TYPE_SPECIAL_TICKET.equals(invoiceInfoDTO.getInvoiceType()) && StringUtils.isBlank((CharSequence)invoiceInfoDTO.getInvoiceBankName())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "invoiceBankName"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (INVOICE_TYPE_SPECIAL_TICKET.equals(invoiceInfoDTO.getInvoiceType()) && StringUtils.isBlank((CharSequence)invoiceInfoDTO.getInvoiceBankAccount())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "invoiceBankAccount"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (INVOICE_TYPE_ELECTRONIC_TICKET.equals(invoiceInfoDTO.getInvoiceType()) && StringUtils.isBlank((CharSequence)invoiceInfoDTO.getMobilePhone())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "mobilePhone"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (INVOICE_TYPE_ELECTRONIC_TICKET.equals(invoiceInfoDTO.getInvoiceType()) && StringUtils.isBlank((CharSequence)invoiceInfoDTO.getEmail())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "email"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isBlank((CharSequence)invoiceInfoDTO.getReqMail())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "reqMail"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isBlank((CharSequence)riskInfo.getRegionType())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "regionType"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isBlank((CharSequence)riskInfo.getContainer())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "container"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if ("Y".equals(invoiceInfoDTO.getReqMail()) && StringUtils.isBlank((CharSequence)invoiceInfoDTO.getMailAddress())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "mailAddress"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if ("Y".equals(invoiceInfoDTO.getReqMail()) && StringUtils.isBlank((CharSequence)invoiceInfoDTO.getMailContact())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "mailContact"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if ("Y".equals(invoiceInfoDTO.getReqMail()) && StringUtils.isBlank((CharSequence)invoiceInfoDTO.getMailTelephone())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "mailTelephone"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
    }

    public void calculateTotalPremium(StanderRequest request) {
        TimeInterval timer = DateUtil.timer();
        request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().setSumPremium(Double.valueOf(1000.0));
        MainDTO mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        List itemList = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList();
        for (int i = 0; i < itemList.size(); ++i) {
            for (ItemKindDTO itemKind : ((ItemMainDTO)itemList.get(i)).getItemKind()) {
                itemKind.setGrossPremium(Double.valueOf(500.0));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)mainDTO.getCalcType())) {
            if ("9".equals(mainDTO.getCalcType())) {
                mainDTO.setCalcType(INVOICE_TYPE_ELECTRONIC_TICKET);
            } else {
                mainDTO.setCalcType(INVOICE_TYPE_SPECIAL_TICKET);
            }
        }
        this.log.warn("\u4fdd\u8d39\u8ba1\u7b97execute\u4e4b\u540e\u7528\u65f6\uff1a{}", (Object)timer.intervalRestart());
    }
}

