/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PayPlanDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyNoGetRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyNoGetRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicySubmitRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicySubmitRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiReqmsgLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationMainService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.utils.CodeConvertUtil;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderFreightPolicySubmitHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderFreightPolicySubmitHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    private CodeConvertUtil codeConvertUtils;
    @Autowired
    ApisBusiReqmsgLogMapper apisBusiReqmsgLogMapper;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisPfpRationMainService apisPfpRationMainService;
    private final String RESPONSE_ENTITY_PLOICYNOGET = "policyNoGetResponse";
    private final String RESPONSE_ENTITY_PLOICYSUBMIT = "policySubmitResponse";
    private static final String CLAUSE_LIABILITY_KEY_WORD = "\u6761\u6b3e\u8d23\u4efb\u4fe1\u606f\u4e2d";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        TimeInterval timer = DateUtil.timer();
        request.getQuotePriceServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        QuotePriceServiceResponse quotePriceServiceResponse;
        block18: {
            QueryWrapper queryWrapper = new QueryWrapper();
            String proposalNo = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getProposalNo();
            queryWrapper.eq((Object)"proposal_no", (Object)proposalNo);
            List apisBusinessChannelOrders = this.apisBusiChannelOrderService.list((Wrapper)queryWrapper);
            if (apisBusinessChannelOrders == null && apisBusinessChannelOrders.size() == 0) {
                throw new ApisBusinessException("\u6295\u4fdd\u5355\u4e0d\u5b58\u5728", ChannelErrorCodeEnum.ERR_C10005.getKey());
            }
            this.log.warn("\u9752\u5c9b\u8d27\u8fd0\u9669\u6e05\u5355\u4fe1\u606f\uff1a{}", (Object)apisBusinessChannelOrders.toString());
            ApisBusiChannelOrder apisBusinessChannelOrder = (ApisBusiChannelOrder)apisBusinessChannelOrders.get(0);
            this.log.warn("\u9752\u5c9b\u8d27\u8fd0\u9669\u6295\u4fdd\u5355{}\u6295\u4fdd\u786e\u8ba4\u5f00\u59cb\uff01", (Object)proposalNo);
            apisBusinessChannelOrder.setRequestTime(LocalDateTime.now());
            quotePriceServiceResponse = QuotePriceServiceResponse.builder().build();
            try {
                String prePayFlag;
                String businessNo = "";
                String policyStatus = "70";
                MainDTO mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
                if (StringUtils.isEmpty((CharSequence)mainDTO.getStepFlag())) {
                    mainDTO.setStepFlag(this.dataCompletionUtil.getStepFlag(request.getHeader().getUserCode()));
                }
                StanderResponse policySubmitResponse = null;
                Map map = this.policyNoGetService(apisBusinessChannelOrder, request, proposalNo);
                String obj = (String)DataCompletionUtil.castToClass(String.class, map.get("policyStatus"));
                policyStatus = StringUtils.isEmpty((CharSequence)obj) ? "70" : obj;
                businessNo = (String)DataCompletionUtil.castToClass(String.class, map.get("businessNo"));
                mainDTO.setJFeeFlag(apisBusinessChannelOrder.getPayType());
                if ("0".equals(apisBusinessChannelOrder.getPayType())) {
                    if ("1".equals(mainDTO.getStepFlag())) {
                        policySubmitResponse = this.coreInsureApi.policySubmit(this.packagePolicyConfirmRequestData(mainDTO, request, businessNo, "P", apisBusinessChannelOrder.getPlanCode(), apisBusinessChannelOrder));
                        BaseApisParamUtil.verificationResponse((StanderResponse)policySubmitResponse, (String)"policySubmitResponse");
                        businessNo = policySubmitResponse.getPolicySubmitResponse().getResponseBody().getBusinessNo();
                        if (StringUtils.isEmpty((CharSequence)businessNo) || businessNo.startsWith("T")) {
                            businessNo = (String)DataCompletionUtil.castToClass(String.class, map.get("businessNo"));
                        }
                        policyStatus = "1".equals(prePayFlag = policySubmitResponse.getPolicySubmitResponse().getResponseBody().getPrePayFlag()) || "0".equals(apisBusinessChannelOrder.getPayType()) ? "70" : "60";
                    }
                } else if ("1".equals(apisBusinessChannelOrder.getPayType()) && "1".equals(apisBusinessChannelOrder.getPayType())) {
                    policySubmitResponse = this.coreInsureApi.policySubmit(this.packagePolicyConfirmRequestData(mainDTO, request, (String)DataCompletionUtil.castToClass(String.class, map.get("businessNo")), "P", apisBusinessChannelOrder.getPlanCode(), apisBusinessChannelOrder));
                    BaseApisParamUtil.verificationResponse((StanderResponse)policySubmitResponse, (String)"policySubmitResponse");
                    businessNo = policySubmitResponse.getPolicySubmitResponse().getResponseBody().getBusinessNo();
                    if (StringUtils.isEmpty((CharSequence)businessNo) || businessNo.startsWith("T")) {
                        businessNo = (String)DataCompletionUtil.castToClass(String.class, map.get("businessNo"));
                    }
                    policyStatus = "1".equals(prePayFlag = policySubmitResponse.getPolicySubmitResponse().getResponseBody().getPrePayFlag()) || "0".equals(apisBusinessChannelOrder.getPayType()) ? "70" : "60";
                }
                if (StringUtils.isNotEmpty((CharSequence)businessNo)) {
                    apisBusinessChannelOrder.setPolicyNo(businessNo);
                    apisBusinessChannelOrder.setPolicyTime(LocalDateTime.now());
                    if ("70".equals(policyStatus)) {
                        apisBusinessChannelOrder.setStatus("04");
                    }
                }
                ResponseHeadDTO responseHeadDTO = ResponseHeadDTO.builder().build();
                responseHeadDTO.setConsumerSeqNo(request.getQuotePriceServiceRequest().getRequestHead().getConsumerSeqNo());
                QuotePriceServiceResponseDTO responseBody = QuotePriceServiceResponseDTO.builder().build();
                if (StringUtils.isNotEmpty((CharSequence)businessNo)) {
                    responseBody.setPolicyStatus(policyStatus);
                    responseBody.setTotalPremium(Double.valueOf(apisBusinessChannelOrder.getPremium().doubleValue()));
                    responseBody.setAgencyPolicyRef(apisBusinessChannelOrder.getOrderNo());
                    responseBody.setBusinessNo(businessNo);
                    responseBody.setProposalNo(apisBusinessChannelOrder.getProposalNo());
                    quotePriceServiceResponse.setResponseBody(responseBody);
                    responseHeadDTO.setStatus(1);
                    quotePriceServiceResponse.setResponseHead(responseHeadDTO);
                    if (policyStatus.equals("70")) {
                        this.apisBusiReqmsgLogMapper.deleteApisBusiReqmsgLog(businessNo, "1");
                    }
                    break block18;
                }
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10054.getValue(), ChannelErrorCodeEnum.ERR_C10054.getKey());
            }
            catch (ApisBusinessException e) {
                String errMsg = e.getMessage();
                if (errMsg.indexOf(CLAUSE_LIABILITY_KEY_WORD) != -1) {
                    String rationCode = apisBusinessChannelOrder.getPlanCode();
                    String rationName = apisBusinessChannelOrder.getPlanName();
                    errMsg = "" + rationName + "\u3010" + rationCode + "\u3011\u4ea7\u54c1\u6b63\u5feb\u9a6c\u52a0\u97ad\u4e0a\u67b6\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8d2d\u4e70\u3002";
                }
                throw new ApisBusinessException(errMsg, e.getErrorCode());
            }
            finally {
                apisBusinessChannelOrder.setFinishedTime(LocalDateTime.now());
                Date startDate = new Date();
                this.apisBusiChannelOrderService.updateById((Object)apisBusinessChannelOrder);
                this.log.warn("\u65b0\u589e\u6e20\u9053\u8ba2\u5355\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
            }
        }
        return StanderResponse.builder().header(request.getHeader()).quotePriceServiceResponse(quotePriceServiceResponse).build();
    }

    public Map policyNoGetService(ApisBusiChannelOrder apisBusiChannelOrder, StanderRequest request, String proposalNo) throws ApisBusinessException {
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        String businessNo = "";
        StanderResponse policyNoGetResponse = this.coreInsureApi.policyNoGet(StanderRequest.builder().header(request.getHeader()).policyNoGetRequest(PolicyNoGetRequest.builder().requestHead(request.getQuotePriceServiceRequest().getRequestHead()).requestBody(PolicyNoGetRequestDTO.builder().proposalNo(proposalNo).build()).build()).build());
        BaseApisParamUtil.verificationResponse((StanderResponse)policyNoGetResponse, (String)"policyNoGetResponse");
        businessNo = policyNoGetResponse.getPolicyNoGetResponse().getResponseBody().getPrePolicyNo();
        apisBusiChannelOrder.setStatus("05");
        resultMap.put("businessNo", businessNo);
        if ("1".equals(apisBusiChannelOrder.getPayType())) {
            resultMap.put("policyStatus", "60");
        } else {
            resultMap.put("policyStatus", "30");
        }
        return resultMap;
    }

    public StanderRequest packagePolicyConfirmRequestData(MainDTO mainDTO, StanderRequest request, String preBusinessNo, String bizType, String planCode, ApisBusiChannelOrder apisBusiChannelOrder) throws ApisBusinessException {
        PolicySubmitRequestDTO policySubmitRequestDTO = new PolicySubmitRequestDTO();
        policySubmitRequestDTO.setBusinessNo(mainDTO.getProposalNo());
        policySubmitRequestDTO.setJfeeFlag(mainDTO.getJFeeFlag());
        policySubmitRequestDTO.setBusinessType(bizType);
        policySubmitRequestDTO.setPayPlanList(this.packagePayPlanInfo(request, apisBusiChannelOrder));
        policySubmitRequestDTO.setUnderWriteType("EX");
        ApisPfpRationMain apisPfpRationMain = new ApisPfpRationMain();
        apisPfpRationMain.setRationCode(planCode);
        apisPfpRationMain.setDeleted(Integer.valueOf(0));
        apisPfpRationMain.setValidStatus(Integer.valueOf(1));
        QueryWrapper queryWrapper = new QueryWrapper((Object)apisPfpRationMain);
        apisPfpRationMain = (ApisPfpRationMain)this.apisPfpRationMainService.getOne((Wrapper)queryWrapper);
        String rationCode = apisPfpRationMain.getRelateRationCode();
        ApisChannelConfigs apisChannelConfigsCondition = new ApisChannelConfigs();
        apisChannelConfigsCondition.setRationCode(rationCode);
        apisChannelConfigsCondition.setConfigCode("RULE_UNDERWRITING");
        ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsCondition);
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs)) {
            policySubmitRequestDTO.setUnderWriteType("IN");
        }
        Map userMap = this.getChannelUserInfo(request);
        policySubmitRequestDTO.setUnderWriteCode(request.getHeader().getUserCode());
        policySubmitRequestDTO.setUnderWriteName((String)DataCompletionUtil.castToClass(String.class, userMap.get("user_name")));
        if (StringUtils.isNotEmpty((CharSequence)preBusinessNo)) {
            policySubmitRequestDTO.setPreBusinessNo(preBusinessNo);
        }
        QuotePriceDTO quotePriceDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        if ("1".equals(mainDTO.getJFeeFlag())) {
            if (StringUtils.isNotEmpty((CharSequence)mainDTO.getOutPaymentType())) {
                policySubmitRequestDTO.setPaymentFlag("2");
                policySubmitRequestDTO.setPayResult("S2");
            } else if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getPayPlanList()) && quotePriceDTO.getPayPlanList().size() > 1) {
                policySubmitRequestDTO.setPaymentFlag("4");
            } else {
                policySubmitRequestDTO.setPaymentFlag("3");
            }
        } else {
            policySubmitRequestDTO.setPaymentFlag("1");
        }
        if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getImageList()) && quotePriceDTO.getImageList().size() > 0) {
            policySubmitRequestDTO.setImageList(quotePriceDTO.getImageList());
        }
        PolicySubmitRequest policySubmitRequest = PolicySubmitRequest.builder().build();
        policySubmitRequest.setRequestHead(request.getQuotePriceServiceRequest().getRequestHead());
        policySubmitRequest.setRequestBody(policySubmitRequestDTO);
        return StanderRequest.builder().header(request.getHeader()).policySubmitRequest(policySubmitRequest).build();
    }

    public List<PayPlanDTO> packagePayPlanInfo(StanderRequest request, ApisBusiChannelOrder apisBusiChannelOrder) {
        QuotePriceDTO quotePriceDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        ArrayList<PayPlanDTO> list = new ArrayList();
        if (ObjectUtil.isEmpty((Object)quotePriceDTO.getPayPlanList()) || quotePriceDTO.getPayPlanList().size() == 0) {
            quotePriceDTO.getMain().setPaymentType("01");
            AppliClientDTO appliClientDTO = (AppliClientDTO)quotePriceDTO.getAppliClient().get(0);
            PayPlanDTO payPlanDTO = PayPlanDTO.builder().build();
            BeanUtils.copyProperties((Object)appliClientDTO, (Object)payPlanDTO);
            payPlanDTO.setInsuredSerialNo(appliClientDTO.getSerialNo());
            payPlanDTO.setPayTimes(Integer.valueOf(1));
            payPlanDTO.setInsuredType("1");
            payPlanDTO.setPlanStartDate(apisBusiChannelOrder.getCreateTime());
            Date startDate = Date.from(apisBusiChannelOrder.getStartDate().atZone(ZoneId.systemDefault()).toInstant());
            if (apisBusiChannelOrder.getCreateTime().getTime() > startDate.getTime()) {
                Date planDate = DateUtils.addDays((Date)apisBusiChannelOrder.getCreateTime(), (int)1);
                payPlanDTO.setPlanDate(planDate);
            } else {
                payPlanDTO.setPlanDate(startDate);
            }
            payPlanDTO.setPlanFee(Double.valueOf(apisBusiChannelOrder.getPremium().doubleValue()));
            payPlanDTO.setNeedPrintInvoice(appliClientDTO.getReqFaPiao());
            payPlanDTO.setInvoiceTitle(appliClientDTO.getInvoiceTitle());
            payPlanDTO.setNeedPostInvoice(appliClientDTO.getReqMail());
            payPlanDTO.setPostWay(appliClientDTO.getMailType());
            payPlanDTO.setPostAddress(appliClientDTO.getPhAddress());
            payPlanDTO.setAccount(quotePriceDTO.getMain().getAccountCode() == null ? appliClientDTO.getVatBankAccount() : quotePriceDTO.getMain().getAccountCode());
            list.add(payPlanDTO);
        } else {
            list = quotePriceDTO.getPayPlanList();
        }
        return list;
    }

    public Map getChannelUserInfo(StanderRequest request) throws ApisDataCompletionException {
        Map userMap = this.codeConvertUtils.getCodeData("channel:user:" + request.getHeader().getUserCode());
        if (ObjectUtils.isEmpty((Object)userMap) || userMap.size() == 0) {
            this.log.error("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8d26\u53f7\u4fe1\u606f\uff0c\u8d26\u53f7\uff1a{}", (Object)request.getHeader().getUserCode());
            throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10173.getKey()).message(ChannelErrorCodeEnum.ERR_C10173.getValue()).build();
        }
        return userMap;
    }
}

