/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl.StanderCalculateHandler;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl.StanderPolicyValidityCorrectHandler;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.IdNumberUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.MediaUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.QuotePriceRulerUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.QuotePriceValidate;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RedisTemplateUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.BusinessConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.BaseCodeConvertUtils;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AssociatePersonsDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainEndorPriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyCalculateServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyCalculateServiceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceServiceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CalculateResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.GeneralCorrectResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.GeneralCorrectResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredIdvDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelCodeMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfpRationKindMapper;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.GeneralRegxs;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreCorrectApi;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import sinosoftgz.utils.data.DateUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class StanderGeneralCorrectCalculateHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderGeneralCorrectCalculateHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    CoreCorrectApi coreCorrectApi;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    ApisBusinessService apisBusinessService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisChannelCodeMapper apisChannelCodeMapper;
    @Autowired
    StanderPolicyValidityCorrectHandler standerPolicyValidityCorrectHandler;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Autowired
    QuotePriceRulerUtil quotePriceRulerUtil;
    @Autowired
    ApisPfpRationKindMapper apisPfpRationKindMapper;
    @Autowired
    MediaUploadUtil mediaUploadUtil;
    @Autowired
    BaseCodeConvertUtils baseCodeConvertUtils;
    @Autowired
    private RedisTemplateUtil redisTemplateUtil;
    @Autowired
    private QuotePriceValidate quotePriceValidate;
    @Autowired
    StanderCalculateHandler standerCalculateHandler;
    private PolicyDTO policyDTO = null;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        this.log.warn("==============\u6279\u6539\u8bd5\u7b97\u63a5\u53e3\u5f00\u59cb==================");
        BaseApisParamUtil.verificationRequest((StanderRequest)request, (String)"endorsePriceServiceRequest");
        this.policyDTO = this.executePolicyDetails(request);
        request.setPolicyDetail(this.policyDTO);
        this.log.warn("\u666e\u901a\u6279\u6539\u8bd5\u7b97\u300b\u4fdd\u5355\u53f7\uff1a{}", (Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getPolicyNo());
        this.dataCompletionUtil.policyCorrectRequestBeforeProcess(request);
        this.dataCompletionUtil.validPolicyCorrectRequestFormat(request);
        this.validateRequest(request, this.policyDTO);
        this.generalCorrectCalculateCompletion(request, this.policyDTO);
        return request;
    }

    private void generalCorrectCalculateCompletion(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        MainEndorPriceDTO main = request.getEndorsePriceServiceRequest().getRequestBody().getMain();
        if (ObjectUtil.isNotEmpty((Object)main.getStartDate())) {
            policyDTO.getMain().setStartDate(main.getStartDate());
        }
        if (ObjectUtil.isNotEmpty((Object)main.getEndDate())) {
            policyDTO.getMain().setEndDate(main.getEndDate());
        }
        if (ObjectUtil.isNotEmpty((Object)main.getAssociatePersons())) {
            List insuredIdvList = main.getAssociatePersons().getInsuredIdvList();
            List oldInsuredIdvList = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getInsuredIdvList();
            if (ObjectUtil.isNotEmpty((Object)insuredIdvList)) {
                for (InsuredIdvDTO dto : insuredIdvList) {
                    List oldList = oldInsuredIdvList.stream().filter(a -> a.getSerialNo() == dto.getSerialNo() && a.getIdentifyNumber().equals(dto.getOrignInsuredIdyNo())).collect(Collectors.toList());
                    if (ObjectUtil.isNotEmpty(oldList)) {
                        if (ObjectUtil.isEmpty((Object)dto.getBirthday())) {
                            if (ObjectUtil.isNotEmpty((Object)dto.getIdentifyType()) && BusinessConstants.IDCARD_TYPE.contains(dto.getIdentifyType()) && ObjectUtil.isNotEmpty((Object)dto.getIdentifyNumber())) {
                                try {
                                    String birthdayStr = dto.getIdentifyNumber().substring(6, 14);
                                    Date birthday = org.apache.commons.lang3.time.DateUtils.parseDate((String)birthdayStr, (String[])new String[]{"yyyyMMdd"});
                                    dto.setBirthday(birthday);
                                }
                                catch (ParseException e) {
                                    this.log.warn("\u88ab\u4fdd\u4eba\u3010##\u3011\u51fa\u751f\u65e5\u8f6c\u6362\u5f02\u5e38\uff1a".replace("##", dto.getIdentifyNumber()));
                                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10005.getValue(), ChannelErrorCodeEnum.ERR_C10005.getKey());
                                }
                            } else {
                                dto.setBirthday(((InsuredIdvDTO)oldList.get(0)).getBirthday());
                            }
                        }
                        dto.setAge(Integer.valueOf(this.dataCompletionUtil.calculateAge(policyDTO.getMain().getStartDate(), dto.getBirthday())));
                        String[] ignoreArray = StanderGeneralCorrectCalculateHandler.getNullPropertyNames((Object)dto);
                        BeanUtils.copyProperties((Object)dto, oldList.get(0), (String[])ignoreArray);
                        continue;
                    }
                    this.log.warn("\u4fdd\u8d39\u6279\u6539\u9884\u7b97\uff0c\u4f20\u9012\u7684\u88ab\u4fdd\u4eba\u6709\u8bef\uff0c\u5e8f\u53f7\u4e3a:{}", (Object)dto.getSerialNo());
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10111.getValue(), ChannelErrorCodeEnum.ERR_C10111.getKey());
                }
            }
        }
        this.log.warn("\u6279\u6539\u8bd5\u7b97\uff0c\u66ff\u6362\u540e\u6570\u636e\u4e3a\uff0c{}", (Object)JSON.toJSONString((Object)policyDTO));
        QuotePriceDTO quotePriceDTO = QuotePriceDTO.builder().build();
        BeanUtils.copyProperties((Object)policyDTO, (Object)quotePriceDTO);
        quotePriceDTO.setPlanCode(((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode());
        quotePriceDTO.getCoverage().setInsuredIdvList(((ItemMainDTO)quotePriceDTO.getCoverage().getItemList().get(0)).getInsuredIdvList());
        ArrayList<InsuredDTO> insuredDTOList = new ArrayList<InsuredDTO>();
        for (InsuredIdvDTO insuredIdvDTO : quotePriceDTO.getCoverage().getInsuredIdvList()) {
            InsuredDTO insuredDTO = InsuredDTO.builder().build();
            BeanUtils.copyProperties((Object)insuredIdvDTO, (Object)insuredDTO);
            insuredDTOList.add(insuredDTO);
        }
        quotePriceDTO.setInsuredList(insuredDTOList);
        BeanUtils.copyProperties((Object)policyDTO, (Object)quotePriceDTO.getCoverage().getInsuredIdvList());
        quotePriceDTO.setPlanCode(((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode());
        PolicyCalculateServiceRequest policyCalculateServiceRequest = PolicyCalculateServiceRequest.builder().build();
        policyCalculateServiceRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        PolicyCalculateServiceRequestDTO policyCalculateServiceRequestDTO = PolicyCalculateServiceRequestDTO.builder().build();
        policyCalculateServiceRequestDTO.setQuotePrice(quotePriceDTO);
        policyCalculateServiceRequest.setRequestBody(policyCalculateServiceRequestDTO);
        request.setPolicyCalculateServiceRequest(policyCalculateServiceRequest);
        QuotePriceServiceRequest quotePriceServiceRequest = QuotePriceServiceRequest.builder().build();
        quotePriceServiceRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        quotePriceServiceRequest.setRequestBody(QuotePriceServiceRequestDTO.builder().quotePrice(quotePriceDTO).build());
        request.setQuotePriceServiceRequest(quotePriceServiceRequest);
        this.dataCompletionUtil.getInsuredType(request);
        this.log.warn("\u6279\u6539\u8bd5\u7b97\uff0c\u4fdd\u8d39\u8ba1\u7b97\u5bf9\u8c61\u5c5e\u6027\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)request.getPolicyCalculateServiceRequest()));
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        StanderResponse response = StanderResponse.builder().build();
        StanderResponse standerResponse = this.standerCalculateHandler.execute(request);
        CalculateResponseDTO calculateResponseDTO = standerResponse.getCalculateResponse().getResponseBody();
        BigDecimal totalPremiumCal = null;
        if (ObjectUtil.isNotEmpty((Object)calculateResponseDTO.getTotalPremium())) {
            totalPremiumCal = new BigDecimal(calculateResponseDTO.getTotalPremium()).setScale(2, 4);
            this.log.warn("\u6279\u6539\u540e\u4fdd\u8d39\u4e3a:{}", (Object)totalPremiumCal.doubleValue());
        }
        GeneralCorrectResponse generalCorrectResponse = GeneralCorrectResponse.builder().build();
        GeneralCorrectResponseDTO generalCorrectResponseDTO = GeneralCorrectResponseDTO.builder().build();
        generalCorrectResponseDTO.setPremiumChange(Double.valueOf(ObjectUtil.isEmpty(totalPremiumCal) ? 0.0 : totalPremiumCal.subtract(new BigDecimal(this.policyDTO.getMain().getSumPremium())).doubleValue()));
        generalCorrectResponseDTO.setPolicyNo(request.getEndorsePriceServiceRequest().getRequestBody().getMain().getPolicyNo());
        generalCorrectResponse.setResponseBody(generalCorrectResponseDTO);
        response.setGeneralCorrectReResponse(generalCorrectResponse);
        return response;
    }

    public static String[] getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null && !"".equals(srcValue)) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        return response;
    }

    private PolicyDTO executePolicyDetails(StanderRequest request) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)request.getEndorsePriceServiceRequest().getRequestBody()) || ObjectUtil.isEmpty((Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain()) || ObjectUtil.isEmpty((Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getPolicyNo())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u3010\u4fdd\u5355\u53f7\u3011"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        String policyNo = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getPolicyNo();
        PolicyDTO policyDetail = null;
        try {
            policyDetail = this.dataCompletionUtil.getPolicyDetail(request, policyNo, false);
        }
        catch (ApisBusinessException apisBusinessException) {
            if ("0007".equals(apisBusinessException.getErrorCode())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10113.getValue(), ChannelErrorCodeEnum.ERR_C10113.getKey());
            }
            throw apisBusinessException;
        }
        return policyDetail;
    }

    private void validateRequest(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        this.checkPolicy(request, policyDTO);
        this.validateMain(request);
        MainEndorPriceDTO main = request.getEndorsePriceServiceRequest().getRequestBody().getMain();
        if (ObjectUtil.isNotEmpty((Object)main.getAssociatePersons())) {
            Date startDate = ObjectUtil.isEmpty((Object)main.getStartDate()) ? policyDTO.getMain().getStartDate() : main.getStartDate();
            this.validateAppliClient(main.getAssociatePersons(), policyDTO, startDate);
            String classCode = policyDTO.getMain().getClassCode();
            if ("09".equals(classCode) || "07".equals(classCode)) {
                this.validateInsuredIdv(main.getAssociatePersons(), policyDTO);
            } else {
                this.validateInsured(main.getAssociatePersons(), policyDTO);
            }
        }
        if ("P070006".equals(policyDTO.getMain().getRiskCode()) && ObjectUtil.isNotEmpty((Object)main.getStartDate())) {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            Calendar c = Calendar.getInstance();
            c.add(5, BusinessConstants.DAY_ADD_NUM);
            if (main.getStartDate().compareTo(c.getTime()) < 0) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10696.getValue(), ChannelErrorCodeEnum.ERR_C10696.getKey());
            }
        }
    }

    private void checkPolicy(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        MainDTO main = policyDTO.getMain();
        String userCode = policyDTO.getMain().getOperateCode();
        if (ObjectUtil.isEmpty((Object)main.getPolicyStatus()) || !"1".equals(main.getPolicyStatus())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10421.getValue(), ChannelErrorCodeEnum.ERR_C10421.getKey());
        }
        String planCode = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
        apisChannelConfigs.setRationCode(planCode);
        apisChannelConfigs.setConfigCode("AMOUNT_CORRECT_POWER");
        apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
        this.log.warn("\u6279\u6539\u8d60\u9669\u7c7b\u578b\u4e3a\uff1a{}", (Object)policyDTO.getMain().getGiftType());
        if (StringUtils.isNotEmpty((CharSequence)policyDTO.getMain().getGiftType()) && !"0".equals(policyDTO.getMain().getGiftType()) && ObjectUtil.isEmpty((Object)apisChannelConfigs)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10506.getValue(), ChannelErrorCodeEnum.ERR_C10506.getKey());
        }
    }

    private void validateInsuredIdv(AssociatePersonsDTO associatePersons, PolicyDTO policyDTO) throws ApisBusinessException {
        if (ObjectUtil.isNotEmpty((Object)associatePersons.getInsuredIdvList())) {
            for (InsuredIdvDTO insured : associatePersons.getInsuredIdvList()) {
                String insuredSex;
                String identifyType;
                List oldInsuredIdvList = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getInsuredIdvList();
                InsuredIdvDTO oldInsured = this.getOldInsured(insured, oldInsuredIdvList);
                String riskCode = policyDTO.getMain().getRiskCode();
                String classCode = policyDTO.getMain().getClassCode();
                String name = ObjectUtil.isNotEmpty((Object)insured.getInsuredName()) ? insured.getInsuredName() : oldInsured.getInsuredName();
                String identifyNumber = ObjectUtil.isNotEmpty((Object)insured.getIdentifyNumber()) ? insured.getIdentifyNumber() : oldInsured.getIdentifyNumber();
                String string = identifyType = ObjectUtil.isNotEmpty((Object)insured.getIdentifyType()) ? insured.getIdentifyType() : oldInsured.getIdentifyType();
                if (Arrays.asList(QuotePriceValidate.ACCIDENT_HEALTH_RISKCODE).contains(riskCode) && StringUtils.isNotEmpty((CharSequence)insured.getInsuredName())) {
                    this.checkInsureName(insured.getInsuredName(), identifyNumber);
                }
                if (Arrays.asList(QuotePriceValidate.ACCIDENT_HEALTH_RISKCODE).contains(riskCode) && StringUtils.isNotEmpty((CharSequence)insured.getInsuredEname())) {
                    this.checkEnName(insured.getInsuredEname());
                }
                if (BusinessConstants.IDCARD_TYPE.contains(identifyType) && ObjectUtil.isNotEmpty((Object)(insuredSex = this.getValueDefault(insured.getSex(), oldInsured.getSex()))) && !insuredSex.equals(String.valueOf(IdcardUtil.getGenderByIdCard((String)identifyNumber) == 1 ? 1 : 2))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10617.getValue(), ChannelErrorCodeEnum.ERR_C10617.getKey());
                }
                if (ObjectUtil.isNotEmpty((Object)insured.getEmail()) && !insured.getEmail().matches(GeneralRegxs.Email)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10144.getValue(), ChannelErrorCodeEnum.ERR_C10144.getKey());
                }
                if (!ObjectUtil.isNotEmpty((Object)insured.getIdentifyNumber())) continue;
                String identityType = "";
                if (ObjectUtil.isNotEmpty((Object)insured.getIdentifyType())) {
                    identityType = insured.getIdentifyType();
                } else if (ObjectUtil.isNotEmpty((Object)oldInsured.getIdentifyType())) {
                    identityType = oldInsured.getIdentifyType();
                }
                if (BusinessConstants.IDCARD_TYPE.contains(identityType)) {
                    int age;
                    if (!insured.getIdentifyNumber().matches(GeneralRegxs.IdentifyNumber)) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10078.getValue().replace("##", insured.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10078.getKey());
                    }
                    String birthdayStr = insured.getIdentifyNumber().substring(6, 14);
                    try {
                        Date birthday = org.apache.commons.lang3.time.DateUtils.parseDate((String)birthdayStr, (String[])new String[]{"yyyyMMdd"});
                        age = this.dataCompletionUtil.calculateAge(policyDTO.getMain().getStartDate(), birthday);
                    }
                    catch (ParseException e) {
                        this.log.warn("\u88ab\u4fdd\u4eba\u3010##\u3011\u51fa\u751f\u65e5\u8f6c\u6362\u5f02\u5e38\uff1a".replace("##", insured.getIdentifyNumber()) + birthdayStr);
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10005.getValue(), ChannelErrorCodeEnum.ERR_C10005.getKey());
                    }
                    ApisPfpRationMain apisPfpRationMainInfo = this.dataCompletionUtil.getApisPfpRationMainInfo(((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode(), "2");
                    if (ObjectUtil.isEmpty((Object)apisPfpRationMainInfo)) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10024.getValue(), ChannelErrorCodeEnum.ERR_C10024.getKey());
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)apisPfpRationMainInfo.getAgeMin()) || !StringUtils.isNotEmpty((CharSequence)apisPfpRationMainInfo.getAgeMax()) || age >= Integer.valueOf(apisPfpRationMainInfo.getAgeMin()) && age <= Integer.valueOf(apisPfpRationMainInfo.getAgeMax())) continue;
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10366.getValue().replaceFirst("##", name).replaceFirst("##", identifyNumber).replaceFirst("##", apisPfpRationMainInfo.getAgeMin()).replaceFirst("##", apisPfpRationMainInfo.getAgeMax()), ChannelErrorCodeEnum.ERR_C10366.getKey());
                }
                if (insured.getIdentifyNumber().matches(GeneralRegxs.PassportOtherIdNo)) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10078.getValue().replace("##", insured.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10078.getKey());
            }
        }
    }

    private String getValueDefault(String a, String b) {
        return ObjectUtil.isEmpty((Object)a) ? b : a;
    }

    private InsuredDTO getOldInsured(InsuredDTO insured, List<InsuredDTO> oldInsuredList) throws ApisBusinessException {
        InsuredDTO oldInsured = null;
        if (ObjectUtil.isNotEmpty((Object)insured.getSerialNo()) && ObjectUtil.isNotEmpty((Object)insured.getOrignInsuredNam()) && ObjectUtil.isNotEmpty((Object)insured.getOrignInsuredIdyNo())) {
            for (InsuredDTO old : oldInsuredList) {
                if (!old.getSerialNo().equals(insured.getSerialNo()) || !old.getIdentifyNumber().equals(insured.getOrignInsuredIdyNo()) || !old.getInsuredName().equals(insured.getOrignInsuredNam())) continue;
                oldInsured = old;
                break;
            }
            if (ObjectUtil.isEmpty((Object)oldInsured)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10111.getValue(), ChannelErrorCodeEnum.ERR_C10111.getKey());
            }
        } else {
            oldInsured = oldInsuredList.get(0);
        }
        return oldInsured;
    }

    private InsuredIdvDTO getOldInsured(InsuredIdvDTO insured, List<InsuredIdvDTO> oldInsuredIdvList) throws ApisBusinessException {
        InsuredIdvDTO oldInsured = null;
        if (ObjectUtil.isNotEmpty((Object)insured.getSerialNo()) && ObjectUtil.isNotEmpty((Object)insured.getOrignInsuredNam()) && ObjectUtil.isNotEmpty((Object)insured.getOrignInsuredIdyNo())) {
            for (InsuredIdvDTO old : oldInsuredIdvList) {
                if (!old.getSerialNo().equals(insured.getSerialNo()) || !old.getIdentifyNumber().equals(insured.getOrignInsuredIdyNo()) || !old.getInsuredName().equals(insured.getOrignInsuredNam())) continue;
                oldInsured = old;
                break;
            }
            if (ObjectUtil.isEmpty((Object)oldInsured)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10111.getValue(), ChannelErrorCodeEnum.ERR_C10111.getKey());
            }
        } else {
            oldInsured = oldInsuredIdvList.get(0);
        }
        return oldInsured;
    }

    private void validateInsured(AssociatePersonsDTO associatePersons, PolicyDTO policyDTO) throws ApisBusinessException {
        if (ObjectUtil.isNotEmpty((Object)associatePersons.getInsuredList())) {
            List insuredList = associatePersons.getInsuredList();
            for (InsuredDTO insured : insuredList) {
                List oldInsuredList = policyDTO.getInsuredList();
                InsuredDTO oldInsured = this.getOldInsured(insured, oldInsuredList);
                if (ObjectUtil.isNotEmpty((Object)insured.getEmail()) && !insured.getEmail().matches(GeneralRegxs.Email)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10144.getValue(), ChannelErrorCodeEnum.ERR_C10144.getKey());
                }
                if (!ObjectUtil.isNotEmpty((Object)insured.getIdentifyNumber())) continue;
                String identityType = "";
                if (ObjectUtil.isNotEmpty((Object)insured.getIdentifyType())) {
                    identityType = insured.getIdentifyType();
                } else if (ObjectUtil.isNotEmpty((Object)oldInsured.getIdentifyType())) {
                    identityType = oldInsured.getIdentifyType();
                }
                if (!(BusinessConstants.IDCARD_TYPE.contains(identityType) ? !insured.getIdentifyNumber().matches(GeneralRegxs.IdentifyNumber) : !insured.getIdentifyNumber().matches(GeneralRegxs.PassportOtherIdNo))) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10078.getValue().replace("##", insured.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10078.getKey());
            }
        }
    }

    private void validateAppliClient(AssociatePersonsDTO associatePersons, PolicyDTO policyDTO, Date startDate) throws ApisBusinessException {
        if (ObjectUtil.isNotEmpty((Object)associatePersons.getAppliClient())) {
            AppliClientDTO appliClient = (AppliClientDTO)associatePersons.getAppliClient().get(0);
            AppliClientDTO oldAppliClient = (AppliClientDTO)policyDTO.getAppliClient().get(0);
            if (ObjectUtil.isNotEmpty((Object)appliClient.getEmail()) && !appliClient.getEmail().matches(GeneralRegxs.Email)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10132.getValue(), ChannelErrorCodeEnum.ERR_C10132.getKey());
            }
            if (ObjectUtil.isNotEmpty((Object)appliClient.getIdentifyNumber())) {
                String identityType = "";
                if (ObjectUtil.isNotEmpty((Object)appliClient.getIdentifyType())) {
                    identityType = appliClient.getIdentifyType();
                } else if (ObjectUtil.isNotEmpty((Object)oldAppliClient.getIdentifyType())) {
                    identityType = oldAppliClient.getIdentifyType();
                }
                if (BusinessConstants.IDCARD_TYPE.contains(identityType) ? !appliClient.getIdentifyNumber().matches(GeneralRegxs.IdentifyNumber) : !appliClient.getIdentifyNumber().matches(GeneralRegxs.PassportOtherIdNo)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10073.getValue().replace("##", appliClient.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10073.getKey());
                }
            }
            if (Arrays.asList(QuotePriceValidate.ACCIDENT_HEALTH_RISKCODE).contains(policyDTO.getMain().getRiskCode())) {
                String sex;
                if (StringUtils.isNotEmpty((CharSequence)appliClient.getInsuredName())) {
                    this.checkInsureName(appliClient.getInsuredName(), appliClient.getIdentifyNumber());
                }
                if (StringUtils.isNotEmpty((CharSequence)appliClient.getInsuredEname())) {
                    this.checkEnName(appliClient.getInsuredEname());
                }
                String insuredType = ObjectUtil.isEmpty((Object)appliClient.getInsuredType()) ? ((AppliClientDTO)policyDTO.getAppliClient().get(0)).getInsuredType() : appliClient.getInsuredType();
                String identifyType = ObjectUtil.isEmpty((Object)appliClient.getIdentifyType()) ? ((AppliClientDTO)policyDTO.getAppliClient().get(0)).getIdentifyType() : appliClient.getIdentifyType();
                String identifyNumber = ObjectUtil.isEmpty((Object)appliClient.getIdentifyNumber()) ? ((AppliClientDTO)policyDTO.getAppliClient().get(0)).getIdentifyNumber() : appliClient.getIdentifyNumber();
                Date birthDay = ObjectUtil.isEmpty((Object)appliClient.getBirthday()) ? ((AppliClientDTO)policyDTO.getAppliClient().get(0)).getBirthday() : appliClient.getBirthday();
                String string = sex = ObjectUtil.isEmpty((Object)appliClient.getSex()) ? ((AppliClientDTO)policyDTO.getAppliClient().get(0)).getSex() : appliClient.getSex();
                if ("1".equals(insuredType) && !Arrays.asList(BusinessConstants.ID_TYPE_PERSONAL).contains(identifyType)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
                }
                if ("2".equals(insuredType) && !Arrays.asList(BusinessConstants.ID_TYPE_COMPANY).contains(identifyType)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
                }
                if ("01".equals(identifyType) || "13".equals(identifyType)) {
                    if (StringUtils.isNotBlank((CharSequence)identifyNumber) && !IdcardUtil.isValidCard((String)identifyNumber)) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10073.getValue().replace("##", identifyNumber), ChannelErrorCodeEnum.ERR_C10073.getKey());
                    }
                    String birthDateStr = IdcardUtil.getBirth((String)identifyNumber);
                    if (ObjectUtil.isNotEmpty((Object)birthDay)) {
                        String birthDayVaild = DateUtils.dateToStr((Date)birthDay, (String)"yyyyMMdd");
                        if (!birthDateStr.equals(birthDayVaild)) {
                            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10240.getValue().replace("##", identifyNumber), ChannelErrorCodeEnum.ERR_C10240.getKey());
                        }
                        if (this.dataCompletionUtil.calculateAge(startDate, birthDay) < BusinessConstants.MINOR_AGE) {
                            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10282.getValue(), ChannelErrorCodeEnum.ERR_C10282.getKey());
                        }
                    }
                    if (!sex.equals(String.valueOf(IdcardUtil.getGenderByIdCard((String)identifyNumber) == 1 ? 1 : 2))) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10616.getValue(), ChannelErrorCodeEnum.ERR_C10616.getKey());
                    }
                } else {
                    IdNumberUtil.ClientType clientType = null;
                    if ("1".equals(identifyType)) {
                        clientType = IdNumberUtil.ClientType.PERSONAL;
                    } else if ("2".equals(identifyType)) {
                        clientType = IdNumberUtil.ClientType.CLIENT;
                    }
                    this.quotePriceValidate.validateIdNumberByIdType(identifyType, identifyNumber, policyDTO.getMain().getRiskCode(), IdNumberUtil.PersonnelType.HOLDER, clientType, policyDTO.getSalesList().getAgentCode(), policyDTO.getMain().getOperateCode());
                }
            }
        }
    }

    private void checkEnName(String enName) throws ApisBusinessException {
        boolean isValidEname;
        String regexEnName = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_NAME_EN", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
        if (StringUtils.isBlank((CharSequence)regexEnName) || "NoData".equalsIgnoreCase(regexEnName)) {
            regexEnName = GeneralRegxs.Ename;
        }
        boolean bl = isValidEname = StringUtils.isNotBlank((CharSequence)regexEnName) && !"NoCheck".equals(regexEnName);
        if (StringUtils.isNotEmpty((CharSequence)enName) && isValidEname && !enName.trim().matches(regexEnName)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10619.getValue().replaceFirst("##", enName), ChannelErrorCodeEnum.ERR_C10619.getKey());
        }
    }

    public void checkInsureName(String insuredName, String identifyNumber) throws ApisBusinessException {
        if (StringUtils.isNotEmpty((CharSequence)insuredName) && !insuredName.trim().replace(" ", "").matches(GeneralRegxs.Name) || insuredName.trim().length() < 2) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10134.getValue().replaceFirst("##", insuredName).replace("##", identifyNumber), ChannelErrorCodeEnum.ERR_C10134.getKey());
        }
    }

    private void validateMain(StanderRequest request) throws ApisBusinessException {
        MainEndorPriceDTO main = request.getEndorsePriceServiceRequest().getRequestBody().getMain();
        if (ObjectUtil.isNotEmpty((Object)main.getStartDate()) && ObjectUtil.isEmpty((Object)main.getEndDate()) || ObjectUtil.isEmpty((Object)main.getStartDate()) && ObjectUtil.isNotEmpty((Object)main.getEndDate())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10203.getValue(), ChannelErrorCodeEnum.ERR_C10203.getKey());
        }
    }
}

