/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.executor.CommonsValidateUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl.StanderPolicyValidityCorrectHandler;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.FxqCustomerCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.IdNumberUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.MediaUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.QuotePriceRulerUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.QuotePriceValidate;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RedisTemplateUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RiskManagementCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.BusinessConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.BaseCodeConvertUtils;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AssociatePersonsDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CoverageDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorsePriceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemCargoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemFamilyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemKindDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainEndorPriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PayPlanDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyCalculateServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyCalculateServiceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicySubmitRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicySubmitRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RenewalInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.ClauseKindDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.ItemDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.quotePriceRuler.RationDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CorrectQuotePriceServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.GeneralCorrectResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.GeneralCorrectResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredIdvDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.MainEndorResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicySubmitResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.quotePriceRule.QuotePriceRetVo;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelInstallmentOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiCorrectOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelInstallmentOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiCorrectOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelCodeMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationKind;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfpRationKindMapper;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.GeneralRegxs;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.RiskManagementScenesEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreCorrectApi;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.DigestUtils;

public class StanderGeneralCorrectHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderGeneralCorrectHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    CoreCorrectApi coreCorrectApi;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    ApisBusinessService apisBusinessService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisChannelCodeMapper apisChannelCodeMapper;
    @Autowired
    StanderPolicyValidityCorrectHandler standerPolicyValidityCorrectHandler;
    @Autowired
    private RiskManagementCheckUtil riskManagementCheckUtil;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Autowired
    private FxqCustomerCheckUtil fxqCustomerCheckUtil;
    @Autowired
    private CommonsValidateUtil commonsValidateUtil;
    @Autowired
    QuotePriceRulerUtil quotePriceRulerUtil;
    @Autowired
    ApisPfpRationKindMapper apisPfpRationKindMapper;
    @Autowired
    MediaUploadUtil mediaUploadUtil;
    @Autowired
    BaseCodeConvertUtils baseCodeConvertUtils;
    @Autowired
    private RedisTemplateUtil redisTemplateUtil;
    @Autowired
    private QuotePriceValidate quotePriceValidate;
    @Autowired
    ApisBusiChannelInstallmentOrderService apisBusiChannelInstallmentOrderService;
    @Autowired
    private ApisBusiCorrectOrderService apisBusiCorrectOrderService;
    private static String ENDORSE_TYPE_GENERAL = "06";
    private static final String INSURED_OPERATOR_TYPE_C = "C";
    private static final String IDENTITY_TYPE = "01";
    public static final String INSURE_DEFINE_CODE = "9999999999";
    private PolicyDTO policyDTO = null;
    public static final String POLICY_SUBMIT_RESPONSE = "policySubmitResponse";
    private Boolean isSelfHelpPlatform;
    private static final String KUAYUE_CORRECT = "kuayueCorrect";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        this.log.warn("==============\u666e\u901a\u6279\u6539\u63a5\u53e3\u5f00\u59cb==================");
        String content = JSON.toJSONString((Object)request.getEndorsePriceServiceRequest(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField});
        content.replaceAll("\n", "");
        request.getEndorsePriceServiceRequest().setRequestHead(RequestHeadDTO.builder().consumerSeqNo(request.getHeader().getUserCode() + DigestUtils.md5DigestAsHex((byte[])content.getBytes())).build());
        BaseApisParamUtil.verificationRequest((StanderRequest)request, (String)"endorsePriceServiceRequest");
        this.policyDTO = this.executePolicyDetails(request);
        request.setPolicyDetail(this.policyDTO);
        this.log.warn("\u666e\u901a\u6279\u6539\u300b\u4fdd\u5355\u53f7\uff1a{}", (Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getPolicyNo());
        this.beforeProcessValidata(request, this.policyDTO);
        this.dataCompletionUtil.policyCorrectRequestBeforeProcess(request);
        this.dataCompletionUtil.validPolicyCorrectRequestFormat(request);
        this.isSelfHelpPlatform = ObjectUtil.isNotEmpty((Object)this.dataCompletionUtil.getConfig(request.getHeader().getUserCode(), "self_help_platform"));
        this.validateRequest(request, this.policyDTO);
        this.dataKuayueCompletion(request, this.policyDTO);
        this.dataXyzValidate(request, this.policyDTO);
        this.premiumCorrectValidate(request, this.policyDTO);
        this.log.warn("\u6279\u6539\u8bd5\u7b97\u8865\u5168\u524d\u6570\u636e:{}", (Object)JSON.toJSONString((Object)request));
        this.generalCorrectConfirmCompletion(request, this.policyDTO);
        this.log.warn("\u6279\u6539\u8bd5\u7b97\uff0c\u8865\u5168\u540e\u6570\u636e,{}", (Object)request);
        this.riskManagementCheckUtil.riskManagementData(request, this.policyDTO, RiskManagementScenesEnum.CORRECT.getCode(), this.policyDTO.getMain().getPolicyType());
        this.fxqCustomerCheckUtil.fxqCustomerData(request, this.policyDTO);
        this.commonsValidateUtil.executorValidate(request, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true));
        return request;
    }

    public void beforeProcessValidata(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        MainEndorPriceDTO main = request.getEndorsePriceServiceRequest().getRequestBody().getMain();
        if (ObjectUtil.isNotEmpty((Object)main.getAssociatePersons()) && ObjectUtil.isNotEmpty((Object)main.getAssociatePersons().getAppliClient()) && "P070006".equals(policyDTO.getMain().getRiskCode())) {
            for (AppliClientDTO dto : main.getAssociatePersons().getAppliClient()) {
                if (DataCompletionUtil.getNotNullPropertyNames((Object)dto).length <= BusinessConstants.GENERAL_CORRECT_APPLICATION_MAX) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10697.getValue(), ChannelErrorCodeEnum.ERR_C10697.getKey());
            }
        }
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        StanderResponse response = StanderResponse.builder().build();
        StanderResponse correctQuotePriceResponse = this.coreCorrectApi.correctQuotePrice(request);
        BaseApisParamUtil.verificationResponse((StanderResponse)correctQuotePriceResponse, (String)"correctQuotePriceServiceResponse");
        CorrectQuotePriceServiceResponse correctQuotePriceServiceResponse = correctQuotePriceResponse.getCorrectQuotePriceServiceResponse();
        response.setCorrectQuotePriceServiceResponse(correctQuotePriceServiceResponse);
        this.dataCorrectConfirmCompletion(request, correctQuotePriceResponse);
        if (request.getEndorsePriceServiceRequest().getRequestBody().getMain().getImageList() != null && request.getEndorsePriceServiceRequest().getRequestBody().getMain().getImageList().size() > 0) {
            this.dataCompletionUtil.imageDataCompletion(request, request.getEndorsePriceServiceRequest().getRequestBody().getMain().getImageList(), response.getCorrectQuotePriceServiceResponse().getResponseBody().getEndorseApply().getMain().getApplyNo());
            this.mediaUploadUtil.syncImgBatchUpload(request);
        }
        StanderResponse policySubmitResponse = this.coreCorrectApi.correctConfirm(request);
        BaseApisParamUtil.verificationResponse((StanderResponse)policySubmitResponse, (String)POLICY_SUBMIT_RESPONSE);
        response.setPolicySubmitResponse(policySubmitResponse.getPolicySubmitResponse());
        return response;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        GeneralCorrectResponse generalCorrectResponse = GeneralCorrectResponse.builder().build();
        GeneralCorrectResponseDTO generalCorrectResponseDTO = GeneralCorrectResponseDTO.builder().build();
        PolicySubmitResponse policySubmitResponse = response.getPolicySubmitResponse();
        CorrectQuotePriceServiceResponse correctQuotePriceServiceResponse = response.getCorrectQuotePriceServiceResponse();
        MainEndorResponseDTO mainEndorResponseDTO = correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain();
        String underwriteFlag = policySubmitResponse.getResponseBody().getUnderwriteFlag();
        if ("1".equals(underwriteFlag) || "3".equals(underwriteFlag)) {
            generalCorrectResponseDTO.setPolicyStatus("70");
        } else if ("4".equals(underwriteFlag)) {
            generalCorrectResponseDTO.setPolicyStatus("30");
        }
        String businessNo = policySubmitResponse.getResponseBody().getBusinessNo();
        generalCorrectResponseDTO.setPolicyNo(businessNo);
        generalCorrectResponseDTO.setTotalPremium(mainEndorResponseDTO.getSumPremium());
        generalCorrectResponseDTO.setComCode(mainEndorResponseDTO.getComCode());
        generalCorrectResponseDTO.setApplyNo(mainEndorResponseDTO.getApplyNo());
        response.setGeneralCorrectReResponse(generalCorrectResponse);
        ApisBusiCorrectOrder apisBusiCorrectOrder = new ApisBusiCorrectOrder();
        apisBusiCorrectOrder.setApplyNo(mainEndorResponseDTO.getApplyNo());
        apisBusiCorrectOrder.setStatus("1");
        String subEndorseType = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getSubEndorType();
        List apisBusiCorrectOrders = this.apisBusiCorrectOrderService.getApisBusiCorrectOrderList(apisBusiCorrectOrder);
        if ("05".equals(subEndorseType) && ObjectUtils.isEmpty((Object)apisBusiCorrectOrders)) {
            List apisBusiChannelInstallmentOrders = this.apisBusiChannelInstallmentOrderService.getOrderByPolicyNo(request.getEndorsePriceServiceRequest().getRequestBody().getMain().getPolicyNo());
            for (ApisBusiChannelInstallmentOrder order : apisBusiChannelInstallmentOrders) {
                if (!ObjectUtil.isEmpty((Object)order.getPayTime()) || order.getCurrentPayNo() <= 2) continue;
                order.setCurrentPremium(order.getCurrentPremium().add(request.getEndorsePriceServiceRequest().getRequestBody().getMain().getMonthPremium()));
            }
            this.apisBusiChannelInstallmentOrderService.updateBatchById((Collection)apisBusiChannelInstallmentOrders);
        }
        ResponseHeadDTO responseHeadDTO = ResponseHeadDTO.builder().build();
        responseHeadDTO.setConsumerSeqNo(request.getEndorsePriceServiceRequest().getRequestHead().getConsumerSeqNo());
        responseHeadDTO.setStatus(1);
        generalCorrectResponse.setResponseHead(responseHeadDTO);
        generalCorrectResponse.setResponseBody(generalCorrectResponseDTO);
        return StanderResponse.builder().header(response.getHeader()).generalCorrectReResponse(generalCorrectResponse).build();
    }

    private void dataCorrectConfirmCompletion(StanderRequest request, StanderResponse response) throws ApisDataCompletionException {
        CorrectQuotePriceServiceResponse correctQuotePriceServiceResponse = response.getCorrectQuotePriceServiceResponse();
        MainEndorResponseDTO main = correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain();
        String manual = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getManual();
        PolicySubmitRequestDTO policySubmitRequestDTO = PolicySubmitRequestDTO.builder().build();
        policySubmitRequestDTO.setBusinessType("E");
        policySubmitRequestDTO.setBusinessNo(main.getApplyNo());
        if ("Y".equals(manual)) {
            policySubmitRequestDTO.setUnderWriteType("BH");
        } else {
            MainDTO mainDTO = this.policyDTO.getMain();
            policySubmitRequestDTO.setUnderWriteType("EX");
            policySubmitRequestDTO.setUnderWriteCode(mainDTO.getOperateCode());
            policySubmitRequestDTO.setUnderWriteName(mainDTO.getOperateName());
        }
        policySubmitRequestDTO.setPayPlanList(this.packgePayPlan(request, this.policyDTO));
        policySubmitRequestDTO.setPaymentFlag("1");
        PolicySubmitRequest policySubmitRequest = PolicySubmitRequest.builder().requestHead(RequestHeadDTO.initRequestHead()).requestBody(policySubmitRequestDTO).build();
        policySubmitRequest.getRequestHead().setConsumerSeqNo(request.getEndorsePriceServiceRequest().getRequestHead().getConsumerSeqNo());
        request.setPolicySubmitRequest(policySubmitRequest);
    }

    private List<PayPlanDTO> packgePayPlan(StanderRequest request, PolicyDTO policyDTO) {
        String planCode = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        String policyNo = policyDTO.getMain().getPolicyNo();
        AppliClientDTO appliClientDTO = (AppliClientDTO)policyDTO.getAppliClient().get(0);
        ApisPfpRationMain apisPfpRationMain = this.dataCompletionUtil.getApisPfpRationMainInfo(planCode, "2");
        if (ObjectUtils.isEmpty((Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getCoverage())) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getCoverage().getItemList())) {
            return null;
        }
        ItemKindDTO itemKindDTO = (ItemKindDTO)((ItemMainDTO)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getCoverage().getItemList().get(0)).getItemKind().get(0);
        if (ObjectUtils.isEmpty((Object)itemKindDTO)) {
            return null;
        }
        ArrayList<PayPlanDTO> payPlanList = new ArrayList<PayPlanDTO>();
        PayPlanDTO payPlanDTO = null;
        Integer currentPayNo = 1;
        List apisBusiChannelInstallmentOrders = this.apisBusiChannelInstallmentOrderService.getOrderByPolicyNo(policyNo);
        for (ApisBusiChannelInstallmentOrder order : apisBusiChannelInstallmentOrders) {
            if (!ObjectUtil.isEmpty((Object)order.getPayTime()) || order.getCurrentPayNo() <= 2) continue;
            payPlanDTO = PayPlanDTO.builder().build();
            BeanUtils.copyProperties((Object)appliClientDTO, (Object)payPlanDTO);
            payPlanDTO.setPlanDate(Date.from(order.getOriginDueDate().atZone(ZoneId.systemDefault()).toInstant()));
            payPlanDTO.setPlanStartDate(Date.from(order.getDueDate().atZone(ZoneId.systemDefault()).toInstant()));
            payPlanDTO.setInsuredSerialNo(appliClientDTO.getSerialNo());
            payPlanDTO.setPayTimes(currentPayNo);
            payPlanDTO.setPlanFee(Double.valueOf(request.getEndorsePriceServiceRequest().getRequestBody().getMain().getMonthPremium().doubleValue()));
            if (ObjectUtils.isEmpty((Object)payPlanDTO.getPlanFee())) {
                payPlanDTO.setPlanFee(Double.valueOf(request.getEndorsePriceServiceRequest().getRequestBody().getMain().getSumPremiumChg().divide(BigDecimal.valueOf(10L)).setScale(2, 4).doubleValue()));
            }
            payPlanDTO.setInsuredType("1");
            payPlanDTO.setNeedPrintInvoice(appliClientDTO.getReqFaPiao());
            payPlanDTO.setInvoiceTitle(appliClientDTO.getInvoiceTitle());
            payPlanDTO.setNeedPostInvoice(appliClientDTO.getReqMail());
            payPlanDTO.setPostWay(appliClientDTO.getMailType());
            payPlanDTO.setPostAddress(appliClientDTO.getPhAddress());
            payPlanList.add(payPlanDTO);
            Integer n = currentPayNo;
            Integer n2 = currentPayNo = Integer.valueOf(currentPayNo + 1);
        }
        return payPlanList;
    }

    private void premiumCorrectValidate(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        if (StringUtils.isNotEmpty((CharSequence)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getEndorseType()) && !"77".equals(request.getEndorsePriceServiceRequest().getRequestBody().getMain().getEndorseType())) {
            return;
        }
        String planCode = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        ApisPfpRationMain apisPfpRationMain = this.dataCompletionUtil.getApisPfpRationMainInfo(planCode, "2");
        if (!"HI-SDSJSPZX".equals(apisPfpRationMain.getRationCode())) {
            return;
        }
        if (ObjectUtil.isNotEmpty((Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getSumPremiumChg()) && ObjectUtil.isNotEmpty((Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getSumInsuredChg())) {
            if (request.getEndorsePriceServiceRequest().getRequestBody().getMain().getSumInsuredChg().multiply(new BigDecimal(100)).intValue() % 500 != 0) {
                throw new ApisBusinessException("\u4fdd\u989d\u53d8\u5316\u91cf\u6709\u8bef", ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
        } else {
            throw new ApisBusinessException("\u4fdd\u8d39\uff0c\u4fdd\u989d\u4e0d\u80fd\u4e3a\u7a7a", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
    }

    private void dataKuayueCompletion(StanderRequest request, PolicyDTO policyDTO) {
        if (KUAYUE_CORRECT.equals(request.getHeader().getBussinessType())) {
            BigDecimal sumInsuredChg;
            BigDecimal sumPremiumChg;
            if (ObjectUtils.isNotEmpty((Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getSumPremiumChg()) && ObjectUtils.isNotEmpty((Object)policyDTO.getMain().getSumPremium()) && (sumPremiumChg = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getSumPremiumChg().subtract(BigDecimal.valueOf(policyDTO.getMain().getSumPremium())).setScale(2, 4)).compareTo(BigDecimal.ZERO) != 0) {
                request.getEndorsePriceServiceRequest().getRequestBody().getMain().setSumPremiumChg(sumPremiumChg);
            }
            if (ObjectUtils.isNotEmpty((Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getSumInsuredChg()) && ObjectUtils.isNotEmpty((Object)policyDTO.getMain().getSumAmount()) && (sumInsuredChg = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getSumInsuredChg().subtract(BigDecimal.valueOf(policyDTO.getMain().getSumAmount())).setScale(2, 4)).compareTo(BigDecimal.ZERO) != 0) {
                request.getEndorsePriceServiceRequest().getRequestBody().getMain().setSumInsuredChg(sumInsuredChg);
            }
        }
    }

    private void dataXyzValidate(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        String planCode = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        ApisPfpRationMain apisPfpRationMain = this.dataCompletionUtil.getApisPfpRationMainInfo(planCode, "2");
        if (!"JDACI".equals(apisPfpRationMain.getRationCode())) {
            return;
        }
        StanderRequest ruleRequest = StanderRequest.builder().build();
        BeanUtils.copyProperties((Object)request, (Object)ruleRequest);
        PolicyCalculateServiceRequest policyCalculateServiceRequest = PolicyCalculateServiceRequest.builder().build();
        policyCalculateServiceRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        PolicyCalculateServiceRequestDTO policyCalculateServiceRequestDTO = PolicyCalculateServiceRequestDTO.builder().build();
        QuotePriceDTO quotePriceDTO = QuotePriceDTO.builder().main(policyDTO.getMain()).coverage(policyDTO.getCoverage()).sales(policyDTO.getSalesList()).appliClient(policyDTO.getAppliClient()).build();
        String count = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getRationCount();
        ((ItemMainDTO)quotePriceDTO.getCoverage().getItemList().get(0)).setRationCount(Integer.valueOf(count));
        this.completionUtilRuleRequest(quotePriceDTO, apisPfpRationMain, policyDTO, count);
        quotePriceDTO.getCoverage().setInsuredIdvList(((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getInsuredIdvList());
        policyCalculateServiceRequestDTO.setQuotePrice(quotePriceDTO);
        policyCalculateServiceRequest.setRequestBody(policyCalculateServiceRequestDTO);
        ruleRequest.setPolicyCalculateServiceRequest(policyCalculateServiceRequest);
        StanderResponse standerResponse = this.quotePriceRulerUtil.execute(ruleRequest, "E");
        int month = policyDTO.getMain().getStartDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().until(LocalDate.now()).getMonths();
        if (month < 0) {
            month = 0;
        }
        month = 12 - month;
        BigDecimal sumPremiumChg = BigDecimal.valueOf(standerResponse.getCalculateResponse().getResponseBody().getTotalPremium() * (double)month).setScale(2, 4);
        if (ObjectUtil.isNotEmpty((Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getSumPremiumChg()) && ObjectUtil.isNotEmpty((Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getSumInsuredChg())) {
            if (sumPremiumChg.compareTo(request.getEndorsePriceServiceRequest().getRequestBody().getMain().getSumPremiumChg()) != 0) {
                throw new ApisBusinessException("\u4fdd\u8d39\u53d8\u5316\u91cf\u6709\u8bef", ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (this.calculateSumInsuredChg(request, apisPfpRationMain, ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getInsuredCount().intValue()).compareTo(request.getEndorsePriceServiceRequest().getRequestBody().getMain().getSumInsuredChg()) != 0) {
                throw new ApisBusinessException("\u4fdd\u989d\u53d8\u5316\u91cf\u6709\u8bef", ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
        } else {
            throw new ApisBusinessException("\u4fdd\u8d39\uff0c\u4fdd\u989d\u4e0d\u80fd\u4e3a\u7a7a", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        request.getEndorsePriceServiceRequest().getRequestBody().getMain().setSumPremiumChg(sumPremiumChg);
    }

    private void completionUtilRuleRequest(QuotePriceDTO quotePriceDTO, ApisPfpRationMain apisPfpRationMain, PolicyDTO policyDTO, String count) {
        List apisPfpRationKinds = this.apisPfpRationKindMapper.getApisPfpRationKindList(apisPfpRationMain.getId().longValue());
        for (ItemKindDTO itemKindDTO : ((ItemMainDTO)quotePriceDTO.getCoverage().getItemList().get(0)).getItemKind()) {
            if (!ObjectUtil.isNotEmpty((Object)apisPfpRationKinds) || apisPfpRationKinds.size() <= 0) continue;
            for (ApisPfpRationKind pfpRationKind1 : apisPfpRationKinds) {
                if (!itemKindDTO.getKindCode().equals(pfpRationKind1.getKindCode())) continue;
                BigDecimal amount = new BigDecimal(0);
                if (ObjectUtil.isEmpty((Object)pfpRationKind1.getAmount())) {
                    itemKindDTO.setSumInsured(amount);
                    continue;
                }
                amount = pfpRationKind1.getAmount().multiply(new BigDecimal(((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getInsuredCount())).multiply(new BigDecimal(Integer.valueOf(count))).setScale(2, 4);
                itemKindDTO.setSumInsured(amount);
            }
        }
    }

    private BigDecimal calculateSumInsuredChg(StanderRequest request, ApisPfpRationMain apisPfpRationMain, int insuredCount) {
        BigDecimal sum = BigDecimal.valueOf(0L);
        List apisPfpRationKinds = this.apisPfpRationKindMapper.getApisPfpRationKindList(apisPfpRationMain.getId().longValue());
        if (ObjectUtil.isNotEmpty((Object)apisPfpRationKinds) && apisPfpRationKinds.size() > 0) {
            for (ApisPfpRationKind pfpRationKind1 : apisPfpRationKinds) {
                sum = sum.add(pfpRationKind1.getAmount());
            }
        }
        return sum.multiply(BigDecimal.valueOf(Integer.valueOf(request.getEndorsePriceServiceRequest().getRequestBody().getMain().getRationCount()) * insuredCount)).setScale(2, 4);
    }

    private void generalCorrectConfirmCompletion(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        String md5Key = request.getEndorsePriceServiceRequest().getRequestHead().getConsumerSeqNo();
        request.getEndorsePriceServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        this.compensateMainConfirmParams(request, policyDTO);
        MainEndorPriceDTO main = request.getEndorsePriceServiceRequest().getRequestBody().getMain();
        if (StringUtils.isNotEmpty((CharSequence)main.getAgencyEndorsementNo())) {
            request.getEndorsePriceServiceRequest().getRequestHead().setConsumerSeqNo(request.getHeader().getUserCode() + main.getAgencyEndorsementNo());
        } else {
            request.getEndorsePriceServiceRequest().getRequestHead().setConsumerSeqNo(md5Key);
        }
        if (ObjectUtil.isEmpty((Object)main.getRenewal()) || !"1".equals(main.getRenewal().getOnlyEndorsementAr())) {
            if (ObjectUtil.isNotEmpty((Object)main.getAssociatePersons())) {
                this.compensateAppliClientConfirmParams(request, policyDTO);
                String classCode = policyDTO.getMain().getClassCode();
                if ("09".equals(classCode) || "07".equals(classCode)) {
                    this.compensateInsuredIdvConfirmParams(request, policyDTO);
                } else {
                    this.compensateInsuredConfirmParams(request, policyDTO);
                }
            }
            this.compensateItemFamily(request, policyDTO);
            this.compensateItemKind(request, policyDTO);
            this.compensateItemCaro(request, policyDTO);
        } else {
            this.compensateRenewalConfirmParams(request, policyDTO);
        }
        int validHour = DateUtil.hour((Date)main.getValidDate(), (boolean)true);
        main.setValidHour(Integer.valueOf(validHour));
    }

    private void compensateItemKind(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        CoverageDTO coverage = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getCoverage();
        if (ObjectUtil.isNotEmpty((Object)coverage) && ObjectUtil.isNotEmpty((Object)coverage.getItemList()) && ObjectUtil.isNotEmpty((Object)((ItemMainDTO)coverage.getItemList().get(0)).getItemKind())) {
            List itemKindDTOList = ((ItemMainDTO)coverage.getItemList().get(0)).getItemKind();
            ArrayList<ItemKindDTO> newItemKindDTOList = new ArrayList<ItemKindDTO>();
            ApisPfpRationMain apisPfpRationMainFlag = this.dataCompletionUtil.getApisPfpRationMainInfo(((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode(), "2");
            List apisPfpRationKinds = this.apisPfpRationKindMapper.getApisPfpRationKindList(apisPfpRationMainFlag.getId().longValue());
            if (ObjectUtil.isNotEmpty((Object)apisPfpRationKinds)) {
                for (ApisPfpRationKind pfpRationKind1 : apisPfpRationKinds) {
                    ItemKindDTO kindDTO = ItemKindDTO.builder().build();
                    kindDTO.setItemNo(((ItemMainDTO)coverage.getItemList().get(0)).getItemNo());
                    kindDTO.setKindCode(pfpRationKind1.getKindCode());
                    kindDTO.setKindName(pfpRationKind1.getKindName());
                    kindDTO.setClauseCode(pfpRationKind1.getClauseCode());
                    kindDTO.setRate(pfpRationKind1.getRate());
                    kindDTO.setCalculateInd(String.valueOf(pfpRationKind1.getCalculateInd() == null ? "" : pfpRationKind1.getCalculateInd()));
                    kindDTO.setKindInd(pfpRationKind1.getClauseType());
                    kindDTO.setClauseName(pfpRationKind1.getClauseName());
                    kindDTO.setIsOptional(pfpRationKind1.getIsOptional());
                    newItemKindDTOList.add(kindDTO);
                    ((ItemMainDTO)coverage.getItemList().get(0)).setItemKind(this.matchUpdataList(newItemKindDTOList, itemKindDTOList));
                }
            }
            this.calculateTotalPremium(request, policyDTO);
        }
    }

    private void calculateTotalPremium(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        String planCode = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        ApisPfpRationMain apisPfpRationMain = this.dataCompletionUtil.getApisPfpRationMainInfo(planCode, "2");
        List itemKindDTOList = ((ItemMainDTO)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getCoverage().getItemList().get(0)).getItemKind();
        CoverageDTO coverage = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getCoverage();
        ((ItemMainDTO)coverage.getItemList().get(0)).setGoodsCode(((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode());
        ((ItemMainDTO)coverage.getItemList().get(0)).setGoodsName(((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsName());
        ((ItemMainDTO)coverage.getItemList().get(0)).setPlanCode(((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getPlanCode());
        ((ItemMainDTO)coverage.getItemList().get(0)).setPlanName(((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getPlanName());
        ((ItemMainDTO)coverage.getItemList().get(0)).setRationCount(Integer.valueOf(policyDTO.getCoverage().getItemList().size()));
        coverage.setInsuredIdvList(((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getInsuredIdvList());
        ((ItemMainDTO)coverage.getItemList().get(0)).setInsuredCount(Integer.valueOf(coverage.getInsuredIdvList().size()));
        StanderRequest ruleRequest = StanderRequest.builder().build();
        BeanUtils.copyProperties((Object)request, (Object)ruleRequest);
        PolicyCalculateServiceRequest policyCalculateServiceRequest = PolicyCalculateServiceRequest.builder().build();
        policyCalculateServiceRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        PolicyCalculateServiceRequestDTO policyCalculateServiceRequestDTO = PolicyCalculateServiceRequestDTO.builder().build();
        QuotePriceDTO quotePriceDTO = QuotePriceDTO.builder().main(policyDTO.getMain()).coverage(coverage).sales(policyDTO.getSalesList()).appliClient(policyDTO.getAppliClient()).build();
        policyCalculateServiceRequestDTO.setQuotePrice(quotePriceDTO);
        policyCalculateServiceRequest.setRequestBody(policyCalculateServiceRequestDTO);
        ruleRequest.setPolicyCalculateServiceRequest(policyCalculateServiceRequest);
        StanderResponse standerResponse = this.quotePriceRulerUtil.execute(ruleRequest, "E");
        request.getEndorsePriceServiceRequest().getRequestBody().getMain().setMonthPremium(BigDecimal.valueOf(standerResponse.getCalculateResponse().getResponseBody().getTotalPremium()));
        BigDecimal sumPremiumChg = BigDecimal.valueOf(standerResponse.getCalculateResponse().getResponseBody().getTotalPremium() * 10.0).setScale(2, 4);
        if (ObjectUtil.isNotEmpty((Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getSumPremiumChg()) && ObjectUtil.isNotEmpty((Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getSumInsuredChg())) {
            this.log.warn("\u8d23\u4efb\u6c47\u603b\u4fdd\u8d39\u53d8\u5316\u91cf\uff1a{},\u4fdd\u5355\u603b\u4fdd\u8d39\u53d8\u5316\u91cf\uff1a{}", (Object)sumPremiumChg, (Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getSumPremiumChg());
            if (sumPremiumChg.compareTo(request.getEndorsePriceServiceRequest().getRequestBody().getMain().getSumPremiumChg()) != 0) {
                throw new ApisBusinessException("\u4fdd\u8d39\u53d8\u5316\u91cf\u6709\u8bef", ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
        } else {
            throw new ApisBusinessException("\u4fdd\u8d39\uff0c\u4fdd\u989d\u4e0d\u80fd\u4e3a\u7a7a", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        request.getEndorsePriceServiceRequest().getRequestBody().getMain().setSumPremiumChg(sumPremiumChg);
        List clauseKindDTOS = ((RationDTO)((ItemDTO)((QuotePriceRetVo)standerResponse.getCalculateResponse().getResponseBody().getQuotePriceRetVoList().get(0)).getInsQuotePriceRuleRequestDto().getItemList().get(0)).getRationList().get(0)).getClauseKindList();
        standerResponse.getCalculateResponse().getResponseBody().getTotalPremium();
        for (ItemKindDTO itemKindDTO : itemKindDTOList) {
            for (ClauseKindDTO clauseKindDTO : clauseKindDTOS) {
                if (!itemKindDTO.getClauseCode().equals(clauseKindDTO.getClauseCode()) || !itemKindDTO.getKindCode().equals(clauseKindDTO.getKindCode())) continue;
                itemKindDTO.setGrossPremium(Double.valueOf(clauseKindDTO.getKindPremium().multiply(BigDecimal.valueOf(10L)).setScale(2, 4).doubleValue()));
                itemKindDTO.setUnitPremium(Double.valueOf(clauseKindDTO.getKindPremium().multiply(BigDecimal.valueOf(10L)).setScale(2, 4).doubleValue()));
            }
        }
    }

    private List<ItemKindDTO> matchUpdataList(List<ItemKindDTO> itemKindDTOList, List<ItemKindDTO> requestItemKindDTOList) {
        ArrayList<ItemKindDTO> newItemKindDTOList = new ArrayList<ItemKindDTO>();
        block0: for (ItemKindDTO kind : itemKindDTOList) {
            for (ItemKindDTO requestKind : requestItemKindDTOList) {
                if (!kind.getKindCode().equals(requestKind.getKindCode()) || !kind.getClauseCode().equals(requestKind.getClauseCode())) continue;
                kind.setSumInsured(requestKind.getSumInsured());
                kind.setUnitAmount(Double.valueOf(requestKind.getSumInsured().doubleValue()));
                newItemKindDTOList.add(kind);
                continue block0;
            }
        }
        return newItemKindDTOList;
    }

    private void compensateItemFamily(StanderRequest request, PolicyDTO policyDTO) throws ApisDataCompletionException {
        CoverageDTO coverage = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getCoverage();
        if (ObjectUtil.isNotEmpty((Object)coverage) && ObjectUtil.isNotEmpty((Object)coverage.getItemList()) && ObjectUtil.isNotEmpty((Object)((ItemMainDTO)coverage.getItemList().get(0)).getItemFamily())) {
            String insureArea;
            ItemFamilyDTO itemFamily = (ItemFamilyDTO)((ItemMainDTO)coverage.getItemList().get(0)).getItemFamily().get(0);
            ItemFamilyDTO oldItemFamily = (ItemFamilyDTO)((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getItemFamily().get(0);
            itemFamily.setItemNo(oldItemFamily.getItemNo());
            itemFamily.setItemDetailNo(oldItemFamily.getItemDetailNo());
            if (StringUtils.isNotEmpty((CharSequence)itemFamily.getItemAddressProvince())) {
                String province = this.baseCodeConvertUtils.convertLocationCode("province", itemFamily.getItemAddressProvince(), null, null);
                if (ObjectUtil.isEmpty((Object)province)) {
                    throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10283.getValue(), ChannelErrorCodeEnum.ERR_C10283.getKey());
                }
                itemFamily.setItemAddressProvince(province);
            }
            if (StringUtils.isNotEmpty((CharSequence)itemFamily.getItemAddressCity())) {
                String itemAddressCity = this.baseCodeConvertUtils.convertLocationCode("city", itemFamily.getItemAddressProvince(), itemFamily.getItemAddressCity(), null);
                if (ObjectUtil.isEmpty((Object)itemAddressCity)) {
                    throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10283.getValue(), ChannelErrorCodeEnum.ERR_C10283.getKey());
                }
                itemFamily.setItemAddressCity(StringUtils.isNotEmpty((CharSequence)itemAddressCity) ? itemAddressCity : "990000");
            }
            if (StringUtils.isNotEmpty((CharSequence)itemFamily.getItemAddressRegion())) {
                String itemAddressRegion = this.baseCodeConvertUtils.convertLocationCode("subCity", itemFamily.getItemAddressProvince(), itemFamily.getItemAddressCity(), itemFamily.getItemAddressRegion());
                itemFamily.setItemAddressRegion(StringUtils.isNotEmpty((CharSequence)itemAddressRegion) ? itemAddressRegion : "990000");
            }
            if (ObjectUtil.isNotEmpty((Object)(insureArea = this.redisTemplateUtil.getApisChannelConfigsByConfigCodeAndRationCode("GOODS_INSURED_AREA_LIMIT", ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode(), RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code))) && (ObjectUtil.isNotEmpty((Object)itemFamily.getItemAddressProvince()) || ObjectUtil.isNotEmpty((Object)itemFamily.getItemAddressCity())) && !insureArea.contains(itemFamily.getItemAddressProvince() + "-" + itemFamily.getItemAddressCity())) {
                throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10239.getValue(), ChannelErrorCodeEnum.ERR_C10239.getKey());
            }
        }
    }

    private void compensateItemCaro(StanderRequest request, PolicyDTO policyDTO) throws ApisDataCompletionException {
        CoverageDTO coverage = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getCoverage();
        if (ObjectUtil.isNotEmpty((Object)coverage) && ObjectUtil.isNotEmpty((Object)coverage.getItemList()) && ObjectUtil.isNotEmpty((Object)((ItemMainDTO)coverage.getItemList().get(0)).getItemCargo())) {
            ItemCargoDTO itemCargo = (ItemCargoDTO)((ItemMainDTO)coverage.getItemList().get(0)).getItemCargo().get(0);
            ItemCargoDTO oldItemCargo = (ItemCargoDTO)((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getItemCargo().get(0);
            itemCargo.setItemNo(oldItemCargo.getItemNo());
        }
    }

    private void compensateInsuredIdvConfirmParams(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        AssociatePersonsDTO associatePersons = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getAssociatePersons();
        if (ObjectUtil.isEmpty((Object)associatePersons) || ObjectUtil.isEmpty((Object)associatePersons.getInsuredIdvList())) {
            return;
        }
        associatePersons.setInsuredList(null);
        List insuredIdvList = associatePersons.getInsuredIdvList();
        List oldInsuredIdvList = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getInsuredIdvList();
        for (InsuredIdvDTO insured : insuredIdvList) {
            InsuredIdvDTO oldInsured = this.getOldInsured(insured, oldInsuredIdvList);
            if (ObjectUtil.isEmpty((Object)insured.getSerialNo())) {
                insured.setSerialNo(oldInsured.getSerialNo());
            }
            if (ObjectUtil.isEmpty((Object)insured.getOrignInsuredNam())) {
                insured.setOrignInsuredNam(oldInsured.getInsuredName());
            }
            if (StringUtils.isEmpty((CharSequence)insured.getOrignInsuredIdyNo())) {
                insured.setOrignInsuredIdyNo(oldInsured.getIdentifyNumber());
            }
            insured.setOperatorType(INSURED_OPERATOR_TYPE_C);
            if (!ObjectUtil.isEmpty((Object)insured.getInsuredType())) continue;
            insured.setInsuredType(oldInsured.getInsuredType());
        }
    }

    private void compensateInsuredConfirmParams(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        MainEndorPriceDTO main = request.getEndorsePriceServiceRequest().getRequestBody().getMain();
        if (ObjectUtil.isEmpty((Object)main.getAssociatePersons().getInsuredList())) {
            return;
        }
        main.getAssociatePersons().setInsuredIdvList(null);
        List insuredList = main.getAssociatePersons().getInsuredList();
        List oldInsuredList = policyDTO.getInsuredList();
        for (InsuredDTO insured : insuredList) {
            InsuredDTO oldInsured = this.getOldInsured(insured, oldInsuredList);
            if (ObjectUtil.isEmpty((Object)insured.getSerialNo())) {
                insured.setSerialNo(oldInsured.getSerialNo());
            }
            if (ObjectUtil.isEmpty((Object)insured.getOrignInsuredNam())) {
                insured.setOrignInsuredNam(oldInsured.getInsuredName());
            }
            if (StringUtils.isEmpty((CharSequence)insured.getOrignInsuredIdyNo())) {
                insured.setOrignInsuredIdyNo(oldInsured.getIdentifyNumber());
            }
            insured.setOperatorType(INSURED_OPERATOR_TYPE_C);
            if (!ObjectUtil.isEmpty((Object)insured.getInsuredType())) continue;
            insured.setInsuredType(oldInsured.getInsuredType());
        }
    }

    private void compensateAppliClientConfirmParams(StanderRequest request, PolicyDTO policyDTO) {
        MainEndorPriceDTO main = request.getEndorsePriceServiceRequest().getRequestBody().getMain();
        if (ObjectUtil.isEmpty((Object)main.getAssociatePersons().getAppliClient())) {
            return;
        }
        AppliClientDTO appliClient = (AppliClientDTO)main.getAssociatePersons().getAppliClient().get(0);
        AppliClientDTO oldAppliClient = (AppliClientDTO)policyDTO.getAppliClient().get(0);
        if (!"P070006".equals(policyDTO.getMain().getRiskCode())) {
            if (ObjectUtil.isEmpty((Object)appliClient.getInsuredName())) {
                appliClient.setInsuredName(oldAppliClient.getInsuredName());
            }
            if (ObjectUtil.isEmpty((Object)appliClient.getInsuredType())) {
                appliClient.setInsuredType(oldAppliClient.getInsuredType());
            }
        }
    }

    private void compensateMainConfirmParams(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        EndorsePriceRequestDTO endorsePriceRequestDTO = request.getEndorsePriceServiceRequest().getRequestBody();
        MainEndorPriceDTO mainEndorPriceDTO = endorsePriceRequestDTO.getMain();
        if (StringUtils.isEmpty((CharSequence)mainEndorPriceDTO.getEndorseType())) {
            mainEndorPriceDTO.setEndorseType(ENDORSE_TYPE_GENERAL);
        }
        if ("5".equals(mainEndorPriceDTO.getEndorseType())) {
            mainEndorPriceDTO.setEndorseType(ENDORSE_TYPE_GENERAL);
            mainEndorPriceDTO.setSubEndorType("05");
        }
        Date validDate = new Date();
        if (ObjectUtil.isNotEmpty((Object)mainEndorPriceDTO.getValidDate())) {
            validDate = mainEndorPriceDTO.getValidDate();
        }
        if (policyDTO.getMain().getStartDate().getTime() >= validDate.getTime()) {
            validDate = policyDTO.getMain().getStartDate();
        }
        if (KUAYUE_CORRECT.equals(request.getHeader().getBussinessType())) {
            validDate = policyDTO.getMain().getStartDate();
        }
        mainEndorPriceDTO.setValidDate(validDate);
        mainEndorPriceDTO.setEndDate(policyDTO.getMain().getEndDate());
        mainEndorPriceDTO.setOperateCode(policyDTO.getMain().getOperateCode());
        mainEndorPriceDTO.setIsPrePrice("N");
    }

    private PolicyDTO executePolicyDetails(StanderRequest request) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)request.getEndorsePriceServiceRequest().getRequestBody()) || ObjectUtil.isEmpty((Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain()) || ObjectUtil.isEmpty((Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getPolicyNo())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u3010\u4fdd\u5355\u53f7\u3011"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        String policyNo = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getPolicyNo();
        PolicyDTO policyDetail = null;
        try {
            policyDetail = this.dataCompletionUtil.getPolicyDetail(request, policyNo, false);
        }
        catch (ApisBusinessException apisBusinessException) {
            if ("0007".equals(apisBusinessException.getErrorCode())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10113.getValue(), ChannelErrorCodeEnum.ERR_C10113.getKey());
            }
            throw apisBusinessException;
        }
        return policyDetail;
    }

    private void validateRequest(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        this.checkPolicy(request, policyDTO);
        this.validateMain(request);
        MainEndorPriceDTO main = request.getEndorsePriceServiceRequest().getRequestBody().getMain();
        if (ObjectUtil.isNotEmpty((Object)main.getAssociatePersons())) {
            Date startDate = ObjectUtil.isEmpty((Object)main.getStartDate()) ? policyDTO.getMain().getStartDate() : main.getStartDate();
            this.validateAppliClient(main.getAssociatePersons(), policyDTO, startDate);
            String classCode = policyDTO.getMain().getClassCode();
            if ("09".equals(classCode) || "07".equals(classCode)) {
                this.validateInsuredIdv(main.getAssociatePersons(), policyDTO);
            } else {
                this.validateInsured(main.getAssociatePersons(), policyDTO);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)main.getRenewal())) {
            if (ObjectUtil.isEmpty((Object)main.getAssociatePersons()) && ObjectUtil.isEmpty((Object)main.getCoverage())) {
                this.validateRenewal(request, main.getRenewal(), policyDTO);
            } else {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10495.getValue(), ChannelErrorCodeEnum.ERR_C10495.getKey());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)main.getEndorseType()) && "77".equals(main.getEndorseType())) {
            ApisChannelConfigs channelConfigsCondition = new ApisChannelConfigs();
            channelConfigsCondition.setConfigCode("insurancePremiumCorrect");
            channelConfigsCondition.setUserCode(request.getHeader().getUserCode());
            ApisChannelConfigs configsPremiumCorrect = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
            if (ObjectUtil.isEmpty((Object)configsPremiumCorrect)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10639.getValue(), ChannelErrorCodeEnum.ERR_C10639.getKey());
            }
        }
    }

    private void validateRenewal(StanderRequest request, RenewalInfoDTO renewal, PolicyDTO policyDTO) throws ApisBusinessException {
        String classCode = policyDTO.getMain().getClassCode();
        String userCode = request.getHeader().getUserCode();
        ApisChannelConfigs correctRenewalInfo = this.dataCompletionUtil.getConfig(userCode, "correct_renewal_info");
        if (ObjectUtil.isEmpty((Object)correctRenewalInfo)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10491.getValue(), ChannelErrorCodeEnum.ERR_C10491.getKey());
        }
        if (!"07".equals(classCode) && !"09".equals(classCode)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10322.getValue(), ChannelErrorCodeEnum.ERR_C10322.getKey());
        }
        if (ObjectUtil.isEmpty((Object)renewal.getAutoTransRenewFlag())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10323.getValue(), ChannelErrorCodeEnum.ERR_C10323.getKey());
        }
        if (!"1".equals(renewal.getAutoTransRenewFlag()) && !"0".equals(renewal.getAutoTransRenewFlag())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10325.getValue(), ChannelErrorCodeEnum.ERR_C10325.getKey());
        }
        if ("1".equals(renewal.getAutoTransRenewFlag())) {
            if (ObjectUtil.isEmpty((Object)renewal.getAccount()) || ObjectUtil.isEmpty((Object)renewal.getBankName())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10324.getValue(), ChannelErrorCodeEnum.ERR_C10324.getKey());
            }
            ApisChannelCode apisChannelCode = new ApisChannelCode();
            apisChannelCode.setCode("auto_renewal_bank");
            apisChannelCode.setDeleted(Integer.valueOf(0));
            apisChannelCode.setChannelValue(renewal.getBankName());
            QueryWrapper queryWrapper = new QueryWrapper((Object)apisChannelCode);
            ApisChannelCode bank = (ApisChannelCode)this.apisChannelCodeService.getOne((Wrapper)queryWrapper);
            if (ObjectUtil.isEmpty((Object)bank)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10321.getValue(), ChannelErrorCodeEnum.ERR_C10321.getKey());
            }
            String rationFlag = "2";
            String goodsCode = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode();
            ApisPfpRationMain apisPfpRationMainInfo = this.dataCompletionUtil.getApisPfpRationMainInfo(goodsCode, rationFlag);
            if (ObjectUtil.isEmpty((Object)apisPfpRationMainInfo)) {
                this.log.error("\u7eed\u4fdd\u6821\u9a8c---\u300b\u65e0\u6cd5\u83b7\u53d6\u8ba1\u5212\u4ee3\u7801\uff1a{}", (Object)goodsCode);
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10024.getValue(), ChannelErrorCodeEnum.ERR_C10024.getKey());
            }
            if (!"Y".equals(apisPfpRationMainInfo.getIsSupportRenew())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10320.getValue(), ChannelErrorCodeEnum.ERR_C10320.getKey());
            }
        }
        if (ObjectUtil.isEmpty((Object)renewal.getOnlyEndorsementAr())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u3010\u66f4\u65b0\u81ea\u52a8\u7eed\u4fdd\u4fe1\u606f\u6807\u8bb0\u3011"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (!"1".equals(renewal.getOnlyEndorsementAr())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10013.getValue().replace("##", "\u3010\u66f4\u65b0\u81ea\u52a8\u7eed\u4fdd\u4fe1\u606f\u6807\u8bb0\u3011"), ChannelErrorCodeEnum.ERR_C10013.getKey());
        }
    }

    private void checkPolicy(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        MainDTO main = policyDTO.getMain();
        String userCode = policyDTO.getMain().getOperateCode();
        if (ObjectUtil.isEmpty((Object)main.getPolicyStatus()) || !"1".equals(main.getPolicyStatus())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10421.getValue(), ChannelErrorCodeEnum.ERR_C10421.getKey());
        }
        String planCode = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
        apisChannelConfigs.setRationCode(planCode);
        apisChannelConfigs.setConfigCode("AMOUNT_CORRECT_POWER");
        apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
        this.log.warn("\u6279\u6539\u8d60\u9669\u7c7b\u578b\u4e3a\uff1a{}", (Object)policyDTO.getMain().getGiftType());
        if (StringUtils.isNotEmpty((CharSequence)policyDTO.getMain().getGiftType()) && !policyDTO.getMain().getGiftType().equals("0") && ObjectUtil.isEmpty((Object)apisChannelConfigs)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10506.getValue(), ChannelErrorCodeEnum.ERR_C10506.getKey());
        }
        Date startDate = policyDTO.getMain().getStartDate();
        Date endDate = policyDTO.getMain().getEndDate();
        Date validDate = new Date();
        if (KUAYUE_CORRECT.equals(request.getHeader().getBussinessType()) && DateUtil.between((Date)startDate, (Date)new Date(), (DateUnit)DateUnit.DAY, (boolean)false) >= 2L) {
            throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10681.getKey()).message(ChannelErrorCodeEnum.ERR_C10681.getValue()).build();
        }
    }

    private void validateInsuredIdv(AssociatePersonsDTO associatePersons, PolicyDTO policyDTO) throws ApisBusinessException {
        if (ObjectUtil.isNotEmpty((Object)associatePersons.getInsuredIdvList())) {
            for (InsuredIdvDTO insured : associatePersons.getInsuredIdvList()) {
                String insuredSex;
                String identifyType;
                List oldInsuredIdvList = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getInsuredIdvList();
                InsuredIdvDTO oldInsured = this.getOldInsured(insured, oldInsuredIdvList);
                String riskCode = policyDTO.getMain().getRiskCode();
                String classCode = policyDTO.getMain().getClassCode();
                String name = ObjectUtil.isNotEmpty((Object)insured.getInsuredName()) ? insured.getInsuredName() : oldInsured.getInsuredName();
                String identifyNumber = ObjectUtil.isNotEmpty((Object)insured.getIdentifyNumber()) ? insured.getIdentifyNumber() : oldInsured.getIdentifyNumber();
                String string = identifyType = ObjectUtil.isNotEmpty((Object)insured.getIdentifyType()) ? insured.getIdentifyType() : oldInsured.getIdentifyType();
                if (Arrays.asList(QuotePriceValidate.ACCIDENT_HEALTH_RISKCODE).contains(riskCode) && StringUtils.isNotEmpty((CharSequence)insured.getInsuredName())) {
                    this.checkInsureName(insured.getInsuredName(), identifyNumber);
                }
                if (Arrays.asList(QuotePriceValidate.ACCIDENT_HEALTH_RISKCODE).contains(riskCode) && StringUtils.isNotEmpty((CharSequence)insured.getInsuredEname())) {
                    this.checkEnName(insured.getInsuredEname());
                }
                if (BusinessConstants.IDCARD_TYPE.contains(identifyType) && ObjectUtil.isNotEmpty((Object)(insuredSex = this.getValueDefault(insured.getSex(), oldInsured.getSex()))) && !insuredSex.equals(String.valueOf(IdcardUtil.getGenderByIdCard((String)identifyNumber) == 1 ? 1 : 2))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10617.getValue(), ChannelErrorCodeEnum.ERR_C10617.getKey());
                }
                if (ObjectUtil.isNotEmpty((Object)insured.getEmail()) && !insured.getEmail().matches(GeneralRegxs.Email)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10144.getValue(), ChannelErrorCodeEnum.ERR_C10144.getKey());
                }
                if (!ObjectUtil.isNotEmpty((Object)insured.getIdentifyNumber())) continue;
                String identityType = "";
                if (ObjectUtil.isNotEmpty((Object)insured.getIdentifyType())) {
                    identityType = insured.getIdentifyType();
                } else if (ObjectUtil.isNotEmpty((Object)oldInsured.getIdentifyType())) {
                    identityType = oldInsured.getIdentifyType();
                }
                if (IDENTITY_TYPE.equals(identityType)) {
                    int age;
                    if (!insured.getIdentifyNumber().matches(GeneralRegxs.IdentifyNumber)) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10078.getValue().replace("##", insured.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10078.getKey());
                    }
                    String birthdayStr = insured.getIdentifyNumber().substring(6, 14);
                    try {
                        Date birthday = DateUtils.parseDate((String)birthdayStr, (String[])new String[]{"yyyyMMdd"});
                        age = this.dataCompletionUtil.calculateAge(policyDTO.getMain().getStartDate(), birthday);
                    }
                    catch (ParseException e) {
                        this.log.warn("\u88ab\u4fdd\u4eba\u3010##\u3011\u51fa\u751f\u65e5\u8f6c\u6362\u5f02\u5e38\uff1a".replace("##", insured.getIdentifyNumber()) + birthdayStr);
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10005.getValue(), ChannelErrorCodeEnum.ERR_C10005.getKey());
                    }
                    ApisPfpRationMain apisPfpRationMainInfo = this.dataCompletionUtil.getApisPfpRationMainInfo(((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode(), "2");
                    if (ObjectUtil.isEmpty((Object)apisPfpRationMainInfo)) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10024.getValue(), ChannelErrorCodeEnum.ERR_C10024.getKey());
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)apisPfpRationMainInfo.getAgeMin()) || !StringUtils.isNotEmpty((CharSequence)apisPfpRationMainInfo.getAgeMax()) || age >= Integer.valueOf(apisPfpRationMainInfo.getAgeMin()) && age <= Integer.valueOf(apisPfpRationMainInfo.getAgeMax())) continue;
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10366.getValue().replaceFirst("##", name).replaceFirst("##", identifyNumber).replaceFirst("##", apisPfpRationMainInfo.getAgeMin()).replaceFirst("##", apisPfpRationMainInfo.getAgeMax()), ChannelErrorCodeEnum.ERR_C10366.getKey());
                }
                if (insured.getIdentifyNumber().matches(GeneralRegxs.PassportOtherIdNo)) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10078.getValue().replace("##", insured.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10078.getKey());
            }
        }
    }

    private String getValueDefault(String a, String b) {
        return ObjectUtil.isEmpty((Object)a) ? b : a;
    }

    private InsuredDTO getOldInsured(InsuredDTO insured, List<InsuredDTO> oldInsuredList) throws ApisBusinessException {
        InsuredDTO oldInsured = null;
        if (ObjectUtil.isNotEmpty((Object)insured.getSerialNo()) && ObjectUtil.isNotEmpty((Object)insured.getOrignInsuredNam()) && ObjectUtil.isNotEmpty((Object)insured.getOrignInsuredIdyNo())) {
            for (InsuredDTO old : oldInsuredList) {
                if (!old.getSerialNo().equals(insured.getSerialNo()) || !old.getIdentifyNumber().equals(insured.getOrignInsuredIdyNo()) || !old.getInsuredName().equals(insured.getOrignInsuredNam())) continue;
                oldInsured = old;
                break;
            }
            if (ObjectUtil.isEmpty((Object)oldInsured)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10111.getValue(), ChannelErrorCodeEnum.ERR_C10111.getKey());
            }
        } else {
            oldInsured = oldInsuredList.get(0);
        }
        return oldInsured;
    }

    private InsuredIdvDTO getOldInsured(InsuredIdvDTO insured, List<InsuredIdvDTO> oldInsuredIdvList) throws ApisBusinessException {
        InsuredIdvDTO oldInsured = null;
        if (ObjectUtil.isNotEmpty((Object)insured.getSerialNo()) && ObjectUtil.isNotEmpty((Object)insured.getOrignInsuredNam()) && ObjectUtil.isNotEmpty((Object)insured.getOrignInsuredIdyNo())) {
            for (InsuredIdvDTO old : oldInsuredIdvList) {
                if (!old.getSerialNo().equals(insured.getSerialNo()) || !old.getIdentifyNumber().equals(insured.getOrignInsuredIdyNo()) || !old.getInsuredName().equals(insured.getOrignInsuredNam())) continue;
                oldInsured = old;
                break;
            }
            if (ObjectUtil.isEmpty((Object)oldInsured)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10111.getValue(), ChannelErrorCodeEnum.ERR_C10111.getKey());
            }
        } else {
            oldInsured = oldInsuredIdvList.get(0);
        }
        return oldInsured;
    }

    private void validateInsured(AssociatePersonsDTO associatePersons, PolicyDTO policyDTO) throws ApisBusinessException {
        if (ObjectUtil.isNotEmpty((Object)associatePersons.getInsuredList())) {
            List insuredList = associatePersons.getInsuredList();
            for (InsuredDTO insured : insuredList) {
                List oldInsuredList = policyDTO.getInsuredList();
                InsuredDTO oldInsured = this.getOldInsured(insured, oldInsuredList);
                if (ObjectUtil.isNotEmpty((Object)insured.getEmail()) && !insured.getEmail().matches(GeneralRegxs.Email)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10144.getValue(), ChannelErrorCodeEnum.ERR_C10144.getKey());
                }
                if (!ObjectUtil.isNotEmpty((Object)insured.getIdentifyNumber())) continue;
                String identityType = "";
                if (ObjectUtil.isNotEmpty((Object)insured.getIdentifyType())) {
                    identityType = insured.getIdentifyType();
                } else if (ObjectUtil.isNotEmpty((Object)oldInsured.getIdentifyType())) {
                    identityType = oldInsured.getIdentifyType();
                }
                if (!(IDENTITY_TYPE.equals(identityType) ? !insured.getIdentifyNumber().matches(GeneralRegxs.IdentifyNumber) : !insured.getIdentifyNumber().matches(GeneralRegxs.PassportOtherIdNo))) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10078.getValue().replace("##", insured.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10078.getKey());
            }
        }
    }

    private void validateAppliClient(AssociatePersonsDTO associatePersons, PolicyDTO policyDTO, Date startDate) throws ApisBusinessException {
        if (ObjectUtil.isNotEmpty((Object)associatePersons.getAppliClient())) {
            AppliClientDTO appliClient = (AppliClientDTO)associatePersons.getAppliClient().get(0);
            AppliClientDTO oldAppliClient = (AppliClientDTO)policyDTO.getAppliClient().get(0);
            if (ObjectUtil.isNotEmpty((Object)appliClient.getEmail()) && !appliClient.getEmail().matches(GeneralRegxs.Email)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10132.getValue(), ChannelErrorCodeEnum.ERR_C10132.getKey());
            }
            if (ObjectUtil.isNotEmpty((Object)appliClient.getIdentifyNumber())) {
                String identityType = "";
                if (ObjectUtil.isNotEmpty((Object)appliClient.getIdentifyType())) {
                    identityType = appliClient.getIdentifyType();
                } else if (ObjectUtil.isNotEmpty((Object)oldAppliClient.getIdentifyType())) {
                    identityType = oldAppliClient.getIdentifyType();
                }
                if (IDENTITY_TYPE.equals(identityType) ? !appliClient.getIdentifyNumber().matches(GeneralRegxs.IdentifyNumber) : !appliClient.getIdentifyNumber().matches(GeneralRegxs.PassportOtherIdNo)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10073.getValue().replace("##", appliClient.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10073.getKey());
                }
            }
            if (Arrays.asList(QuotePriceValidate.ACCIDENT_HEALTH_RISKCODE).contains(policyDTO.getMain().getRiskCode())) {
                String sex;
                if (StringUtils.isNotEmpty((CharSequence)appliClient.getInsuredName())) {
                    this.checkInsureName(appliClient.getInsuredName(), appliClient.getIdentifyNumber());
                }
                if (StringUtils.isNotEmpty((CharSequence)appliClient.getInsuredEname())) {
                    this.checkEnName(appliClient.getInsuredEname());
                }
                String insuredType = ObjectUtil.isEmpty((Object)appliClient.getInsuredType()) ? ((AppliClientDTO)policyDTO.getAppliClient().get(0)).getInsuredType() : appliClient.getInsuredType();
                String identifyType = ObjectUtil.isEmpty((Object)appliClient.getIdentifyType()) ? ((AppliClientDTO)policyDTO.getAppliClient().get(0)).getIdentifyType() : appliClient.getIdentifyType();
                String identifyNumber = ObjectUtil.isEmpty((Object)appliClient.getIdentifyNumber()) ? ((AppliClientDTO)policyDTO.getAppliClient().get(0)).getIdentifyNumber() : appliClient.getIdentifyNumber();
                Date birthDay = ObjectUtil.isEmpty((Object)appliClient.getBirthday()) ? ((AppliClientDTO)policyDTO.getAppliClient().get(0)).getBirthday() : appliClient.getBirthday();
                String string = sex = ObjectUtil.isEmpty((Object)appliClient.getSex()) ? ((AppliClientDTO)policyDTO.getAppliClient().get(0)).getSex() : appliClient.getSex();
                if ("1".equals(insuredType) && !Arrays.asList(BusinessConstants.ID_TYPE_PERSONAL).contains(identifyType)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
                }
                if ("2".equals(insuredType) && !Arrays.asList(BusinessConstants.ID_TYPE_COMPANY).contains(identifyType)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
                }
                if (IDENTITY_TYPE.equals(identifyType) || "13".equals(identifyType)) {
                    if (StringUtils.isNotBlank((CharSequence)identifyNumber) && !IdcardUtil.isValidCard((String)identifyNumber)) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10073.getValue().replace("##", identifyNumber), ChannelErrorCodeEnum.ERR_C10073.getKey());
                    }
                    String birthDateStr = IdcardUtil.getBirth((String)identifyNumber);
                    if (ObjectUtil.isNotEmpty((Object)birthDay)) {
                        String birthDayVaild = sinosoftgz.utils.data.DateUtils.dateToStr((Date)birthDay, (String)"yyyyMMdd");
                        if (!birthDateStr.equals(birthDayVaild)) {
                            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10240.getValue().replace("##", identifyNumber), ChannelErrorCodeEnum.ERR_C10240.getKey());
                        }
                        if (this.dataCompletionUtil.calculateAge(startDate, birthDay) < BusinessConstants.MINOR_AGE) {
                            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10282.getValue(), ChannelErrorCodeEnum.ERR_C10282.getKey());
                        }
                    }
                    if (ObjectUtil.isNotEmpty((Object)sex) && !sex.equals(String.valueOf(IdcardUtil.getGenderByIdCard((String)identifyNumber) == 1 ? 1 : 2))) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10616.getValue(), ChannelErrorCodeEnum.ERR_C10616.getKey());
                    }
                } else {
                    IdNumberUtil.ClientType clientType = null;
                    if ("1".equals(identifyType)) {
                        clientType = IdNumberUtil.ClientType.PERSONAL;
                    } else if ("2".equals(identifyType)) {
                        clientType = IdNumberUtil.ClientType.CLIENT;
                    }
                    this.quotePriceValidate.validateIdNumberByIdType(identifyType, identifyNumber, policyDTO.getMain().getRiskCode(), IdNumberUtil.PersonnelType.HOLDER, clientType, policyDTO.getSalesList().getAgentCode(), policyDTO.getMain().getOperateCode());
                }
            }
        }
    }

    private void checkEnName(String enName) throws ApisBusinessException {
        boolean isValidEname;
        String regexEnName = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_NAME_EN", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
        if (StringUtils.isBlank((CharSequence)regexEnName) || "NoData".equalsIgnoreCase(regexEnName)) {
            regexEnName = GeneralRegxs.Ename;
        }
        boolean bl = isValidEname = StringUtils.isNotBlank((CharSequence)regexEnName) && !"NoCheck".equals(regexEnName);
        if (StringUtils.isNotEmpty((CharSequence)enName) && isValidEname && !enName.trim().matches(regexEnName)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10619.getValue().replaceFirst("##", enName), ChannelErrorCodeEnum.ERR_C10619.getKey());
        }
    }

    public void checkInsureName(String insuredName, String identifyNumber) throws ApisBusinessException {
        if (StringUtils.isNotEmpty((CharSequence)insuredName) && !insuredName.trim().replace(" ", "").matches(GeneralRegxs.Name) || insuredName.trim().length() < 2) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10134.getValue().replaceFirst("##", insuredName).replace("##", identifyNumber), ChannelErrorCodeEnum.ERR_C10134.getKey());
        }
    }

    private void validateMain(StanderRequest request) throws ApisBusinessException {
        MainEndorPriceDTO main = request.getEndorsePriceServiceRequest().getRequestBody().getMain();
        if (!KUAYUE_CORRECT.equals(request.getHeader().getBussinessType()) && ObjectUtil.isEmpty((Object)main.getReason())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u3010\u6279\u6539\u539f\u56e0\u3011"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isNotEmpty((Object)main.getStartDate()) && ObjectUtil.isEmpty((Object)main.getEndDate()) || ObjectUtil.isEmpty((Object)main.getStartDate()) && ObjectUtil.isNotEmpty((Object)main.getEndDate())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10203.getValue(), ChannelErrorCodeEnum.ERR_C10203.getKey());
        }
    }

    private void compensateRenewalConfirmParams(StanderRequest request, PolicyDTO policyDTO) {
        MainEndorPriceDTO main = request.getEndorsePriceServiceRequest().getRequestBody().getMain();
        if ("1".equals(main.getRenewal().getAutoTransRenewFlag())) {
            main.getRenewal().setAutoDeduction(main.getRenewal().getAutoTransRenewFlag());
            ApisChannelCode apisChannelCode = new ApisChannelCode();
            apisChannelCode.setCode("auto_renewal_bank");
            apisChannelCode.setDeleted(Integer.valueOf(0));
            apisChannelCode.setChannelValue(main.getRenewal().getBankName());
            QueryWrapper queryWrapper = new QueryWrapper((Object)apisChannelCode);
            ApisChannelCode bank = (ApisChannelCode)this.apisChannelCodeService.getOne((Wrapper)queryWrapper);
            main.getRenewal().setBankType(bank.getValue());
            if (ObjectUtils.isEmpty((Object)policyDTO.getRenewal()) | StringUtils.isEmpty((CharSequence)policyDTO.getRenewal().getAccountName())) {
                main.getRenewal().setAccountName(((AppliClientDTO)policyDTO.getAppliClient().get(0)).getInsuredName());
            }
        } else {
            main.getRenewal().setAutoDeduction(main.getRenewal().getAutoTransRenewFlag());
            main.getRenewal().setAutoTransRenewFlag(null);
        }
    }
}

