/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.EmployeeImageUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.MediaUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiBudgetRequest;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiBudgetRequestService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.TeamPersonsDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CorrectQuotePriceServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.EndorseApplyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.EndorseServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.EndorseServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.MainEndorResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.constants.ApisCommonConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreCorrectApi;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderGroupBudgetHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderGroupBudgetHandler.class);
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    private EmployeeImageUploadUtil employeeImageUploadUtil;
    @Autowired
    CoreCorrectApi coreCorrectApi;
    @Autowired
    MediaUploadUtil mediaUploadUtil;
    @Autowired
    ApisBusiBudgetRequestService apisBusiBudgetRequestService;
    private static final String BUDGET = "budget";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        this.dataCompletionUtil.verifyRepeatRequest(request);
        request.getQuotePriceServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        MainDTO mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        List planList = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPlanList();
        if (ObjectUtils.isEmpty((Object)planList)) {
            request.getQuotePriceServiceRequest().getRequestHead().setConsumerSeqNo(request.getHeader().getUserCode() + mainDTO.getOrderNo());
        } else {
            request.getQuotePriceServiceRequest().getRequestHead().setConsumerSeqNo(request.getHeader().getUserCode() + request.getHeader().getBusinessKey());
        }
        PolicyDTO policyDTO = this.dataCompletionUtil.executeGroupCorrectPolicyDetails(request);
        request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().setPolicyDTO(policyDTO);
        this.dataCompletionUtil.selfHelpPlatformProcess(request, request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPolicyDTO());
        this.dataCompletionUtil.verifyGroupCorrectDate(request);
        List insuredIdvList = this.dataCompletionUtil.transformInsured(request);
        this.dataCompletionUtil.transformEmp(request);
        this.dataCompletionUtil.dataCorrectConfirmCompletion(request, insuredIdvList);
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        int status;
        StanderResponse response;
        ApisChannelConfigs channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setConfigCode("employee_count_flag");
        if (ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPolicyDTO().getSalesList())) {
            channelConfigsCondition.setChannelCode(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPolicyDTO().getSalesList().getAgentCode());
        }
        TeamPersonsDTO teamPersonsDTO = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getTeamPersons();
        String employeeCount = null;
        ApisChannelConfigs channelConfigs = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        if (ObjectUtil.isNotEmpty((Object)channelConfigs)) {
            employeeCount = channelConfigs.getConfigValue();
        }
        if (StringUtils.isBlank(employeeCount)) {
            employeeCount = "50";
        }
        PolicyDTO policyDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPolicyDTO();
        List itemEmployeeDTOS = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getItemEmployeeDTOS();
        if (ObjectUtils.isNotEmpty((Object)itemEmployeeDTOS)) {
            teamPersonsDTO.setIsExistImgId(ApisCommonConstantsEnum.MASTER_POLICY_FALSE.getKey());
            if (itemEmployeeDTOS.size() > Integer.parseInt(employeeCount)) {
                teamPersonsDTO.setIsExistImgId(ApisCommonConstantsEnum.MASTER_POLICY_TRUE.getKey());
                String fileAddress = this.employeeImageUploadUtil.employeeListUpload(JSON.toJSONString((Object)teamPersonsDTO), policyDTO.getMain().getPolicyNo(), request);
                if (StringUtils.isBlank((CharSequence)fileAddress)) {
                    throw ApisDataCompletionException.builder().errorCode(ErrorNullValueCodeEnum.ERR_N11001.getKey()).message("\u96c7\u5458\u6e05\u5355\u4e0a\u4f20\u5f71\u50cf\u5931\u8d25").build();
                }
                teamPersonsDTO.setEmployeeList(null);
                teamPersonsDTO.setAutoSubmit(ApisCommonConstantsEnum.MASTER_POLICY_TRUE.getKey());
                teamPersonsDTO.setImgId(fileAddress);
                request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().setIssueFlag("N");
            } else {
                request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().setIssueFlag("Y");
            }
        }
        if (ObjectUtil.isEmpty((Object)(response = this.coreCorrectApi.correctQuotePrice(request)).getCorrectQuotePriceServiceResponse())) {
            this.log.error("\u6279\u6539\u9884\u8bd5\u7b97\u8fd4\u56de\u4e3a\u7a7a\uff01");
            throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B00002.getValue(), ErrorBisCodeEnum.ERR_B00002.getKey());
        }
        ResponseHeadDTO responseHead = response.getCorrectQuotePriceServiceResponse().getResponseHead();
        if (ObjectUtil.isNotEmpty((Object)responseHead) && 0 == (status = responseHead.getStatus())) {
            this.log.error(responseHead.getAppMessage());
            throw new ApisBusinessException(responseHead.getAppMessage(), responseHead.getAppCode());
        }
        return response;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) {
        CorrectQuotePriceServiceResponse correctQuotePriceServiceResponse = response.getCorrectQuotePriceServiceResponse();
        EndorseServiceResponse endorseServiceResponse = new EndorseServiceResponse();
        EndorseServiceResponseDTO endorseServiceResponseDTO = new EndorseServiceResponseDTO();
        if (correctQuotePriceServiceResponse.getResponseHead().getStatus() == 1) {
            MainDTO mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
            String applyNo = null;
            String policyNo = null;
            applyNo = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getPolicyNo();
            Double sumPremium = correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain().getSumPremium();
            Double chgSumPremium = correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain().getChgSumPremium();
            String policyStatus = "70";
            policyNo = correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain().getApplyNo();
            MainEndorResponseDTO main = new MainEndorResponseDTO();
            main.setApplyNo(applyNo);
            main.setPolicyStatus(policyStatus);
            main.setPolicyNo(policyNo);
            main.setSumPremium(sumPremium);
            main.setChgSumPremium(chgSumPremium);
            EndorseApplyDTO endorseApply = new EndorseApplyDTO();
            endorseApply.setMain(main);
            main.setOrderId(mainDTO.getOrderNo());
            endorseServiceResponseDTO.setEndorseApply(endorseApply);
            endorseServiceResponse.setResponseHead(correctQuotePriceServiceResponse.getResponseHead());
            endorseServiceResponse.setResponseBody(endorseServiceResponseDTO);
            response.setEndorseServiceResponse(endorseServiceResponse);
            this.saveApisBusiBudgetRequest(request, correctQuotePriceServiceResponse, applyNo, policyStatus);
        } else {
            endorseServiceResponse.setResponseHead(correctQuotePriceServiceResponse.getResponseHead());
            response.setEndorseServiceResponse(endorseServiceResponse);
        }
        return response;
    }

    private void saveApisBusiBudgetRequest(StanderRequest request, CorrectQuotePriceServiceResponse correctQuotePriceServiceResponse, String applyNo, String policyStatus) {
        ApisBusiBudgetRequest apisBusiBudgetRequest = new ApisBusiBudgetRequest();
        if (ObjectUtils.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getItemEmployeeDTOS())) {
            apisBusiBudgetRequest.setBusinessKey(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getOrderNo());
        } else {
            apisBusiBudgetRequest.setBusinessKey(request.getHeader().getBusinessKey());
        }
        apisBusiBudgetRequest.setUserCode(request.getHeader().getUserCode());
        apisBusiBudgetRequest.setRequestUser(request.getHeader().getOriginUserCode());
        apisBusiBudgetRequest.setChannelCode(request.getHeader().getChannelCode());
        apisBusiBudgetRequest.setPolicyNo(applyNo);
        apisBusiBudgetRequest.setEndorseType(BUDGET);
        apisBusiBudgetRequest.setNotifyUrl(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getNotifyUrl());
        apisBusiBudgetRequest.setPolicyStatus(policyStatus);
        apisBusiBudgetRequest.setConsumerSeqNo(request.getQuotePriceServiceRequest().getRequestHead().getConsumerSeqNo());
        if (ApisCommonConstantsEnum.MASTER_POLICY_TRUE.getKey().equals(request.getEndorsePriceServiceRequest().getRequestBody().getMain().getTeamPersons().getIsExistImgId())) {
            apisBusiBudgetRequest.setStatus("0");
            apisBusiBudgetRequest.setAsyncFlag("Y");
        } else {
            apisBusiBudgetRequest.setStatus(DataCompletionUtil.POLICY_STAUTS_1);
            apisBusiBudgetRequest.setAsyncFlag("N");
        }
        Double sumPremium = correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain().getSumPremium();
        Double sumAmount = correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain().getSumAmount();
        apisBusiBudgetRequest.setSumPremium(sumPremium != null ? new BigDecimal(sumPremium) : null);
        apisBusiBudgetRequest.setSumAmount(sumAmount != null ? new BigDecimal(sumAmount) : null);
        Double chgSumPremium = correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain().getChgSumPremium();
        if (null != chgSumPremium) {
            apisBusiBudgetRequest.setSumPremiumChg(BigDecimal.valueOf(chgSumPremium));
        }
        if (null != correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain().getChgSumAmount()) {
            apisBusiBudgetRequest.setSumAmountChg(BigDecimal.valueOf(correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain().getChgSumAmount()));
        }
        this.log.warn("\u9884\u8bd5\u7b97\u63a5\u53e3\u4fdd\u5b58\u8bf7\u6c42\u6570\u636e.. businessKey = {}", (Object)request.getHeader().getBusinessKey());
        this.apisBusiBudgetRequestService.save((Object)apisBusiBudgetRequest);
    }
}

