/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.EmployeeImageUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.MediaUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RiskManagementCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorsePriceServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemEmployeeDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicySubmitRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicySubmitRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.TeamPersonsDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CorrectQuotePriceServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.EndorseApplyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.EndorseServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.EndorseServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.MainEndorResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicySubmitResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiCorrectOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiCorrectOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiCorrectReqMsgLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.constants.ApisCommonConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreCorrectApi;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderGroupCorrectHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderGroupCorrectHandler.class);
    @Autowired
    CoreCorrectApi coreCorrectApi;
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    ApisBusiCorrectReqMsgLogService apisBusiCorrectReqMsgLogService;
    @Autowired
    private ApisBusinessService apisBusinessService;
    @Autowired
    private ApisBusiCorrectOrderService apisBusiCorrectOrderService;
    @Autowired
    private RiskManagementCheckUtil riskManagementCheckUtil;
    @Autowired
    MediaUploadUtil mediaUploadUtil;
    @Autowired
    private EmployeeImageUploadUtil employeeImageUploadUtil;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    private static String CHANNEL_CODE = "all";
    private static String OPERATE_CODE = "all";
    private static String UNDER_WRITE_EX = "EX";
    private static String UNDER_WRITE_BH = "BH";
    private static String UNDER_WRITE_IN = "IN";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        this.dataCompletionUtil.verifyRepeatRequest(request);
        request.getQuotePriceServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        MainDTO mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        List planList = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPlanList();
        if (ObjectUtils.isEmpty((Object)planList)) {
            request.getQuotePriceServiceRequest().getRequestHead().setConsumerSeqNo(request.getHeader().getUserCode() + mainDTO.getOrderNo());
        } else {
            request.getQuotePriceServiceRequest().getRequestHead().setConsumerSeqNo(request.getHeader().getUserCode() + request.getHeader().getBusinessKey());
        }
        PolicyDTO policyDTO = this.dataCompletionUtil.executeGroupCorrectPolicyDetails(request);
        request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().setPolicyDTO(policyDTO);
        this.dataCompletionUtil.selfHelpPlatformProcess(request, request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPolicyDTO());
        this.dataCompletionUtil.verifyGroupCorrectDate(request);
        List insuredIdvList = this.dataCompletionUtil.transformInsured(request);
        this.dataCompletionUtil.transformEmp(request);
        this.dataCompletionUtil.dataCorrectConfirmCompletion(request, insuredIdvList);
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        int status;
        ApisChannelConfigs channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setConfigCode("employee_count_flag");
        if (ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPolicyDTO().getSalesList())) {
            channelConfigsCondition.setChannelCode(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPolicyDTO().getSalesList().getAgentCode());
        }
        TeamPersonsDTO teamPersonsDTO = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getTeamPersons();
        String employeeCount = null;
        ApisChannelConfigs channelConfigs = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        if (ObjectUtil.isNotEmpty((Object)channelConfigs)) {
            employeeCount = channelConfigs.getConfigValue();
        }
        if (StringUtils.isBlank(employeeCount)) {
            employeeCount = "50";
        }
        PolicyDTO policyDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPolicyDTO();
        List itemEmployeeDTOS = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getItemEmployeeDTOS();
        if (ObjectUtils.isNotEmpty((Object)itemEmployeeDTOS)) {
            teamPersonsDTO.setIsExistImgId(ApisCommonConstantsEnum.MASTER_POLICY_FALSE.getKey());
            if (itemEmployeeDTOS.size() > Integer.parseInt(employeeCount)) {
                teamPersonsDTO.setIsExistImgId(ApisCommonConstantsEnum.MASTER_POLICY_TRUE.getKey());
                String fileAddress = this.employeeImageUploadUtil.employeeListUpload(JSON.toJSONString((Object)teamPersonsDTO), policyDTO.getMain().getPolicyNo(), request);
                if (StringUtils.isBlank((CharSequence)fileAddress)) {
                    throw ApisDataCompletionException.builder().errorCode(ErrorNullValueCodeEnum.ERR_N11001.getKey()).message("\u96c7\u5458\u6e05\u5355\u4e0a\u4f20\u5f71\u50cf\u5931\u8d25").build();
                }
                teamPersonsDTO.setEmployeeList(null);
                teamPersonsDTO.setAutoSubmit(ApisCommonConstantsEnum.MASTER_POLICY_TRUE.getKey());
                teamPersonsDTO.setImgId(fileAddress);
                request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().setIssueFlag("N");
            } else {
                request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().setIssueFlag("Y");
            }
        }
        StanderResponse response = this.coreCorrectApi.correctQuotePrice(request);
        if (request.getEndorsePriceServiceRequest().getRequestBody().getMain().getImageList() != null && response.getCorrectQuotePriceServiceResponse().getResponseBody() != null && request.getEndorsePriceServiceRequest().getRequestBody().getMain().getImageList().size() > 0) {
            this.dataCompletionUtil.imageDataCompletion(request, request.getEndorsePriceServiceRequest().getRequestBody().getMain().getImageList(), response.getCorrectQuotePriceServiceResponse().getResponseBody().getEndorseApply().getMain().getApplyNo());
            this.mediaUploadUtil.syncImgBatchUpload(request);
        }
        if (request.getQuotePriceServiceRequest() != null && request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getImageList() != null && request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getImageList().size() > 0 && response.getCorrectQuotePriceServiceResponse().getResponseBody() != null) {
            this.dataCompletionUtil.imageDataCompletion(request, request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getImageList(), response.getCorrectQuotePriceServiceResponse().getResponseBody().getEndorseApply().getMain().getApplyNo());
            this.mediaUploadUtil.syncImgBatchUpload(request);
        }
        if (ApisCommonConstantsEnum.MASTER_POLICY_TRUE.getKey().equals(teamPersonsDTO.getAutoSubmit())) {
            // empty if block
        }
        if (ObjectUtil.isEmpty((Object)response.getCorrectQuotePriceServiceResponse())) {
            this.log.error("\u6279\u6539\u8bd5\u7b97\u8fd4\u56de\u4e3a\u7a7a\uff01");
            throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B00002.getValue(), ErrorBisCodeEnum.ERR_B00002.getKey());
        }
        ResponseHeadDTO responseHead = response.getCorrectQuotePriceServiceResponse().getResponseHead();
        if (ObjectUtil.isNotEmpty((Object)responseHead) && 0 == (status = responseHead.getStatus())) {
            this.log.error(responseHead.getAppMessage());
            throw new ApisBusinessException(responseHead.getAppMessage(), responseHead.getAppCode());
        }
        String issueFlag = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getIssueFlag();
        if (StringUtils.isNotBlank((CharSequence)issueFlag) && "Y".equals(issueFlag)) {
            int status2;
            this.dataCorrectConfirmCompletion(request, response);
            CorrectQuotePriceServiceResponse correctQuotePriceResponse = response.getCorrectQuotePriceServiceResponse();
            response = this.coreCorrectApi.correctConfirm(request);
            if (ObjectUtil.isEmpty((Object)response.getPolicySubmitResponse())) {
                this.log.error("\u6279\u5355\u786e\u8ba4\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff01");
                throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B00002.getValue(), ErrorBisCodeEnum.ERR_B00002.getKey());
            }
            ResponseHeadDTO head = response.getPolicySubmitResponse().getResponseHead();
            if (ObjectUtil.isNotEmpty((Object)head) && 0 == (status2 = head.getStatus())) {
                this.log.error(head.getAppMessage());
                throw new ApisBusinessException(head.getAppMessage(), head.getAppCode());
            }
            response.setCorrectQuotePriceServiceResponse(correctQuotePriceResponse);
        } else if (ObjectUtil.isNotEmpty((Object)response.getCorrectQuotePriceServiceResponse().getResponseBody()) && StringUtils.isNotBlank((CharSequence)issueFlag) && "N".equals(issueFlag)) {
            CorrectQuotePriceServiceResponse correctQuotePriceServiceResponse = response.getCorrectQuotePriceServiceResponse();
            EndorsePriceServiceRequest endorsePriceServiceRequest = request.getEndorsePriceServiceRequest();
        } else {
            this.log.error("\u56e2\u5355\u6279\u5355\u51fa\u5355\u63a5\u53e3>>>>>>\u5fc5\u4f20\u53c2\u6570\uff1a\u662f\u5426\u6fc0\u6d3b\u4fdd\u5355(issueFlag)\u53c2\u6570\u4e3a\u7a7a\uff01");
            throw new ApisBusinessException("\u5fc5\u4f20\u53c2\u6570\uff1a\u662f\u5426\u6fc0\u6d3b\u4fdd\u5355(issueFlag)\u53c2\u6570\u4e3a\u7a7a\uff01", "ERROR_001");
        }
        return response;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) {
        CorrectQuotePriceServiceResponse correctQuotePriceServiceResponse = response.getCorrectQuotePriceServiceResponse();
        PolicySubmitResponse policySubmitResponse = response.getPolicySubmitResponse();
        EndorseServiceResponse endorseServiceResponse = new EndorseServiceResponse();
        EndorseServiceResponseDTO endorseServiceResponseDTO = new EndorseServiceResponseDTO();
        if (correctQuotePriceServiceResponse.getResponseHead().getStatus() == 1) {
            String issueFlag = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getIssueFlag();
            MainDTO mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
            String applyNo = null;
            String policyNo = null;
            applyNo = "Y".equals(issueFlag) ? policySubmitResponse.getResponseBody().getBusinessNo() : request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getPolicyNo();
            Double sumPremium = correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain().getSumPremium();
            Double chgSumPremium = correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain().getChgSumPremium();
            String policyStatus = null;
            policyStatus = "Y".equals(issueFlag) ? "70" : "60";
            TeamPersonsDTO teamPersonsDTO = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getTeamPersons();
            policyNo = correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain().getApplyNo();
            if (StringUtils.isNotBlank((CharSequence)teamPersonsDTO.getIsExistImgId()) && ApisCommonConstantsEnum.MASTER_POLICY_FALSE.getKey().equals(teamPersonsDTO.getIsExistImgId())) {
                if (StringUtils.isNotBlank((CharSequence)mainDTO.getJFeeFlag()) && "1".equals(mainDTO.getJFeeFlag()) && chgSumPremium > 0.0) {
                    policyStatus = "60";
                    String underWriteFlag = policySubmitResponse.getResponseBody().getUnderwriteFlag();
                    policyNo = StringUtils.isNotBlank((CharSequence)policySubmitResponse.getResponseBody().getBusinessNo()) ? policySubmitResponse.getResponseBody().getBusinessNo() : correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain().getApplyNo();
                    if ("4".equals(underWriteFlag)) {
                        policyStatus = "14";
                    }
                    applyNo = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getPolicyNo();
                }
            } else if (StringUtils.isNotBlank((CharSequence)teamPersonsDTO.getIsExistImgId()) && ApisCommonConstantsEnum.MASTER_POLICY_TRUE.getKey().equals(teamPersonsDTO.getIsExistImgId())) {
                policyStatus = "14";
                applyNo = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getPolicyNo();
                policyNo = correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain().getApplyNo();
            }
            MainEndorResponseDTO main = new MainEndorResponseDTO();
            main.setApplyNo(applyNo);
            main.setPolicyStatus(policyStatus);
            main.setPolicyNo(policyNo);
            main.setSumPremium(sumPremium);
            main.setChgSumPremium(chgSumPremium);
            EndorseApplyDTO endorseApply = new EndorseApplyDTO();
            endorseApply.setMain(main);
            main.setOrderId(mainDTO.getOrderNo());
            endorseServiceResponseDTO.setEndorseApply(endorseApply);
            if (ObjectUtils.isNotEmpty((Object)policySubmitResponse)) {
                endorseServiceResponse.setResponseHead(policySubmitResponse.getResponseHead());
            } else {
                endorseServiceResponse.setResponseHead(correctQuotePriceServiceResponse.getResponseHead());
            }
            endorseServiceResponse.setResponseBody(endorseServiceResponseDTO);
            response.setEndorseServiceResponse(endorseServiceResponse);
            if (!"70".equals(policyStatus)) {
                this.saveApisBusiCorrectOrder(request, correctQuotePriceServiceResponse, policyNo, policyStatus, sumPremium, chgSumPremium);
            } else {
                this.saveApisBusiCorrectOrder(request, correctQuotePriceServiceResponse, applyNo, policyStatus, sumPremium, chgSumPremium);
            }
        } else {
            endorseServiceResponse.setResponseHead(correctQuotePriceServiceResponse.getResponseHead());
            response.setEndorseServiceResponse(endorseServiceResponse);
        }
        return response;
    }

    private void saveApisBusiCorrectOrder(StanderRequest request, CorrectQuotePriceServiceResponse correctQuotePriceServiceResponse, String applyNo, String policyStatus, Double sumPremium, Double chgSumPremium) {
        ApisBusiCorrectOrder apisBusiCorrectOrder = new ApisBusiCorrectOrder();
        if (ObjectUtils.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getItemEmployeeDTOS())) {
            apisBusiCorrectOrder.setBusinessKey(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getOrderNo());
        } else {
            apisBusiCorrectOrder.setBusinessKey(request.getHeader().getBusinessKey());
        }
        apisBusiCorrectOrder.setUserCode(request.getHeader().getUserCode());
        apisBusiCorrectOrder.setRequestUser(request.getHeader().getOriginUserCode());
        apisBusiCorrectOrder.setChannelCode(request.getHeader().getChannelCode());
        apisBusiCorrectOrder.setPolicyNo(applyNo);
        apisBusiCorrectOrder.setEndorseType("G002");
        apisBusiCorrectOrder.setStatus("1");
        apisBusiCorrectOrder.setReason(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getOrderNo());
        apisBusiCorrectOrder.setErrMsg(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getNotifyUrl());
        apisBusiCorrectOrder.setCancelFlag(policyStatus);
        apisBusiCorrectOrder.setPayeeAccount(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getPolicyNo());
        apisBusiCorrectOrder.setPremium(sumPremium != null ? new BigDecimal(sumPremium) : null);
        apisBusiCorrectOrder.setRefundPremium(chgSumPremium != null ? new BigDecimal(chgSumPremium) : null);
        apisBusiCorrectOrder.setApplyNo(correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain().getApplyNo());
        apisBusiCorrectOrder.setEndorseNo(correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain().getEndorseNo());
        if (null != chgSumPremium) {
            apisBusiCorrectOrder.setSumPremiumChg(BigDecimal.valueOf(chgSumPremium));
        }
        if (null != correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain().getChgSumAmount()) {
            apisBusiCorrectOrder.setSumAmountChg(BigDecimal.valueOf(correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain().getChgSumAmount()));
        }
        this.log.warn("save apisBusiCorrectOrder.. businessKey = {}", (Object)request.getHeader().getBusinessKey());
        this.apisBusiCorrectOrderService.save((Object)apisBusiCorrectOrder);
    }

    public void dataCorrectConfirmCompletion(StanderRequest request, StanderResponse response) throws ApisDataCompletionException {
        EndorsePriceServiceRequest endorsePriceRequest = request.getEndorsePriceServiceRequest();
        CorrectQuotePriceServiceResponse correctQuotePriceResponse = response.getCorrectQuotePriceServiceResponse();
        QuotePriceServiceRequest quotePriceServiceRequest = request.getQuotePriceServiceRequest();
        PolicySubmitRequestDTO policyConfirmRequestDTO = new PolicySubmitRequestDTO();
        PolicySubmitRequest policyConfirmRequest = new PolicySubmitRequest();
        Double chgSumPremium = correctQuotePriceResponse.getResponseBody().getEndorseApply().getMain().getChgSumPremium();
        String jfFlag = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getJFeeFlag();
        ApisChannelConfigs channelConfigs = this.dataCompletionUtil.getJfFlag(request, "channel_jfeeFlag");
        if (ObjectUtil.isNotEmpty((Object)channelConfigs)) {
            jfFlag = channelConfigs.getConfigValue();
        }
        policyConfirmRequestDTO.setJfeeFlag(jfFlag);
        if ("1".equals(jfFlag)) {
            request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().setJFeeFlag(jfFlag);
            policyConfirmRequestDTO.setPaymentFlag("3");
        } else {
            policyConfirmRequestDTO.setPaymentFlag("1");
        }
        String operateName = quotePriceServiceRequest.getRequestBody().getQuotePrice().getMain().getOperateName();
        Map userMap = new HashMap();
        this.log.warn("originUserCode = {}", (Object)request.getHeader().getOriginUserCode());
        ApisChannelConfigs selfHelpPlatform = this.dataCompletionUtil.getConfig(request.getHeader().getOriginUserCode(), "self_help_platform");
        boolean isSelfPlat = ObjectUtil.isNotEmpty((Object)selfHelpPlatform);
        if (!isSelfPlat) {
            userMap = this.dataCompletionUtil.getChannelUserInfo(request);
        }
        if (quotePriceServiceRequest.getRequestBody().getQuotePrice().getMain().getManual() != null && "Y".equals(quotePriceServiceRequest.getRequestBody().getQuotePrice().getMain().getManual())) {
            policyConfirmRequestDTO.setUnderWriteType(UNDER_WRITE_BH);
        } else {
            policyConfirmRequestDTO.setUnderWriteType(UNDER_WRITE_EX);
            policyConfirmRequestDTO.setUnderWriteCode(request.getHeader().getUserCode());
            policyConfirmRequestDTO.setUnderWriteName(userMap.size() == 0 ? operateName : (String)DataCompletionUtil.castToClass(String.class, userMap.get("user_name")));
        }
        if ("1".equals(jfFlag)) {
            policyConfirmRequestDTO.setUnderWriteType(UNDER_WRITE_IN);
        }
        policyConfirmRequestDTO.setBusinessNo(correctQuotePriceResponse.getResponseBody().getEndorseApply().getMain().getApplyNo());
        policyConfirmRequestDTO.setBusinessType("E");
        policyConfirmRequest.setRequestHead(quotePriceServiceRequest.getRequestHead());
        policyConfirmRequest.setRequestBody(policyConfirmRequestDTO);
        request.setPolicySubmitRequest(policyConfirmRequest);
    }

    public List<ItemEmployeeDTO> transformEmployee(StanderRequest request) {
        List itemEmployeeDTOList = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getItemEmployeeDTOS();
        if (ObjectUtils.isEmpty((Object)itemEmployeeDTOList)) {
            return null;
        }
        PolicyDTO policyDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPolicyDTO();
        List itemList = policyDTO.getCoverage().getItemList();
        ArrayList<ItemEmployeeDTO> employeeDTOListNew = new ArrayList<ItemEmployeeDTO>();
        for (int i = 0; i < itemEmployeeDTOList.size(); ++i) {
            ItemEmployeeDTO itemEmployeeQu = (ItemEmployeeDTO)itemEmployeeDTOList.get(i);
            employeeDTOListNew.add(itemEmployeeQu);
        }
        if (ObjectUtil.isNotEmpty(employeeDTOListNew)) {
            Integer maxSerialNo;
            int num = 1;
            if (ObjectUtil.isNotEmpty((Object)policyDTO) && null != (maxSerialNo = policyDTO.getMaxSerialNo())) {
                num = maxSerialNo + 1;
            }
        }
        return employeeDTOListNew;
    }
}

