/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CoverageDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.GroupPlanDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainEndorPriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.TeamPersonsDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.GroupCorrectUnderWriteResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.GroupCorrectUnderWriteResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredIdvDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.MainEndorResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.GeneralRegxs;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreCorrectApi;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import sinosoftgz.utils.data.DateUtils;

public class StanderGroupEndorUnderWriteHandler
implements BusinessHandler {
    @Autowired
    CoreCorrectApi coreCorrectApi;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    private static String IS_PRE_PRICE_FLAG_Y = "Y";
    private static String CORRECT_CALCULATE_FLAG_CODE = "correct_calculate_flag_code";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        this.validateRquest(request);
        request.getEndorsePriceServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        MainEndorPriceDTO mainEndorDTO = request.getEndorsePriceServiceRequest().getRequestBody().getMain();
        mainEndorDTO.setEndorseType("08");
        String policyNo = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getPolicyNo();
        mainEndorDTO.setEndDate(request.getEndorsePriceServiceRequest().getRequestBody().getMain().getEndDate());
        mainEndorDTO.setEndorseDate(new Date());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(mainEndorDTO.getEndorseDate());
        if (mainEndorDTO.getEndDate().getTime() < System.currentTimeMillis()) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10421.getValue(), ChannelErrorCodeEnum.ERR_C10421.getKey());
        }
        if (mainEndorDTO.getStartDate().getTime() > System.currentTimeMillis()) {
            mainEndorDTO.setValidDate(mainEndorDTO.getStartDate());
        } else {
            mainEndorDTO.setValidDate(calendar.getTime());
        }
        mainEndorDTO.setIsPrePrice(IS_PRE_PRICE_FLAG_Y);
        mainEndorDTO.setOperateCode(request.getHeader().getUserCode());
        mainEndorDTO.setReason("01");
        mainEndorDTO.setCalculateFlag(this.dataCompletionUtil.getCalculateFlag(request.getHeader().getUserCode(), CORRECT_CALCULATE_FLAG_CODE, request.getEndorsePriceServiceRequest().getRequestBody().getGroupPlanList()));
        mainEndorDTO.setIsFromPp(StringUtils.isEmpty((CharSequence)mainEndorDTO.getIsFromPp()) || !"1".equals(mainEndorDTO.getIsFromPp()) ? "0" : "1");
        this.settleCoverageInfo(request);
        List oldIdvDTOList = this.dataCompletedInsuredIdv(request);
        request.getEndorsePriceServiceRequest().getRequestBody().getMain().setCoverage(null);
        return request;
    }

    public void validateRquest(StanderRequest request) throws ApisBusinessException {
        List planDTOList = request.getEndorsePriceServiceRequest().getRequestBody().getGroupPlanList();
        for (GroupPlanDTO planDTO : planDTOList) {
            List insuredIdvList = planDTO.getInsuredIdvList();
            for (InsuredIdvDTO insuredIdvDTO : insuredIdvList) {
                if ("A".equals(insuredIdvDTO.getOperatorType()) || insuredIdvDTO.getSerialNo() != null) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10507.getValue(), ChannelErrorCodeEnum.ERR_C10507.getKey());
            }
        }
    }

    private List<InsuredIdvDTO> dataCompletedInsuredIdv(StanderRequest request) {
        List insuredIdvDTOList = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getTeamPersons().getInsuredidvList();
        int i = 1;
        for (InsuredIdvDTO insuredIdvDTO : insuredIdvDTOList) {
            if ("A".equals(insuredIdvDTO.getOperatorType())) {
                insuredIdvDTO.setSerialNo(Integer.valueOf(i++));
            }
            if (!StringUtils.isBlank((CharSequence)insuredIdvDTO.getInsuredName())) continue;
            insuredIdvDTO.setInsuredName(null);
        }
        return insuredIdvDTOList;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        StanderResponse endorseServiceResponse = this.coreCorrectApi.groupCorrectUnderWrite(request);
        BaseApisParamUtil.verificationResponse((StanderResponse)endorseServiceResponse, (String)"endorseServiceResponse");
        endorseServiceResponse.setHeader(request.getHeader());
        return this.convertResponseInfo(endorseServiceResponse);
    }

    private StanderResponse convertResponseInfo(StanderResponse endorseServiceResponse) {
        GroupCorrectUnderWriteResponse response = GroupCorrectUnderWriteResponse.builder().build();
        response.setResponseHead(endorseServiceResponse.getEndorseServiceResponse().getResponseHead());
        GroupCorrectUnderWriteResponseDTO groupCorrectUnderWriteResponseDTO = GroupCorrectUnderWriteResponseDTO.builder().build();
        MainEndorResponseDTO mainEndorDTO = endorseServiceResponse.getEndorseServiceResponse().getResponseBody().getEndorseApply().getMain();
        groupCorrectUnderWriteResponseDTO.setTotalPremium(mainEndorDTO.getSumPremium());
        List insuredPremiumDTOList = endorseServiceResponse.getEndorseServiceResponse().getResponseBody().getEndorseApply().getMain().getInsuredPremiumList();
        groupCorrectUnderWriteResponseDTO.setInsuredPremiumList(insuredPremiumDTOList);
        response.setResponseBody(groupCorrectUnderWriteResponseDTO);
        return StanderResponse.builder().groupCorrectUnderWriteResponse(response).header(endorseServiceResponse.getHeader()).build();
    }

    public void settleCoverageInfo(StanderRequest request) throws ApisBusinessException {
        ArrayList insuredIdvDTOList = new ArrayList();
        ArrayList<ItemMainDTO> itemMainDTOList = new ArrayList<ItemMainDTO>();
        CoverageDTO coverageDTO = CoverageDTO.builder().build();
        List planDTOList = request.getEndorsePriceServiceRequest().getRequestBody().getGroupPlanList();
        MainEndorPriceDTO mainEndorDTO = request.getEndorsePriceServiceRequest().getRequestBody().getMain();
        int itemNo = 1;
        for (GroupPlanDTO planDTO : planDTOList) {
            ItemMainDTO itemMainDTO = ItemMainDTO.builder().build();
            itemMainDTO.setGoodsCode(planDTO.getPlanCode());
            itemMainDTO.setItemNo(Integer.valueOf(itemNo));
            itemMainDTO.setInsuredCount(Integer.valueOf(planDTO.getInsuredIdvList().size()));
            itemMainDTOList.add(itemMainDTO);
            insuredIdvDTOList.addAll(planDTO.getInsuredIdvList());
            ++itemNo;
        }
        coverageDTO.setItemList(itemMainDTOList);
        coverageDTO.setInsuredIdvList(insuredIdvDTOList);
        request.getEndorsePriceServiceRequest().getRequestBody().getMain().setTeamPersons(TeamPersonsDTO.builder().insuredidvList(insuredIdvDTOList).build());
        request.getEndorsePriceServiceRequest().getRequestBody().getMain().setCoverage(coverageDTO);
        request.getEndorsePriceServiceRequest().getRequestBody().setGroupPlanList(null);
    }

    private void validateDob(List<GroupPlanDTO> planDTOList, MainEndorPriceDTO mainEndorPriceDTO) throws ApisBusinessException {
        for (GroupPlanDTO planDTO : planDTOList) {
            ApisPfpRationMain apisPfpRationMain = this.dataCompletionUtil.getApisPfpRationMainInfo(planDTO.getPlanCode(), "2");
            if (ObjectUtil.isEmpty((Object)apisPfpRationMain)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10024.getValue(), ChannelErrorCodeEnum.ERR_C10024.getKey());
            }
            if (!StringUtils.isNotEmpty((CharSequence)apisPfpRationMain.getAgeMin()) || !StringUtils.isNotEmpty((CharSequence)apisPfpRationMain.getAgeMax())) continue;
            for (InsuredIdvDTO insuredIdvDTO : planDTO.getInsuredIdvList()) {
                long year = this.dataCompletionUtil.calculateAge(mainEndorPriceDTO.getValidDate(), insuredIdvDTO.getBirthday());
                if (year >= (long)Integer.parseInt(apisPfpRationMain.getAgeMin()) && year <= (long)Integer.parseInt(apisPfpRationMain.getAgeMax())) continue;
                throw new ApisBusinessException("\u88ab\u4fdd\u9669\u4eba\u59d3\u540d\u3010" + insuredIdvDTO.getInsuredName() + "\u3011\u8bc1\u4ef6\u53f7\u3010" + insuredIdvDTO.getIdentifyNumber() + "\u3011\u5e74\u9f84\u8d85\u51fa\u8ba1\u5212\u7684\u5e74\u9f84\u9650\u5236\u3010" + apisPfpRationMain.getAgeMin() + "\u3011-\u3010" + apisPfpRationMain.getAgeMax() + "\u3011!", ChannelErrorCodeEnum.ERR_C10366.getKey());
            }
        }
    }

    private void validateIsRepeatDate(StanderRequest request, List<InsuredIdvDTO> oldIdvDTOList) throws ApisBusinessException {
        List insuredIdvDTOList = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getTeamPersons().getInsuredidvList();
        for (int i = 0; i < insuredIdvDTOList.size(); ++i) {
            InsuredIdvDTO insuredIdvDTO = (InsuredIdvDTO)insuredIdvDTOList.get(i);
            for (int j = i + 1; j < insuredIdvDTOList.size(); ++j) {
                InsuredIdvDTO idvDTO = (InsuredIdvDTO)insuredIdvDTOList.get(j);
                if (insuredIdvDTO.getItemNo() != idvDTO.getItemNo() && insuredIdvDTO.getIdentifyNumber().equals(idvDTO.getIdentifyNumber()) && insuredIdvDTO.getEndDate().after(idvDTO.getStartDate())) {
                    throw new ApisBusinessException("\u88ab\u4fdd\u9669\u4eba\u3010" + insuredIdvDTO.getInsuredName() + "\u3011\u6709\u91cd\u590d\u4fdd\u9669\u533a\u95f4", ChannelErrorCodeEnum.ERR_C10111.getKey());
                }
                if (insuredIdvDTO.getItemNo() != idvDTO.getItemNo() || !insuredIdvDTO.getIdentifyNumber().equals(idvDTO.getIdentifyNumber())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10420.getValue(), ChannelErrorCodeEnum.ERR_C10420.getKey());
            }
        }
        for (InsuredIdvDTO insuredIdvDTO : insuredIdvDTOList) {
            for (InsuredIdvDTO oldIdvDTO : oldIdvDTOList) {
                if (!insuredIdvDTO.getIdentifyNumber().equals(oldIdvDTO.getIdentifyNumber()) || !insuredIdvDTO.getEndDate().after(oldIdvDTO.getStartDate()) || !insuredIdvDTO.getOperatorType().equals("A")) continue;
                throw new ApisBusinessException("\u88ab\u4fdd\u9669\u4eba\u3010" + insuredIdvDTO.getInsuredName() + "\u3011\u6709\u91cd\u590d\u4fdd\u9669\u533a\u95f4", ChannelErrorCodeEnum.ERR_C10111.getKey());
            }
        }
    }

    private void validateRequest(StanderRequest request, PolicyDTO policyDTO, List<InsuredIdvDTO> oldIdvDTOList) throws ApisBusinessException {
        List insuredIdvDTOList = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getCoverage().getInsuredIdvList();
        List itemList = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getCoverage().getItemList();
        MainDTO mainDTO = policyDTO.getMain();
        List oldItemList = policyDTO.getCoverage().getItemList();
        for (ItemMainDTO itemMainDTO : itemList) {
            boolean itemFlag = true;
            for (ItemMainDTO oldItemDto : oldItemList) {
                if (!itemMainDTO.getGoodsCode().equals(oldItemDto.getGoodsCode())) continue;
                itemFlag = false;
            }
            if (!itemFlag) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10454.getValue().replace("##", itemMainDTO.getGoodsCode()), ChannelErrorCodeEnum.ERR_C10454.getKey());
        }
        HashMap<String, String> idMap = new HashMap<String, String>();
        for (InsuredIdvDTO insuredIdvDTO : insuredIdvDTOList) {
            if ("C".equals(insuredIdvDTO.getOperatorType()) || "D".equals(insuredIdvDTO.getOperatorType())) {
                boolean flag = true;
                for (InsuredIdvDTO oldIdvDto : oldIdvDTOList) {
                    if (!oldIdvDto.getInsuredId().equals(insuredIdvDTO.getInsuredId())) continue;
                    flag = false;
                }
                if (flag) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10111.getValue(), ChannelErrorCodeEnum.ERR_C10111.getKey());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getInsuredName()) && !insuredIdvDTO.getInsuredName().matches(GeneralRegxs.GroupEndorName)) {
                throw new ApisBusinessException("\u88ab\u4fdd\u9669\u4eba\u59d3\u540d\u4e0d\u5408\u6cd5\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4", ChannelErrorCodeEnum.ERR_C10144.getKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getEmail()) && !insuredIdvDTO.getEmail().matches(GeneralRegxs.Email)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10144.getValue(), ChannelErrorCodeEnum.ERR_C10144.getKey());
            }
            if (idMap.containsKey(insuredIdvDTO.getInsuredId())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10221.getValue().replace("##", insuredIdvDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10221.getKey());
            }
            idMap.put(insuredIdvDTO.getInsuredId(), insuredIdvDTO.getInsuredName());
            if ("01".equals(insuredIdvDTO.getIdentifyType())) {
                if (StringUtils.isNotEmpty((CharSequence)insuredIdvDTO.getIdentifyNumber()) && !insuredIdvDTO.getIdentifyNumber().matches(GeneralRegxs.IdentifyNumber)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10266.getValue().replaceFirst("##", insuredIdvDTO.getInsuredName()).replace("##", insuredIdvDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10266.getKey());
                }
                String birthDateStr = insuredIdvDTO.getIdentifyNumber().substring(6, 14);
                if (!birthDateStr.equals(DateUtils.dateToStr((Date)insuredIdvDTO.getBirthday(), (String)"yyyyMMdd"))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10119.getValue().replace("##", insuredIdvDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10119.getKey());
                }
            }
            if (insuredIdvDTO.getStartDate().before(mainDTO.getStartDate()) || insuredIdvDTO.getStartDate().after(mainDTO.getEndDate())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10416.getValue(), ChannelErrorCodeEnum.ERR_C10416.getKey());
            }
            if (!insuredIdvDTO.getEndDate().before(mainDTO.getStartDate()) && !insuredIdvDTO.getEndDate().after(mainDTO.getEndDate())) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10417.getValue(), ChannelErrorCodeEnum.ERR_C10417.getKey());
        }
        request.getEndorsePriceServiceRequest().getRequestBody().getMain().setCoverage(null);
    }
}

