/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.lang.UUID;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.ExaminatInfomationUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ExaminatInformationRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ExaminatInformationResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiPhyexamTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiPhyexamTaskLogMapper;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderHealthInformationHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderHealthInformationHandler.class);
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    ApisBusiPhyexamTaskLogMapper apisBusiPhyexamTaskLogMapper;
    @Autowired
    ExaminatInfomationUtil examinatInfomationUtil;
    public static final String EXAMINAT_INFOMATION = "1";
    public static final String HEALTH_INFOMATION = "2";
    public static final String HEALTH_EXAMINAT_INFOMATION = "3";
    public static final String HEALTH_EXAMINAT_COMPLETE = "4";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        request.getHeader().setBusinessKey(UUID.fastUUID().toString().replaceAll("-", ""));
        request.getExaminatInformationRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        this.dataCompletionUtil.verifyRepeatExaminatRequest(request);
        this.verifyNull(request);
        this.examinatInfomationUtil.verifPolicy(request, request.getExaminatInformationRequest().getRequestBody().getPolicyNo(), request.getHeader().getUserCode());
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        ExaminatInformationRequestDTO examinatInformationRequestDTO = request.getExaminatInformationRequest().getRequestBody();
        ExaminatInformationResponse examinatInformationResponse = ExaminatInformationResponse.builder().responseBody(examinatInformationRequestDTO).build();
        ApisBusiPhyexamTaskLog apisBusiPhyexamTaskLog = this.examinatInfomationUtil.queryTasklLog(request);
        if (apisBusiPhyexamTaskLog == null) {
            apisBusiPhyexamTaskLog = new ApisBusiPhyexamTaskLog();
            apisBusiPhyexamTaskLog.setCreateTime(new Date());
            apisBusiPhyexamTaskLog.setHealthInformation(examinatInformationRequestDTO.getHealthInformation());
            apisBusiPhyexamTaskLog.setPolicyNo(examinatInformationRequestDTO.getPolicyNo());
            apisBusiPhyexamTaskLog.setStatus(HEALTH_INFOMATION);
            apisBusiPhyexamTaskLog.setCreator(request.getHeader().getUserCode());
            apisBusiPhyexamTaskLog.setUpdateTime(new Date());
            this.apisBusiPhyexamTaskLogMapper.insert((Object)apisBusiPhyexamTaskLog);
        } else {
            if (HEALTH_INFOMATION.equals(apisBusiPhyexamTaskLog.getStatus())) {
                throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10469.getKey()).message(ChannelErrorCodeEnum.ERR_C10469.getValue()).build();
            }
            if (HEALTH_EXAMINAT_INFOMATION.equals(apisBusiPhyexamTaskLog.getStatus())) {
                throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10469.getKey()).message(ChannelErrorCodeEnum.ERR_C10469.getValue()).build();
            }
            if (HEALTH_EXAMINAT_COMPLETE.equals(apisBusiPhyexamTaskLog.getStatus())) {
                throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10469.getKey()).message(ChannelErrorCodeEnum.ERR_C10469.getValue()).build();
            }
            if (EXAMINAT_INFOMATION.equals(apisBusiPhyexamTaskLog.getStatus())) {
                apisBusiPhyexamTaskLog.setHealthInformation(examinatInformationRequestDTO.getHealthInformation());
                apisBusiPhyexamTaskLog.setPolicyNo(examinatInformationRequestDTO.getPolicyNo());
                apisBusiPhyexamTaskLog.setStatus(HEALTH_EXAMINAT_INFOMATION);
                apisBusiPhyexamTaskLog.setModifier(request.getHeader().getUserCode());
                apisBusiPhyexamTaskLog.setUpdateTime(new Date());
                this.apisBusiPhyexamTaskLogMapper.updateById((Object)apisBusiPhyexamTaskLog);
            }
        }
        return StanderResponse.builder().header(request.getHeader()).examinatInformationResponse(examinatInformationResponse).build();
    }

    public void verifyNull(StanderRequest request) throws ApisBusinessException {
        ExaminatInformationRequestDTO examinatInformationRequest = request.getExaminatInformationRequest().getRequestBody();
        if (StringUtils.isBlank((CharSequence)examinatInformationRequest.getPolicyNo())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorNullValueCodeEnum.ERR_N90003.getKey()).message(ErrorNullValueCodeEnum.ERR_N90003.getValue()).build();
        }
    }
}

