/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InstallmentQueryListDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InstallmentQueryListResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InstallmentQueryListResponseBodyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InstallmentQueryListResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiChannelInstallmentOrderMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiChannelOrderMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelUserMapper;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderInstallmentListHandler
implements BusinessHandler {
    @Autowired
    private ApisBusiChannelOrderMapper apisBusiChannelOrderMapper;
    @Autowired
    private DataCompletionUtil dataCompletionUtil;
    @Autowired
    private ApisBusiChannelInstallmentOrderMapper apisBusiChannelInstallmentOrderMapper;
    @Autowired
    ApisChannelUserMapper apisChannelUserMapper;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        if (StringUtils.isEmpty((CharSequence)request.getInstallmentQueryListRequest().getPolicyNo())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u4fdd\u5355\u53f7"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        StanderResponse response = new StanderResponse();
        InstallmentQueryListResponse installmentQueryList = new InstallmentQueryListResponse();
        installmentQueryList.setHead(new InstallmentQueryListResponseHeadDTO().code(ChannelErrorCodeEnum.ERR_C10002.getKey()).message(ChannelErrorCodeEnum.ERR_C10002.getValue()).businessKey(request.getHeader().getBusinessKey()));
        PolicyDTO policyDTO = this.executePolicyDetails(request);
        this.verifyOrder(policyDTO);
        String status = "1".equals(policyDTO.getMain().getPolicyStatus()) ? "70" : "80";
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_code", (Object)policyDTO.getMain().getOperateCode());
        ApisChannelUser user = (ApisChannelUser)this.apisChannelUserMapper.selectOne((Wrapper)queryWrapper);
        String channelName = "";
        if (ObjectUtil.isNotEmpty((Object)user) && StringUtils.isNotEmpty((CharSequence)user.getChannelName())) {
            channelName = user.getChannelName();
        }
        String policyNo = request.getInstallmentQueryListRequest().getPolicyNo();
        List installmentOrderList = this.apisBusiChannelInstallmentOrderMapper.getListByPolicyNo(policyNo);
        ArrayList installmentList = new ArrayList();
        installmentOrderList.forEach(i -> installmentList.add(new InstallmentQueryListDTO(i)));
        String orderNo = StringUtils.isNotEmpty((CharSequence)policyDTO.getMain().getOrderNo()) ? policyDTO.getMain().getOrderNo() : "";
        installmentQueryList.setBody(new InstallmentQueryListResponseBodyDTO().policyNo(policyNo).status(status).orderNo(orderNo).channelName(channelName).payCount(Integer.valueOf(installmentList.size())).installmentList(installmentList));
        response.setInstallmentQueryList(installmentQueryList);
        return response;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        return response;
    }

    private PolicyDTO executePolicyDetails(StanderRequest request) throws ApisBusinessException {
        String policyNo = request.getInstallmentQueryListRequest().getPolicyNo();
        PolicyDTO policyDetail = null;
        try {
            policyDetail = this.dataCompletionUtil.getPolicyDetail(request, policyNo, true);
        }
        catch (ApisBusinessException apisBusinessException) {
            if ("0007".equals(apisBusinessException.getErrorCode())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10113.getValue(), ChannelErrorCodeEnum.ERR_C10113.getKey());
            }
            throw apisBusinessException;
        }
        return policyDetail;
    }

    private void verifyOrder(PolicyDTO policyDTO) throws ApisBusinessException {
        if (policyDTO == null) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10014.getValue(), ChannelErrorCodeEnum.ERR_C10014.getKey());
        }
        if (policyDTO.getPayPlanList().size() == 1) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10609.getValue(), ChannelErrorCodeEnum.ERR_C10609.getKey());
        }
    }
}

