/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl.StanderImgBatchUploadHandler;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.LitigationQuotePriceValidate;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.MediaUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.QuotePriceValidate;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyNoGetRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyNoGetRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderJingYouQuotePriceHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderJingYouQuotePriceHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    MediaUploadUtil mediaUploadUtil;
    @Autowired
    HttpRequestService httpRequestService;
    @Autowired
    QuotePriceValidate quotePriceValidate;
    @Autowired
    StanderImgBatchUploadHandler standerImgBatchUploadHandler;
    @Autowired
    LitigationQuotePriceValidate litigationQuotePriceValidate;
    private final String REQUEST_ENTITY_QUOTEPRICE = "quotePriceServiceRequest";
    private final String RESPONSE_ENTITY_QUOTEPRICE = "policyListQueryResponse";
    private final String RESPONSE_ENTITY_PLOICYNOGET = "policyNoGetResponse";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        TimeInterval timer = DateUtil.timer();
        request.getQuotePriceServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        BaseApisParamUtil.verificationRequest((StanderRequest)request, (String)"quotePriceServiceRequest");
        this.dataCompletionUtil.dataCompletion(request);
        this.log.warn("\u6570\u636e\u8865\u5168\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        MainDTO mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(mainDTO.getInputDate());
        calendar.add(5, 1);
        mainDTO.setStartDate(calendar.getTime());
        calendar.setTime(mainDTO.getStartDate());
        calendar.add(1, 1);
        mainDTO.setEndDate(calendar.getTime());
        this.log.warn("\u51fa\u5355\u89c4\u5219\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.log.warn("\u4fdd\u8d39\u8ba1\u7b97\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        QuotePriceServiceResponse quotePriceServiceResponse;
        block9: {
            ApisBusiChannelOrder apisBusinessChannelOrder = new ApisBusiChannelOrder();
            apisBusinessChannelOrder.setRequestTime(LocalDateTime.now());
            quotePriceServiceResponse = QuotePriceServiceResponse.builder().build();
            Double sumPremium = null;
            MainDTO mainDTO = MainDTO.builder().build();
            try {
                apisBusinessChannelOrder.setStatus("01");
                String businessNo = "";
                StanderResponse quotePriceResponse = this.coreInsureApi.quotePrice(request);
                BaseApisParamUtil.verificationResponse((StanderResponse)quotePriceResponse, (String)"policyListQueryResponse");
                mainDTO = quotePriceResponse.getPolicyListQueryResponse().getResponseBody().getMain();
                apisBusinessChannelOrder.setPayType(mainDTO.getJFeeFlag());
                sumPremium = mainDTO.getSumPremium();
                apisBusinessChannelOrder.setProposalTime(LocalDateTime.now());
                apisBusinessChannelOrder.setProposalNo(mainDTO.getProposalNo());
                ImgBatchUploadServiceRequest imgBatchUploadServiceRequest = ImgBatchUploadServiceRequest.builder().build();
                ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = ImgBatchUploadRequestDTO.builder().build();
                imgBatchUploadRequestDTO.setLinkNo(mainDTO.getProposalNo());
                imgBatchUploadRequestDTO.setOrderNo(mainDTO.getOrderNo());
                imgBatchUploadServiceRequest.setRequestBody(imgBatchUploadRequestDTO);
                request.setImgBatchUploadServiceRequest(imgBatchUploadServiceRequest);
                this.mediaUploadUtil.syncUploadGuaranteeMaterial(request);
                apisBusinessChannelOrder.setStatus("02");
                Map map = this.policyNoGetService(apisBusinessChannelOrder, request, mainDTO);
                businessNo = (String)DataCompletionUtil.castToClass(String.class, map.get("businessNo"));
                if (StringUtils.isNotEmpty((CharSequence)businessNo)) {
                    apisBusinessChannelOrder.setPolicyNo(businessNo);
                    apisBusinessChannelOrder.setPolicyTime(LocalDateTime.now());
                    apisBusinessChannelOrder.setStatus("04");
                }
                ResponseHeadDTO responseHeadDTO = ResponseHeadDTO.builder().build();
                responseHeadDTO.setConsumerSeqNo(request.getQuotePriceServiceRequest().getRequestHead().getConsumerSeqNo());
                QuotePriceServiceResponseDTO responseBody = QuotePriceServiceResponseDTO.builder().build();
                if (StringUtils.isNotEmpty((CharSequence)businessNo)) {
                    String agencyPolicyRef = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getOrderNo();
                    responseBody.setAgencyPolicyRef(agencyPolicyRef);
                    responseBody.setBusinessNo(mainDTO.getProposalNo());
                    quotePriceServiceResponse.setResponseBody(responseBody);
                    responseHeadDTO.setStatus(1);
                    quotePriceServiceResponse.setResponseHead(responseHeadDTO);
                    break block9;
                }
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10054.getValue(), ChannelErrorCodeEnum.ERR_C10054.getKey());
            }
            catch (ApisBusinessException e) {
                throw new ApisBusinessException(e.getMessage(), e.getErrorCode());
            }
            finally {
                apisBusinessChannelOrder.setFinishedTime(LocalDateTime.now());
                if (ObjectUtil.isNotEmpty(sumPremium)) {
                    apisBusinessChannelOrder.setPremium(new BigDecimal(sumPremium));
                }
                if (ObjectUtil.isNotEmpty((Object)mainDTO.getSumAmount())) {
                    apisBusinessChannelOrder.setAmount(new BigDecimal(mainDTO.getSumAmount()));
                }
                Date startDate = new Date();
                this.dataCompletionUtil.insertApisBusinessChannelOrder(request, apisBusinessChannelOrder);
                this.log.warn("\u65b0\u589e\u6e20\u9053\u8ba2\u5355\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
            }
        }
        return StanderResponse.builder().header(request.getHeader()).quotePriceServiceResponse(quotePriceServiceResponse).build();
    }

    public Map policyNoGetService(ApisBusiChannelOrder apisBusiChannelOrder, StanderRequest request, MainDTO mainDTO) throws ApisBusinessException {
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        StanderResponse policyNoGetResponse = this.coreInsureApi.policyNoGet(StanderRequest.builder().header(request.getHeader()).policyNoGetRequest(PolicyNoGetRequest.builder().requestHead(request.getQuotePriceServiceRequest().getRequestHead()).requestBody(PolicyNoGetRequestDTO.builder().proposalNo(mainDTO.getProposalNo()).build()).build()).build());
        BaseApisParamUtil.verificationResponse((StanderResponse)policyNoGetResponse, (String)"policyNoGetResponse");
        String businessNo = policyNoGetResponse.getPolicyNoGetResponse().getResponseBody().getPrePolicyNo();
        apisBusiChannelOrder.setStatus("05");
        resultMap.put("businessNo", businessNo);
        resultMap.put("policyStatus", "60");
        return resultMap;
    }

    public void calculateTotalPremium(StanderRequest request) {
        MainDTO mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        ItemMainDTO itemMainDTO = (ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0);
        Double amout = itemMainDTO.getSumInsured();
        Double sumPremium = new BigDecimal(amout).multiply(new BigDecimal(0.1)).setScale(2, 4).doubleValue();
        mainDTO.setSumPremium(sumPremium);
    }
}

