/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.executor.CommonsValidateUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.EmailCommonUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.FxqCustomerCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RedisTemplateUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RiskManagementCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorsePriceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorsePriceServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorseServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainEndorDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainEndorPriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PolicyRefundConfirmQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PolicyRefundQueryRequestBodyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.EndorseApplyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.EndorseServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.EndorseServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.payment.RefundConfirmQueryResponseVo;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.RiskManagementScenesEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreCorrectApi;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderLitigationCorrectHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderLitigationCorrectHandler.class);
    @Autowired
    CoreCorrectApi coreCorrectApi;
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    RedisTemplateUtil redisTemplateUtil;
    @Autowired
    private RiskManagementCheckUtil riskManagementCheckUtil;
    @Autowired
    private FxqCustomerCheckUtil fxqCustomerCheckUtil;
    @Autowired
    private CommonsValidateUtil commonsValidateUtil;
    @Autowired
    private EmailCommonUtil emailCommonUtil;
    @Autowired
    private ApisBusiChannelOrderService apisBusiChannelOrderService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        RequestHeadDTO requestHeadDTO = RequestHeadDTO.initRequestHead();
        request.getEndorseServiceRequest().setRequestHead(requestHeadDTO);
        MainEndorDTO mainEndorDTO = request.getEndorseServiceRequest().getRequestBody().getMain();
        request.getHeader().setUserCode("DE200001_01");
        this.log.warn("\u9ad8\u9662\u9000\u4fdd\u6279\u6539\uff0c{}", (Object)mainEndorDTO.getPolicyNo());
        String orderNo = request.getEndorseServiceRequest().getRequestBody().getOrderNo();
        ApisBusiChannelOrder apisBusiChannelOrder = this.apisBusiChannelOrderService.findOneByOrderNo(orderNo);
        mainEndorDTO.setReqRefund("Y");
        this.verify(apisBusiChannelOrder);
        mainEndorDTO.setManual("Y");
        mainEndorDTO.setPolicyNo(apisBusiChannelOrder.getPolicyNo());
        PolicyDTO policyDTO = this.dataCompletionUtil.executePolicyDetails(request);
        Integer flag = this.refundQueryConfirm(apisBusiChannelOrder.getPolicyNo(), policyDTO);
        if (flag == 2) {
            mainEndorDTO.setRefundCost("Y");
        } else if (flag == 0) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
        request.getEndorseServiceRequest().getRequestBody().setPolicyDTO(policyDTO);
        request.getEndorseServiceRequest().getRequestBody().getMain().setEndDate(policyDTO.getMain().getEndDate());
        request.getEndorseServiceRequest().getRequestBody().getMain().setSubEndorType("01");
        request.getEndorseServiceRequest().getRequestBody().getMain().setEndorseType("01");
        request.getEndorseServiceRequest().getRequestBody().getMain().setCalculateFlag("2");
        request.getEndorseServiceRequest().getRequestBody().getMain().setValidDate((Date)DateUtil.parse((CharSequence)policyDTO.getMain().getStartDateStr(), (String)"yyyy-MM-dd"));
        this.dataQuotePriceCompletion(request, policyDTO);
        this.riskDataCompletion(request, policyDTO, policyDTO.getMain().getPolicyType());
        this.fxqDataCompletion(request, policyDTO);
        this.commonsValidateUtil.executorValidate(request, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true));
        return request;
    }

    private void verify(ApisBusiChannelOrder apisBusiChannelOrder) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)apisBusiChannelOrder) || !"04".equals(apisBusiChannelOrder.getStatus())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10113.getValue(), ChannelErrorCodeEnum.ERR_C10113.getKey());
        }
    }

    private Integer refundQueryConfirm(String policyNo, PolicyDTO policyDTO) throws ApisBusinessException {
        Integer flag = 0;
        PolicyRefundConfirmQueryRequest policyRefundQueryRequest = new PolicyRefundConfirmQueryRequest();
        policyRefundQueryRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        PolicyRefundQueryRequestBodyDTO bodyDTO = PolicyRefundQueryRequestBodyDTO.builder().build();
        bodyDTO.setPolicyNo(policyNo);
        policyRefundQueryRequest.setRefundQueryBody(bodyDTO);
        try {
            RefundConfirmQueryResponseVo responseVo = this.coreInsureApi.refundQueryConfirm(policyRefundQueryRequest);
            if (ObjectUtil.isNotEmpty((Object)responseVo) && ObjectUtil.isNotEmpty((Object)responseVo.getResponseBody())) {
                if ("1".equals(responseVo.getResponseBody().getFlag())) {
                    flag = 2;
                } else {
                    flag = 1;
                    this.emailCommonUtil.saveLitigationSurrenderEmailSend(policyNo, ((AppliClientDTO)policyDTO.getAppliClient().get(0)).getInsuredName(), ((AppliClientDTO)policyDTO.getAppliClient().get(0)).getMobile());
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u9000\u4fdd\u8ba1\u7b97" + policyNo + "\u8c03\u7528\u6536\u4ed8\u539f\u8def\u9000\u6b3e\u67e5\u8be2\u786e\u8ba4\u63a5\u53e3\u62a5\u9519\uff1a{}", (Throwable)e);
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
        return flag;
    }

    private void riskDataCompletion(StanderRequest request, PolicyDTO policyDTO, String policyType) throws ApisBusinessException {
        String riskManagementScenes = null;
        if (request.getEndorseServiceRequest().getRequestBody().getMain().getEndorseType().equals("01")) {
            riskManagementScenes = RiskManagementScenesEnum.REFUND.getCode();
        }
        this.riskManagementCheckUtil.riskManagementData(request, policyDTO, riskManagementScenes, policyType);
    }

    private void fxqDataCompletion(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        this.fxqCustomerCheckUtil.fxqCustomerData(request, policyDTO);
    }

    public void dataQuotePriceCompletion(StanderRequest request, PolicyDTO policyDTO) {
        EndorseServiceRequest endorseServiceRequest = request.getEndorseServiceRequest();
        String operateCode = request.getHeader().getUserCode();
        EndorsePriceServiceRequest endorsePriceServiceRequest = new EndorsePriceServiceRequest();
        EndorsePriceRequestDTO endorsePriceRequestDTO = new EndorsePriceRequestDTO();
        MainEndorPriceDTO mainEndorPriceDTO = new MainEndorPriceDTO();
        BeanUtils.copyProperties((Object)endorseServiceRequest.getRequestBody().getMain(), (Object)mainEndorPriceDTO);
        mainEndorPriceDTO.setOperateCode(operateCode);
        int validHour = DateUtil.hour((Date)mainEndorPriceDTO.getValidDate(), (boolean)true);
        mainEndorPriceDTO.setValidHour(Integer.valueOf(validHour));
        endorsePriceRequestDTO.setMain(mainEndorPriceDTO);
        endorsePriceServiceRequest.setRequestHead(endorseServiceRequest.getRequestHead());
        endorsePriceServiceRequest.setRequestBody(endorsePriceRequestDTO);
        request.setEndorsePriceServiceRequest(endorsePriceServiceRequest);
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        return this.dataCompletionUtil.doPolicyConfirmExecute(request, this.dataCompletionUtil.doCorrectQuotePriceExecutor(request, null));
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) {
        EndorseServiceResponse endorseServiceResponse = new EndorseServiceResponse();
        EndorseServiceResponseDTO endorseServiceResponseDTO = new EndorseServiceResponseDTO();
        ResponseHeadDTO responseHeadDTO = null;
        EndorseApplyDTO endorseApplyDTO = response.getCorrectQuotePriceServiceResponse().getResponseBody().getEndorseApply();
        endorseApplyDTO.getMain().setOrderId(request.getEndorseServiceRequest().getRequestBody().getOrderNo());
        endorseServiceResponseDTO.setEndorseApply(endorseApplyDTO);
        endorseServiceResponse.setResponseHead(responseHeadDTO);
        endorseServiceResponse.setResponseBody(endorseServiceResponseDTO);
        response.setEndorseServiceResponse(endorseServiceResponse);
        response.setCorrectQuotePriceServiceResponse(null);
        response.setPolicySubmitResponse(null);
        response.setHeader(request.getHeader());
        this.log.warn("\u9ad8\u9662\u6279\u6539\u6253\u5370\u8fd4\u56de\u4fe1\u606f\uff0c{}", (Object)response);
        return response;
    }
}

