/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.executor.CommonsValidateUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl.StanderPolicyDetailHandler;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.FxqCustomerCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.MediaUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RedisTemplateUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RiskManagementCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.BusinessConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AssociatePersonsDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CoverageDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorsePriceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorsePriceServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorseRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorseServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainEndorPriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicySubmitRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicySubmitRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RespondentDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RiskInfoActionDutyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RiskInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CorrectQuotePriceServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.MainEndorResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDetailResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiCorrectOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiCorrectOrderService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.RiskManagementScenesEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreCorrectApi;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import com.sun.jmx.snmp.Timestamp;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderLitigationGerneralCorrectHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderLitigationGerneralCorrectHandler.class);
    @Autowired
    CoreCorrectApi coreCorrectApi;
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    RedisTemplateUtil redisTemplateUtil;
    @Autowired
    private RiskManagementCheckUtil riskManagementCheckUtil;
    @Autowired
    private FxqCustomerCheckUtil fxqCustomerCheckUtil;
    @Autowired
    private CommonsValidateUtil commonsValidateUtil;
    @Autowired
    private ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    MediaUploadUtil mediaUploadUtil;
    @Autowired
    private ApisBusiCorrectOrderService apisBusiCorrectOrderService;
    @Autowired
    StanderPolicyDetailHandler standerPolicyDetailHandler;
    public static final String POLICY_SUBMIT_RESPONSE = "policySubmitResponse";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        request.getQuotePriceServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        QuotePriceDTO quotePriceDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        this.log.warn("\u9ad8\u9662\u7ebf\u4e0a\u666e\u901a\u6279\u6539\uff0c\u62c5\u4fddid\u4e3a\uff1a{}", (Object)quotePriceDTO.getMain().getOrderNo());
        this.dataCompletionUtil.lockByKey(quotePriceDTO.getMain().getOrderNo() + "_litigationGeneralCorrect");
        ApisBusiChannelOrder apisBusiChannelOrder = this.apisBusiChannelOrderService.findOneByOrderNo(quotePriceDTO.getMain().getOrderNo());
        PolicyDetailResponse policyDetailResponse = this.getPolicyDetail(apisBusiChannelOrder.getPolicyNo());
        PolicyDTO policyDTO = policyDetailResponse.getResponseBody().getPolicy();
        request.getHeader().setUserCode("DE200001_01");
        request.setEndorseServiceRequest(EndorseServiceRequest.builder().requestBody(EndorseRequestDTO.builder().policyDTO(policyDTO).build()).build());
        this.beforeComplete(request);
        this.log.warn("\u9ad8\u9662\u63d0\u70bc\u6279\u6539\u9879\u5f00\u59cb");
        this.gerneralDataComplete(request, quotePriceDTO, policyDTO);
        this.log.warn("\u9ad8\u9662\u666e\u901a\u6279\u6539\uff0c{}", (Object)policyDTO.getMain().getPolicyNo());
        this.riskManagementCheckUtil.riskManagementData(request, policyDTO, RiskManagementScenesEnum.CORRECT.getCode(), policyDTO.getMain().getPolicyType());
        this.fxqCustomerCheckUtil.fxqCustomerData(request, policyDTO);
        this.commonsValidateUtil.executorValidate(request, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true));
        return request;
    }

    private void beforeComplete(StanderRequest request) throws ApisBusinessException {
        RiskInfoDTO riskInfoDTO;
        CoverageDTO coverageDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage();
        QuotePriceDTO quotePriceDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getInsuredList())) {
            this.dataCompletionUtil.dataCompletionInsuredDTO(quotePriceDTO);
        }
        this.dataCompletionUtil.dataCompletionAppliClientDTO(quotePriceDTO);
        if (ObjectUtil.isNotEmpty((Object)coverageDTO.getRespondents()) && coverageDTO.getRespondents().size() > 0) {
            Integer serialNo = 1;
            for (RespondentDTO respondentDTO : coverageDTO.getRespondents()) {
                respondentDTO.setSerialNo(serialNo);
                if (StringUtils.isEmpty((CharSequence)respondentDTO.getInsuredType())) {
                    respondentDTO.setInsuredType("1");
                }
                Integer n = serialNo;
                serialNo = serialNo + 1;
                Integer n2 = serialNo;
            }
        }
        if (ObjectUtil.isNotEmpty((Object)coverageDTO.getRiskInfoActionDutyList())) {
            int index = 1;
            for (RiskInfoActionDutyDTO riskInfoActionDutyDTO : coverageDTO.getRiskInfoActionDutyList()) {
                riskInfoActionDutyDTO.setSerialNo(Integer.valueOf(index));
                Boolean flag = false;
                for (RespondentDTO respondentDTO : coverageDTO.getRespondents()) {
                    if (!riskInfoActionDutyDTO.getPropertyOwner().equals(respondentDTO.getInsuredId())) continue;
                    riskInfoActionDutyDTO.setPropertyOwner(String.valueOf(respondentDTO.getSerialNo()));
                    flag = true;
                    break;
                }
                if (!flag.booleanValue()) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10694.getValue().replace("##", riskInfoActionDutyDTO.getPropertyOwner()), ChannelErrorCodeEnum.ERR_C10694.getKey());
                }
                JSONObject jsonObject = this.transDutyJsonObject(JSONObject.parseObject((String)riskInfoActionDutyDTO.getExtInfo()), (Map)BusinessConstants.LITIGATION_CONSTANTS.KEY_MAP);
                RiskInfoActionDutyDTO copyDto = (RiskInfoActionDutyDTO)JSON.parseObject((String)JSON.toJSONString((Object)jsonObject), RiskInfoActionDutyDTO.class);
                this.log.warn("\u9ad8\u9662\u8bc9\u8bbc\u9669\uff0c\u8f6c\u6362\u540e\u6807\u7684\u6570\u636e\u4e3a:{}", (Object)JSON.toJSONString((Object)copyDto));
                String[] ignoreArray = DataCompletionUtil.getNotNullPropertyNames((Object)riskInfoActionDutyDTO);
                BeanUtils.copyProperties((Object)copyDto, (Object)riskInfoActionDutyDTO, (String[])ignoreArray);
                this.log.warn("\u9ad8\u9662\u8bc9\u8d23\u9669\uff0c\u590d\u5236\u540e\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)riskInfoActionDutyDTO));
                ++index;
            }
        }
        if ("9".equals((riskInfoDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getRiskInfo()).getChannelPreservationType()) || "10".equals(riskInfoDTO.getChannelPreservationType())) {
            if ("9".equals(riskInfoDTO.getChannelPreservationType())) {
                riskInfoDTO.setPreservationTypeDesc("\u80a1\u6743");
            } else if ("10".equals(riskInfoDTO.getChannelPreservationType())) {
                riskInfoDTO.setPreservationTypeDesc("\u7a0e\u52a1");
            }
        } else if (StringUtils.isNotEmpty((CharSequence)riskInfoDTO.getPreservationTypeDesc())) {
            JSONObject jsonObject = JSONObject.parseObject((String)riskInfoDTO.getPreservationTypeDesc());
            riskInfoDTO.setPreservationTypeDesc(ObjectUtil.isNotEmpty((Object)jsonObject.get((Object)"ms")) ? jsonObject.get((Object)"ms").toString() : "");
        }
    }

    private JSONObject transDutyJsonObject(JSONObject jsonObject, Map<String, String> keyMap) {
        JSONObject resJson = new JSONObject();
        Set keySet = jsonObject.keySet();
        for (String key : keySet) {
            String resKey = keyMap.get(key) == null ? key : keyMap.get(key);
            resJson.put(resKey, jsonObject.get((Object)key));
        }
        return resJson;
    }

    private void gerneralDataComplete(StanderRequest request, QuotePriceDTO quotePriceDTO, PolicyDTO policyDTO) throws ApisBusinessException {
        Object beforeDto;
        Object beforeDto2;
        Object beforeDto3;
        boolean tag = false;
        ArrayList<AppliClientDTO> appliClientList = new ArrayList<AppliClientDTO>();
        int maxIndex = 0;
        int insr = 1;
        AppliClientDTO ac = policyDTO.getAppliClient().stream().sorted(Comparator.comparing(AppliClientDTO::getSerialNo).reversed()).findFirst().orElse(null);
        maxIndex = ObjectUtil.isEmpty((Object)ac) ? 0 : ac.getSerialNo();
        for (AppliClientDTO dto : quotePriceDTO.getAppliClient()) {
            beforeDto3 = policyDTO.getAppliClient().stream().filter(a -> a.getInsuredId().equals(dto.getInsuredId())).findFirst().orElse(null);
            if (ObjectUtil.isEmpty((Object)beforeDto3)) {
                dto.setSerialNo(Integer.valueOf(maxIndex + insr));
                dto.setOperatorType(BusinessConstants.OPERATOR_TYPE_A);
                appliClientList.add(dto);
                ++insr;
                tag = true;
                continue;
            }
            Map applicationMap = this.compareFields(beforeDto3, (Object)dto, BusinessConstants.LITIGATION_CONSTANTS.APPLICLIENT_NAME, BusinessConstants.LITIGATION_CONSTANTS.APPLICLIENT_NEED_NAME);
            if (!ObjectUtil.isNotEmpty((Object)applicationMap)) continue;
            AppliClientDTO appliClientDTO = AppliClientDTO.builder().build();
            for (Map.Entry entry : applicationMap.entrySet()) {
                this.setValueToObject((String)entry.getKey(), ((List)entry.getValue()).get(1), (Object)appliClientDTO);
            }
            appliClientDTO.setOrignInsuredNam(beforeDto3.getInsuredName());
            appliClientDTO.setOrignInsuredIdyNo(beforeDto3.getIdentifyNumber());
            appliClientDTO.setOperatorType(BusinessConstants.OPERATOR_TYPE_C);
            appliClientDTO.setSerialNo(beforeDto3.getSerialNo());
            appliClientList.add(appliClientDTO);
            tag = true;
        }
        for (AppliClientDTO dto : policyDTO.getAppliClient()) {
            beforeDto3 = quotePriceDTO.getAppliClient().stream().filter(a -> a.getInsuredId().equals(dto.getInsuredId())).findFirst().orElse(null);
            if (!ObjectUtil.isEmpty((Object)beforeDto3)) continue;
            dto.setOperatorType(BusinessConstants.OPERATOR_TYPE_D);
            dto.setOrignInsuredNam(dto.getInsuredName());
            dto.setOrignInsuredIdyNo(dto.getIdentifyNumber());
            appliClientList.add(dto);
            tag = true;
        }
        insr = 1;
        ArrayList<InsuredDTO> insuredList = new ArrayList<InsuredDTO>();
        InsuredDTO is = policyDTO.getInsuredList().stream().sorted(Comparator.comparing(InsuredDTO::getSerialNo).reversed()).findFirst().orElse(null);
        maxIndex = ObjectUtil.isEmpty((Object)is) ? 0 : is.getSerialNo();
        for (InsuredDTO dto : quotePriceDTO.getInsuredList()) {
            beforeDto2 = policyDTO.getInsuredList().stream().filter(a -> a.getInsuredId().equals(dto.getInsuredId())).findFirst().orElse(null);
            if (ObjectUtil.isEmpty((Object)beforeDto2)) {
                dto.setSerialNo(Integer.valueOf(maxIndex + insr));
                dto.setOperatorType(BusinessConstants.OPERATOR_TYPE_A);
                insuredList.add(dto);
                ++insr;
                tag = true;
                continue;
            }
            Map insuredMap = this.compareFields(beforeDto2, (Object)dto, BusinessConstants.LITIGATION_CONSTANTS.APPLICLIENT_NAME, BusinessConstants.LITIGATION_CONSTANTS.APPLICLIENT_NEED_NAME);
            if (!ObjectUtil.isNotEmpty((Object)insuredMap)) continue;
            InsuredDTO insuredDTO = InsuredDTO.builder().build();
            for (Map.Entry entry : insuredMap.entrySet()) {
                this.setValueToObject((String)entry.getKey(), ((List)entry.getValue()).get(1), (Object)insuredDTO);
            }
            insuredDTO.setOrignInsuredNam(beforeDto2.getInsuredName());
            insuredDTO.setOrignInsuredIdyNo(beforeDto2.getIdentifyNumber());
            insuredDTO.setOperatorType(BusinessConstants.OPERATOR_TYPE_C);
            insuredDTO.setSerialNo(beforeDto2.getSerialNo());
            insuredList.add(insuredDTO);
            tag = true;
        }
        for (InsuredDTO dto : policyDTO.getInsuredList()) {
            beforeDto2 = quotePriceDTO.getInsuredList().stream().filter(a -> a.getInsuredId().equals(dto.getInsuredId())).findFirst().orElse(null);
            if (!ObjectUtil.isEmpty((Object)beforeDto2)) continue;
            dto.setOperatorType(BusinessConstants.OPERATOR_TYPE_D);
            dto.setOrignInsuredNam(dto.getInsuredName());
            dto.setOrignInsuredIdyNo(dto.getIdentifyNumber());
            insuredList.add(dto);
            tag = true;
        }
        insr = 1;
        ArrayList<RespondentDTO> respondentDTOList = new ArrayList<RespondentDTO>();
        RespondentDTO rp = policyDTO.getCoverage().getRespondents().stream().sorted(Comparator.comparing(RespondentDTO::getSerialNo).reversed()).findFirst().orElse(null);
        maxIndex = ObjectUtil.isEmpty((Object)rp) ? 0 : rp.getSerialNo();
        for (RespondentDTO dto : quotePriceDTO.getCoverage().getRespondents()) {
            beforeDto = policyDTO.getCoverage().getRespondents().stream().filter(a -> a.getInsuredId().equals(dto.getInsuredId())).findFirst().orElse(null);
            if (ObjectUtil.isEmpty((Object)beforeDto)) {
                dto.setSerialNo(Integer.valueOf(maxIndex + insr));
                dto.setOperatorType(BusinessConstants.OPERATOR_TYPE_A);
                respondentDTOList.add(dto);
                ++insr;
                tag = true;
                continue;
            }
            Map respondentMap = this.compareFields(beforeDto, (Object)dto, BusinessConstants.LITIGATION_CONSTANTS.APPLICLIENT_NAME, BusinessConstants.LITIGATION_CONSTANTS.APPLICLIENT_NEED_NAME);
            if (!ObjectUtil.isNotEmpty((Object)respondentMap)) continue;
            RespondentDTO respondentDTO = RespondentDTO.builder().build();
            for (Map.Entry entry : respondentMap.entrySet()) {
                this.setValueToObject((String)entry.getKey(), ((List)entry.getValue()).get(1), (Object)respondentDTO);
            }
            respondentDTO.setOrignInsuredName(beforeDto.getInsuredName());
            respondentDTO.setOrignInsuredIdyNo(beforeDto.getIdentifyNumber());
            respondentDTO.setOperatorType(BusinessConstants.OPERATOR_TYPE_C);
            respondentDTO.setSerialNo(beforeDto.getSerialNo());
            respondentDTOList.add(respondentDTO);
            tag = true;
        }
        for (RespondentDTO dto : policyDTO.getCoverage().getRespondents()) {
            beforeDto = quotePriceDTO.getCoverage().getRespondents().stream().filter(a -> a.getInsuredId().equals(dto.getInsuredId())).findFirst().orElse(null);
            if (!ObjectUtil.isEmpty((Object)beforeDto)) continue;
            dto.setOperatorType(BusinessConstants.OPERATOR_TYPE_D);
            dto.setOrignInsuredName(dto.getInsuredName());
            dto.setOrignInsuredIdyNo(dto.getIdentifyNumber());
            respondentDTOList.add(dto);
            tag = true;
        }
        insr = 1;
        ArrayList<RiskInfoActionDutyDTO> riskInfoActionDutyDtoList = new ArrayList<RiskInfoActionDutyDTO>();
        if (ObjectUtil.isNotEmpty((Object)policyDTO.getCoverage().getRiskInfoActionDutyList())) {
            RiskInfoActionDutyDTO beforeDto4;
            RiskInfoActionDutyDTO ra = policyDTO.getCoverage().getRiskInfoActionDutyList().stream().sorted(Comparator.comparing(RiskInfoActionDutyDTO::getSerialNo).reversed()).findFirst().orElse(null);
            maxIndex = ObjectUtil.isEmpty((Object)ra) ? 0 : ra.getSerialNo();
            for (RiskInfoActionDutyDTO dto : quotePriceDTO.getCoverage().getRiskInfoActionDutyList()) {
                beforeDto4 = policyDTO.getCoverage().getRiskInfoActionDutyList().stream().filter(a -> a.getPropertyType().equals(dto.getPropertyType())).findFirst().orElse(null);
                if (ObjectUtil.isEmpty((Object)beforeDto4)) {
                    dto.setSerialNo(Integer.valueOf(maxIndex + insr));
                    dto.setOperatorType(BusinessConstants.OPERATOR_TYPE_A);
                    riskInfoActionDutyDtoList.add(dto);
                    ++insr;
                    tag = true;
                    continue;
                }
                Map riskInfoActionMap = this.compareFieldsByIgnore((Object)beforeDto4, (Object)dto, BusinessConstants.LITIGATION_CONSTANTS.RISK_DUTY_IGNORE_NAME);
                if (!ObjectUtil.isNotEmpty((Object)riskInfoActionMap)) continue;
                RiskInfoActionDutyDTO riskInfoActionDutyDTO = RiskInfoActionDutyDTO.builder().build();
                for (Map.Entry entry : riskInfoActionMap.entrySet()) {
                    this.setValueToObject((String)entry.getKey(), ((List)entry.getValue()).get(1), (Object)riskInfoActionDutyDTO);
                }
                riskInfoActionDutyDTO.setOperatorType(BusinessConstants.OPERATOR_TYPE_C);
                riskInfoActionDutyDTO.setSerialNo(beforeDto4.getSerialNo());
                riskInfoActionDutyDtoList.add(riskInfoActionDutyDTO);
                tag = true;
            }
            for (RiskInfoActionDutyDTO dto : policyDTO.getCoverage().getRiskInfoActionDutyList()) {
                beforeDto4 = quotePriceDTO.getCoverage().getRiskInfoActionDutyList().stream().filter(a -> a.getPropertyType().equals(dto.getPropertyType())).findFirst().orElse(null);
                if (!ObjectUtil.isEmpty((Object)beforeDto4)) continue;
                dto.setOperatorType(BusinessConstants.OPERATOR_TYPE_D);
                riskInfoActionDutyDtoList.add(dto);
                tag = true;
            }
        }
        String preservationType = null;
        if (ObjectUtil.isEmpty((Object)policyDTO.getRiskInfo().getPreservationType()) || !policyDTO.getRiskInfo().getPreservationType().equals(quotePriceDTO.getRiskInfo().getPreservationType())) {
            preservationType = quotePriceDTO.getRiskInfo().getPreservationType();
            tag = true;
        }
        String preservationTypeDesc = null;
        if (ObjectUtil.isEmpty((Object)policyDTO.getRiskInfo().getPreservationTypeDesc()) || !policyDTO.getRiskInfo().getPreservationTypeDesc().equals(quotePriceDTO.getRiskInfo().getPreservationTypeDesc())) {
            preservationTypeDesc = quotePriceDTO.getRiskInfo().getPreservationTypeDesc();
            tag = true;
        }
        String caseNo = null;
        if (ObjectUtil.isEmpty((Object)policyDTO.getRiskInfo().getCaseNo()) || !policyDTO.getRiskInfo().getCaseNo().equals(quotePriceDTO.getRiskInfo().getCaseNo())) {
            caseNo = quotePriceDTO.getRiskInfo().getCaseNo();
            tag = true;
        }
        Date endorseDate = new Date();
        int validHour = DateUtil.hour((Date)endorseDate, (boolean)true);
        request.setEndorsePriceServiceRequest(EndorsePriceServiceRequest.builder().requestHead(RequestHeadDTO.initRequestHead()).requestBody(EndorsePriceRequestDTO.builder().main(MainEndorPriceDTO.builder().policyNo(policyDTO.getMain().getPolicyNo()).reason("\u53d8\u66f4\u62c5\u4fdd\u7533\u8bf7").endorseType("06").endorseDate(endorseDate).validDate(endorseDate.compareTo(policyDTO.getMain().getStartDate()) > 0 ? endorseDate : policyDTO.getMain().getStartDate()).operateCode(request.getHeader().getUserCode()).validHour(Integer.valueOf(validHour)).build()).build()).build());
        if (!tag) {
            return;
        }
        request.getEndorsePriceServiceRequest().getRequestBody().getMain().setAssociatePersons(AssociatePersonsDTO.builder().appliClient(appliClientList).insuredList(insuredList).respondents(respondentDTOList).build());
        request.getEndorsePriceServiceRequest().getRequestBody().getMain().setCoverage(CoverageDTO.builder().riskInfoActionDutyList(riskInfoActionDutyDtoList).build());
        request.getEndorsePriceServiceRequest().getRequestBody().getMain().setRiskInfo(RiskInfoDTO.builder().preservationTypeDesc(preservationTypeDesc).preservationType(preservationType).caseNo(caseNo).build());
        this.log.warn("\u9ad8\u9662\u6279\u6539\uff0c\u63d0\u70bc\u540e\u6570\u636e\u4e3a\uff0c{}", (Object)JSON.toJSONString((Object)request.getEndorsePriceServiceRequest()));
    }

    private void setValueToObject(String key, Object value, Object object) {
        Object returnStr = null;
        try {
            Field[] fields;
            for (Field field : fields = object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                returnStr = field.get(object);
                if (field.getAnnotation(JsonProperty.class) != null) {
                    JsonProperty annotation;
                    if (!(field.getAnnotation(JsonProperty.class) instanceof JsonProperty) || (annotation = field.getAnnotation(JsonProperty.class)) == null) continue;
                    System.out.println(annotation + "");
                    String jsonPropertyValue = annotation.value();
                    if (!key.equals(jsonPropertyValue)) continue;
                    field.set(object, value);
                } else {
                    String fieldName = field.getName();
                    if (!key.equals(fieldName)) continue;
                    field.set(object, value);
                }
                break;
            }
        }
        catch (Exception e) {
            this.log.error("\u9ad8\u9662\u53cd\u5c04\u8d4b\u503c\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a{}", (Throwable)e);
        }
    }

    private Map<String, List<Object>> compareFields(Object obj1, Object obj2, List<String> compareList, List<String> allList) throws ApisBusinessException {
        try {
            HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
            if (obj1.getClass() == obj2.getClass()) {
                PropertyDescriptor[] pds;
                Class<?> clazz = obj1.getClass();
                for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(clazz, Object.class).getPropertyDescriptors()) {
                    String name = pd.getName();
                    Method readMethod = pd.getReadMethod();
                    Object objBefore = readMethod.invoke(obj1, new Object[0]);
                    Object objAfter = readMethod.invoke(obj2, new Object[0]);
                    if (objBefore instanceof Timestamp) {
                        objBefore = new Date(((Timestamp)objBefore).getDateTime());
                    }
                    if (objAfter instanceof Timestamp) {
                        objAfter = new Date(((Timestamp)objAfter).getDateTime());
                    }
                    if (ObjectUtil.isNotEmpty(compareList) && compareList.contains(name)) {
                        ArrayList<Object> list;
                        if (objBefore == null && objAfter == null) continue;
                        if (objBefore == null && objAfter != null) {
                            this.log.warn("\u5b57\u6bb5\u6bd4\u8f83\u4e0d\u76f8\u7b26\uff0c\u5b57\u6bb5\u540d\u4e3a\uff0c{}\u3002\u5b57\u6bb5\u503c\u5206\u522b\u4e3a\uff0c{}\uff0c{}", new Object[]{name, objBefore, objAfter});
                            list = new ArrayList<Object>();
                            list.add(objBefore);
                            list.add(objAfter);
                            map.put(name, list);
                            continue;
                        }
                        if (objBefore.equals(objAfter)) continue;
                        this.log.warn("\u5b57\u6bb5\u6bd4\u8f83\u4e0d\u76f8\u7b26\uff0c\u5b57\u6bb5\u540d\u4e3a\uff0c{}\u3002\u5b57\u6bb5\u503c\u5206\u522b\u4e3a\uff0c{}\uff0c{}", new Object[]{name, objBefore, objAfter});
                        list = new ArrayList();
                        list.add(objBefore);
                        list.add(objAfter);
                        map.put(name, list);
                        continue;
                    }
                    if (!ObjectUtil.isNotEmpty(allList) || !allList.contains(name) || objBefore == null && objAfter == null) continue;
                    if (objBefore == null && objAfter != null) {
                        this.log.error("\u8be5\u5b57\u6bb5\u4e0d\u5141\u8bb8\u6279\u6539\uff0c\u5b57\u6bb5\u540d\u4e3a\uff0c{}\u3002\u5b57\u6bb5\u503c\u5206\u522b\u4e3a\uff0c{}\uff0c{}", new Object[]{name, objBefore, objAfter});
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10712.getValue(), ChannelErrorCodeEnum.ERR_C10712.getKey());
                    }
                    if (objBefore.equals(objAfter)) continue;
                    this.log.error("\u8be5\u5b57\u6bb5\u4e0d\u5141\u8bb8\u6279\u6539\uff0c\u5b57\u6bb5\u540d\u4e3a\uff0c{}\u3002\u5b57\u6bb5\u503c\u5206\u522b\u4e3a\uff0c{}\uff0c{}", new Object[]{name, objBefore, objAfter});
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10712.getValue(), ChannelErrorCodeEnum.ERR_C10712.getKey());
                }
            }
            return map;
        }
        catch (ApisBusinessException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("\u5b57\u6bb5\u6bd4\u8f83\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a{}", (Throwable)e);
            return null;
        }
    }

    private Map<String, List<Object>> compareFieldsByIgnore(Object obj1, Object obj2, List<String> ignoreList) {
        try {
            HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
            if (obj1.getClass() == obj2.getClass()) {
                PropertyDescriptor[] pds;
                Class<?> clazz = obj1.getClass();
                for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(clazz, Object.class).getPropertyDescriptors()) {
                    ArrayList<Object> list;
                    String name = pd.getName();
                    Method readMethod = pd.getReadMethod();
                    Object objBefore = readMethod.invoke(obj1, new Object[0]);
                    Object objAfter = readMethod.invoke(obj2, new Object[0]);
                    if (objBefore instanceof Timestamp) {
                        objBefore = new Date(((Timestamp)objBefore).getDateTime());
                    }
                    if (objAfter instanceof Timestamp) {
                        objAfter = new Date(((Timestamp)objAfter).getDateTime());
                    }
                    if (!ObjectUtil.isNotEmpty(ignoreList) || ignoreList.contains(name) || objBefore == null && objAfter == null) continue;
                    if (objBefore == null && objAfter != null) {
                        this.log.warn("\u5b57\u6bb5\u6bd4\u8f83\u4e0d\u76f8\u7b26\uff0c\u5b57\u6bb5\u540d\u4e3a\uff0c{}\u3002\u5b57\u6bb5\u503c\u5206\u522b\u4e3a\uff0c{}\uff0c{}", new Object[]{name, objBefore, objAfter});
                        list = new ArrayList<Object>();
                        list.add(objBefore);
                        list.add(objAfter);
                        map.put(name, list);
                        continue;
                    }
                    if (objBefore.equals(objAfter)) continue;
                    this.log.warn("\u5b57\u6bb5\u6bd4\u8f83\u4e0d\u76f8\u7b26\uff0c\u5b57\u6bb5\u540d\u4e3a\uff0c{}\u3002\u5b57\u6bb5\u503c\u5206\u522b\u4e3a\uff0c{}\uff0c{}", new Object[]{name, objBefore, objAfter});
                    list = new ArrayList();
                    list.add(objBefore);
                    list.add(objAfter);
                    map.put(name, list);
                }
            }
            return map;
        }
        catch (Exception e) {
            this.log.error("\u5b57\u6bb5\u6bd4\u8f83\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a{}", (Throwable)e);
            return null;
        }
    }

    public PolicyDetailResponse getPolicyDetail(String policyNo) throws ApisBusinessException {
        PolicyDetailServiceRequest policyDetailServiceRequest = PolicyDetailServiceRequest.builder().build();
        policyDetailServiceRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        policyDetailServiceRequest.setRequestBody(PolicyDetailRequestDTO.builder().policyNo(policyNo).businessNature2("all").operateCode("all").build());
        StanderRequest request = StanderRequest.builder().policyDetailServiceRequest(policyDetailServiceRequest).build();
        StanderResponse standerResponse = this.standerPolicyDetailHandler.execute(request);
        BaseApisParamUtil.verificationResponse((StanderResponse)standerResponse, (String)"policyDetailResponse");
        return standerResponse.getPolicyDetailResponse();
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        StanderResponse response = StanderResponse.builder().build();
        StanderResponse correctQuotePriceResponse = this.coreCorrectApi.correctQuotePrice(request);
        BaseApisParamUtil.verificationResponse((StanderResponse)correctQuotePriceResponse, (String)"correctQuotePriceServiceResponse");
        CorrectQuotePriceServiceResponse correctQuotePriceServiceResponse = correctQuotePriceResponse.getCorrectQuotePriceServiceResponse();
        response.setCorrectQuotePriceServiceResponse(correctQuotePriceServiceResponse);
        this.dataCorrectConfirmCompletion(request, correctQuotePriceResponse);
        this.uploadMedia(request, response.getCorrectQuotePriceServiceResponse().getResponseBody().getEndorseApply().getMain().getApplyNo());
        StanderResponse policySubmitResponse = this.coreCorrectApi.correctConfirm(request);
        BaseApisParamUtil.verificationResponse((StanderResponse)policySubmitResponse, (String)POLICY_SUBMIT_RESPONSE);
        response.setPolicySubmitResponse(policySubmitResponse.getPolicySubmitResponse());
        return response;
    }

    public void uploadMedia(StanderRequest request, String applyNo) throws ApisBusinessException {
        this.log.warn("\u672c\u6b21\u7ec4\u88c5\u4e0a\u4f20\u4e1a\u52a1\u53f7\u4e3a\uff1a{}", (Object)applyNo);
        MainDTO mainDTO = request.getEndorseServiceRequest().getRequestBody().getPolicyDTO().getMain();
        ImgBatchUploadServiceRequest imgBatchUploadServiceRequest = ImgBatchUploadServiceRequest.builder().build();
        ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = ImgBatchUploadRequestDTO.builder().build();
        imgBatchUploadRequestDTO.setLinkNo(applyNo);
        imgBatchUploadRequestDTO.setOrderNo(mainDTO.getOrderNo());
        imgBatchUploadServiceRequest.setRequestBody(imgBatchUploadRequestDTO);
        request.setImgBatchUploadServiceRequest(imgBatchUploadServiceRequest);
        this.mediaUploadUtil.syncUploadGuaranteeMaterial(request);
    }

    private void dataCorrectConfirmCompletion(StanderRequest request, StanderResponse response) throws ApisDataCompletionException {
        CorrectQuotePriceServiceResponse correctQuotePriceServiceResponse = response.getCorrectQuotePriceServiceResponse();
        MainEndorResponseDTO main = correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain();
        String manual = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getManual();
        PolicySubmitRequestDTO policySubmitRequestDTO = PolicySubmitRequestDTO.builder().build();
        policySubmitRequestDTO.setBusinessType("E");
        policySubmitRequestDTO.setBusinessNo(main.getApplyNo());
        if (this.isBh(request)) {
            MainDTO mainDTO = request.getEndorseServiceRequest().getRequestBody().getPolicyDTO().getMain();
            policySubmitRequestDTO.setUnderWriteType("EX");
            policySubmitRequestDTO.setUnderWriteCode(mainDTO.getOperateCode());
            policySubmitRequestDTO.setUnderWriteName(mainDTO.getOperateName());
        } else {
            policySubmitRequestDTO.setUnderWriteType("BH");
        }
        policySubmitRequestDTO.setPaymentFlag("3");
        PolicySubmitRequest policySubmitRequest = PolicySubmitRequest.builder().requestHead(RequestHeadDTO.initRequestHead()).requestBody(policySubmitRequestDTO).build();
        policySubmitRequest.getRequestHead().setConsumerSeqNo(UUID.fastUUID().toString().replaceAll("-", ""));
        request.setPolicySubmitRequest(policySubmitRequest);
    }

    private boolean isBh(StanderRequest request) {
        PolicyDTO policyDTO = request.getEndorseServiceRequest().getRequestBody().getPolicyDTO();
        boolean flag = true;
        for (RiskInfoActionDutyDTO dto : request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getRiskInfoActionDutyList()) {
            if (BusinessConstants.LITIGATION_CONSTANTS.EX_PROPERTY_TYPE.contains(dto.getPropertyType())) continue;
            flag = false;
            break;
        }
        return policyDTO.getMain().getSumAmount() <= 1000000.0 && flag;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        try {
            ApisBusiCorrectOrder apisBusiCorrectOrder = new ApisBusiCorrectOrder();
            apisBusiCorrectOrder.setStatus("1");
            MainEndorPriceDTO main = request.getEndorsePriceServiceRequest().getRequestBody().getMain();
            apisBusiCorrectOrder.setPolicyNo(main.getPolicyNo());
            apisBusiCorrectOrder.setManual(this.isBh(request) ? "EX" : "BH");
            apisBusiCorrectOrder.setEndorseType("06");
            if (ObjectUtil.isNotEmpty((Object)request.getEndorseServiceRequest().getRequestBody().getPolicyDTO())) {
                PolicyDTO policyDTO = request.getEndorseServiceRequest().getRequestBody().getPolicyDTO();
                apisBusiCorrectOrder.setChannelCode(policyDTO.getSalesList().getAgentCode());
                apisBusiCorrectOrder.setUserCode(policyDTO.getMain().getOperateCode());
                apisBusiCorrectOrder.setRequestUser(request.getHeader().getOriginUserCode());
                apisBusiCorrectOrder.setPlanCode(((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode());
                apisBusiCorrectOrder.setJfeeFlag(policyDTO.getMain().getJFeeFlag());
                apisBusiCorrectOrder.setPayTimes(policyDTO.getMain().getPayTimes());
                if (ObjectUtil.isNotEmpty((Object)policyDTO.getMain().getSumPremium())) {
                    apisBusiCorrectOrder.setPremium(BigDecimal.valueOf(policyDTO.getMain().getSumPremium()));
                }
            }
            if (ObjectUtil.isNotEmpty((Object)response) && ObjectUtil.isNotEmpty((Object)response.getCorrectQuotePriceServiceResponse()) && ObjectUtil.isNotEmpty((Object)response.getCorrectQuotePriceServiceResponse().getResponseBody()) && ObjectUtil.isNotEmpty((Object)response.getCorrectQuotePriceServiceResponse().getResponseBody().getEndorseApply().getMain().getApplyNo())) {
                MainEndorResponseDTO mainDto = response.getCorrectQuotePriceServiceResponse().getResponseBody().getEndorseApply().getMain();
                apisBusiCorrectOrder.setApplyNo(mainDto.getApplyNo());
                apisBusiCorrectOrder.setEndorseNo(mainDto.getPolicyNo());
            }
            if (ObjectUtil.isNotEmpty((Object)request.getHeader())) {
                apisBusiCorrectOrder.setBusinessKey(request.getHeader().getBusinessKey());
                apisBusiCorrectOrder.setCreator(request.getHeader().getUserCode());
            }
            this.apisBusiCorrectOrderService.save((Object)apisBusiCorrectOrder);
        }
        catch (Exception e) {
            this.log.error("\u9ad8\u9662\u63d2\u5165\u6279\u6539\u65e5\u5fd7\u5931\u8d25\uff0c{}", (Throwable)e);
        }
        return response;
    }
}

