/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.LitigationInvoiceUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.ValidatorsUtils;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationInvoiceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.validate.insure.LitigationInvoiceCompanyCheck;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderLitigationInvoiceHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(StanderLitigationInvoiceHandler.class);
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    ValidatorsUtils validatorsUtils;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    LitigationInvoiceUtil litigationInvoiceUtil;
    private static String POLICY_VALID = "1";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        Map userInfo = this.dataCompletionUtil.getChannelUserInfo(request);
        request.getHeader().setChannelCode(userInfo.get("channel_code") != null ? userInfo.get("channel_code") + "" : null);
        this.validateData(request);
        return request;
    }

    private void validateData(StanderRequest standerRequest) throws ApisBusinessException {
        if (ObjectUtils.isEmpty((Object)standerRequest) || ObjectUtils.isEmpty((Object)standerRequest.getLitigationInvoiceRequest()) || ObjectUtils.isEmpty((Object)standerRequest.getLitigationInvoiceRequest().getRequestBody())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u4f20\u5165\u6d88\u606f"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        LitigationInvoiceDTO dto = standerRequest.getLitigationInvoiceRequest().getRequestBody();
        if ("1".equals(dto.getTitleType()) && "1".equals(dto.getInvoiceType())) {
            log.warn("\u9ad8\u9662\u8bc9\u8d23\u9669\u5f00\u5355\u63a5\u53e3\uff1a\u4e2a\u4eba\u4e0d\u652f\u6301\u5f00\u5177\u4e13\u7968\uff01");
            throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B120002.getValue(), ErrorBisCodeEnum.ERR_B120002.getKey());
        }
        if (!this.apisBusiChannelOrderService.isExistOrder(dto.getPolicyNo()).booleanValue()) {
            log.warn("\u9ad8\u9662\u8bc9\u8d23\u9669\u5f00\u5355\u63a5\u53e3\uff1a\u5165\u53c2\u4fdd\u5355\u53f7\u4e0d\u5b58\u5728ChannelOrder\u4e2d\uff01");
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10155.getValue(), ChannelErrorCodeEnum.ERR_C10155.getKey());
        }
        PolicyDTO policyDetail = this.litigationInvoiceUtil.getPolicyDetail(standerRequest, dto.getPolicyNo());
        if (ObjectUtils.isEmpty((Object)policyDetail) || ObjectUtils.isEmpty((Object)policyDetail.getMain()) || !POLICY_VALID.equals(policyDetail.getMain().getPolicyStatus())) {
            log.warn("\u9ad8\u9662\u8bc9\u8d23\u9669\u5f00\u5355\u63a5\u53e3\uff1a\u4fdd\u5355\u65e0\u6548\uff01");
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10164.getValue(), ChannelErrorCodeEnum.ERR_C10164.getKey());
        }
        if (CollectionUtils.isNotEmpty((Collection)this.apisBusiTaskLogService.getTaskInfo(ApisAutoTaskConstantsEnum.LITIGATION_INVOICE_NOTIFY.getValue(), dto.getPolicyNo()))) {
            log.warn("\u9ad8\u9662\u8bc9\u8d23\u9669\u5f00\u5355\u63a5\u53e3\uff1a{}\uff01", (Object)ErrorBisCodeEnum.ERR_B120001.getValue());
            throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B120001.getValue(), ErrorBisCodeEnum.ERR_B120001.getKey());
        }
        this.validatorsUtils.valid((Object)dto);
        if ("2".equals(dto.getTitleType()) && "1".equals(dto.getInvoiceType())) {
            this.validatorsUtils.valid((Object)dto, LitigationInvoiceCompanyCheck.class);
        }
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        this.litigationInvoiceUtil.sendInvoiceEmail(request.getLitigationInvoiceRequest().getRequestBody());
        return this.litigationInvoiceUtil.convertResponse(request);
    }
}

