/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.ManUnderwriteService;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.ValidatorsUtils;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.underwrite.ManUnderwriteCancelResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwInsuredService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwOrderService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderManUnderwriteCancelHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(StanderManUnderwriteCancelHandler.class);
    @Autowired
    ValidatorsUtils validatorsUtils;
    @Autowired
    ApisBusiUwOrderService apisBusiUwOrderService;
    @Autowired
    ApisBusiUwInsuredService apisBusiUwInsuredService;
    @Autowired
    ManUnderwriteService manUnderwriteService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        this.validatorsUtils.valid((Object)request.getManUnderwriteCancelRequest());
        this.checkBusiness(request);
        return request;
    }

    private void checkBusiness(StanderRequest request) throws ApisBusinessException {
        ApisBusiUwOrder order = this.apisBusiUwOrderService.getByAgent(request.getManUnderwriteCancelRequest().getAgencyPolicyRef(), null, request.getHeader().getUserCode());
        if (ObjectUtils.isEmpty((Object)order)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10717.getValue(), ChannelErrorCodeEnum.ERR_C10717.getKey());
        }
        if ("10".equals(order.getStatus()) || "11".equals(order.getStatus())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10724.getValue(), ChannelErrorCodeEnum.ERR_C10724.getKey());
        }
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        String orderNo = request.getHeader().getUserCode() + request.getManUnderwriteCancelRequest().getAgencyPolicyRef();
        boolean success = this.manUnderwriteService.cancelPush(orderNo);
        if (success) {
            log.warn("\u8ba2\u5355\u53f7\u3010{}\u3011\u4eba\u5de5\u6838\u4fdd\u64a4\u9500\u8ba2\u5355\u63a8\u9001\u4f9b\u5e94\u5546,\u6210\u529f", (Object)orderNo);
            this.apisBusiUwOrderService.updateStatus(orderNo, "11");
            this.apisBusiUwInsuredService.updateStatusByOrderNo(orderNo, "11");
            ManUnderwriteCancelResponse response = ManUnderwriteCancelResponse.builder().agencyPolicyRef(request.getManUnderwriteCancelRequest().getAgencyPolicyRef()).build();
            return StanderResponse.builder().manUnderwriteCancelResponse(response).build();
        }
        log.warn("\u8ba2\u5355\u53f7\u3010{}\u3011\u4eba\u5de5\u6838\u4fdd\u64a4\u9500\u8ba2\u5355\u63a8\u9001\u4f9b\u5e94\u5546,\u5931\u8d25", (Object)orderNo);
        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10725.getValue(), ChannelErrorCodeEnum.ERR_C10725.getKey());
    }
}

