/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.ManUnderwriteService;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.ValidatorsUtils;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ManUnderwriteInsured;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ManUnderwriteItemKind;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ManUnderwriteSubmitRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.underwrite.ManUnderwriteSubmitResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwInsuredService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwSupportService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationKindDTO;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationMainService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderManUnderwriteSubmitHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(StanderManUnderwriteSubmitHandler.class);
    @Autowired
    ValidatorsUtils validatorsUtils;
    @Autowired
    ApisBusiUwOrderService apisBusiUwOrderService;
    @Autowired
    ApisBusiUwInsuredService apisBusiUwInsuredService;
    @Autowired
    ApisBusiUwSupportService apisBusiUwSupportService;
    @Autowired
    ManUnderwriteService manUnderwriteService;
    @Autowired
    ApisPfpRationMainService apisPfpRationMainService;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        this.checkIdempotent(request);
        this.validatorsUtils.valid((Object)request.getManUnderwriteSubmitRequest());
        this.checkBusiness(request);
        return request;
    }

    private void checkBusiness(StanderRequest request) throws ApisBusinessException {
        if (!this.apisBusiUwSupportService.supportIsEnable(request.getManUnderwriteSubmitRequest().getSupportCode())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10716.getValue(), ChannelErrorCodeEnum.ERR_C10716.getKey());
        }
        List insuredList = request.getManUnderwriteSubmitRequest().getInsuredList();
        List planCodeList = insuredList.stream().map(ManUnderwriteInsured::getPlanCode).collect(Collectors.toList());
        List rationKindList = this.apisPfpRationMainService.listMainKinds(planCodeList);
        List notExistPlanCodes = planCodeList.stream().filter(planCode -> {
            List exists = rationKindList.stream().map(ApisPfpRationKindDTO::getRationCode).collect(Collectors.toList());
            return !exists.contains(planCode);
        }).collect(Collectors.toList());
        if (ObjectUtils.isNotEmpty(notExistPlanCodes)) {
            String planCodesStr = notExistPlanCodes.stream().collect(Collectors.joining(","));
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10176.getValue().replace("##", planCodesStr), ChannelErrorCodeEnum.ERR_C10176.getKey());
        }
        List notExistKindCodes = insuredList.stream().filter(insured -> {
            List kindCodes = insured.getItemKindList().stream().map(ManUnderwriteItemKind::getKindCode).collect(Collectors.toList());
            List allKindCodes = rationKindList.stream().filter(kind -> kind.getRationCode().equals(insured.getPlanCode())).map(ApisPfpRationKindDTO::getKindCode).collect(Collectors.toList());
            return !allKindCodes.containsAll(kindCodes);
        }).collect(Collectors.toList());
        if (ObjectUtils.isNotEmpty(notExistKindCodes)) {
            String msg = notExistKindCodes.stream().map(insured -> {
                List kindCodes = insured.getItemKindList().stream().map(ManUnderwriteItemKind::getKindCode).collect(Collectors.toList());
                List allKindCodes = rationKindList.stream().filter(kind -> kind.getRationCode().equals(insured.getPlanCode())).map(ApisPfpRationKindDTO::getKindCode).collect(Collectors.toList());
                String kindCodesStr = kindCodes.stream().filter(kind -> !allKindCodes.contains(kind)).collect(Collectors.joining(","));
                return "\u8ba1\u5212\u4ee3\u7801\u3010" + insured.getPlanCode() + "\u3011\u4e0b\u8d23\u4efb\u4ee3\u7801\u3010 " + kindCodesStr + " \u3011\u4e0d\u5b58\u5728";
            }).collect(Collectors.joining(","));
            throw new ApisBusinessException(msg, ChannelErrorCodeEnum.ERR_C10176.getKey());
        }
        List professionList = this.apisChannelCodeService.listByCode("SmallClassProfession");
        String controlOcc = this.apisChannelConfigsService.getConfigValue("OCC_CONTROL_MAN");
        List<String> controlOccList = Arrays.asList(StringUtils.split((String)controlOcc, (String)";"));
        for (ManUnderwriteInsured insured2 : insuredList) {
            List existInsured = this.apisBusiUwInsuredService.listExtentByIdNo(insured2.getIdNumber(), insured2.getIdType(), insured2.getPlanCode());
            if (ObjectUtils.isNotEmpty((Object)existInsured)) {
                if (existInsured.stream().anyMatch(item -> StringUtils.isBlank((CharSequence)item.getUwRsCode()))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10733.getValue().replaceFirst("##", insured2.getPlanCode()).replaceFirst("##", insured2.getIdNumber()), ChannelErrorCodeEnum.ERR_C10733.getKey());
                }
                if (existInsured.stream().anyMatch(item -> StringUtils.isNotBlank((CharSequence)item.getUwRsCode()) && LocalDateTime.now().isBefore(item.getUwExpireTime()))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10733.getValue().replaceFirst("##", insured2.getPlanCode()).replaceFirst("##", insured2.getIdNumber()), ChannelErrorCodeEnum.ERR_C10733.getKey());
                }
            }
            if (professionList.stream().noneMatch(profession -> profession.getValue().equals(insured2.getOccupationCode()))) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10735.getValue().replaceFirst("##", insured2.getOccupationCode()), ChannelErrorCodeEnum.ERR_C10735.getKey());
            }
            if (controlOccList.contains(insured2.getOccupationCode())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10736.getValue().replace("##", insured2.getOccupationName()), ChannelErrorCodeEnum.ERR_C10736.getKey());
            }
            if (!"ZZ".equals(request.getManUnderwriteSubmitRequest().getSupportCode())) continue;
            if (ObjectUtils.isEmpty((Object)insured2.getHeight())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "\u8eab\u9ad8Height"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (!ObjectUtils.isEmpty((Object)insured2.getWeight())) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "\u4f53\u91cdWeight"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
    }

    private void checkIdempotent(StanderRequest request) throws ApisBusinessException {
        ManUnderwriteSubmitRequest submitRequest = request.getManUnderwriteSubmitRequest();
        int count = this.apisBusiUwOrderService.countByAgent(submitRequest.getAgencyPolicyRef(), submitRequest.getAgencyCode(), request.getHeader().getUserCode());
        if (count > 0) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10289.getValue(), ChannelErrorCodeEnum.ERR_C10289.getKey());
        }
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        if (this.manUnderwriteService.saveWholeOrder(request)) {
            ManUnderwriteSubmitResponse response = ManUnderwriteSubmitResponse.builder().agencyPolicyRef(request.getManUnderwriteSubmitRequest().getAgencyPolicyRef()).build();
            return StanderResponse.builder().manUnderwriteSubmitResponse(response).build();
        }
        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
    }
}

