/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.ManUnderwriteService;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.ValidatorsUtils;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ManUnderwriteSupplyInsured;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ManUnderwriteSupplyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.underwrite.ManUnderwriteSupplyResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwInsured;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwInsuredService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwOrderService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderManUnderwriteSupplyHandler
implements BusinessHandler {
    @Autowired
    ValidatorsUtils validatorsUtils;
    @Autowired
    ApisBusiUwOrderService apisBusiUwOrderService;
    @Autowired
    ManUnderwriteService manUnderwriteService;
    @Autowired
    ApisBusiUwInsuredService apisBusiUwInsuredService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        this.validatorsUtils.valid((Object)request.getManUnderwriteSupplyRequest());
        this.checkBusiness(request);
        return request;
    }

    private void checkBusiness(StanderRequest request) throws ApisBusinessException {
        ManUnderwriteSupplyRequest supplyRequest = request.getManUnderwriteSupplyRequest();
        ApisBusiUwOrder order = this.apisBusiUwOrderService.getByAgent(supplyRequest.getAgencyPolicyRef(), supplyRequest.getAgencyCode(), request.getHeader().getUserCode());
        if (ObjectUtils.isEmpty((Object)order)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10717.getValue(), ChannelErrorCodeEnum.ERR_C10717.getKey());
        }
        if (!order.getStatus().equals("5")) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10718.getValue(), ChannelErrorCodeEnum.ERR_C10718.getKey());
        }
        List uwIdList = supplyRequest.getInsuredList().stream().map(ManUnderwriteSupplyInsured::getInsuredUwId).collect(Collectors.toList());
        List insuredList = this.apisBusiUwInsuredService.listByUwIds(uwIdList);
        if (ObjectUtils.isEmpty((Object)insuredList)) {
            String notExistUwIds = String.join((CharSequence)",", uwIdList);
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10719.getValue().replace("##", notExistUwIds), ChannelErrorCodeEnum.ERR_C10719.getKey());
        }
        if (insuredList.size() < uwIdList.size()) {
            List existUwIds = insuredList.stream().map(ApisBusiUwInsured::getUwId).collect(Collectors.toList());
            String notExistUwIds = uwIdList.stream().filter(uwId -> !existUwIds.contains(uwId)).collect(Collectors.joining(","));
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10719.getValue().replace("##", notExistUwIds), ChannelErrorCodeEnum.ERR_C10719.getKey());
        }
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        if (this.manUnderwriteService.saveSupply(request)) {
            ManUnderwriteSupplyResponse response = ManUnderwriteSupplyResponse.builder().agencyPolicyRef(request.getManUnderwriteSupplyRequest().getAgencyPolicyRef()).build();
            return StanderResponse.builder().manUnderwriteSupplyResponse(response).build();
        }
        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
    }
}

