/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl.PaymentServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.PaymentGatewayUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ApplyInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PaymentApplyServiceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PaymentGatewayChannelDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PaymentGatewayRequestBodyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PaymentGatewayRequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PaymentGatewayServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.ApisChannelUserDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.InsuredInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PaymentApplyServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PaymentApplyServiceResponseBodyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PaymentGatewayResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiPayLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiChannelOrderMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiPayLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiReqmsgLogService;
import com.jdaz.sinosoftgz.apis.commons.utils.OtherUtils;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.factory.CoreDtoConverterFactory;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import com.jdaz.sinosoftgz.coreapi.payment.PaymentGatewayApi;
import com.sinosoft.epay.sdk.EpaySign;
import groovy.json.StringEscapeUtils;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

/*
 * Exception performing whole class analysis ignored.
 */
public class StanderPaymentApplyHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderPaymentApplyHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    PaymentGatewayApi paymentGatewayApi;
    @Autowired
    ApisBusiChannelOrderMapper apisBusinessChannelOrderMapper;
    @Autowired
    private ApisBusiReqmsgLogService apisBusiReqmsgLogService;
    @Autowired
    private CoreDtoConverterFactory coreDtoConverterFactory;
    @Value(value="${spring.datasource.password}")
    private String dataSourcePassword;
    @Value(value="${payment.successPaySignConstant}")
    private String successPaySignConstant;
    @Value(value="${payment.privateKey}")
    private String privateKey;
    private static String PAYMENT_METHOD = "wxMiniProg";
    @Autowired
    ApisBusiPayLogMapper apisPayLogMapper;
    private static Integer PAYMENT_DELAY_TIME_SETTING = 12;
    @Value(value="${payment.callBack.returnUrl}")
    private String returnCallBack;
    @Value(value="${payment.callBack.notifyUrl}")
    private String notifyCallBack;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    private static final String APPLET_FLAG = "appletFlag";
    public static HashMap<String, String> identifytypeMap = new HashMap();

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        request.getPaymentApplyServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        if (request.getPaymentApplyServiceRequest().getRequestBody() == null) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "body"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        PaymentApplyServiceRequestDTO body = request.getPaymentApplyServiceRequest().getRequestBody();
        if (StringUtils.isBlank((CharSequence)body.getAgencyCode())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "AgencyCode"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isBlank((CharSequence)body.getNotifyUrl())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "NotifyUrl"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isBlank((CharSequence)body.getPayAppid())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "PayAppid"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (body.getTotalPremium() == null) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "totalPremium"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (body.getPolicyList() == null || body.getPolicyList().size() == 0) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "policyList"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (body.getPolicyList().size() > 1 && StrUtil.isBlank((CharSequence)body.getOrderNo())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "OrderNo"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if ("1".equals(body.getRenewalPayFlag()) && StringUtils.isEmpty((CharSequence)body.getContractNotifyUrl())) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N40008.getValue(), ErrorNullValueCodeEnum.ERR_N40008.getKey());
        }
        if (ObjectUtil.isNotEmpty((Object)body.getPolicyList()) && body.getPolicyList().size() > 1 && "1".equals(body.getRenewalPayFlag())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10703.getValue(), ChannelErrorCodeEnum.ERR_C10703.getKey());
        }
        List policyInfoDTOS = body.getPolicyList();
        BigDecimal totalPremium = BigDecimal.ZERO;
        for (PolicyInfoDTO policyInfoDTO : policyInfoDTOS) {
            if (StringUtils.isBlank((CharSequence)policyInfoDTO.getPolicyRef())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "PolicyRef"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (policyInfoDTO.getPremium() == null) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "Premium"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            totalPremium = totalPremium.add(policyInfoDTO.getPremium());
        }
        if (totalPremium.compareTo(body.getTotalPremium()) != 0) {
            throw new ApisBusinessException("\u7f34\u8d39\u603b\u91d1\u989d\u4e0d\u7b49\u4e8e\u652f\u4ed8\u4fdd\u5355\u6e05\u5355\u4fdd\u8d39\u603b\u91d1\u989d\uff0c\u8bf7\u786e\u8ba4\uff01", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        body.setRenewalPayFlag(StringUtils.isEmpty((CharSequence)body.getRenewalPayFlag()) ? "0" : body.getRenewalPayFlag());
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        PaymentApplyServiceResponse response = PaymentApplyServiceResponse.builder().build();
        PaymentApplyServiceResponseBodyDTO bodyDTO = PaymentApplyServiceResponseBodyDTO.builder().build();
        PaymentApplyServiceRequestDTO paymentApplyServiceRequest = request.getPaymentApplyServiceRequest().getRequestBody();
        this.log.warn("\u652f\u4ed8\u7533\u8bf7\u63a5\u53e3\u5f02\u6b65\u56de\u8c03\u5730\u5740\uff1a{}", (Object)paymentApplyServiceRequest.getNotifyUrl());
        PaymentGatewayChannelDTO paymentGatewayChannelDTO = new PaymentGatewayChannelDTO();
        String policyRef = ((PolicyInfoDTO)paymentApplyServiceRequest.getPolicyList().get(0)).getPolicyRef();
        if (paymentApplyServiceRequest.getPolicyList().size() > 1) {
            policyRef = "BatchPayment";
        }
        paymentGatewayChannelDTO.setPolicyRef(policyRef);
        paymentGatewayChannelDTO.setTotalPremium(paymentApplyServiceRequest.getTotalPremium());
        paymentGatewayChannelDTO.setAgencyCode(paymentApplyServiceRequest.getAgencyCode());
        paymentGatewayChannelDTO.setPaymentMethod(PAYMENT_METHOD);
        paymentGatewayChannelDTO.setNotifyUrl(paymentApplyServiceRequest.getNotifyUrl());
        paymentGatewayChannelDTO.setReturnUrl("novalue");
        paymentGatewayChannelDTO.setRenewalPayFlag(paymentApplyServiceRequest.getRenewalPayFlag());
        paymentGatewayChannelDTO.setContractNotifyUrl(paymentApplyServiceRequest.getContractNotifyUrl());
        boolean isMobile = PaymentServiceImpl.isMobile((PaymentGatewayChannelDTO)paymentGatewayChannelDTO);
        paymentGatewayChannelDTO.setIsMobile(Boolean.valueOf(isMobile));
        paymentGatewayChannelDTO.setOrderNo(paymentApplyServiceRequest.getOrderNo());
        String appletFlag = this.dataCompletionUtil.reversalCode("appletFlag", paymentApplyServiceRequest.getPayAppid());
        if (StringUtils.isBlank((CharSequence)appletFlag)) {
            throw new ApisBusinessException("AppID\u672a\u914d\u7f6e\u6b63\u786e\u7684AppFlag!", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        paymentGatewayChannelDTO.setAppletFlag(appletFlag);
        boolean envFlag = "Fchx201911".equals(this.dataSourcePassword) || "Fchx202001".equals(this.dataSourcePassword);
        this.log.warn("\u73af\u5883\u5224\u65ad\u4f9d\u636e\uff1a{}", (Object)this.dataSourcePassword);
        if (envFlag) {
            paymentGatewayChannelDTO.setTotalPremium(BigDecimal.valueOf(0.01).multiply(BigDecimal.valueOf(paymentApplyServiceRequest.getPolicyList().size())));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("agencyCode", paymentGatewayChannelDTO.getAgencyCode());
        map.put("notifyUrl", paymentGatewayChannelDTO.getNotifyUrl());
        map.put("paymentMethod", paymentGatewayChannelDTO.getPaymentMethod());
        map.put("policyRef", paymentGatewayChannelDTO.getPolicyRef());
        map.put("returnUrl", paymentGatewayChannelDTO.getReturnUrl());
        map.put("totalPremium", paymentGatewayChannelDTO.getTotalPremium().toString());
        String content = PaymentGatewayUtil.createLinkString(map) + this.successPaySignConstant;
        String md5 = SecureUtil.md5((String)content);
        paymentGatewayChannelDTO.setSign(md5);
        Date now = new Date();
        DateTime expireDate = DateUtil.offsetHour((Date)now, (int)PAYMENT_DELAY_TIME_SETTING);
        paymentGatewayChannelDTO.setExpireTime((Date)expireDate);
        this.convertParams(paymentGatewayChannelDTO, request);
        PaymentGatewayResponse resp = null;
        try {
            resp = this.paymentGatewayApi.paymentNoApply(request);
            this.log.warn("\u8c03\u7528\u6838\u5fc3\u63a5\u53e3\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)resp));
        }
        catch (Exception e) {
            this.log.error("\u652f\u4ed8\u7f51\u5173\uff0c\u8c03\u7528\u6838\u5fc3\u652f\u4ed8\u7533\u8bf7\u63a5\u53e3\u62a5\u9519\uff0c\u4e1a\u52a1\u53f7{}", (Object)paymentGatewayChannelDTO.getPolicyRef());
            throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B40002.getValue(), ErrorBisCodeEnum.ERR_B40002.getKey());
        }
        if (resp != null && 0L != resp.getHead().getCode()) {
            this.log.error("\u652f\u4ed8\u7f51\u5173\uff0c\u8c03\u7528\u6838\u5fc3\u652f\u4ed8\u7533\u8bf7\u63a5\u53e3\u62a5\u9519\uff0c\u4e1a\u52a1\u53f7{},\u9519\u8bef\u4fe1\u606f:{}", (Object)paymentGatewayChannelDTO.getPolicyRef(), (Object)resp.getHead().getMessage());
            String message = ErrorBisCodeEnum.ERR_B40002.getValue();
            if (StrUtil.isNotEmpty((CharSequence)resp.getHead().getMessage())) {
                message = resp.getHead().getMessage();
            }
            throw new ApisBusinessException(message, ErrorBisCodeEnum.ERR_B40002.getKey());
        }
        bodyDTO.setPayMethod(paymentGatewayChannelDTO.getPaymentMethod());
        bodyDTO.setAppletFlag(paymentGatewayChannelDTO.getAppletFlag());
        bodyDTO.setPayAppid(paymentApplyServiceRequest.getPayAppid());
        response.setBody(bodyDTO);
        this.paylogHandle(paymentGatewayChannelDTO, request, resp);
        if (StringUtils.isNotBlank((CharSequence)resp.getBody().getAppletData())) {
            bodyDTO.setAppletData(StringEscapeUtils.escapeJava((String)resp.getBody().getAppletData()));
        }
        return StanderResponse.builder().header(request.getHeader()).paymentApplyServiceResponse(response).build();
    }

    public static String getIdentifyType(String type) {
        if (StrUtil.isEmpty((CharSequence)type)) {
            return null;
        }
        String identifyType = (String)identifytypeMap.get(type);
        if (identifyType == null) {
            identifyType = "99";
        }
        return identifyType;
    }

    public void convertParams(PaymentGatewayChannelDTO paymentGatewayChannelDTO, StanderRequest request) throws ApisBusinessException {
        PaymentGatewayServiceRequest req = PaymentGatewayServiceRequest.builder().build();
        PaymentGatewayRequestHeadDTO head = PaymentGatewayRequestHeadDTO.builder().build();
        head.setMsgtype("payNoApply");
        head.setVersion("1.0");
        head.setSystemCode("03");
        head.setTimestamp(String.valueOf(DateUtil.current()));
        head.setSign(paymentGatewayChannelDTO.getSign());
        PaymentGatewayRequestBodyDTO body = PaymentGatewayRequestBodyDTO.builder().build();
        String paymentMethod = paymentGatewayChannelDTO.getPaymentMethod();
        this.log.warn("convertParams\u4e2d\u6e20\u9053\u652f\u4ed8\u65b9\u5f0f\uff1a{}", (Object)paymentMethod);
        String paymentCode = PaymentServiceImpl.getPaymentCode((PaymentGatewayChannelDTO)paymentGatewayChannelDTO);
        body.setEntrustPayFlag(paymentGatewayChannelDTO.getEntrustPayFlag());
        body.setPayMethod(paymentCode);
        if ("JD02".equals(paymentCode)) {
            body.setPayeType("2");
        }
        if ("JD01".equals(paymentCode)) {
            body.setPayeType("1");
        }
        body.setOperateType("0");
        body.setAppletFlag(paymentGatewayChannelDTO.getAppletFlag());
        body.setSumFee(paymentGatewayChannelDTO.getTotalPremium().toString());
        body.setPcUrl(this.returnCallBack);
        body.setMoveUrl(this.returnCallBack);
        body.setThirdFlag("01");
        body.setThirdCallUrl(this.notifyCallBack);
        body.setThirdContractCallUrl(paymentGatewayChannelDTO.getContractNotifyUrl());
        body.setRenewalPayFlag(paymentGatewayChannelDTO.getRenewalPayFlag());
        List policyInfoDTOS = request.getPaymentApplyServiceRequest().getRequestBody().getPolicyList();
        ArrayList<ApplyInfoDTO> list = new ArrayList<ApplyInfoDTO>();
        boolean isOnePolicyInfo = policyInfoDTOS.size() <= 1;
        for (PolicyInfoDTO policyInfoDTO : policyInfoDTOS) {
            ApisChannelUserDTO channelUserDTO;
            String comCode;
            ApplyInfoDTO applyInfoDTO = new ApplyInfoDTO();
            String policyRef = policyInfoDTO.getPolicyRef();
            QueryWrapper apisBusiChannelOrderQueryWrapper = new QueryWrapper();
            apisBusiChannelOrderQueryWrapper.eq((Object)"policy_no", (Object)policyRef);
            ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusinessChannelOrderMapper.selectOne((Wrapper)apisBusiChannelOrderQueryWrapper);
            if (BeanUtil.isEmpty((Object)order, (String[])new String[0])) {
                this.log.error("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38,\u4e1a\u52a1\u53f7\uff1a{}", (Object)policyRef);
                throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B40004.getValue(), ErrorBisCodeEnum.ERR_B40004.getKey());
            }
            String productCode = order.getProductCode();
            String planName = order.getPlanName();
            String giftType = order.getGiftType();
            Integer payNumber = order.getPayNumbers();
            this.log.warn("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f,productCode:{},planName:{},giftType:{},payNumber:{}", new Object[]{productCode, planName, giftType, payNumber});
            if (BeanUtil.isEmpty((Object)productCode, (String[])new String[0])) {
                this.log.error("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f,productCode\u7a7a\u6307\u9488\u5f02\u5e38,\u4e1a\u52a1\u53f7\uff1a{}", (Object)policyRef);
                throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B40001.getValue(), ErrorBisCodeEnum.ERR_B40001.getKey());
            }
            if (BeanUtil.isEmpty((Object)planName, (String[])new String[0])) {
                this.log.error("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff0cplanName\u7a7a\u6307\u9488\u5f02\u5e38\uff0c\u4e1a\u52a1\u53f7\uff1a{}", (Object)policyRef);
                throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B40005.getValue(), ErrorBisCodeEnum.ERR_B40005.getKey());
            }
            if (BeanUtil.isNotEmpty((Object)giftType, (String[])new String[0]) && "_1_2".contains(giftType)) {
                this.log.error("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff0c\u8d60\u9669\u4fdd\u5355\u4e0d\u8d70\u652f\u4ed8\u6d41\u7a0b\uff0c\u4e1a\u52a1\u53f7\uff1a{}", (Object)policyRef);
                throw new ApisBusinessException("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff0c\u8d60\u9669\u4fdd\u5355\u4e0d\u8d70\u652f\u4ed8\u6d41\u7a0b\uff0c\u4e1a\u52a1\u53f7\uff1a" + policyRef, ErrorBisCodeEnum.ERR_B40005.getKey());
            }
            if (BeanUtil.isNotEmpty((Object)payNumber, (String[])new String[0]) && payNumber > 1 && (BeanUtil.isEmpty((Object)paymentGatewayChannelDTO.getEntrustPayFlag(), (String[])new String[0]) || !"1".equals(paymentGatewayChannelDTO.getEntrustPayFlag()))) {
                this.log.error("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff0c\u5206\u671f\u4fdd\u5355\u5206\u671f\u6807\u5fd7\u53ca\u88ab\u4fdd\u9669\u4eba\u540d\u79f0\u3001\u8bc1\u4ef6\u53f7\u3001\u8bc1\u4ef6\u7c7b\u578b\u5fc5\u4f20\uff0c\u4e1a\u52a1\u53f7\uff1a{}", (Object)policyRef);
                throw new ApisBusinessException("\u5206\u671f\u4fdd\u5355\u5206\u671f\u6807\u5fd7\u53ca\u88ab\u4fdd\u9669\u4eba\u540d\u79f0\u3001\u8bc1\u4ef6\u53f7\u3001\u8bc1\u4ef6\u7c7b\u578b\u5fc5\u4f20,\u4e1a\u52a1\u53f7\uff1a" + policyRef, ErrorBisCodeEnum.ERR_B40005.getKey());
            }
            if ("2".equals(paymentGatewayChannelDTO.getEntrustPayFlag())) {
                boolean isOneYear = false;
                if (ObjectUtil.isNotEmpty((Object)order.getStartDate()) && ObjectUtil.isNotEmpty((Object)order.getEndDate())) {
                    isOneYear = DataCompletionUtil.isOutOneYear((LocalDateTime)order.getStartDate(), (LocalDateTime)order.getEndDate(), (boolean)true);
                }
                if (!isOneYear) {
                    this.log.error("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff0c\u5206\u671f\u4fdd\u5355\u5206\u671f\u6807\u5fd7\u53d6\u503c\u9519\u8bef\uff0c\u4e1a\u52a1\u53f7\uff1a{}\uff0centrustPayFlag\uff1a{}", (Object)policyRef, (Object)paymentGatewayChannelDTO.getEntrustPayFlag());
                    throw new ApisBusinessException("\u5206\u671f\u4fdd\u5355\u5206\u671f\u6807\u5fd7\u53d6\u503c\u9519\u8bef", ErrorBisCodeEnum.ERR_B40005.getKey());
                }
            }
            if (StrUtil.isEmpty((CharSequence)(comCode = (channelUserDTO = this.apisBusinessChannelOrderMapper.selectChannelUserInfo(order.getCreator())).getComCode()))) {
                this.log.error("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff0ccomCode\u83b7\u53d6\u5f02\u5e38\uff0c\u4e1a\u52a1\u53f7\uff1a{}", (Object)policyRef);
                throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B40005.getValue(), "ERR_B40006");
            }
            body.setProductName(planName);
            body.setRouteCode(StrUtil.sub((CharSequence)comCode, (int)0, (int)4));
            applyInfoDTO.setBusinessNo(order.getProposalNo());
            applyInfoDTO.setComCode(comCode);
            applyInfoDTO.setRiskCode(productCode);
            applyInfoDTO.setAmount(policyInfoDTO.getPremium().toString());
            String goodsCode = order.getPlanCode();
            String goodsName = order.getPlanName();
            if (StrUtil.isNotBlank((CharSequence)goodsCode)) {
                applyInfoDTO.setGoodsCode(goodsCode);
            }
            if (StrUtil.isNotBlank((CharSequence)goodsName)) {
                applyInfoDTO.setGoodsName(goodsName);
            }
            boolean envFlag = this.dataSourcePassword.equals("Fchx201911") || this.dataSourcePassword.equals("Fchx202001");
            this.log.warn("\u73af\u5883\u5224\u65ad\u4f9d\u636e\uff1a{}", (Object)this.dataSourcePassword);
            if (envFlag) {
                applyInfoDTO.setAmount(BigDecimal.valueOf(0.01).toString());
            }
            Date startDate = Date.from(order.getStartDate().atZone(ZoneId.systemDefault()).toInstant());
            applyInfoDTO.setEffectDate(DateUtil.format((Date)startDate, (String)"yyyy-MM-dd"));
            applyInfoDTO.setSerialNo("1");
            if ("1".equals(paymentGatewayChannelDTO.getEntrustPayFlag())) {
                List insuredInfoDTOS = null;
                insuredInfoDTOS = isOnePolicyInfo ? paymentGatewayChannelDTO.getInsuredInfos() : policyInfoDTO.getInsuredInfos();
                if (BeanUtil.isEmpty((Object)insuredInfoDTOS, (String[])new String[0])) {
                    throw new ApisBusinessException("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff0c\u5206\u671f\u4fdd\u5355\u88ab\u4fdd\u9669\u4eba\u540d\u79f0\u3001\u8bc1\u4ef6\u53f7\u3001\u8bc1\u4ef6\u7c7b\u578b\u5fc5\u4f20\uff0c\u4e1a\u52a1\u53f7\uff1a" + policyRef, ErrorBisCodeEnum.ERR_B40005.getKey());
                }
                ArrayList<InsuredInfoDTO> insuredInfos = new ArrayList<InsuredInfoDTO>();
                for (InsuredInfoDTO item : insuredInfoDTOS) {
                    String name = item.getName();
                    String identifyNo = item.getIdentifyNo();
                    String identifyType = StanderPaymentApplyHandler.getIdentifyType((String)item.getIdentifyType());
                    if (StrUtil.isEmpty((CharSequence)name) || StrUtil.isEmpty((CharSequence)identifyNo) || StrUtil.isEmpty((CharSequence)identifyType)) {
                        throw new ApisBusinessException("\u652f\u4ed8\u7f51\u5173\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff0c\u5206\u671f\u4fdd\u5355\u88ab\u4fdd\u9669\u4eba\u540d\u79f0\u3001\u8bc1\u4ef6\u53f7\u3001\u8bc1\u4ef6\u7c7b\u578b\u5fc5\u4f20\uff0c\u4e1a\u52a1\u53f7\uff1a" + policyRef, ErrorBisCodeEnum.ERR_B40005.getKey());
                    }
                    InsuredInfoDTO insuredInfoDTO = new InsuredInfoDTO();
                    insuredInfoDTO.setName(name);
                    insuredInfoDTO.setIdentifyNo(identifyNo);
                    insuredInfoDTO.setIdentifyType(identifyType);
                    insuredInfos.add(insuredInfoDTO);
                }
                if (insuredInfos.size() > 0) {
                    applyInfoDTO.setInsuredDtos(insuredInfos);
                }
            }
            list.add(applyInfoDTO);
        }
        body.setApplyInfoDTO(list);
        JSONObject headMap = JSON.parseObject((String)JSON.toJSONString((Object)head));
        JSONObject bodyMap = JSON.parseObject((String)JSON.toJSONString((Object)body));
        EpaySign epaySignClient = EpaySign.newInstance(null, (String)this.privateKey, (Boolean)false);
        String strSign = epaySignClient.requestSign((Map)headMap, (Map)bodyMap);
        this.log.warn("\u652f\u4ed8\u7f51\u5173\uff0c\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff0c \u8bf7\u6c42\u53c2\u6570sign\uff1a{}", (Object)strSign);
        head.setSign(strSign);
        req.setHead(head);
        req.setBody(body);
        request.setPaymentGateWayServiceRequest(req);
    }

    public void paylogHandle(PaymentGatewayChannelDTO paymentGatewayChannelDTO, StanderRequest request, PaymentGatewayResponse resp) {
        String payApplyNo = resp.getBody().getPayApplyNo();
        String checkNo = resp.getBody().getCheckNo();
        QueryWrapper apisBusiChannelOrderQueryWrapper = null;
        Long payLogId = null;
        if ("BatchPayment".equals(paymentGatewayChannelDTO.getPolicyRef())) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"pay_no", (Object)payApplyNo);
            this.apisPayLogMapper.delete((Wrapper)updateWrapper);
            ApisBusiPayLog mainPayLog = this.insertPayLog(paymentGatewayChannelDTO, payApplyNo, checkNo);
            payLogId = mainPayLog.getId();
        }
        for (PolicyInfoDTO policyInfoDTO : request.getPaymentApplyServiceRequest().getRequestBody().getPolicyList()) {
            apisBusiChannelOrderQueryWrapper = new QueryWrapper();
            apisBusiChannelOrderQueryWrapper.eq((Object)"policy_no", (Object)policyInfoDTO.getPolicyRef());
            ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusinessChannelOrderMapper.selectOne((Wrapper)apisBusiChannelOrderQueryWrapper);
            order.setPayNo(payApplyNo);
            this.apisBusinessChannelOrderMapper.updatePayNoById(order);
            ApisBusiPayLog history = new ApisBusiPayLog();
            history.setAgencyCode(paymentGatewayChannelDTO.getAgencyCode());
            history.setBusinessNo(policyInfoDTO.getPolicyRef());
            history.setPaymentMethod(paymentGatewayChannelDTO.getPaymentMethod());
            history.setTotalPremium(paymentGatewayChannelDTO.getTotalPremium());
            history.setNotifyUrl(paymentGatewayChannelDTO.getNotifyUrl());
            history.setReturnUrl(paymentGatewayChannelDTO.getReturnUrl());
            history.setSign(paymentGatewayChannelDTO.getSign());
            history.setIsMobile(String.valueOf(paymentGatewayChannelDTO.getIsMobile()));
            history.setPayNo(payApplyNo);
            history.setCheckNo(checkNo);
            history.setOrderNo(paymentGatewayChannelDTO.getOrderNo());
            history.setPayLogId(payLogId);
            if (ObjectUtil.isNotEmpty((Object)paymentGatewayChannelDTO.getNotifyUrl())) {
                history.setNotifyDomain(OtherUtils.getDomainFromUrl((String)paymentGatewayChannelDTO.getNotifyUrl()));
            }
            this.apisPayLogMapper.insert((Object)history);
        }
    }

    private ApisBusiPayLog insertPayLog(PaymentGatewayChannelDTO paymentGatewayChannelDTO, String payApplyNo, String checkNo) {
        ApisBusiPayLog history = new ApisBusiPayLog();
        history.setAgencyCode(paymentGatewayChannelDTO.getAgencyCode());
        history.setBusinessNo(paymentGatewayChannelDTO.getPolicyRef());
        history.setPaymentMethod(paymentGatewayChannelDTO.getPaymentMethod());
        history.setTotalPremium(paymentGatewayChannelDTO.getTotalPremium());
        history.setNotifyUrl(paymentGatewayChannelDTO.getNotifyUrl());
        history.setReturnUrl(paymentGatewayChannelDTO.getReturnUrl());
        history.setSign(paymentGatewayChannelDTO.getSign());
        history.setIsMobile(String.valueOf(paymentGatewayChannelDTO.getIsMobile()));
        history.setPayNo(payApplyNo);
        history.setCheckNo(checkNo);
        history.setOrderNo(paymentGatewayChannelDTO.getOrderNo());
        if (ObjectUtil.isNotEmpty((Object)paymentGatewayChannelDTO.getNotifyUrl())) {
            history.setNotifyDomain(OtherUtils.getDomainFromUrl((String)paymentGatewayChannelDTO.getNotifyUrl()));
        }
        this.apisPayLogMapper.insert((Object)history);
        return history;
    }

    public void payReturnCallBack(String payAppNo) throws Exception {
        this.log.warn("\u652f\u4ed8\u7f51\u5173\uff0c\u540c\u6b65\u56de\u8c03\u5f00\u59cb\uff0c\u652f\u4ed8\u53f7\uff1a{}", (Object)payAppNo);
        if (StrUtil.isEmpty((CharSequence)payAppNo)) {
            throw new RuntimeException("\u8bf7\u6c42\u53c2\u6570\u652f\u4ed8\u53f7\u7f3a\u5931");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"pay_no", (Object)payAppNo);
        List apisBusiPayLogs = this.apisPayLogMapper.selectList((Wrapper)queryWrapper);
        QueryWrapper apisBusiChannelOrderQueryWrapper = null;
        ApisBusiChannelOrder updateEntity = null;
        UpdateWrapper wrapper = null;
        ApisBusiPayLog updatePayLog = null;
        QueryWrapper installmentOrderUpdateWrapper = null;
        Object apisBusiChannelInstallmentOrders = null;
        String orderNo = "";
        String status = "";
        String agentCode = "";
        DateTime dateTime = DateUtil.date((Date)new Date());
        ApisBusiPayLog apisBusiPayLog = new ApisBusiPayLog();
        LocalDateTime localDateTime = dateTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        for (ApisBusiPayLog apisBusiPayLogBusi : apisBusiPayLogs) {
            apisBusiChannelOrderQueryWrapper = new QueryWrapper();
            apisBusiChannelOrderQueryWrapper.eq((Object)"policy_no", (Object)apisBusiPayLogBusi.getBusinessNo());
            ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusinessChannelOrderMapper.selectOne((Wrapper)apisBusiChannelOrderQueryWrapper);
            orderNo = order.getOrderNo();
            UpdateWrapper orderUpdateWrapper = new UpdateWrapper();
            orderUpdateWrapper.eq((Object)"id", (Object)order.getId());
            updateEntity = new ApisBusiChannelOrder();
            updateEntity.setStatus("04");
            updateEntity.setPayTime(localDateTime);
            updateEntity.setPolicyTime(localDateTime);
            this.apisBusinessChannelOrderMapper.update((Object)updateEntity, (Wrapper)orderUpdateWrapper);
            status = "wxpayH5".equals(apisBusiPayLogBusi.getPaymentMethod()) ? "PROCESSING" : "SUCCESS";
            wrapper = new UpdateWrapper();
            updatePayLog = new ApisBusiPayLog();
            updatePayLog.setPayTime(new Date());
            updatePayLog.setTradeStatus(status);
            updatePayLog.setMsg("\u8bf7\u6c42\u6210\u529f");
            wrapper.eq((Object)"id", (Object)apisBusiPayLogBusi.getId());
            this.apisPayLogMapper.update((Object)updatePayLog, (Wrapper)wrapper);
            installmentOrderUpdateWrapper = new QueryWrapper();
            installmentOrderUpdateWrapper.eq((Object)"policy_no", (Object)apisBusiPayLogBusi.getBusinessNo());
            installmentOrderUpdateWrapper.eq((Object)"current_pay_no", (Object)1);
            apisBusiPayLogBusi.setMsg(updatePayLog.getMsg());
            apisBusiPayLogBusi.setPayTime(updatePayLog.getPayTime());
            apisBusiPayLogBusi.setTradeStatus(updatePayLog.getTradeStatus());
            apisBusiPayLog = apisBusiPayLogBusi;
        }
        String sign = this.getSign(apisBusiPayLog, orderNo, status);
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append("<!DOCTYPE html>");
        htmlBuilder.append("<html>");
        htmlBuilder.append("<head>");
        htmlBuilder.append("<title>\u652f\u4ed8\u56de\u8c03\u9875\u9762</title>");
        htmlBuilder.append("</head>");
        htmlBuilder.append("<body>");
        htmlBuilder.append("<form id=\"returnForm\" method=\"post\" action=\"" + StrUtil.nullToEmpty((CharSequence)apisBusiPayLog.getReturnUrl()) + "\">");
        htmlBuilder.append("<input name=\"agencyCode\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)apisBusiPayLog.getAgencyCode()) + "\"/>");
        htmlBuilder.append("<input name=\"policyRef\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)apisBusiPayLog.getBusinessNo()) + "\"/>");
        htmlBuilder.append("<input name=\"totalPremium\" type=\"hidden\" value=\"" + (apisBusiPayLog.getTotalPremium() == null ? "" : apisBusiPayLog.getTotalPremium().toString()) + "\"/>");
        htmlBuilder.append("<input name=\"paymentMethod\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)apisBusiPayLog.getPaymentMethod()) + "\"/>");
        htmlBuilder.append("<input name=\"notifyUrl\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)apisBusiPayLog.getNotifyUrl()) + "\"/>");
        htmlBuilder.append("<input name=\"returnUrl\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)apisBusiPayLog.getReturnUrl()) + "\"/>");
        htmlBuilder.append("<input name=\"paymentGatewaySn\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)orderNo) + "\"/>");
        htmlBuilder.append("<input name=\"payTime\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)DateUtil.format((Date)updatePayLog.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss")) + "\"/>");
        htmlBuilder.append("<input name=\"tradeStatus\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)status) + "\"/>");
        htmlBuilder.append("<input name=\"msg\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)updatePayLog.getMsg()) + "\"/>");
        htmlBuilder.append("<input name=\"sign\" type=\"hidden\" value=\"" + StrUtil.nullToEmpty((CharSequence)sign) + "\"/>");
        htmlBuilder.append("</form>");
        htmlBuilder.append("<script>document.getElementById('returnForm').submit();</script>");
        htmlBuilder.append("</body>");
        htmlBuilder.append("</html>");
        this.log.warn(htmlBuilder.toString());
        this.log.warn("\u652f\u4ed8\u7f51\u5173\uff0c\u540c\u6b65\u56de\u8c03\u7ed3\u675f\uff0c\u652f\u4ed8\u53f7\uff1a{}", (Object)payAppNo);
    }

    private String getSign(ApisBusiPayLog apisBusiPayLog, String orderNo, String status) {
        String agencyCode = apisBusiPayLog.getAgencyCode();
        String msg = apisBusiPayLog.getMsg();
        String notifyUrl = apisBusiPayLog.getNotifyUrl();
        String payTime = DateUtil.format((Date)apisBusiPayLog.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss");
        String paymentGatewaySn = orderNo;
        String paymentMethod = apisBusiPayLog.getPaymentMethod();
        String policyRef = apisBusiPayLog.getBusinessNo();
        String returnUrl = apisBusiPayLog.getReturnUrl();
        String totalPremium = apisBusiPayLog.getTotalPremium().toString();
        String tradeStatus = status;
        String signConstant = this.successPaySignConstant;
        String content = "agencyCode=" + agencyCode + "&msg=" + msg + "&notifyUrl=" + notifyUrl + "&payTime=" + payTime + "&paymentGatewaySn=" + paymentGatewaySn + "&paymentMethod=" + paymentMethod + "&policyRef=" + policyRef + "&returnUrl=" + returnUrl + "&totalPremium=" + totalPremium + "&tradeStatus=" + tradeStatus + signConstant;
        this.log.warn("\u540c\u6b65\u56de\u8c03\u52a0\u5bc6sign\uff0c\u62fc\u63a5\u5b57\u7b26\u4e32\uff1a{}", (Object)content);
        String sign = SecureUtil.md5((String)content);
        this.log.warn("\u540c\u6b65\u56de\u8c03\u52a0\u5bc6sign\uff1a{}", (Object)sign);
        return sign;
    }

    static {
        identifytypeMap.put("1", "01");
        identifytypeMap.put("2", "03");
        identifytypeMap.put("3", "99");
        identifytypeMap.put("01", "01");
        identifytypeMap.put("03", "03");
        identifytypeMap.put("05", "05");
        identifytypeMap.put("99", "99");
    }
}

