/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.BusinessConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.ValidatorsUtils;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.RationServicesDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PlanDetailQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.BenefitDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.LimitInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PlanBasicInformationDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PlanDetailQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PlanDetailQueryResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PremiumDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.RemarkDTO;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationClauseKindFactory;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationHealth;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationPfchealth;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfsInsuredType;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationClauseKindFactoryService;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationEngageService;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationHealthService;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationKindService;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationLimitService;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationMainService;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationPfchealthService;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationServicesDetailService;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfsInsuredTypeService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StanderPlanDetailHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(StanderPlanDetailHandler.class);
    @Autowired
    ApisPfpRationMainService apisPfpRationMainService;
    @Autowired
    ApisPfpRationClauseKindFactoryService apisPfpRationClauseKindFactoryService;
    @Autowired
    ApisPfpRationHealthService apisPfpRationHealthService;
    @Autowired
    ApisPfpRationPfchealthService apisPfpRationPfchealthService;
    @Autowired
    ApisPfpRationKindService apisPfpRationKindService;
    @Autowired
    ApisPfpRationEngageService apisPfpRationEngageService;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Autowired
    ApisPfsInsuredTypeService apisPfsInsuredTypeService;
    @Autowired
    ApisPfpRationLimitService apisPfpRationLimitService;
    @Autowired
    ApisPfpRationServicesDetailService apisPfpRationServicesDetailService;
    @Autowired
    ValidatorsUtils validatorsUtils;
    private static final String[] EFFECTIVE_RISK_TYPES = new String[]{"593", "594", "595", "543", "544", "545", "504"};
    private static final String SPLIT_STR = ",";
    private static final Integer DEFAULT_MIN_AGE = 0;
    private static final String LIMIT = "1";
    private static final String DEDUCTIBLE = "2";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        String uuid = UUID.fastUUID().toString().replaceAll("-", "");
        String businessKey = request.getHeader().getBusinessKey();
        request.getHeader().setBusinessKey(ObjectUtil.isNotEmpty((Object)businessKey) ? businessKey : uuid);
        request.getPlanDetailQueryRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        this.validatorsUtils.valid((Object)request.getPlanDetailQueryRequest().getRequestBody());
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        PlanDetailQueryRequest planDetailQueryRequest = request.getPlanDetailQueryRequest();
        try {
            ApisPfpRationMain apisPfpRationMain = this.apisPfpRationMainService.getPlanMain(planDetailQueryRequest.getRequestBody().getPlanCode());
            TimeInterval timer = DateUtil.timer();
            PlanBasicInformationDTO planBasicInformationDTO = this.getPlanBasicInformationDTO(apisPfpRationMain);
            log.warn("\u83b7\u53d6\u8ba1\u5212\u660e\u7ec6\u57fa\u672c\u4fe1\u606f\u7528\u65f6\uff1a{}", (Object)timer.intervalRestart());
            List benefits = this.getBenfitDTOs(apisPfpRationMain);
            log.warn("\u83b7\u53d6\u8ba1\u5212\u660e\u7ec6\u4fdd\u969c\u5229\u76ca\u6e05\u5355\u7528\u65f6\uff1a{}", (Object)timer.intervalRestart());
            List premiums = this.getPermiumDTOList(apisPfpRationMain);
            log.warn("\u83b7\u53d6\u8ba1\u5212\u660e\u7ec6\u4fdd\u8d39\u8ba1\u7b97\u6e05\u5355\u7528\u65f6\uff1a{}", (Object)timer.intervalRestart());
            List remarks = this.getRemarkDTOs(apisPfpRationMain);
            List limitList = this.getLimitInfoDTOs(apisPfpRationMain, LIMIT);
            List deductibleList = this.getLimitInfoDTOs(apisPfpRationMain, DEDUCTIBLE);
            List servicesList = this.getServicesDTOs(apisPfpRationMain);
            log.warn("\u83b7\u53d6\u8ba1\u5212\u660e\u7ec6\u5065\u5eb7\u95ee\u5377\u6e05\u5355\u7528\u65f6\uff1a{}", (Object)timer.intervalRestart());
            return StanderResponse.builder().header(request.getHeader()).planDetailQueryResponse(PlanDetailQueryResponse.builder().responseBody(PlanDetailQueryResponseDTO.builder().planBasicInformation(planBasicInformationDTO).benefitList(benefits).premiumList(premiums).remarkList(remarks).limitList(limitList).deductibleList(deductibleList).servicesList(servicesList).build()).build()).build();
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
    }

    private List<RationServicesDTO> getServicesDTOs(ApisPfpRationMain apisPfpRationMain) {
        List servicesDetails;
        List<Object> servicesDTOS = new ArrayList<RationServicesDTO>();
        if (ObjectUtils.isNotEmpty((Object)apisPfpRationMain) && ObjectUtils.isNotEmpty((Object)(servicesDetails = this.apisPfpRationServicesDetailService.listServiceDetailsByRationId(apisPfpRationMain.getId())))) {
            servicesDTOS = servicesDetails.stream().map(detail -> RationServicesDTO.builder().fileCategory(detail.getFileCategory()).serviceCode(detail.getServiceCode()).serviceName(detail.getServiceName()).serviceEname(detail.getServiceEname()).fileCategoryText(detail.getFileCategoryText()).build()).collect(Collectors.toList());
        }
        return servicesDTOS;
    }

    private List<LimitInfoDTO> getLimitInfoDTOs(ApisPfpRationMain apisPfpRationMain, String limitType) {
        List limits;
        List<Object> limitInfoDTOS = new ArrayList<LimitInfoDTO>();
        if (ObjectUtils.isNotEmpty((Object)apisPfpRationMain) && ObjectUtils.isNotEmpty((Object)(limits = this.apisPfpRationLimitService.listLimitsByRationId(apisPfpRationMain.getId(), limitType)))) {
            limitInfoDTOS = limits.stream().map(limit -> LimitInfoDTO.builder().limitCode(limit.getLimitCode()).limitName(limit.getLimitName()).limitLevel(ObjectUtils.isNotEmpty((Object)limit.getLimitLevel()) ? limit.getLimitLevel() + "" : "").clauseCode(limit.getClauseCode()).benefitCode(limit.getKindCode()).limitValue(ObjectUtils.isNotEmpty((Object)limit.getLimitValue()) ? limit.getLimitValue().toString() : "").limitUnit(limit.getLimitUnit()).remark(limit.getRemark()).build()).collect(Collectors.toList());
        }
        return limitInfoDTOS;
    }

    private List<RemarkDTO> getRemarkDTOs(ApisPfpRationMain apisPfpRationMain) {
        List apisPfpRationEngages;
        List<Object> remarkDTOS = new ArrayList<RemarkDTO>();
        if (ObjectUtils.isNotEmpty((Object)apisPfpRationMain) && ObjectUtils.isNotEmpty((Object)(apisPfpRationEngages = this.apisPfpRationEngageService.listByRationId(apisPfpRationMain.getId())))) {
            remarkDTOS = apisPfpRationEngages.stream().map(engage -> RemarkDTO.builder().remarkID(engage.getRationVersion()).remarkNameZhs(engage.getEngageDesc()).engageCode(engage.getEngageCode()).engageName(engage.getEngageName()).build()).collect(Collectors.toList());
        }
        return remarkDTOS;
    }

    private List<PremiumDTO> getPermiumDTOList(ApisPfpRationMain apisPfpRationMain) {
        List apisPfpRationClauseKindFactories;
        List<Object> premiumDTOList = new ArrayList<PremiumDTO>();
        if (ObjectUtils.isNotEmpty((Object)apisPfpRationMain) && ObjectUtils.isNotEmpty((Object)(apisPfpRationClauseKindFactories = this.apisPfpRationClauseKindFactoryService.getListByRationId(apisPfpRationMain.getId())))) {
            List types = this.apisPfsInsuredTypeService.list();
            premiumDTOList = apisPfpRationClauseKindFactories.stream().map(factory -> {
                PremiumDTO premiumDTO = PremiumDTO.builder().insuredType(factory.getGdInsuredType()).basicPrem(factory.getGdBasePremium()).startDay(factory.getGdStartDay()).endDay(factory.getGdEndDay()).socialSecurityFlag(factory.getGdIsInsuranceFlag()).gdPremiumConfig(factory.getGdPremiumConfig()).factorCode(factory.getFactorCode()).factorName(factory.getFactorName()).factorType(factory.getFactorType()).factorTextValue(factory.getFactorTextValue()).factorLimitsMin(factory.getFactorLimitsMin()).factorLimitsMax(factory.getFactorLimitsMax()).factorRateMin(factory.getFactorRateMin()).factorRateMax(factory.getFactorRateMax()).gdItemType(factory.getGdItemType()).gdSex(factory.getGdSex()).gdMinAmountRate(factory.getGdMinAmountRate()).gdMaxAmountRate(factory.getGdMaxAmountRate()).gdSku(factory.getGdSku()).gdMinAmount(factory.getGdMinAmount()).gdMaxAmount(factory.getGdMaxAmount()).gdTranSoprtType(factory.getGdTranSoprtType()).gdIsXiz(factory.getGdIsXiz()).gdSingleLimit(factory.getGdSingleLimit()).gdLjLimit(factory.getGdLjLimit()).gdIsInsuranceFlag(factory.getGdIsInsuranceFlag()).gdMinPopulation(factory.getGdMinPopulation()).gdMaxPopulation(factory.getGdMaxPopulation()).build();
                if (ObjectUtils.isNotEmpty((Object)factory.getGdInsuredType())) {
                    ApisPfsInsuredType queryApisPfsInsuredType = types.stream().filter(type -> type.getInsuredType().equals(factory.getGdInsuredType())).findFirst().orElse(new ApisPfsInsuredType());
                    premiumDTO.setInsuredTypeName(queryApisPfsInsuredType.getInsuredName());
                    premiumDTO.setAgeFrom(null != queryApisPfsInsuredType.getAgeFrom() ? queryApisPfsInsuredType.getAgeFrom() : DEFAULT_MIN_AGE);
                    premiumDTO.setAgeTo(queryApisPfsInsuredType.getAgeTo());
                }
                return premiumDTO;
            }).collect(Collectors.toList());
        }
        return premiumDTOList;
    }

    private List<BenefitDTO> getBenfitDTOs(ApisPfpRationMain apisPfpRationMain) {
        List apisPfpRationKinds;
        List<Object> benefitDTOS = new ArrayList<BenefitDTO>();
        if (ObjectUtils.isNotEmpty((Object)apisPfpRationMain) && ObjectUtils.isNotEmpty((Object)(apisPfpRationKinds = this.apisPfpRationKindService.getListByRationId(apisPfpRationMain.getId())))) {
            benefitDTOS = apisPfpRationKinds.stream().map(rationKind -> BenefitDTO.builder().benefitCode(rationKind.getKindCode()).benefitNameZhs(rationKind.getKindName()).benefitNameEn("").sumInsured(rationKind.getAmount()).calculateInd(rationKind.getCalculateInd()).clauseCode(rationKind.getClauseCode()).isOptional(rationKind.getIsOptional()).premium(rationKind.getPremium()).rate(rationKind.getRate()).sumRateFactorMin(rationKind.getSumRateFactorMin()).sumRateFactorMax(rationKind.getSumRateFactorMax()).build()).collect(Collectors.toList());
        }
        return benefitDTOS;
    }

    private PlanBasicInformationDTO getPlanBasicInformationDTO(ApisPfpRationMain apisPfpRationMain) {
        PlanBasicInformationDTO planBasicInformationDTO = new PlanBasicInformationDTO();
        if (ObjectUtils.isNotEmpty((Object)apisPfpRationMain)) {
            ZoneId zone = ZoneId.systemDefault();
            List channelCodes = this.apisChannelCodeService.getListByCode("riskType", apisPfpRationMain.getProductCode());
            List riskTypes = channelCodes.stream().map(ApisChannelCode::getChannelValue).collect(Collectors.toList());
            String riskType = riskTypes.stream().filter(e -> Arrays.asList(EFFECTIVE_RISK_TYPES).contains(e)).findFirst().orElse("");
            String groupPlanName = this.apisPfpRationMainService.getGroupPlanName(apisPfpRationMain.getRationCode());
            String appliRelation = "";
            if (ObjectUtil.isNotEmpty((Object)apisPfpRationMain.getAppliRelation())) {
                String[] relation = apisPfpRationMain.getAppliRelation().split(SPLIT_STR);
                appliRelation = Arrays.stream(relation).map(re -> ObjectUtil.isNotEmpty(BusinessConstants.RELATION.get(re)) ? (String)BusinessConstants.RELATION.get(re) : "").collect(Collectors.joining(SPLIT_STR));
            }
            String premCalMethod = "";
            List clauseKindFactories = this.apisPfpRationClauseKindFactoryService.getListByRationId(apisPfpRationMain.getId());
            if (ObjectUtils.isNotEmpty((Object)clauseKindFactories) && clauseKindFactories.stream().findFirst().isPresent()) {
                premCalMethod = ((ApisPfpRationClauseKindFactory)clauseKindFactories.stream().findFirst().get()).getGdPremiumConfig();
            }
            ApisPfpRationPfchealth apisPfpRationPfchealth = this.getApisPfpRationPfchealth(apisPfpRationMain.getId());
            planBasicInformationDTO = PlanBasicInformationDTO.builder().planCode(apisPfpRationMain.getRationCode()).planStatus(apisPfpRationMain.getValidStatus()).effectiveDate(ObjectUtils.isEmpty((Object)apisPfpRationMain.getValidDate()) ? null : Date.from(apisPfpRationMain.getValidDate().atZone(zone).toInstant())).expireDate(ObjectUtils.isEmpty((Object)apisPfpRationMain.getInvalidDate()) ? null : Date.from(apisPfpRationMain.getInvalidDate().atZone(zone).toInstant())).planNameZhs(apisPfpRationMain.getRationName()).planNameEn(apisPfpRationMain.getRationEname()).typeOfPlan(riskType).planVersion(apisPfpRationMain.getRationVersion().toString()).groupPlanName(groupPlanName).minAge(StringUtils.isNotBlank((CharSequence)apisPfpRationMain.getAgeMin()) ? Integer.valueOf(apisPfpRationMain.getAgeMin()) : null).maxAge(StringUtils.isNotBlank((CharSequence)apisPfpRationMain.getAgeMax()) ? Integer.valueOf(apisPfpRationMain.getAgeMax()) : null).insuredAndPolicyholderRelation(appliRelation).occupationClass(apisPfpRationMain.getInsuredOccupation()).planType(apisPfpRationMain.getCustomerType().toString()).currency("RMB").deductible("").destination(apisPfpRationMain.getIssueArea()).premCalMethod(premCalMethod).questionnaireCode(apisPfpRationPfchealth.getHealthCode()).questionnaireNameZhs(apisPfpRationPfchealth.getHealthName()).questionnaireNameEn(apisPfpRationPfchealth.getHealthEname()).validRule(apisPfpRationMain.getValidRule()).isSupportRenew(apisPfpRationMain.getIsSupportRenew()).isAutoRenew(apisPfpRationMain.getIsAutoRenew()).renewableMaxAge(apisPfpRationMain.getRenewableMaxAge()).paymentType(apisPfpRationMain.getPaymentType()).gracepperiod(apisPfpRationMain.getGracepperiod()).customerType(apisPfpRationMain.getCustomerType()).isGiftRisk(apisPfpRationMain.getIsGiftRisk()).rationRateType(apisPfpRationMain.getRationRateType()).rationType(apisPfpRationMain.getRationType()).datumType(apisPfpRationMain.getDatumType()).issueArea(apisPfpRationMain.getIssueArea()).innerRation(apisPfpRationMain.getInnerRation()).innerBeforeRenewalDays(apisPfpRationMain.getInnerBeforeRenewalDays()).innerAfterRenewalDays(apisPfpRationMain.getInnerAfterRenewalDays()).outwithRation(apisPfpRationMain.getOutwithRation()).outwithBeforeRenewalDays(apisPfpRationMain.getOutwithBeforeRenewalDays()).outwithAfterRenewalDays(apisPfpRationMain.getOutwithAfterRenewalDays()).build();
        }
        return planBasicInformationDTO;
    }

    private ApisPfpRationPfchealth getApisPfpRationPfchealth(Long rationId) {
        ApisPfpRationPfchealth health;
        ApisPfpRationHealth apisPfpRationHealth = this.apisPfpRationHealthService.getApisPfpRationHealthByRationId(rationId);
        ApisPfpRationPfchealth apisPfpRationPfchealth = new ApisPfpRationPfchealth();
        if (ObjectUtils.isNotEmpty((Object)apisPfpRationHealth) && ObjectUtils.isNotEmpty((Object)(health = this.apisPfpRationPfchealthService.getApisPfpRationPfchealthByRationHealthId(apisPfpRationHealth.getId())))) {
            apisPfpRationPfchealth = health;
        }
        return apisPfpRationPfchealth;
    }
}

