/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl.StanderCalculateHandler;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CalculateObjectDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.planQuotation.PlanQuotationQueryRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.planQuotation.PlanQuotationQueryServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CalculateResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredPremiumDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.planQuotation.PlanQuoatationResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.planQuotation.PlanQuoatationResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfpRationClauseKindFactoryMapper;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderPlanQuotationHandler
implements BusinessHandler {
    private static Logger log = LoggerFactory.getLogger(StanderCalculateHandler.class);
    @Autowired
    private CoreInsureApi coreInsureApi;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    ApisPfpRationClauseKindFactoryMapper apisPfpRationClauseKindFactoryMapper;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        String uuid = UUID.fastUUID().toString().replaceAll("-", "");
        String businessKey = request.getHeader().getBusinessKey();
        request.getHeader().setBusinessKey(ObjectUtil.isNotEmpty((Object)businessKey) ? businessKey : uuid);
        request.getPlanQuotationQueryServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        HashMap resultMap = new HashMap();
        String[] planQuotationArray = new String[]{"PlanCode", "StartDate", "EndDate"};
        Object[] planQuotationEnumArray = new Object[]{ErrorNullValueCodeEnum.ERR_N30013, ErrorNullValueCodeEnum.ERR_N30003, ErrorNullValueCodeEnum.ERR_N30004};
        PlanQuotationQueryRequestDTO requestBody = request.getPlanQuotationQueryServiceRequest().getRequestBody();
        this.dataCompletionUtil.checkNotNull((Object)requestBody, planQuotationArray, planQuotationEnumArray, resultMap);
        if (resultMap.size() > 0) {
            ErrorNullValueCodeEnum errorNullValueCodeEnum = (ErrorNullValueCodeEnum)DataCompletionUtil.castToClass(ErrorNullValueCodeEnum.class, resultMap.get(1));
            log.error("\n\u8ba1\u5212\u67e5\u8be2\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a\uff1a{}", (Object)errorNullValueCodeEnum.getValue());
            throw ApisDataCompletionException.builder().errorCode(errorNullValueCodeEnum.getKey()).message(errorNullValueCodeEnum.getValue()).build();
        }
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        this.dataCompletionUtil.accreditPlan(request);
        List calList = this.assemblyParametersByRequest(request);
        return this.coreInsureApi.policyCalculate(calList);
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) {
        this.assemblyParametersByResponse(request, response);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CalculateObjectDTO> assemblyParametersByRequest(StanderRequest request) throws ApisDataCompletionException {
        PlanQuotationQueryRequestDTO planQuotation;
        ArrayList<CalculateObjectDTO> calList;
        String methodType;
        block11: {
            methodType = null;
            calList = new ArrayList<CalculateObjectDTO>();
            planQuotation = request.getPlanQuotationQueryServiceRequest().getRequestBody();
            try {
                methodType = this.apisPfpRationClauseKindFactoryMapper.verifyCalculateMethod(planQuotation.getPlanCode());
            }
            catch (Exception e) {
                log.error("\n\u7cfb\u7edf\u5185\u90e8\u9519\u8bef", (Throwable)e);
            }
            finally {
                if (StringUtils.isNotBlank((CharSequence)methodType)) break block11;
                log.error("\n>>>\u4fdd\u8d39\u8ba1\u7b97\u65b9\u5f0f\u914d\u7f6e\u6709\u8bef \u4fdd\u8d39\u8ba1\u7b97\u65b9\u5f0f\uff1a{}", (Object)planQuotation.getPlanCode());
                throw ApisDataCompletionException.builder().errorCode(ErrorNullValueCodeEnum.ERR_N30001.getKey()).message(ErrorNullValueCodeEnum.ERR_N30001.getValue()).build();
            }
        }
        String effectiveDate = DateUtil.format((Date)planQuotation.getStartDate(), (String)"yyyy-MM-dd");
        String expireDate = DateUtil.format((Date)planQuotation.getEndDate(), (String)"yyyy-MM-dd");
        int days = Integer.parseInt(String.valueOf(DateUtil.between((Date)DateUtil.parse((CharSequence)effectiveDate), (Date)DateUtil.parse((CharSequence)expireDate), (DateUnit)DateUnit.DAY)));
        boolean dateFlag = DataCompletionUtil.judgeUwDate((Date)planQuotation.getStartDate(), (Date)planQuotation.getEndDate());
        if (!dateFlag) {
            ++days;
        }
        String[] insuredTypeArray = new String[]{"2", "1", "3"};
        for (int i = 0; i < insuredTypeArray.length; ++i) {
            CalculateObjectDTO calculateObjectDTO = CalculateObjectDTO.builder().build();
            calculateObjectDTO.setConsumerSeqNo(request.getPlanQuotationQueryServiceRequest().getRequestHead().getConsumerSeqNo());
            calculateObjectDTO.setPlanCode(planQuotation.getPlanCode());
            calculateObjectDTO.setCalMethod(methodType);
            calculateObjectDTO.setInsuredType(insuredTypeArray[i]);
            if (methodType.equals("1") || methodType.equals("11") || methodType.equals("12")) {
                calculateObjectDTO.setDay(Integer.valueOf(days));
            }
            if (methodType.equals("5") || methodType.equals("2")) {
                boolean flag = DataCompletionUtil.judgeDate((Date)planQuotation.getStartDate(), (Date)planQuotation.getEndDate());
                calculateObjectDTO.setYearDays((flag ? new Integer("366") : new Integer("365")).intValue());
                calculateObjectDTO.setUwDays(Integer.valueOf(days));
            }
            if (methodType.equals("3")) {
                int months = DataCompletionUtil.calculateMonths((int)days);
                calculateObjectDTO.setMonth(Integer.valueOf(months));
            }
            if (methodType.equals("11") || methodType.equals("12")) {
                calculateObjectDTO.setPhdTotal(Integer.valueOf(1));
            }
            calList.add(calculateObjectDTO);
        }
        return calList;
    }

    public void assemblyParametersByResponse(StanderRequest request, StanderResponse response) {
        BeanUtils.copyProperties((Object)request.getHeader(), (Object)response.getHeader());
        CalculateResponse calculateResponse = response.getCalculateResponse();
        PlanQuotationQueryServiceRequest planQuotationQueryServiceRequest = request.getPlanQuotationQueryServiceRequest();
        PlanQuoatationResponse planQuoatationResponse = PlanQuoatationResponse.builder().build();
        ResponseHeadDTO responseHead = ResponseHeadDTO.builder().build();
        BeanUtils.copyProperties((Object)calculateResponse.getResponseHead(), (Object)responseHead);
        planQuoatationResponse.setResponseHead(responseHead);
        PlanQuoatationResponseDTO planQuoatationResponseDTO = PlanQuoatationResponseDTO.builder().build();
        planQuoatationResponseDTO.setPlanCode(planQuotationQueryServiceRequest.getRequestBody().getPlanCode());
        List list = calculateResponse.getResponseBody().getInsuredPremiumList();
        InsuredPremiumDTO insuredPremiumDTO = null;
        String insuredType = null;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                insuredPremiumDTO = (InsuredPremiumDTO)list.get(i);
                insuredType = insuredPremiumDTO.getInsuredType();
                if ("2".equals(insuredType)) {
                    planQuoatationResponseDTO.setChdPrem(new BigDecimal(insuredPremiumDTO.getPremium().toString()));
                    continue;
                }
                if ("1".equals(insuredType)) {
                    planQuoatationResponseDTO.setAduPrem(new BigDecimal(insuredPremiumDTO.getPremium().toString()));
                    continue;
                }
                planQuoatationResponseDTO.setEldPrem(new BigDecimal(insuredPremiumDTO.getPremium().toString()));
            }
        }
        planQuoatationResponse.setPlanQuoatationResponseDTO(planQuoatationResponseDTO);
        response.setPlanQuoatationResponse(planQuoatationResponse);
        response.setCalculateResponse(null);
    }
}

