/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl.StanderPolicyDetailHandler;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.policyActivate.PolicyActivateRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelInstallmentOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiChannelOrderMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiReqmsgLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelInstallmentOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.GeneralRegxs;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import sinosoftgz.utils.data.DateUtils;

public class StanderPolicyActivateHandler
implements BusinessHandler {
    private static Logger log = LoggerFactory.getLogger(StanderPolicyActivateHandler.class);
    private static String POLICY_QUERY_RANGE = "policy_query_range";
    private static String BACK_SIGN = "backSign";
    private static String JFEE_FLAG = "channel_jfeeFlag";
    private static String[] EXCETPTION_POLICY_STATUS = new String[]{"00", "01", "02", "03"};
    private static String WORKED_POLICY_STATUS = "04";
    private static String WAITING_POLICY_STATUS = "05";
    private static String JFEE_FLAG_1 = "1";
    private static String JFEE_PROCESS_SORT_1 = "1";
    private static String BUSINESS_SOURCE = "BUSINESS_SOURCE";
    private static String POLICYACTIVATE_RESPONSE = "policyActivateResponse";
    @Autowired
    private CoreInsureApi coreInsureApi;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    StanderPolicyDetailHandler standerPolicyDetailHandler;
    @Autowired
    ApisBusiChannelOrderMapper apisBusiChannelOrderMapper;
    @Autowired
    ApisBusinessService apisBusinessService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisBusiReqmsgLogMapper apisBusiReqmsgLogMapper;
    @Autowired
    ApisBusiChannelInstallmentOrderService apisBusiChannelInstallmentOrderService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        Date startTime;
        ApisChannelConfigs channelConfig;
        ApisChannelConfigs apisChannelConfigs;
        String userCode;
        BigDecimal vaildPremium;
        ApisBusiChannelOrder order;
        HashMap resultMap = new HashMap();
        String[] refundCalculateArray = new String[]{"BusinessNo"};
        Object[] refundCalculateEnumArray = new Object[]{ErrorNullValueCodeEnum.ERR_N90003};
        PolicyActivateRequestDTO requestBody = request.getPolicyActivateServiceRequest().getRequestBody();
        this.dataCompletionUtil.checkNotNull((Object)requestBody, refundCalculateArray, refundCalculateEnumArray, resultMap);
        if (resultMap.size() > 0) {
            ErrorNullValueCodeEnum errorNullValueCodeEnum = (ErrorNullValueCodeEnum)DataCompletionUtil.castToClass(ErrorNullValueCodeEnum.class, resultMap.get(1));
            log.error("\n\u4fdd\u5355\u6fc0\u6d3b\u63a5\u53e3\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a\uff1a{}", (Object)errorNullValueCodeEnum.getValue());
            throw ApisDataCompletionException.builder().errorCode(errorNullValueCodeEnum.getKey()).message(errorNullValueCodeEnum.getValue()).build();
        }
        Date payTime = request.getPolicyActivateServiceRequest().getRequestBody().getPayTime();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"policy_no", (Object)requestBody.getBusinessNo());
        try {
            order = (ApisBusiChannelOrder)this.apisBusiChannelOrderMapper.selectOne((Wrapper)queryWrapper);
        }
        catch (Exception e) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
        if (ObjectUtil.isEmpty((Object)order)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10162.getValue(), ChannelErrorCodeEnum.ERR_C10162.getKey());
        }
        if (StringUtils.isNotEmpty((CharSequence)requestBody.getPaymentMethod()) && "1".equals(order.getPayType())) {
            String paymentMethod = this.dataCompletionUtil.convertCode("paymentMethod_1", requestBody.getPaymentMethod());
            if (StringUtils.isEmpty((CharSequence)paymentMethod)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10117.getValue(), ChannelErrorCodeEnum.ERR_C10117.getKey());
            }
            if (paymentMethod.equals("JDPayTrade") && StringUtils.isEmpty((CharSequence)requestBody.getPayApplyNo())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10671.getValue(), ChannelErrorCodeEnum.ERR_C10671.getKey());
            }
        }
        String userCode2 = request.getHeader().getUserCode();
        ApisChannelConfigs apisChannelConfigs2 = new ApisChannelConfigs();
        apisChannelConfigs2.setUserCode(userCode2);
        apisChannelConfigs2.setConfigCode(POLICY_QUERY_RANGE);
        ApisChannelConfigs channelConfig2 = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs2);
        if (channelConfig2 == null && !request.getHeader().getUserCode().equals(order.getCreator())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10156.getValue(), ChannelErrorCodeEnum.ERR_C10156.getKey());
        }
        ApisBusiChannelInstallmentOrder validatorInstallmentOrder = new ApisBusiChannelInstallmentOrder();
        validatorInstallmentOrder.setPolicyNo(requestBody.getBusinessNo());
        validatorInstallmentOrder.setCurrentPayNo(Integer.valueOf(1));
        QueryWrapper qw = new QueryWrapper((Object)validatorInstallmentOrder);
        ApisBusiChannelInstallmentOrder busiValidtorChannelInstallmentOrder = (ApisBusiChannelInstallmentOrder)this.apisBusiChannelInstallmentOrderService.getOne((Wrapper)qw);
        BigDecimal bigDecimal = vaildPremium = ObjectUtil.isNotEmpty((Object)busiValidtorChannelInstallmentOrder) && ObjectUtil.isNotEmpty((Object)busiValidtorChannelInstallmentOrder.getCurrentPremium()) ? busiValidtorChannelInstallmentOrder.getCurrentPremium() : order.getPremium();
        if ("0".equals(order.getPayType())) {
            if (requestBody.getPremium().compareTo(vaildPremium) != 0 && requestBody.getPremium().compareTo(order.getPremium()) != 0) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10101.getValue(), ChannelErrorCodeEnum.ERR_C10101.getKey());
            }
        } else if (requestBody.getPremium().compareTo(vaildPremium) != 0) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10101.getValue(), ChannelErrorCodeEnum.ERR_C10101.getKey());
        }
        if (BigDecimal.ZERO.compareTo(requestBody.getPremium()) >= 0) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10161.getValue(), ChannelErrorCodeEnum.ERR_C10161.getKey());
        }
        if (!DateUtils.dateToStr((Date)payTime, (String)"yyyyMMddHHmmss").matches(GeneralRegxs.DateFormat)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10009.getValue().replaceFirst("##", "payTime").replace("##", "yyyyMMddHHmmss"), ChannelErrorCodeEnum.ERR_C10009.getKey());
        }
        String policyStatus = order.getStatus();
        if (StrUtil.isEmpty((CharSequence)policyStatus) || Arrays.asList(EXCETPTION_POLICY_STATUS).contains(policyStatus)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10164.getValue(), ChannelErrorCodeEnum.ERR_C10164.getKey());
        }
        String jfeeFlag = order.getPayType();
        log.warn("{}\u4fdd\u5355\u751f\u6548\u7684\u662f\u5426\u89c1\u8d39\u6807\u8bc6\uff1a{}", (Object)order.getPolicyNo(), (Object)order.getPayType());
        if (StrUtil.isEmpty((CharSequence)jfeeFlag)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10162.getValue(), ChannelErrorCodeEnum.ERR_C10162.getKey());
        }
        if (JFEE_FLAG_1.equals(jfeeFlag) && WAITING_POLICY_STATUS.equals(policyStatus)) {
            userCode = request.getHeader().getUserCode();
            apisChannelConfigs = new ApisChannelConfigs();
            apisChannelConfigs.setUserCode(userCode);
            apisChannelConfigs.setConfigCode(BUSINESS_SOURCE);
            channelConfig = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
            if (ObjectUtil.isNotEmpty((Object)channelConfig) && JFEE_PROCESS_SORT_1.equals(channelConfig.getConfigValue())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10701.getValue(), ChannelErrorCodeEnum.ERR_C10701.getKey());
            }
        }
        if (WORKED_POLICY_STATUS.equals(policyStatus)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10157.getValue(), ChannelErrorCodeEnum.ERR_C10157.getKey());
        }
        userCode = request.getHeader().getUserCode();
        apisChannelConfigs = new ApisChannelConfigs();
        apisChannelConfigs.setUserCode(userCode);
        apisChannelConfigs.setConfigCode(BACK_SIGN);
        channelConfig = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
        if (BeanUtil.isEmpty((Object)channelConfig, (String[])new String[0]) && payTime.after(startTime = Date.from(order.getStartDate().atZone(ZoneId.systemDefault()).toInstant()))) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10159.getValue(), ChannelErrorCodeEnum.ERR_C10159.getKey());
        }
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        StanderResponse resp = null;
        try {
            resp = this.coreInsureApi.policyActivate(request);
            BaseApisParamUtil.verificationResponse((StanderResponse)resp, (String)POLICYACTIVATE_RESPONSE);
        }
        catch (ApisBusinessException e) {
            throw new ApisBusinessException(e.getMessage(), e.getErrorCode());
        }
        return resp;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        String businessNo = response.getPolicyActivateResponse().getResponseBody().getBusinessNo();
        UpdateWrapper orderUpdateWrapper = new UpdateWrapper();
        orderUpdateWrapper.eq((Object)"policy_no", (Object)businessNo);
        ApisBusiChannelOrder updateEntity = new ApisBusiChannelOrder();
        updateEntity.setStatus(WORKED_POLICY_STATUS);
        DateTime dateTime = DateUtil.date((Date)request.getPolicyActivateServiceRequest().getRequestBody().getPayTime());
        LocalDateTime localDateTime = dateTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        updateEntity.setPayTime(localDateTime);
        updateEntity.setPolicyTime(localDateTime);
        this.apisBusiChannelOrderMapper.update((Object)updateEntity, (Wrapper)orderUpdateWrapper);
        this.apisBusiReqmsgLogMapper.deleteApisBusiReqmsgLog(businessNo, "1");
        ApisBusiChannelInstallmentOrder validatorInstallmentOrder = new ApisBusiChannelInstallmentOrder();
        validatorInstallmentOrder.setPolicyNo(businessNo);
        validatorInstallmentOrder.setCurrentPayNo(Integer.valueOf(1));
        QueryWrapper qw = new QueryWrapper((Object)validatorInstallmentOrder);
        ApisBusiChannelInstallmentOrder busiValidtorChannelInstallmentOrder = (ApisBusiChannelInstallmentOrder)this.apisBusiChannelInstallmentOrderService.getOne((Wrapper)qw);
        if (ObjectUtil.isNotEmpty((Object)busiValidtorChannelInstallmentOrder)) {
            ApisBusiChannelOrder order = this.apisBusiChannelOrderMapper.findOneByPolicyNo(businessNo);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"deleted", (Object)ApisChannelConfigs.DELETE_FLAG_FALSE);
            queryWrapper.eq((Object)"user_code", (Object)order.getCreator());
            queryWrapper.eq((Object)"config_code", (Object)"channel_jfeeFlag");
            List list = this.apisChannelConfigsService.list((Wrapper)queryWrapper);
            if ("1".equals(order.getPayType()) && ObjectUtil.isNotEmpty((Object)list) && list.size() > 0) {
                busiValidtorChannelInstallmentOrder.setOrderNo(request.getPolicyActivateServiceRequest().getRequestBody().getPlatformSerialNumber());
                LocalDateTime localFirstPt = dateTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                busiValidtorChannelInstallmentOrder.setPayTime(localFirstPt);
                this.apisBusiChannelInstallmentOrderService.updateById((Object)busiValidtorChannelInstallmentOrder);
            }
        }
        return response;
    }
}

