/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorseQueryRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorseQueryServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemKindDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PolicyRefundQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PolicyRefundQueryRequestBodyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PremiumPayStatusQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PremiumPayStatusQueryRequestBodyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PremiumPayStatusQueryRequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDetailResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.payment.RefundQueryResponseVo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.payment.ResponseVo;
import com.jdaz.sinosoftgz.apis.commons.model.api.saleManage.request.DockRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.saleManage.request.body.DockRequestBody;
import com.jdaz.sinosoftgz.apis.commons.model.api.saleManage.request.head.RequestHead;
import com.jdaz.sinosoftgz.apis.commons.model.api.saleManage.response.ChannelDetailResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelCodeMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelConfigsMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelUserService;
import com.jdaz.sinosoftgz.apis.commons.service.constants.CommonConstant;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.impl.ApisBusiRenewalServiceImpl;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.impl.ApisPfpKindClaimExchangeServiceImpl;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.impl.ApisPfpProductMainServiceImpl;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorCode;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreCorrectApi;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StanderPolicyDetailHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderPolicyDetailHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    private ApisChannelCodeMapper apisChannelCodeMapper;
    private static final String IS_POLICYSTATUS_FALG = "Y";
    @Autowired
    ApisPfpProductMainServiceImpl apisPfpProductMainServiceImpl;
    @Autowired
    ApisPfpKindClaimExchangeServiceImpl apisPfpKindClaimExchangeServiceImpl;
    @Autowired
    ApisBusiRenewalServiceImpl apisBusiRenewalService;
    @Autowired
    CoreCorrectApi coreCorrectApi;
    @Autowired
    private ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    private ApisChannelUserService apisChannelUserService;
    @Autowired
    private ApisChannelConfigsMapper apisChannelConfigsMapper;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        if (request == null || request.getPolicyDetailServiceRequest() == null) {
            throw new ApisDataCompletionException(ErrorNullValueCodeEnum.ERR_N00001.getValue(), ErrorNullValueCodeEnum.ERR_N00001.getKey());
        }
        String userCode = request.getHeader().getUserCode();
        if (StringUtils.isEmpty((CharSequence)userCode)) {
            throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10145.getKey()).message(ChannelErrorCodeEnum.ERR_C10145.getValue()).build();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"config_code", (Object)"policy_query_range");
        queryWrapper.eq((Object)"deleted", (Object)CommonConstant.DeletedFlag.DELETED_NO);
        List userAccountList = this.apisChannelConfigsService.list((Wrapper)queryWrapper);
        HashSet<String> userCodeList = new HashSet<String>();
        for (ApisChannelConfigs userAccount : userAccountList) {
            if (userAccount.getUserCode() == null) continue;
            userCodeList.add(userAccount.getUserCode());
        }
        String operateCode = request.getPolicyDetailServiceRequest().getRequestBody().getOperateCode();
        if (userCodeList.contains(operateCode)) {
            request.getPolicyDetailServiceRequest().getRequestBody().setOperateCode("all");
            request.getPolicyDetailServiceRequest().getRequestBody().setBusinessNature2("all");
        } else {
            ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
            apisChannelConfigs.setUserCode(userCode);
            apisChannelConfigs.setConfigCode("policy_query_range");
            ApisChannelConfigs channelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
            if (channelConfigs != null) {
                request.getPolicyDetailServiceRequest().getRequestBody().setOperateCode("all");
                request.getPolicyDetailServiceRequest().getRequestBody().setBusinessNature2("all");
            } else {
                String[] userArr = userCode.split("_");
                if (userArr.length > 1 && "00".equals(userArr[1])) {
                    userCode = "all";
                }
                request.getPolicyDetailServiceRequest().getRequestBody().setOperateCode(userCode);
                ApisChannelUser apisChannelUser = new ApisChannelUser();
                apisChannelUser.setUserCode(request.getHeader().getUserCode());
                QueryWrapper apisChannelUserWrapper = new QueryWrapper((Object)apisChannelUser);
                List channelUserList = this.apisChannelUserService.list((Wrapper)apisChannelUserWrapper);
                if (ObjectUtils.isNotEmpty((Object)channelUserList) && channelUserList.size() > 0) {
                    request.getPolicyDetailServiceRequest().getRequestBody().setBusinessNature2(((ApisChannelUser)channelUserList.get(0)).getChannelCode());
                    request.getHeader().setChannelCode(((ApisChannelUser)channelUserList.get(0)).getChannelCode());
                } else {
                    throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10174.getKey()).message(ChannelErrorCodeEnum.ERR_C10174.getValue()).build();
                }
            }
        }
        request.getPolicyDetailServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        this.requestCheck(request);
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        ApisBusiChannelOrder apisBusinessChannelOrder;
        QueryWrapper queryWrapper;
        this.requestCheck(request);
        StanderResponse standerResponse = null;
        boolean isQueryDetail = true;
        if (ObjectUtil.isNotEmpty((Object)request.getHeader()) && "kuayuePolicyDetail".equals(request.getHeader().getBussinessType())) {
            if (StrUtil.isNotBlank((CharSequence)request.getPolicyDetailServiceRequest().getRequestBody().getKuayueApplyNo())) {
                ApisBusiChannelOrder apisBusiChannelOrderQuery = new ApisBusiChannelOrder();
                apisBusiChannelOrderQuery.setProposalNo(request.getPolicyDetailServiceRequest().getRequestBody().getKuayueApplyNo());
                apisBusiChannelOrderQuery.setAgentCode(request.getHeader().getChannelCode());
                queryWrapper = new QueryWrapper((Object)apisBusiChannelOrderQuery);
                apisBusinessChannelOrder = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
                if (null != apisBusinessChannelOrder && StrUtil.isNotBlank((CharSequence)apisBusinessChannelOrder.getPolicyNo())) {
                    request.getPolicyDetailServiceRequest().getRequestBody().setPolicyNo(apisBusinessChannelOrder.getPolicyNo());
                } else {
                    isQueryDetail = false;
                }
            } else {
                isQueryDetail = false;
            }
        }
        if (isQueryDetail) {
            if (StringUtils.isNotEmpty((CharSequence)request.getPolicyDetailServiceRequest().getRequestBody().getIsStatusQueryFlag()) && request.getPolicyDetailServiceRequest().getRequestBody().getIsStatusQueryFlag().equals(IS_POLICYSTATUS_FALG)) {
                standerResponse = this.coreInsureApi.policyDetail(request);
                if (standerResponse.getPolicyDetailResponse().getResponseHead().getStatus() == 0 && ObjectUtils.isEmpty((Object)standerResponse.getPolicyDetailResponse().getResponseBody())) {
                    ApisBusiChannelOrder apisBusinessChannelOrderExample = new ApisBusiChannelOrder();
                    apisBusinessChannelOrderExample.setPolicyNo(request.getPolicyDetailServiceRequest().getRequestBody().getPolicyNo());
                    apisBusinessChannelOrderExample.setAgentCode(request.getHeader().getChannelCode());
                    queryWrapper = new QueryWrapper((Object)apisBusinessChannelOrderExample);
                    apisBusinessChannelOrder = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
                    if (apisBusinessChannelOrder != null && !"04".equals(apisBusinessChannelOrder.getStatus())) {
                        PolicyDetailResponseDTO responseDTO = PolicyDetailResponseDTO.builder().policy(PolicyDTO.builder().main(MainDTO.builder().build()).build()).build();
                        standerResponse.getPolicyDetailResponse().setResponseBody(responseDTO);
                        standerResponse.getPolicyDetailResponse().getResponseBody().getPolicy().getMain().setPolicyStatus("60");
                        standerResponse.getPolicyDetailResponse().getResponseBody().getPolicy().getMain().setPolicyNo(apisBusinessChannelOrder.getPolicyNo());
                        standerResponse.getPolicyDetailResponse().getResponseHead().setStatus(CommonConstant.FccbResponseCode.SUCCESS.intValue());
                    }
                }
            } else {
                long startTime = System.currentTimeMillis();
                standerResponse = this.coreInsureApi.policyDetail(request);
                this.log.warn("\u7eed\u4fdd\u67e5\u8be2\u4fdd\u5355\u8be6\u60c5\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
            }
        }
        return standerResponse;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        boolean isQueryDetail;
        boolean bl = isQueryDetail = ObjectUtil.isEmpty((Object)request.getHeader()) || !"kuayuePolicyDetail".equals(request.getHeader().getBussinessType()) || StrUtil.isNotBlank((CharSequence)request.getPolicyDetailServiceRequest().getRequestBody().getKuayueApplyNo());
        if (isQueryDetail) {
            if (response == null || response.getPolicyDetailResponse() == null) {
                throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00002.getKey(), ErrorNullValueCodeEnum.ERR_N00002.getValue());
            }
            if (response.getPolicyDetailResponse().getResponseBody() == null || response.getPolicyDetailResponse().getResponseHead() == null || response.getPolicyDetailResponse().getResponseHead().getStatus() == CommonConstant.FccbResponseCode.FAIL.intValue()) {
                ResponseHeadDTO responseHeadDTO = ResponseHeadDTO.builder().build();
                responseHeadDTO.setAppCode(ChannelErrorCodeEnum.ERR_C10014.getKey());
                responseHeadDTO.setAppMessage(ChannelErrorCodeEnum.ERR_C10014.getValue());
                response.getPolicyDetailResponse().setResponseHead(responseHeadDTO);
                return response;
            }
            response.getPolicyDetailResponse().getResponseHead().setAppCode(ChannelErrorCodeEnum.ERR_C10002.getKey());
            response.getPolicyDetailResponse().getResponseHead().setAppMessage(ChannelErrorCodeEnum.ERR_C10002.getValue());
        }
        if (ObjectUtil.isNotEmpty((Object)request.getHeader()) && "kuayuePolicyDetail".equals(request.getHeader().getBussinessType()) && ObjectUtil.isNotEmpty((Object)request.getPolicyDetailServiceRequest().getRequestBody().getKuayueApplyEndorseNo())) {
            response = this.kuayueEndorseProcess(request, response);
        } else if (ObjectUtils.isEmpty((Object)request.getPolicyDetailServiceRequest().getRequestBody().getIsStatusQueryFlag())) {
            PolicyDTO policyDTO = response.getPolicyDetailResponse().getResponseBody().getPolicy();
            this.completeOpusDate(policyDTO);
            this.completeDamageResultCodeAndDamageResultName(policyDTO);
            this.removeItemByPlanCode(policyDTO, request.getPolicyDetailServiceRequest().getRequestBody().getPlancode());
            if ("SSP_USER".equals(request.getHeader().getUserCode()) && "1".equals(this.getWeChatOffCode())) {
                this.paymentSettlement(policyDTO);
                this.refundStatus(policyDTO);
                this.ppDockRequest(policyDTO, request);
                this.endorseProcess(policyDTO, request, response.getPolicyDetailResponse().getResponseBody());
            }
            this.completePremiumCalType(policyDTO);
            if (ObjectUtil.isNotEmpty((Object)policyDTO.getMain().getStartDateStr())) {
                policyDTO.getMain().setStartDate((Date)DateUtil.parse((CharSequence)policyDTO.getMain().getStartDateStr(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (ObjectUtil.isNotEmpty((Object)policyDTO.getMain().getEndDateStr())) {
                policyDTO.getMain().setEndDate((Date)DateUtil.parse((CharSequence)policyDTO.getMain().getEndDateStr(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
        }
        return response;
    }

    public void makeDate(PolicyDTO policyDTO) {
        Date startDate = policyDTO.getMain().getStartDate();
        Integer startHour = policyDTO.getMain().getStartHour();
        Integer startMinute = policyDTO.getMain().getStartMinute();
        Integer startSecond = policyDTO.getMain().getStartSecond();
        Date endDate = policyDTO.getMain().getEndDate();
        Integer endHour = policyDTO.getMain().getEndHour();
        Integer endMinute = policyDTO.getMain().getEndMinute();
        Integer endSecond = policyDTO.getMain().getEndSecond();
        Calendar c = Calendar.getInstance();
        if (ObjectUtils.isNotEmpty((Object)startHour) && ObjectUtils.isNotEmpty((Object)startMinute) && ObjectUtils.isNotEmpty((Object)startSecond)) {
            c.setTime(startDate);
            c.add(11, startHour);
            c.add(13, startMinute);
            c.add(12, startSecond);
            policyDTO.getMain().setStartDate(c.getTime());
        }
        if (ObjectUtils.isNotEmpty((Object)endHour) && ObjectUtils.isNotEmpty((Object)endMinute) && ObjectUtils.isNotEmpty((Object)endSecond)) {
            c.setTime(endDate);
            c.add(11, endHour);
            c.add(13, endMinute);
            c.add(12, endSecond);
            policyDTO.getMain().setEndDate(c.getTime());
        }
    }

    private void completeDamageResultCodeAndDamageResultName(PolicyDTO policyDTO) {
        if (ObjectUtils.isNotEmpty((Object)policyDTO.getCoverage().getItemList()) && policyDTO.getCoverage().getItemList().size() > 0) {
            for (int j = 0; j < policyDTO.getCoverage().getItemList().size(); ++j) {
                List itemKindDTOList = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(j)).getItemKind();
                if (!ObjectUtils.isNotEmpty((Object)itemKindDTOList) || itemKindDTOList.size() <= 0) continue;
                for (int i = 0; i < itemKindDTOList.size(); ++i) {
                    String kindCode = ((ItemKindDTO)itemKindDTOList.get(i)).getKindCode();
                    if (!ObjectUtils.isNotEmpty((Object)kindCode)) continue;
                    String valueDesc = this.apisChannelCodeMapper.getValueDesc(null, "kind_damageType", kindCode);
                    if (StringUtils.isNotEmpty((CharSequence)valueDesc)) {
                        ((ItemKindDTO)((ItemMainDTO)policyDTO.getCoverage().getItemList().get(j)).getItemKind().get(i)).setDamageResultName(valueDesc);
                    }
                    ArrayList<String> kindCodeList = new ArrayList<String>();
                    kindCodeList.add(kindCode);
                    List value = this.apisChannelCodeMapper.getChannelValueDescByList("kind_damageType", kindCodeList);
                    if (!ObjectUtil.isNotEmpty((Object)value) || value.size() <= 0) continue;
                    ((ItemKindDTO)((ItemMainDTO)policyDTO.getCoverage().getItemList().get(j)).getItemKind().get(i)).setDamageResultCode((String)value.get(0));
                }
            }
        }
    }

    private void completeOpusDate(PolicyDTO policyDTO) {
        policyDTO.getMain().setOpusDate(policyDTO.getMain().getUnderWriteEndDate());
    }

    private void completePremiumCalType(PolicyDTO policyDTO) {
        if (StringUtils.isEmpty((CharSequence)policyDTO.getMain().getPremiumCalType()) && StringUtils.isNotEmpty((CharSequence)policyDTO.getMain().getIsSupportFamily()) && policyDTO.getMain().getIsSupportFamily().equals(IS_POLICYSTATUS_FALG)) {
            policyDTO.getMain().setPremiumCalType("3");
        } else {
            policyDTO.getMain().setPremiumCalType("1");
        }
    }

    private void removeItemByPlanCode(PolicyDTO policyDTO, String planCode) {
        if (ObjectUtil.isEmpty((Object)policyDTO) || StringUtils.isEmpty((CharSequence)planCode)) {
            return;
        }
        if (policyDTO.getCoverage() == null || policyDTO.getCoverage().getItemList() == null) {
            return;
        }
        List itemList = policyDTO.getCoverage().getItemList();
        itemList.removeIf(itemMainDTO -> !planCode.equalsIgnoreCase(itemMainDTO.getGoodsCode()));
    }

    private void removeItemByInsuredNameOrIdentifyNumber(PolicyDTO policyDTO, String insuredName, String identifyNumber) {
        if (ObjectUtil.isEmpty((Object)policyDTO)) {
            return;
        }
        if (policyDTO.getCoverage() == null || policyDTO.getCoverage().getItemList() == null) {
            return;
        }
        List itemList = policyDTO.getCoverage().getItemList();
        if (ObjectUtils.isNotEmpty((Object)itemList) && itemList.size() > 0) {
            List insuredIdvList;
            int i;
            if (StringUtils.isNotEmpty((CharSequence)insuredName)) {
                for (i = 0; i < itemList.size(); ++i) {
                    insuredIdvList = ((ItemMainDTO)itemList.get(i)).getInsuredIdvList();
                    if (!ObjectUtils.isNotEmpty((Object)insuredIdvList) || insuredIdvList.size() <= 0) continue;
                    ((ItemMainDTO)itemList.get(i)).getInsuredIdvList().removeIf(insuredIdvDTO -> !insuredName.equals(insuredIdvDTO.getInsuredName()));
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)identifyNumber)) {
                for (i = 0; i < itemList.size(); ++i) {
                    insuredIdvList = ((ItemMainDTO)itemList.get(i)).getInsuredIdvList();
                    if (!ObjectUtils.isNotEmpty((Object)insuredIdvList) || insuredIdvList.size() <= 0) continue;
                    ((ItemMainDTO)itemList.get(i)).getInsuredIdvList().removeIf(insuredIdvDTO -> !identifyNumber.equals(insuredIdvDTO.getIdentifyNumber()));
                }
            }
        }
    }

    private void requestCheck(StanderRequest request) throws ApisBusinessException {
        PolicyDetailRequestDTO policyDetailRequestDTO = request.getPolicyDetailServiceRequest().getRequestBody();
        HashMap<String, String> stringStringHashMap = new HashMap<String, String>(16);
        if (ObjectUtil.isEmpty((Object)request.getHeader()) || !"kuayuePolicyDetail".equals(request.getHeader().getBussinessType())) {
            stringStringHashMap.put("policyNo", "\u4fdd\u9669\u5355\u53f7");
        }
        stringStringHashMap.put("businessNature2", "\u9500\u552e\u6e20\u9053");
        stringStringHashMap.put("operateCode", "\u64cd\u4f5c\u5458");
        BaseApisParamUtil.checkFieldThrowExp((Object)policyDetailRequestDTO, stringStringHashMap, (ErrorCode)ErrorNullValueCodeEnum.ERR_N51000);
    }

    private void paymentSettlement(PolicyDTO policyDTO) {
        PremiumPayStatusQueryRequest premiumPayStatusQueryRequest = PremiumPayStatusQueryRequest.builder().build();
        premiumPayStatusQueryRequest.setRequestHead(PremiumPayStatusQueryRequestHeadDTO.initHeadDTO());
        PremiumPayStatusQueryRequestBodyDTO bodyDTO = PremiumPayStatusQueryRequestBodyDTO.builder().build();
        bodyDTO.setPolicyNo(policyDTO.getMain().getPolicyNo());
        premiumPayStatusQueryRequest.setPremiumPayStatusQueryBody(bodyDTO);
        try {
            ResponseVo responseVo = this.coreInsureApi.premiumPayStatusQuery(premiumPayStatusQueryRequest);
            if (ObjectUtil.isNotEmpty((Object)responseVo) && responseVo.getStatus() == 0) {
                policyDTO.getMain().setSettlementFlag(responseVo.getData());
            }
        }
        catch (Exception e) {
            this.log.error("\u4fdd\u5355{},\u8c03\u7528\u6536\u4ed8\u662f\u5426\u5b9e\u6536\u62a5\u9519\uff1a", (Object)policyDTO.getMain().getPolicyNo(), (Object)e);
        }
    }

    private void refundStatus(PolicyDTO policyDTO) {
        PolicyRefundQueryRequest policyRefundQueryRequest = new PolicyRefundQueryRequest();
        policyRefundQueryRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        PolicyRefundQueryRequestBodyDTO bodyDTO = PolicyRefundQueryRequestBodyDTO.builder().build();
        bodyDTO.setPolicyNo(policyDTO.getMain().getPolicyNo());
        policyRefundQueryRequest.setPolicyRefundQueryBody(bodyDTO);
        try {
            RefundQueryResponseVo responseVo = this.coreInsureApi.policyRefundQuery(policyRefundQueryRequest);
            if (ObjectUtil.isNotEmpty((Object)responseVo) && ObjectUtil.isNotEmpty((Object)responseVo.getPolicyRefundInfoResponseBody())) {
                policyDTO.getMain().setRefundStatus(responseVo.getPolicyRefundInfoResponseBody().getRefundStatus());
                policyDTO.getMain().setRefundMessage(responseVo.getPolicyRefundInfoResponseBody().getMessage());
            }
        }
        catch (Exception e) {
            this.log.error("\u4fdd\u5355:{},\u8c03\u7528\u6536\u4ed8\u9000\u8d39\u4fdd\u5355\u7684\u9000\u8d39\u72b6\u6001\u67e5\u8be2\u63a5\u53e3\u62a5\u9519\uff1a{}", (Object)policyDTO.getMain().getPolicyNo(), (Object)e);
        }
    }

    private void ppDockRequest(PolicyDTO policyDTO, StanderRequest request) {
        DockRequest dockRequest = DockRequest.builder().head(new RequestHead()).build();
        String channleCode = policyDTO.getSalesList().getAgentCode();
        if (StringUtils.isBlank((CharSequence)channleCode)) {
            return;
        }
        dockRequest.setBody(DockRequestBody.builder().userCode("admin").agentCode(channleCode).build());
        try {
            ChannelDetailResponse responseVo = this.coreInsureApi.channelDetailQuery(dockRequest);
            if (ObjectUtil.isNotEmpty((Object)responseVo) && ObjectUtil.isNotEmpty((Object)responseVo.getBody())) {
                policyDTO.getMain().setAllowRetreat(responseVo.getBody().getAllowRetreat());
                String issueUserjFeeFlag = this.getIssueUserjFeeFlag(policyDTO.getMain().getOperateCode(), policyDTO.getMain().getRiskCode());
                policyDTO.getMain().setIssueUserjFeeFlag(issueUserjFeeFlag);
            }
        }
        catch (Exception e) {
            this.log.error("\u4fdd\u5355:{},\u8c03\u7528\u9500\u7ba1\u6e20\u9053\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3 \u62a5\u9519\uff1a", (Object)policyDTO.getMain().getPolicyNo(), (Object)e);
        }
    }

    private void endorseProcess(PolicyDTO policyDTO, StanderRequest request, PolicyDetailResponseDTO responseDTO) {
        String applyNo = responseDTO.getNewApplyNo();
        if (StringUtils.isBlank((CharSequence)applyNo)) {
            return;
        }
        EndorseQueryServiceRequest endorseQueryServiceRequest = EndorseQueryServiceRequest.builder().requestHead(RequestHeadDTO.initRequestHead()).requestBody(EndorseQueryRequestDTO.builder().applyNo(applyNo).build()).build();
        request.setEndorseQueryServiceRequest(endorseQueryServiceRequest);
        try {
            StanderResponse response = this.coreCorrectApi.correctQuery(request);
            if (ObjectUtil.isNotEmpty((Object)response) && ObjectUtil.isNotEmpty((Object)response.getEndorseQueryResponse()) && ObjectUtil.isNotEmpty((Object)response.getEndorseQueryResponse().getResponseBody()) && ObjectUtil.isNotEmpty((Object)response.getEndorseQueryResponse().getResponseBody().getMain())) {
                policyDTO.getMain().setUnderWriteFlag(response.getEndorseQueryResponse().getResponseBody().getMain().getUnderwriteFlag());
                policyDTO.getMain().setUnderWriteOpinion(response.getEndorseQueryResponse().getResponseBody().getMain().getUnderWriteOpinion());
                policyDTO.setPayPlanEndor(response.getEndorseQueryResponse().getResponseBody().getMain().getPayPlan());
            }
        }
        catch (Exception e) {
            this.log.error("\u4fdd\u5355\u53f7\uff1a{}\u7684\u6279\u5355\u7533\u8bf7\u53f7{} \u8c03\u7528\u6279\u5355\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3 \u62a5\u9519\uff1a", new Object[]{policyDTO.getMain().getPolicyNo(), applyNo, e});
        }
    }

    private StanderResponse kuayueEndorseProcess(StanderRequest request, StanderResponse response) {
        String applyNo = request.getPolicyDetailServiceRequest().getRequestBody().getKuayueApplyEndorseNo();
        if (StringUtils.isBlank((CharSequence)applyNo)) {
            return response;
        }
        EndorseQueryServiceRequest endorseQueryServiceRequest = EndorseQueryServiceRequest.builder().requestHead(RequestHeadDTO.initRequestHead()).requestBody(EndorseQueryRequestDTO.builder().applyNo(applyNo).build()).build();
        request.setEndorseQueryServiceRequest(endorseQueryServiceRequest);
        try {
            StanderResponse correctQueryResponse = this.coreCorrectApi.correctQuery(request);
            if (ObjectUtil.isNotEmpty((Object)correctQueryResponse) && ObjectUtil.isNotEmpty((Object)correctQueryResponse.getEndorseQueryResponse())) {
                if (null == response) {
                    response = StanderResponse.builder().build();
                }
                response.setEndorseQueryResponse(correctQueryResponse.getEndorseQueryResponse());
            }
            return response;
        }
        catch (Exception e) {
            this.log.error("\u6279\u5355\u7533\u8bf7\u53f7{},\u8c03\u7528\u6279\u5355\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3 \u62a5\u9519\uff1a", (Object)applyNo, (Object)e);
            return response;
        }
    }

    public String getWeChatOffCode() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"config_code", (Object)"wechatOffCode");
        ApisChannelConfigs configs = (ApisChannelConfigs)this.apisChannelConfigsMapper.selectOne((Wrapper)queryWrapper);
        if (configs == null) {
            return "0";
        }
        return configs.getConfigValue();
    }

    public String getIssueUserjFeeFlag(String userCode, String productCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_code", (Object)userCode);
        queryWrapper.like((Object)"product_code", (Object)productCode);
        queryWrapper.eq((Object)"config_code", (Object)"channel_jfeeFlag");
        queryWrapper.eq((Object)"deleted", (Object)CommonConstant.DeletedFlag.DELETED_NO);
        ApisChannelConfigs configs = (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)queryWrapper);
        if (configs == null) {
            return "0";
        }
        return configs.getConfigValue();
    }
}

