/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RenewalQueryUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemKindDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyListQueryRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyListDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyListQueryResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelUserService;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpKindClaimExchange;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.service.constants.CommonConstant;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationMainService;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.impl.ApisPfpKindClaimExchangeServiceImpl;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreCorrectApi;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import sinosoftgz.utils.data.DateUtils;

public class StanderPolicyListHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(StanderPolicyListHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    ApisPfpKindClaimExchangeServiceImpl apisPfpKindClaimExchangeServiceImpl;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    private ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    private RenewalQueryUtil renewalQueryUtil;
    @Autowired
    private ApisChannelUserService apisChannelUserService;
    @Autowired
    private DataCompletionUtil dataCompletionUtil;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Autowired
    CoreCorrectApi coreCorrectApi;
    @Autowired
    private ApisBusinessService apisBusinessService;
    @Autowired
    ApisPfpRationMainService apisPfpRationMainService;
    private static final String POLICY_LIST_SERVICE_RESPONSE = "policyListQueryResponse";
    private static final String POLICY_TYPE_C = "C";
    private static final int REQUEST_QUERY_STRAIGHT = 0;
    private static final int R0_REQUEST_BY_INSURE_OR_HOLD_FLAG = 1;
    private static final int R1_REQUEST_WEICHAT_GROUP_QUERY_BOTH = 2;
    private static final int R2_RESPONSE_WEICHAT_FOR_NEW_REPORY = 4;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        if (request == null || request.getPolicyListServiceRequest() == null) {
            throw new ApisDataCompletionException(ErrorNullValueCodeEnum.ERR_N00001.getValue(), ErrorNullValueCodeEnum.ERR_N00001.getKey());
        }
        if (request.getPolicyListServiceRequest().getRequestBody() == null) {
            throw new ApisDataCompletionException(ErrorNullValueCodeEnum.ERR_N52000.getValue(), ErrorNullValueCodeEnum.ERR_N52000.getKey());
        }
        if ("Q004".equals(request.getHeader().getOriginRequestType()) && ObjectUtil.isEmpty((Object)request.getPolicyListServiceRequest().getRequestBody().getIdentifyNumber())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10222.getValue().replaceFirst("##", "\u5fc5\u987b\u8f93\u5165\u8bc1\u4ef6\u53f7"), ChannelErrorCodeEnum.ERR_C10222.getKey());
        }
        String userCode = request.getHeader().getUserCode();
        if (StringUtils.isEmpty((CharSequence)userCode)) {
            throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10145.getKey()).message(ChannelErrorCodeEnum.ERR_C10145.getValue()).build();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"config_code", (Object)"policy_query_range");
        queryWrapper.eq((Object)"user_code", (Object)userCode);
        List channelConfigs = this.apisChannelConfigsService.list((Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)channelConfigs) && channelConfigs.size() > 0) {
            String bussinessType = request.getHeader().getBussinessType();
            if (("policyListQ001".equals(bussinessType) || "policyListQ007".equals(bussinessType)) && StringUtils.isNotEmpty((CharSequence)((ApisChannelConfigs)channelConfigs.get(0)).getRationCode())) {
                ArrayList<String> goodsCodesList = new ArrayList<String>();
                for (ApisChannelConfigs a : channelConfigs) {
                    goodsCodesList.add(a.getRationCode());
                }
                request.getPolicyListServiceRequest().getRequestBody().setGoodsCodes(goodsCodesList);
            }
            request.getPolicyListServiceRequest().getRequestBody().setOperateCode("all");
            request.getPolicyListServiceRequest().getRequestBody().setBusinessNature2("all");
        } else {
            String[] userArr = userCode.split("_");
            if (userArr.length > 1 && "00".equals(userArr[1])) {
                userCode = "all";
            }
            request.getPolicyListServiceRequest().getRequestBody().setOperateCode(userCode);
            ApisChannelUser apisChannelUser = new ApisChannelUser();
            apisChannelUser.setUserCode(request.getHeader().getUserCode());
            QueryWrapper apisChannelUserWrapper = new QueryWrapper((Object)apisChannelUser);
            List channelUserList = this.apisChannelUserService.list((Wrapper)apisChannelUserWrapper);
            if (ObjectUtils.isNotEmpty((Object)channelUserList) && channelUserList.size() > 0) {
                request.getPolicyListServiceRequest().getRequestBody().setBusinessNature2(((ApisChannelUser)channelUserList.get(0)).getChannelCode());
                request.getHeader().setChannelCode(((ApisChannelUser)channelUserList.get(0)).getChannelCode());
            } else {
                throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10174.getKey()).message(ChannelErrorCodeEnum.ERR_C10174.getValue()).build();
            }
        }
        if (ObjectUtil.isEmpty((Object)request.getPolicyListServiceRequest().getRequestBody().getPageIndex())) {
            request.getPolicyListServiceRequest().getRequestBody().setPageSize(Integer.valueOf(50));
            request.getPolicyListServiceRequest().getRequestBody().setPageIndex(Integer.valueOf(1));
        } else if (request.getPolicyListServiceRequest().getRequestBody().getPageSize() > 50 && this.dataCompletionUtil.isQueryPageSizeOpen()) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10640.getValue(), ChannelErrorCodeEnum.ERR_C10640.getKey());
        }
        PolicyListQueryRequestDTO policyListQueryRequestDTO = request.getPolicyListServiceRequest().getRequestBody();
        request.getPolicyListServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        if (StringUtils.isEmpty((CharSequence)policyListQueryRequestDTO.getQueryType())) {
            policyListQueryRequestDTO.setQueryType("0");
        }
        int route = this.findRoute(policyListQueryRequestDTO);
        policyListQueryRequestDTO.setRoute(route);
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        if (request.getPolicyListServiceRequest().getRequestBody() == null) {
            throw new ApisDataCompletionException(ErrorNullValueCodeEnum.ERR_N52000.getValue(), ErrorNullValueCodeEnum.ERR_N52000.getKey());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getPolicyListServiceRequest().getRequestBody().getLossTypes())) {
            request.getPolicyListServiceRequest().getRequestBody().setClaimType(request.getPolicyListServiceRequest().getRequestBody().getLossTypes());
            request.getPolicyListServiceRequest().getRequestBody().setLossTypes(null);
        }
        int route = request.getPolicyListServiceRequest().getRequestBody().getRoute();
        StanderResponse standerResponse = null;
        standerResponse = (route & 1) != 0 ? this.requestByInsureOrHoldFlag(request) : ((route & 2) != 0 ? this.requestWechatGroupQueryBoth(request) : this.coreInsureApi.policyList(request));
        return standerResponse;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        int route;
        if (response == null || response.getPolicyListQueryResponse() == null) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00002.getKey(), ErrorNullValueCodeEnum.ERR_N00002.getValue());
        }
        if (response.getPolicyListQueryResponse().getResponseHead() == null || response.getPolicyListQueryResponse().getResponseBody() == null || response.getPolicyListQueryResponse().getResponseBody().getPolicyList() == null || response.getPolicyListQueryResponse().getResponseHead().getStatus() == CommonConstant.FccbResponseCode.FAIL.intValue() || response.getPolicyListQueryResponse().getResponseBody().getPolicyList().size() == 0) {
            ResponseHeadDTO responseHeadDTO = ResponseHeadDTO.builder().build();
            responseHeadDTO.setAppCode(ChannelErrorCodeEnum.ERR_C10014.getKey());
            responseHeadDTO.setAppMessage(ChannelErrorCodeEnum.ERR_C10014.getValue());
            response.getPolicyListQueryResponse().setResponseHead(responseHeadDTO);
            return response;
        }
        response.getPolicyListQueryResponse().getResponseHead().setAppCode(ChannelErrorCodeEnum.ERR_C10002.getKey());
        response.getPolicyListQueryResponse().getResponseHead().setAppMessage(ChannelErrorCodeEnum.ERR_C10002.getValue());
        List policyList = response.getPolicyListQueryResponse().getResponseBody().getPolicyList();
        PolicyListQueryRequestDTO policyListQueryRequestDTO = request.getPolicyListServiceRequest().getRequestBody();
        if (ObjectUtils.isNotEmpty((Object)policyList) && policyList.size() > 0) {
            this.setRationCodeAndRationName(policyList);
            this.setGoodsCodeAndGoodsNameByItemNo(policyList);
            ApisChannelConfigs selfHelpPlatform = this.dataCompletionUtil.getConfig(request.getHeader().getUserCode(), "self_help_platform");
            boolean isSelfHelpPlatform = ObjectUtil.isNotEmpty((Object)selfHelpPlatform);
            if (isSelfHelpPlatform) {
                this.getRenewalFlag(policyList, request);
            }
            if (!("Y".equals(policyListQueryRequestDTO.getHolderFlag()) || "Y".equals(policyListQueryRequestDTO.getInsuredFlag()) || "Y".equals(policyListQueryRequestDTO.getHolderAndInsuredFlag()))) {
                this.filterItemByItemNo(policyList);
            }
            response.getPolicyListQueryResponse().getResponseBody().setPolicyList(policyList);
        }
        if (((route = request.getPolicyListServiceRequest().getRequestBody().getRoute()) & 4) != 0) {
            // empty if block
        }
        if (ObjectUtils.isNotEmpty((Object)policyList) && policyList.size() > 0) {
            for (int i = 0; i < policyList.size(); ++i) {
                List insuredList;
                PolicyListDTO policyListDTO = (PolicyListDTO)policyList.get(i);
                this.completeDamageResultCodeAndDamageResultName(policyListDTO);
                if (!"JME_USER".equals(request.getHeader().getUserCode()) || !"policyListQ001".equals(request.getHeader().getBussinessType()) || !ObjectUtil.isNotEmpty((Object)(insuredList = policyListDTO.getInsuredList())) || insuredList.size() <= 1) continue;
                Comparator<InsuredDTO> comparator4startDate = Comparator.comparing(InsuredDTO::getInsuredStartDate);
                Date minInsuredStartDate = insuredList.stream().min(comparator4startDate).get().getInsuredStartDate();
                Comparator<InsuredDTO> comparator4endDate = Comparator.comparing(InsuredDTO::getInsuredEndDate);
                Date maxInsuredEndDate = insuredList.stream().max(comparator4endDate).get().getInsuredEndDate();
                ((InsuredDTO)insuredList.get(0)).setInsuredStartDate(minInsuredStartDate);
                ((InsuredDTO)insuredList.get(0)).setInsuredEndDate(maxInsuredEndDate);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getPolicyListServiceRequest().getRequestBody().getInsuredFlag())) {
            response.getPolicyListQueryResponse().getResponseBody().setInsuredFlag("Y");
            response.getPolicyListQueryResponse().getResponseBody().setHolderFlag("N");
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getPolicyListServiceRequest().getRequestBody().getHolderFlag())) {
            response.getPolicyListQueryResponse().getResponseBody().setHolderFlag("Y");
            response.getPolicyListQueryResponse().getResponseBody().setInsuredFlag("N");
        }
        if (StringUtils.isEmpty((CharSequence)request.getPolicyListServiceRequest().getRequestBody().getInsuredFlag()) && StringUtils.isEmpty((CharSequence)request.getPolicyListServiceRequest().getRequestBody().getHolderFlag())) {
            response.getPolicyListQueryResponse().getResponseBody().setHolderFlag("Y");
            response.getPolicyListQueryResponse().getResponseBody().setInsuredFlag("Y");
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getPolicyListServiceRequest().getRequestBody().getInsuredFlag()) && StringUtils.isNotEmpty((CharSequence)request.getPolicyListServiceRequest().getRequestBody().getHolderFlag())) {
            response.getPolicyListQueryResponse().getResponseBody().setHolderFlag("Y");
            response.getPolicyListQueryResponse().getResponseBody().setInsuredFlag("Y");
        }
        return response;
    }

    private void filterPolicyByLossType(List<PolicyListDTO> policyList, String lossType) {
        if (ObjectUtils.isNotEmpty(policyList) && policyList.size() > 0) {
            block0: for (int i = 0; i < policyList.size(); ++i) {
                policyList.get(i).setIsIncludeLosssType(Boolean.valueOf(false));
                List itemMainDTOList = policyList.get(i).getCoverage().getItemList();
                if (!ObjectUtils.isNotEmpty((Object)itemMainDTOList) || itemMainDTOList.size() <= 0) continue;
                for (int j = 0; j < itemMainDTOList.size(); ++j) {
                    List itemKindDTOList = ((ItemMainDTO)policyList.get(i).getCoverage().getItemList().get(j)).getItemKind();
                    if (!ObjectUtils.isNotEmpty((Object)itemKindDTOList) || itemKindDTOList.size() <= 0) continue;
                    for (int k = 0; k < itemKindDTOList.size(); ++k) {
                        if (!ObjectUtils.isNotEmpty((Object)((ItemKindDTO)((ItemMainDTO)policyList.get(i).getCoverage().getItemList().get(j)).getItemKind().get(k)).getDamageResultCode()) || !((ItemKindDTO)((ItemMainDTO)policyList.get(i).getCoverage().getItemList().get(j)).getItemKind().get(k)).getDamageResultCode().equalsIgnoreCase(lossType)) continue;
                        policyList.get(i).setIsIncludeLosssType(Boolean.valueOf(true));
                        continue block0;
                    }
                }
            }
        }
        policyList.removeIf(policyListDTO -> policyListDTO.getIsIncludeLosssType() == false);
    }

    private void getRenewalFlag(List<PolicyListDTO> policyList, StanderRequest standerRequest) {
        Object requestHeadDTO = null;
        Object policyDetailServiceRequest = null;
        Object policyDetailRequestDTO = null;
        if (StringUtils.isBlank((CharSequence)standerRequest.getPolicyListServiceRequest().getRequestBody().getAppliIdentifyNumber()) && StringUtils.isBlank((CharSequence)standerRequest.getPolicyListServiceRequest().getRequestBody().getAppliIdentifyType()) && StringUtils.isBlank((CharSequence)standerRequest.getPolicyListServiceRequest().getRequestBody().getAppliName())) {
            return;
        }
        if (standerRequest.getPolicyListServiceRequest().getRequestBody().getAppliIdentifyNumber() == null) {
            standerRequest.getPolicyListServiceRequest().getRequestBody().setAppliIdentifyNumber("");
        }
        String[] appliIdentifyNumberArr = standerRequest.getPolicyListServiceRequest().getRequestBody().getAppliIdentifyNumber().split(",");
        if (ObjectUtils.isNotEmpty(policyList) && policyList.size() > 0) {
            HashSet<String> goodsCodeArr = new HashSet<String>();
            HashSet<String> planCode = new HashSet<String>();
            for (int i = 0; i < policyList.size(); ++i) {
                goodsCodeArr.add(policyList.get(i).getGoodsCode());
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"ration_code", goodsCodeArr);
            queryWrapper.eq((Object)"deleted", (Object)CommonConstant.DeletedFlag.DELETED_NO);
            queryWrapper.eq((Object)"valid_status", (Object)CommonConstant.ValidStatus.VALID_YES);
            List apisPfpRationMains = this.apisPfpRationMainService.list((Wrapper)queryWrapper);
            if (ObjectUtil.isNotEmpty((Object)apisPfpRationMains) && apisPfpRationMains.size() > 0) {
                for (ApisPfpRationMain apisPfpRationMain : apisPfpRationMains) {
                    planCode.add(apisPfpRationMain.getRelateRationCode());
                }
                QueryWrapper queryWrapperT = new QueryWrapper();
                queryWrapperT.eq((Object)"ration_flag", (Object)1);
                queryWrapperT.in((Object)"ration_code", planCode);
                queryWrapperT.eq((Object)"deleted", (Object)CommonConstant.DeletedFlag.DELETED_NO);
                queryWrapperT.eq((Object)"valid_status", (Object)CommonConstant.ValidStatus.VALID_YES);
                apisPfpRationMains = this.apisPfpRationMainService.list((Wrapper)queryWrapperT);
            }
            for (int i = 0; i < policyList.size(); ++i) {
                policyList.get(i).setRenewalFlag("N");
                if (!"07".equals(policyList.get(i).getClassCode()) && !"09".equals(policyList.get(i).getClassCode())) {
                    policyList.get(i).setRenewalMsg("\u8be5\u4fdd\u5355\u4e0d\u4e3a\u610f\u5065\u9669\u4ea7\u54c1\u3002");
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)policyList.get(i).getGiftType()) && !"0".equals(policyList.get(i).getGiftType())) {
                    policyList.get(i).setRenewalMsg("\u8be5\u4fdd\u5355\u4e3a\u8d60\u9669\u3002");
                    continue;
                }
                if (!"01".equals(policyList.get(i).getPolicyType())) {
                    policyList.get(i).setRenewalMsg("\u8be5\u5355\u4e3a\u56e2\u5355\u3002");
                    continue;
                }
                boolean appFlag = false;
                log.warn("\u6295\u4fdd\u4eba\u8bc1\u4ef6\u53f7\u7801{}", (Object)((AppliClientDTO)policyList.get(i).getAppliClient().get(0)).getIdentifyNumber());
                for (String appliIdentifyNumber : appliIdentifyNumberArr) {
                    if (!((AppliClientDTO)policyList.get(i).getAppliClient().get(0)).getIdentifyNumber().equalsIgnoreCase(appliIdentifyNumber)) continue;
                    appFlag = true;
                }
                if (!appFlag) {
                    policyList.get(i).setRenewalMsg("\u8be5\u5355\u4e0d\u662f\u7531\u6295\u4fdd\u4eba\u67e5\u51fa\u6765\u7684\u3002");
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)standerRequest.getPolicyListServiceRequest().getRequestBody().getAppliName()) && !((AppliClientDTO)policyList.get(i).getAppliClient().get(0)).getInsuredName().equals(standerRequest.getPolicyListServiceRequest().getRequestBody().getAppliName())) {
                    policyList.get(i).setRenewalMsg("\u8be5\u5355\u4e0d\u662f\u7531\u6295\u4fdd\u4eba\u67e5\u51fa\u6765\u7684\u3002");
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)standerRequest.getPolicyListServiceRequest().getRequestBody().getAppliIdentifyType()) && !((AppliClientDTO)policyList.get(i).getAppliClient().get(0)).getIdentifyType().equals(standerRequest.getPolicyListServiceRequest().getRequestBody().getAppliIdentifyType())) {
                    policyList.get(i).setRenewalMsg("\u8be5\u5355\u4e0d\u662f\u7531\u6295\u4fdd\u4eba\u67e5\u51fa\u6765\u7684\u3002");
                    continue;
                }
                if (DateUtils.disDay((String)policyList.get(i).getEndDateStr(), (String)policyList.get(i).getStartDateStr()) < 364) {
                    policyList.get(i).setRenewalMsg("\u8be5\u4fdd\u5355\u4fdd\u9669\u533a\u95f4\u5c0f\u4e8e364\u5929\u3002");
                    continue;
                }
                ApisPfpRationMain apisPfpRationMain = null;
                for (ApisPfpRationMain apisPfpRationMainT : apisPfpRationMains) {
                    if (!apisPfpRationMainT.getRationCode().equals(policyList.get(i).getRationCode())) continue;
                    apisPfpRationMain = apisPfpRationMainT;
                }
                Integer renewalDays = 0;
                Integer renewalDaysBefore = 0;
                if (apisPfpRationMain == null || StringUtils.isBlank((CharSequence)apisPfpRationMain.getInnerAfterRenewalDays())) {
                    renewalDays = 60;
                    renewalDaysBefore = 60;
                } else {
                    try {
                        renewalDays = Integer.parseInt(apisPfpRationMain.getInnerAfterRenewalDays());
                    }
                    catch (NumberFormatException e) {
                        renewalDays = 60;
                    }
                    try {
                        renewalDaysBefore = Integer.parseInt(apisPfpRationMain.getInnerBeforeRenewalDays());
                    }
                    catch (NumberFormatException e) {
                        renewalDaysBefore = 60;
                    }
                }
                log.warn("\u8ddd\u79bb\u4fdd\u5355\u7ec8\u4fdd\u65e5\u671f\u5929\u6570{}", (Object)DateUtils.disDay((String)policyList.get(i).getEndDateStr(), (String)DateUtils.getNowDateString()));
                if (DateUtils.disDay((String)policyList.get(i).getEndDateStr(), (String)DateUtils.getNowDateString()) > renewalDaysBefore) {
                    policyList.get(i).setRenewalMsg("\u8be5\u4fdd\u5355\u751f\u6548\u4e2d\u4e14\u8ddd\u79bb\u4fdd\u5355\u7ec8\u4fdd\u65e5\u671f\u5927\u4e8e\u53ef\u5728\u7ec8\u4fdd\u65e5\u671f\u524d\u5f00\u59cb\u91cd\u65b0\u6295\u4fdd\u5929\u6570\uff08" + renewalDaysBefore + "\uff09");
                    continue;
                }
                log.warn("\u4fdd\u5355\u5df2\u8fc7\u671f\u5929\u6570{}", (Object)DateUtils.disDay((String)DateUtils.getNowDateString(), (String)policyList.get(i).getEndDateStr()));
                if (DateUtils.disDay((String)DateUtils.getNowDateString(), (String)policyList.get(i).getEndDateStr()) > renewalDays) {
                    policyList.get(i).setRenewalMsg("\u8be5\u4fdd\u5355\u5df2\u8fc7\u671f\u5929\u6570\u5927\u4e8e\u53ef\u5728\u7ec8\u4fdd\u65e5\u671f\u8fc7\u540e\u8fdb\u884c\u91cd\u65b0\u6295\u4fdd\u5929\u6570\uff08" + renewalDays + "\uff09");
                    continue;
                }
                policyList.get(i).setRenewalFlag("Y");
                try {
                    this.renewalQueryUtil.completeRenewal(policyList.get(i), standerRequest);
                    continue;
                }
                catch (Exception e) {
                    policyList.get(i).setRenewalFlag("N");
                    policyList.get(i).setRenewalMsg("\u53ef\u7eed\u4fdd\u8ba1\u5212\u6e05\u5355\u67e5\u8be2\u5931\u8d25:" + e.getMessage());
                }
            }
        }
    }

    private void completeDamageResultCodeAndDamageResultName(PolicyListDTO policyDTO) {
        if (ObjectUtils.isNotEmpty((Object)policyDTO.getCoverage().getItemList()) && policyDTO.getCoverage().getItemList().size() > 0) {
            for (int j = 0; j < policyDTO.getCoverage().getItemList().size(); ++j) {
                List itemKindDTOList = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(j)).getItemKind();
                if (!ObjectUtils.isNotEmpty((Object)itemKindDTOList) || itemKindDTOList.size() <= 0) continue;
                for (int i = 0; i < itemKindDTOList.size(); ++i) {
                    String kindCode = ((ItemKindDTO)itemKindDTOList.get(i)).getKindCode();
                    if (!ObjectUtils.isNotEmpty((Object)kindCode)) continue;
                    QueryWrapper queryWrapper2 = new QueryWrapper();
                    queryWrapper2.eq((Object)"channel_value", (Object)kindCode);
                    queryWrapper2.eq((Object)"deleted", (Object)ApisChannelCode.DELETE_FLAG_FALSE);
                    queryWrapper2.eq((Object)"code", (Object)"kind_damageType");
                    ApisChannelCode apisChannelCode = (ApisChannelCode)this.apisChannelCodeService.getOne((Wrapper)queryWrapper2);
                    if (ObjectUtil.isNotEmpty((Object)apisChannelCode)) {
                        ((ItemKindDTO)((ItemMainDTO)policyDTO.getCoverage().getItemList().get(j)).getItemKind().get(i)).setDamageResultCode(apisChannelCode.getChannelValueDesc());
                        ((ItemKindDTO)((ItemMainDTO)policyDTO.getCoverage().getItemList().get(j)).getItemKind().get(i)).setDamageResultName(apisChannelCode.getValueDesc());
                        continue;
                    }
                    log.warn("{},\u67e5apis_channel_code\u8868\u4e3a\u7a7a", (Object)kindCode);
                }
            }
        }
    }

    private List<PolicyListDTO> filterItemByItemNo(List<PolicyListDTO> policyList) {
        if (ObjectUtils.isNotEmpty(policyList) && policyList.size() > 0) {
            for (PolicyListDTO curPolicy : policyList) {
                List insuredDTOList = curPolicy.getInsuredList();
                List itemMainDTOList = curPolicy.getCoverage().getItemList();
                ArrayList<Integer> unusedItem = new ArrayList<Integer>();
                ArrayList<Integer> insuredNoList = new ArrayList<Integer>();
                if (ObjectUtils.isNotEmpty((Object)insuredDTOList) && insuredDTOList.size() > 0) {
                    for (InsuredDTO curInsured : insuredDTOList) {
                        if (curInsured.getItemNo() == null) continue;
                        insuredNoList.add(curInsured.getItemNo());
                    }
                }
                if (ObjectUtils.isNotEmpty((Object)itemMainDTOList) && itemMainDTOList.size() > 0) {
                    for (ItemMainDTO curItem : itemMainDTOList) {
                        Integer itemItemNo = curItem.getItemNo();
                        if (insuredNoList == null || insuredNoList.size() == 0 || insuredNoList.contains(itemItemNo)) continue;
                        unusedItem.add(itemItemNo);
                    }
                }
                if (ObjectUtils.isNotEmpty(unusedItem) && unusedItem.size() > 0) {
                    for (Integer curItemNo : unusedItem) {
                        itemMainDTOList.removeIf(itemMainDTO -> curItemNo.equals(itemMainDTO.getItemNo()) && StringUtils.isNotBlank((CharSequence)itemMainDTO.getPlanType()) && itemMainDTO.getPlanType().equals(POLICY_TYPE_C));
                        log.warn("\u8fc7\u6ee4\u6ca1\u6709\u4e8e\u88ab\u4fdd\u9669\u4eba\u5173\u8054\u5e76\u4e14\u4fdd\u969c\u7c7b\u578b\u662f\u666e\u901a\u4fdd\u969c\u7684\u6807\u7684\u4fe1\u606f:curItemNo:{} \u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u8fc7\u6ee4\u6389", (Object)curItemNo);
                    }
                }
                curPolicy.getCoverage().setItemList(itemMainDTOList);
            }
        }
        return policyList;
    }

    private List<PolicyListDTO> setRationCodeAndRationName(List<PolicyListDTO> policyList) {
        if (ObjectUtils.isNotEmpty(policyList) && policyList.size() > 0) {
            for (int i = 0; i < policyList.size(); ++i) {
                if (StringUtils.isEmpty((CharSequence)policyList.get(i).getRationCode()) && ObjectUtils.isNotEmpty((Object)policyList.get(i).getInsuredList()) && policyList.get(i).getInsuredList().size() > 0 && StringUtils.isNotEmpty((CharSequence)((InsuredDTO)policyList.get(i).getInsuredList().get(0)).getRationCode())) {
                    policyList.get(i).setRationCode(((InsuredDTO)policyList.get(i).getInsuredList().get(0)).getRationCode());
                }
                if (StringUtils.isEmpty((CharSequence)policyList.get(i).getRationName()) && ObjectUtils.isNotEmpty((Object)policyList.get(i).getInsuredList()) && policyList.get(i).getInsuredList().size() > 0 && StringUtils.isNotEmpty((CharSequence)((InsuredDTO)policyList.get(i).getInsuredList().get(0)).getRationName())) {
                    policyList.get(i).setRationName(((InsuredDTO)policyList.get(i).getInsuredList().get(0)).getRationName());
                }
                if (!StringUtils.isEmpty((CharSequence)policyList.get(i).getGoodsCode()) || !StringUtils.isNotEmpty((CharSequence)policyList.get(i).getGoodsType())) continue;
                policyList.get(i).setGoodsCode(policyList.get(i).getGoodsType());
            }
        }
        return policyList;
    }

    private List<PolicyListDTO> setGoodsCodeAndGoodsNameByItemNo(List<PolicyListDTO> policyList) throws ApisBusinessException {
        if (ObjectUtils.isNotEmpty(policyList) && policyList.size() > 0) {
            for (PolicyListDTO curPolicy : policyList) {
                List insuredDTOList = curPolicy.getInsuredList();
                List itemMainDTOList = curPolicy.getCoverage().getItemList();
                if (ObjectUtils.isNotEmpty((Object)insuredDTOList) && insuredDTOList.size() > 0) {
                    for (InsuredDTO curInsured : insuredDTOList) {
                        Integer insureItemNo = curInsured.getItemNo();
                        if (!ObjectUtils.isNotEmpty((Object)itemMainDTOList) || itemMainDTOList.size() <= 0 || !ObjectUtils.isNotEmpty((Object)insureItemNo)) continue;
                        for (ItemMainDTO curItem : itemMainDTOList) {
                            Integer itemItemNo = curItem.getItemNo();
                            if (!ObjectUtils.isNotEmpty((Object)itemItemNo) || !itemItemNo.equals(insureItemNo) || !StringUtils.isNotEmpty((CharSequence)curItem.getPlanType()) || !curItem.getPlanType().equals(POLICY_TYPE_C) || !StringUtils.isNotEmpty((CharSequence)curItem.getGoodsCode()) || !StringUtils.isNotEmpty((CharSequence)curItem.getGoodsName())) continue;
                            curInsured.setGoodsCode(curItem.getGoodsCode());
                            curInsured.setGoodsName(curItem.getGoodsName());
                        }
                    }
                }
                curPolicy.setInsuredList(insuredDTOList);
            }
        }
        return policyList;
    }

    private StanderResponse requestByInsureOrHoldFlag(StanderRequest request) {
        PolicyListQueryRequestDTO requestBody = request.getPolicyListServiceRequest().getRequestBody();
        String insuredFlag = requestBody.getInsuredFlag();
        String holderFlag = requestBody.getHolderFlag();
        if ("Y".equals(insuredFlag) && !"Y".equals(holderFlag) && !"Y".equals(requestBody.getHolderAndInsuredFlag())) {
            requestBody.setAppliName(null);
            requestBody.setAppliIdentifyNumber(null);
            requestBody.setAppliIdentifyType(null);
        } else if ("Y".equals(holderFlag) && !"Y".equals(insuredFlag) && !"Y".equals(requestBody.getHolderAndInsuredFlag())) {
            requestBody.setInsuredName(null);
            requestBody.setIdentifyType(null);
            requestBody.setIdentifyNumber(null);
        }
        return this.coreInsureApi.policyList(request);
    }

    private StanderResponse requestWechatGroupQueryBoth(StanderRequest request) throws ApisBusinessException {
        PolicyListQueryRequestDTO requestBody = request.getPolicyListServiceRequest().getRequestBody();
        String identifyNumber = requestBody.getIdentifyNumber();
        if (StringUtils.isEmpty((CharSequence)identifyNumber)) {
            return null;
        }
        requestBody.setIdentifyNumber(null);
        requestBody.setAppliIdentifyNumber(identifyNumber);
        log.warn("(\u56e2\u5355)\u6838\u5fc3\u4fdd\u5355\u5217\u8868\u63a5\u53e3\u67e5\u8be2\uff1a{}", (Object)request.getHeader().getUserCode());
        StanderResponse standerResponseAppli = this.coreInsureApi.policyList(request);
        requestBody.setIdentifyNumber(identifyNumber);
        requestBody.setAppliIdentifyNumber(null);
        log.warn("(\u56e2\u5355)\u6838\u5fc3\u4fdd\u5355\u5217\u8868\u63a5\u53e3\u67e5\u8be2\uff1a{}", (Object)request.getHeader().getUserCode());
        StanderResponse standerResponseInsured = this.coreInsureApi.policyList(request);
        boolean successAppli = BaseApisParamUtil.isCoreResSuccess((StanderResponse)standerResponseAppli, (String)POLICY_LIST_SERVICE_RESPONSE);
        boolean successInsured = BaseApisParamUtil.isCoreResSuccess((StanderResponse)standerResponseInsured, (String)POLICY_LIST_SERVICE_RESPONSE);
        if (!successAppli) {
            return standerResponseInsured;
        }
        if (!successInsured) {
            return standerResponseAppli;
        }
        boolean bodyIsNullAppli = this.checkResponseBodyIsNull(standerResponseAppli);
        boolean bodyIsNullInsured = this.checkResponseBodyIsNull(standerResponseInsured);
        if (bodyIsNullAppli) {
            return standerResponseInsured;
        }
        if (bodyIsNullInsured) {
            return standerResponseAppli;
        }
        HashMap<String, PolicyListDTO> policyHashMap = new HashMap<String, PolicyListDTO>(16);
        PolicyListQueryResponseDTO responseBodyAppli = standerResponseAppli.getPolicyListQueryResponse().getResponseBody();
        List policyListAppli = responseBodyAppli.getPolicyList();
        for (PolicyListDTO aDTO : policyListAppli) {
            policyHashMap.put(aDTO.getPolicyNo(), aDTO);
        }
        PolicyListQueryResponseDTO responseBodyInsured = standerResponseInsured.getPolicyListQueryResponse().getResponseBody();
        List policyListInsured = responseBodyInsured.getPolicyList();
        for (PolicyListDTO aDTO : policyListInsured) {
            policyHashMap.put(aDTO.getPolicyNo(), aDTO);
        }
        for (PolicyListDTO aDTO : policyListAppli) {
            ((PolicyListDTO)policyHashMap.get(aDTO.getPolicyNo())).setAppliClient(aDTO.getAppliClient());
        }
        for (PolicyListDTO aDTO : policyListInsured) {
            ((PolicyListDTO)policyHashMap.get(aDTO.getPolicyNo())).setInsuredList(aDTO.getInsuredList());
        }
        ArrayList<PolicyListDTO> policyListDtos = new ArrayList<PolicyListDTO>();
        for (Map.Entry next : policyHashMap.entrySet()) {
            PolicyListDTO value = (PolicyListDTO)next.getValue();
            policyListDtos.add(value);
        }
        standerResponseInsured.getPolicyListQueryResponse().getResponseBody().setPolicyList(policyListDtos);
        standerResponseInsured.getPolicyListQueryResponse().getResponseBody().setCount(Integer.valueOf(policyListDtos.size()));
        return standerResponseInsured;
    }

    private void responseWechatForNewReport(PolicyListQueryRequestDTO requestBody, PolicyListQueryResponseDTO responseBody) {
        if (requestBody == null || responseBody == null) {
            return;
        }
        String lossTypes = requestBody.getLossTypes();
        List policyList = responseBody.getPolicyList();
        if (StringUtils.isEmpty((CharSequence)lossTypes) || policyList == null) {
            return;
        }
        ArrayList<PolicyListDTO> fitPolicyListDtos = new ArrayList<PolicyListDTO>();
        HashSet<String> kindCodeSet = new HashSet<String>();
        List insuredListCur = null;
        List kindListCur = null;
        QueryWrapper queryWrapper = null;
        List claimList = null;
        List insuredDTOList = null;
        List itemMainDTOList = null;
        Integer insureItemNo = null;
        Integer itemItemNo = null;
        for (int i = 0; i < policyList.size(); ++i) {
            insuredDTOList = ((PolicyListDTO)policyList.get(i)).getInsuredList();
            itemMainDTOList = ((PolicyListDTO)policyList.get(i)).getCoverage().getItemList();
            for (int j = 0; j < insuredDTOList.size(); ++j) {
                insureItemNo = ((InsuredDTO)insuredDTOList.get(j)).getItemNo();
                if (insureItemNo == null) continue;
                for (int k = 0; k < itemMainDTOList.size(); ++k) {
                    itemItemNo = ((ItemMainDTO)itemMainDTOList.get(k)).getItemNo();
                    if (itemItemNo == null || !insureItemNo.equals(itemItemNo)) continue;
                    ((InsuredDTO)insuredDTOList.get(j)).setItemKind(((ItemMainDTO)itemMainDTOList.get(k)).getItemKind());
                }
            }
        }
        boolean existEqual = false;
        for (PolicyListDTO curPolicy : policyList) {
            insuredListCur = curPolicy.getInsuredList();
            if (insuredListCur != null) {
                for (InsuredDTO curInsured : insuredListCur) {
                    kindListCur = curInsured.getItemKind();
                    if (kindListCur == null) continue;
                    for (ItemKindDTO aKind : kindListCur) {
                        kindCodeSet.add(aKind.getKindCode());
                    }
                }
            }
            if (kindCodeSet.isEmpty()) continue;
            queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"kind_code", kindCodeSet);
            queryWrapper.select(new String[]{"damage_result_code", "damage_result_type"});
            queryWrapper.groupBy((Object[])new String[]{"damage_result_code", "damage_result_type"});
            claimList = this.apisPfpKindClaimExchangeServiceImpl.list((Wrapper)queryWrapper);
            existEqual = false;
            if (claimList != null) {
                for (ApisPfpKindClaimExchange claimItem : claimList) {
                    if (!lossTypes.equalsIgnoreCase(claimItem.getDamageResultCode())) continue;
                    existEqual = true;
                    break;
                }
            }
            if (existEqual) {
                fitPolicyListDtos.add(curPolicy);
            }
            kindCodeSet.clear();
        }
        responseBody.setPolicyList(fitPolicyListDtos);
        responseBody.setCount(Integer.valueOf(fitPolicyListDtos.size()));
    }

    private boolean checkResponseBodyIsNull(StanderResponse standerResponse) {
        return standerResponse == null || standerResponse.getPolicyListQueryResponse() == null || standerResponse.getPolicyListQueryResponse().getResponseBody() == null || standerResponse.getPolicyListQueryResponse().getResponseBody().getPolicyList() == null || standerResponse.getPolicyListQueryResponse().getResponseBody().getPolicyList().size() == 0;
    }

    private int findRoute(PolicyListQueryRequestDTO policyListQueryRequestDTO) {
        int route = 0;
        if (StringUtils.isNotEmpty((CharSequence)policyListQueryRequestDTO.getHolderFlag()) || StringUtils.isNotEmpty((CharSequence)policyListQueryRequestDTO.getInsuredFlag())) {
            route |= 1;
        } else if (StringUtils.isNotEmpty((CharSequence)policyListQueryRequestDTO.getIdentifyNumber()) && BaseApisParamUtil.isAllFieldEmptyExceptSpec((Object)policyListQueryRequestDTO, (String[])new String[]{"identifyNumber", "queryType", "route"})) {
            route |= 2;
        }
        if (StringUtils.isNotEmpty((CharSequence)policyListQueryRequestDTO.getLossTypes())) {
            route |= 4;
        }
        return route;
    }

    public void responseChangePolicyStatus(StanderResponse standerResponse) throws ApisBusinessException {
        if (this.checkResponseBodyIsNull(standerResponse)) {
            return;
        }
        List policyList = standerResponse.getPolicyListQueryResponse().getResponseBody().getPolicyList();
        Object policyStatus = null;
        ApisBusiChannelOrder apisBusinessChannelOrderExample = null;
        ApisBusiChannelOrder apisBusinessChannelOrder = null;
        QueryWrapper queryWrapper = null;
        for (PolicyListDTO next : policyList) {
            apisBusinessChannelOrderExample = new ApisBusiChannelOrder();
            apisBusinessChannelOrderExample.setPolicyNo(next.getPolicyNo());
            queryWrapper = new QueryWrapper((Object)apisBusinessChannelOrderExample);
            apisBusinessChannelOrder = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
            if (apisBusinessChannelOrder == null || "04".equals(apisBusinessChannelOrder.getStatus())) continue;
            next.setPolicyStatus("60");
        }
    }
}

