/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.executor.CommonsValidateUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.FxqCustomerCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.MediaUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.QuotePriceValidate;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RiskManagementCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EndorsePriceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainEndorPriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicySubmitRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicySubmitRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CorrectQuotePriceServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.MainEndorResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicySubmitResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyValidityCorrectResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyValidityCorrectResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.RiskManagementScenesEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreCorrectApi;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StanderPolicyValidityCorrectHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderPolicyValidityCorrectHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    CoreCorrectApi coreCorrectApi;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    ApisBusinessService apisBusinessService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    private RiskManagementCheckUtil riskManagementCheckUtil;
    @Autowired
    private FxqCustomerCheckUtil fxqCustomerCheckUtil;
    @Autowired
    private CommonsValidateUtil commonsValidateUtil;
    @Autowired
    private MediaUploadUtil mediaUploadUtil;
    private PolicyDTO policyDTO = null;
    private static final String POLICY_SUBMIT_RESPONSE = "policySubmitResponse";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        this.log.warn("==============\u4fdd\u671f\u5e73\u79fb\u63a5\u53e3\u5f00\u59cb==================");
        BaseApisParamUtil.verificationRequest((StanderRequest)request, (String)"endorsePriceServiceRequest");
        this.policyDTO = this.executePolicyDetails(request);
        request.setPolicyDetail(this.policyDTO);
        this.log.warn("\u4fdd\u671f\u5e73\u79fb\u300b\u4fdd\u5355\u53f7\uff1a{}", (Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getPolicyNo());
        this.dataCompletionUtil.policyCorrectRequestBeforeProcess(request);
        this.validateRequest(request, this.policyDTO);
        this.beforeConfirmCompletion(request, this.policyDTO);
        this.riskManagementCheckUtil.riskManagementData(request, this.policyDTO, RiskManagementScenesEnum.CORRECT.getCode(), this.policyDTO.getMain().getPolicyType());
        this.fxqCustomerCheckUtil.fxqCustomerData(request, this.policyDTO);
        this.commonsValidateUtil.executorValidate(request, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true));
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        StanderResponse response = StanderResponse.builder().build();
        StanderResponse correctQuotePriceResponse = this.coreCorrectApi.correctQuotePrice(request);
        BaseApisParamUtil.verificationResponse((StanderResponse)correctQuotePriceResponse, (String)"correctQuotePriceServiceResponse");
        CorrectQuotePriceServiceResponse correctQuotePriceServiceResponse = correctQuotePriceResponse.getCorrectQuotePriceServiceResponse();
        response.setCorrectQuotePriceServiceResponse(correctQuotePriceServiceResponse);
        this.dataCorrectConfirmCompletion(request, correctQuotePriceResponse);
        if (request.getEndorsePriceServiceRequest().getRequestBody().getMain().getImageList() != null && request.getEndorsePriceServiceRequest().getRequestBody().getMain().getImageList().size() > 0) {
            this.dataCompletionUtil.imageDataCompletion(request, request.getEndorsePriceServiceRequest().getRequestBody().getMain().getImageList(), response.getCorrectQuotePriceServiceResponse().getResponseBody().getEndorseApply().getMain().getApplyNo());
            this.mediaUploadUtil.syncImgBatchUpload(request);
        }
        StanderResponse policySubmitResponse = this.coreCorrectApi.correctConfirm(request);
        BaseApisParamUtil.verificationResponse((StanderResponse)policySubmitResponse, (String)POLICY_SUBMIT_RESPONSE);
        response.setPolicySubmitResponse(policySubmitResponse.getPolicySubmitResponse());
        return response;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        PolicyValidityCorrectResponseDTO policyValidityCorrectResponseDTO = PolicyValidityCorrectResponseDTO.builder().build();
        PolicySubmitResponse policySubmitResponse = response.getPolicySubmitResponse();
        CorrectQuotePriceServiceResponse correctQuotePriceServiceResponse = response.getCorrectQuotePriceServiceResponse();
        MainEndorResponseDTO main = correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain();
        String underwriteFlag = policySubmitResponse.getResponseBody().getUnderwriteFlag();
        if ("1".equals(underwriteFlag) || "3".equals(underwriteFlag)) {
            policyValidityCorrectResponseDTO.setPolicyStatus("70");
        } else if ("4".equals(underwriteFlag)) {
            policyValidityCorrectResponseDTO.setPolicyStatus("30");
        }
        String businessNo = policySubmitResponse.getResponseBody().getBusinessNo();
        policyValidityCorrectResponseDTO.setPolicyNo(businessNo);
        policyValidityCorrectResponseDTO.setTotalPremium(main.getSumPremium());
        policyValidityCorrectResponseDTO.setComCode(main.getComCode());
        policyValidityCorrectResponseDTO.setApplyNo(main.getApplyNo());
        ResponseHeadDTO responseHeadDTO = ResponseHeadDTO.builder().build();
        responseHeadDTO.setConsumerSeqNo(request.getEndorsePriceServiceRequest().getRequestHead().getConsumerSeqNo());
        responseHeadDTO.setStatus(1);
        PolicyValidityCorrectResponse policyValidityCorrectResponse = PolicyValidityCorrectResponse.builder().responseHead(responseHeadDTO).responseBody(policyValidityCorrectResponseDTO).build();
        response.setPolicyValidityCorrectResponse(policyValidityCorrectResponse);
        return StanderResponse.builder().header(request.getHeader()).policyValidityCorrectResponse(policyValidityCorrectResponse).build();
    }

    private void beforeConfirmCompletion(StanderRequest request, PolicyDTO policyDTO) {
        request.getEndorsePriceServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        this.compensateMainConfirmParams(request, policyDTO);
        this.requestBeforeProcess(request);
    }

    private void requestBeforeProcess(StanderRequest request) {
        request.getEndorsePriceServiceRequest().getRequestBody().getMain().setAssociatePersons(null);
        request.getEndorsePriceServiceRequest().getRequestBody().getMain().setCoverage(null);
        request.getEndorsePriceServiceRequest().getRequestBody().getMain().setRenewal(null);
    }

    private void compensateMainConfirmParams(StanderRequest request, PolicyDTO policyDTO) {
        EndorsePriceRequestDTO endorsePriceRequestDTO = request.getEndorsePriceServiceRequest().getRequestBody();
        MainEndorPriceDTO mainEndorPriceDTO = endorsePriceRequestDTO.getMain();
        mainEndorPriceDTO.setEndorseType("10");
        Date validDate = new Date();
        Date startDate = policyDTO.getMain().getStartDate();
        if ("P070006".equals(policyDTO.getMain().getRiskCode()) && ObjectUtil.isNotEmpty((Object)mainEndorPriceDTO.getStartDate())) {
            startDate = mainEndorPriceDTO.getStartDate();
        }
        if (startDate.getTime() >= validDate.getTime()) {
            validDate = startDate;
        }
        mainEndorPriceDTO.setValidDate(validDate);
        mainEndorPriceDTO.setOperateCode(policyDTO.getMain().getOperateCode());
        mainEndorPriceDTO.setIsPrePrice("N");
        int validHour = DateUtil.hour((Date)mainEndorPriceDTO.getValidDate(), (boolean)true);
        mainEndorPriceDTO.setValidHour(Integer.valueOf(validHour));
    }

    private void validateRequest(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        this.checkPolicy(request, policyDTO);
        this.validateMain(request, policyDTO);
        MainEndorPriceDTO main = request.getEndorsePriceServiceRequest().getRequestBody().getMain();
    }

    private void validateMain(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        MainEndorPriceDTO main = request.getEndorsePriceServiceRequest().getRequestBody().getMain();
        if (ObjectUtil.isNotEmpty((Object)main.getStartDate()) && ObjectUtil.isEmpty((Object)main.getEndDate())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10461.getValue(), ChannelErrorCodeEnum.ERR_C10461.getKey());
        }
        Date startDate = main.getStartDate();
        Date endDate = main.getEndDate();
        Date oldStartDate = policyDTO.getMain().getStartDate();
        Date oldEndDate = policyDTO.getMain().getEndDate();
        if ("P070006".equals(policyDTO.getMain().getRiskCode())) {
            if (main.getStartDate().compareTo(new Date()) <= 0) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10696.getValue(), ChannelErrorCodeEnum.ERR_C10696.getKey());
            }
            if (new Date().compareTo(oldStartDate) >= 0) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10281.getValue(), ChannelErrorCodeEnum.ERR_C10281.getKey());
            }
        } else if (startDate.getTime() <= oldStartDate.getTime()) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10114.getValue(), ChannelErrorCodeEnum.ERR_C10114.getKey());
        }
        if (startDate.getTime() >= endDate.getTime()) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10204.getValue(), ChannelErrorCodeEnum.ERR_C10204.getKey());
        }
        if (!QuotePriceValidate.isOutOneYear((Date)startDate, (Date)endDate, (boolean)false)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10040.getValue(), ChannelErrorCodeEnum.ERR_C10040.getKey());
        }
        long days = DataCompletionUtil.betweenDays((Date)startDate, (Date)endDate, (boolean)true);
        long oldDays = DataCompletionUtil.betweenDays((Date)oldStartDate, (Date)oldEndDate, (boolean)true);
        if (days != oldDays) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10463.getValue(), ChannelErrorCodeEnum.ERR_C10463.getKey());
        }
        if (!"kuayueCorrect".equals(request.getHeader().getBussinessType()) && ObjectUtil.isEmpty((Object)main.getReason())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u3010\u6279\u6539\u539f\u56e0\u3011"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
    }

    private void checkPolicy(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        MainDTO main = policyDTO.getMain();
        String userCode = request.getHeader().getUserCode();
        if (ObjectUtil.isEmpty((Object)main.getPolicyStatus()) || !"1".equals(main.getPolicyStatus())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10421.getValue(), ChannelErrorCodeEnum.ERR_C10421.getKey());
        }
        String planCode = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
        apisChannelConfigs.setRationCode(planCode);
        apisChannelConfigs.setConfigCode("AMOUNT_CORRECT_POWER");
        apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
        this.log.warn("\u6279\u6539\u8d60\u9669\u7c7b\u578b\u4e3a\uff1a{}", (Object)policyDTO.getMain().getGiftType());
        if (StringUtils.isNotEmpty((CharSequence)policyDTO.getMain().getGiftType()) && !policyDTO.getMain().getGiftType().equals("0") && ObjectUtil.isEmpty((Object)apisChannelConfigs)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10506.getValue(), ChannelErrorCodeEnum.ERR_C10506.getKey());
        }
        Date startDate = policyDTO.getMain().getStartDate();
        if ("kuayueCorrect".equals(request.getHeader().getBussinessType()) && DateUtil.between((Date)startDate, (Date)new Date(), (DateUnit)DateUnit.DAY, (boolean)false) >= 2L) {
            throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10681.getKey()).message(ChannelErrorCodeEnum.ERR_C10681.getValue()).build();
        }
    }

    private PolicyDTO executePolicyDetails(StanderRequest request) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)request.getEndorsePriceServiceRequest().getRequestBody()) || ObjectUtil.isEmpty((Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain()) || ObjectUtil.isEmpty((Object)request.getEndorsePriceServiceRequest().getRequestBody().getMain().getPolicyNo())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u3010\u4fdd\u5355\u53f7\u3011"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        String policyNo = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getPolicyNo();
        return this.dataCompletionUtil.getPolicyDetail(request, policyNo, false);
    }

    private void dataCorrectConfirmCompletion(StanderRequest request, StanderResponse response) throws ApisDataCompletionException {
        CorrectQuotePriceServiceResponse correctQuotePriceServiceResponse = response.getCorrectQuotePriceServiceResponse();
        MainEndorResponseDTO main = correctQuotePriceServiceResponse.getResponseBody().getEndorseApply().getMain();
        String manual = request.getEndorsePriceServiceRequest().getRequestBody().getMain().getManual();
        PolicySubmitRequestDTO policySubmitRequestDTO = PolicySubmitRequestDTO.builder().build();
        policySubmitRequestDTO.setBusinessType("E");
        policySubmitRequestDTO.setBusinessNo(main.getApplyNo());
        if ("Y".equals(manual)) {
            policySubmitRequestDTO.setUnderWriteType("BH");
        } else {
            MainDTO mainDTO = this.policyDTO.getMain();
            policySubmitRequestDTO.setUnderWriteType("EX");
            policySubmitRequestDTO.setUnderWriteCode(mainDTO.getOperateCode());
            policySubmitRequestDTO.setUnderWriteName(mainDTO.getOperateName());
        }
        policySubmitRequestDTO.setPaymentFlag("1");
        PolicySubmitRequest policySubmitRequest = PolicySubmitRequest.builder().requestHead(RequestHeadDTO.initRequestHead()).requestBody(policySubmitRequestDTO).build();
        request.setPolicySubmitRequest(policySubmitRequest);
    }
}

