/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.util.HexUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.service.constants.CommonConstant;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.impl.ApisPfpKindClaimExchangeServiceImpl;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class StanderPrintQueryVoucherImgURLHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(StanderPrintQueryVoucherImgURLHandler.class);
    @Value(value="${printQueryVoucherImg.interface.execute}")
    String printQueryVoucherImgUrl;
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    ApisPfpKindClaimExchangeServiceImpl apisPfpKindClaimExchangeServiceImpl;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        if (request == null || request.getPrintQueryVoucherImgUrlRequest() == null) {
            throw new ApisDataCompletionException(ErrorNullValueCodeEnum.ERR_N00001.getValue(), ErrorNullValueCodeEnum.ERR_N00001.getKey());
        }
        if (request.getPrintQueryVoucherImgUrlRequest().getRequestBody() == null) {
            throw new ApisDataCompletionException(ErrorNullValueCodeEnum.ERR_N52000.getValue(), ErrorNullValueCodeEnum.ERR_N52000.getKey());
        }
        request.getPrintQueryVoucherImgUrlRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        if (request.getPrintQueryVoucherImgUrlRequest().getRequestBody() == null) {
            throw new ApisDataCompletionException(ErrorNullValueCodeEnum.ERR_N52000.getValue(), ErrorNullValueCodeEnum.ERR_N52000.getKey());
        }
        StanderResponse standerResponse = this.coreInsureApi.printQueryVoucherImgUrl(request);
        return standerResponse;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        if (response == null || response.getPrintQueryImgUrlResponse() == null) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00002.getKey(), ErrorNullValueCodeEnum.ERR_N00002.getValue());
        }
        if (response.getPrintQueryImgUrlResponse().getResponseHead() == null || response.getPrintQueryImgUrlResponse().getResponseBody() == null || response.getPrintQueryImgUrlResponse().getResponseBody().getZipUrl() == null && response.getPrintQueryImgUrlResponse().getResponseBody().getImgUrl() == null || response.getPrintQueryImgUrlResponse().getResponseHead().getStatus() == CommonConstant.FccbResponseCode.FAIL.intValue()) {
            ResponseHeadDTO responseHeadDTO = ResponseHeadDTO.builder().build();
            responseHeadDTO.setAppCode(ChannelErrorCodeEnum.ERR_C10014.getKey());
            responseHeadDTO.setAppMessage(ChannelErrorCodeEnum.ERR_C10014.getValue());
            response.getPrintQueryImgUrlResponse().setResponseHead(responseHeadDTO);
            return response;
        }
        if (StringUtils.isNotBlank((CharSequence)response.getPrintQueryImgUrlResponse().getResponseBody().getZipUrl())) {
            String zipUrl = response.getPrintQueryImgUrlResponse().getResponseBody().getZipUrl();
            log.warn("\u7535\u5b50\u51ed\u8bc1\u4e0b\u8f7d\u5730\u5740\uff0c\u52a0\u5bc6\u524d\u7684url\uff1a{}", (Object)zipUrl);
            zipUrl = this.printQueryVoucherImgUrl + HexUtil.encodeHexStr((String)("zipUrl|" + zipUrl));
            response.getPrintQueryImgUrlResponse().getResponseBody().setZipUrl(zipUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)response.getPrintQueryImgUrlResponse().getResponseBody().getImgUrl())) {
            String imgUrl = response.getPrintQueryImgUrlResponse().getResponseBody().getImgUrl();
            log.warn("\u7535\u5b50\u51ed\u8bc1\u4e0b\u8f7d\u6587\u4ef6\uff0c\u52a0\u5bc6\u524d\u7684url\uff1a{}", (Object)imgUrl);
            imgUrl = this.printQueryVoucherImgUrl + HexUtil.encodeHexStr((String)("imgUrl|" + imgUrl));
            response.getPrintQueryImgUrlResponse().getResponseBody().setImgUrl(imgUrl);
        }
        if (StringUtils.isBlank((CharSequence)response.getPrintQueryImgUrlResponse().getResponseBody().getZipUrl()) && StringUtils.isBlank((CharSequence)response.getPrintQueryImgUrlResponse().getResponseBody().getImgUrl())) {
            log.warn("\u6838\u5fc3\u8fd4\u56de\u4e0b\u8f7d\u5730\u5740\u4e3a\u7a7a");
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
        response.getPrintQueryImgUrlResponse().getResponseHead().setAppCode(ChannelErrorCodeEnum.ERR_C10002.getKey());
        response.getPrintQueryImgUrlResponse().getResponseHead().setAppMessage(ChannelErrorCodeEnum.ERR_C10002.getValue());
        return response;
    }
}

