/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.executor.CommonsValidateUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.FxqCustomerCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.MediaUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.QuotePriceValidate;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RiskManagementCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.ThyroidUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.ZybxRiskManagementCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyNoGetRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyNoGetRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.policyActivate.PolicyPaymentNotifyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.policyActivate.PolicyPaymentNotifyResultRequestParams;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.policyActivate.PolicyPaymentNotifyResult;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiReqmsgLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.RiskCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StanderQuotePriceHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderQuotePriceHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    HttpRequestService httpRequestService;
    @Autowired
    QuotePriceValidate quotePriceValidate;
    @Autowired
    MediaUploadUtil mediaUploadUtil;
    @Autowired
    ThyroidUtil thyroidUtil;
    @Autowired
    ApisBusiReqmsgLogMapper apisBusiReqmsgLogMapper;
    @Autowired
    private RiskManagementCheckUtil riskManagementCheckUtil;
    @Autowired
    private CommonsValidateUtil commonsValidateUtil;
    private ZybxRiskManagementCheckUtil zybxRiskManagementCheckUtil;
    @Autowired
    private FxqCustomerCheckUtil fxqCustomerCheckUtil;
    private final String REQUEST_ENTITY_QUOTEPRICE = "quotePriceServiceRequest";
    private final String RESPONSE_ENTITY_QUOTEPRICE = "policyListQueryResponse";
    private final String RESPONSE_ENTITY_PLOICYNOGET = "policyNoGetResponse";
    private final String RESPONSE_ENTITY_PLOICYSUBMIT = "policySubmitResponse";
    private final String API_POLICY_PAYMENT_NOTIFY = "policyPaymentNotify";
    private static final String CLAUSE_LIABILITY_KEY_WORD = "\u6761\u6b3e\u8d23\u4efb\u4fe1\u606f\u4e2d";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        TimeInterval timer = DateUtil.timer();
        request.getQuotePriceServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        BaseApisParamUtil.verificationRequest((StanderRequest)request, (String)"quotePriceServiceRequest");
        this.dataCompletionUtil.verifyRepeatRequest(request);
        this.dataCompletionUtil.dataCompletion(request);
        MainDTO mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        request.getQuotePriceServiceRequest().getRequestHead().setConsumerSeqNo(request.getHeader().getUserCode() + mainDTO.getOrderNo());
        this.log.warn("\u6570\u636e\u8865\u5168\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.quotePriceValidate.validateRquest(request);
        this.log.warn("\u51fa\u5355\u89c4\u5219\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.dataCompletionUtil.settleInsuredFlag(request);
        this.dataCompletionUtil.calculateTotalPremium(request);
        this.log.warn("\u4fdd\u8d39\u8ba1\u7b97\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().setPlanList(null);
        this.dataCompletionUtil.riskDataCompletion(request);
        this.dataCompletionUtil.fxqDataCompletion(request);
        this.commonsValidateUtil.executorValidate(request, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        QuotePriceServiceResponse quotePriceServiceResponse;
        block29: {
            ApisBusiChannelOrder apisBusinessChannelOrder = new ApisBusiChannelOrder();
            apisBusinessChannelOrder.setRequestTime(LocalDateTime.now());
            apisBusinessChannelOrder.setCreateTime(new Date());
            quotePriceServiceResponse = QuotePriceServiceResponse.builder().build();
            Double sumPremium = null;
            String comCode = null;
            MainDTO mainDTO = MainDTO.builder().build();
            try {
                String prePayFlag;
                List haveManuals;
                List insuredIdvList;
                apisBusinessChannelOrder.setStatus("01");
                String businessNo = "";
                String policyStatus = "70";
                Date startTime = new Date();
                StanderResponse quotePriceResponse = this.coreInsureApi.quotePrice(request);
                BaseApisParamUtil.verificationResponse((StanderResponse)quotePriceResponse, (String)"policyListQueryResponse");
                mainDTO = quotePriceResponse.getPolicyListQueryResponse().getResponseBody().getMain();
                MainDTO requestMainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
                if (StringUtils.isEmpty((CharSequence)requestMainDTO.getJFeeFlag())) {
                    requestMainDTO.setJFeeFlag(mainDTO.getJFeeFlag());
                }
                if (StringUtils.isEmpty((CharSequence)requestMainDTO.getStepFlag())) {
                    requestMainDTO.setStepFlag(this.dataCompletionUtil.getStepFlag(request.getHeader().getUserCode()));
                }
                apisBusinessChannelOrder.setPayType(mainDTO.getJFeeFlag());
                if (StringUtils.isNotEmpty((CharSequence)requestMainDTO.getOutPaymentType()) && "0".equals(mainDTO.getJFeeFlag())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10471.getValue(), ChannelErrorCodeEnum.ERR_C10471.getKey());
                }
                sumPremium = mainDTO.getSumPremium();
                comCode = mainDTO.getComCode();
                StanderResponse policySubmitResponse = null;
                apisBusinessChannelOrder.setProposalTime(LocalDateTime.now());
                apisBusinessChannelOrder.setProposalNo(mainDTO.getProposalNo());
                mainDTO.setOutPaymentType(requestMainDTO.getOutPaymentType() == null ? "" : requestMainDTO.getOutPaymentType());
                if ("P010998".equals(mainDTO.getRiskCode()) || "P010989".equals(mainDTO.getRiskCode()) || RiskCodeEnum.getType((String)mainDTO.getRiskCode()) == 3) {
                    request.getImgBatchUploadServiceRequest().getRequestBody().setOrderNo(mainDTO.getOrderNo());
                    request.getImgBatchUploadServiceRequest().getRequestBody().setLinkNo(mainDTO.getProposalNo());
                    this.mediaUploadUtil.syncImgBatchUpload(request);
                }
                if (ObjectUtils.isNotEmpty((Object)(insuredIdvList = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getInsuredIdvList())) && ObjectUtils.isNotEmpty(haveManuals = insuredIdvList.stream().filter(ins -> StringUtils.isNotBlank((CharSequence)ins.getManualUwId())).collect(Collectors.toList()))) {
                    request.getImgBatchUploadServiceRequest().getRequestBody().setOrderNo(mainDTO.getOrderNo());
                    request.getImgBatchUploadServiceRequest().getRequestBody().setLinkNo(mainDTO.getProposalNo());
                    this.mediaUploadUtil.syncImgBatchUploadUw(request);
                }
                if (ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getIsThyriod()) && request.getQuotePriceServiceRequest().getRequestBody().getIsThyriod().booleanValue()) {
                    this.thyroidUtil.syncUpload(request, mainDTO.getProposalNo(), mainDTO.getOrderNo());
                }
                apisBusinessChannelOrder.setStatus("02");
                apisBusinessChannelOrder.setGiftType(mainDTO.getGiftType());
                Map map = this.policyNoGetService(apisBusinessChannelOrder, request, mainDTO);
                String obj = (String)DataCompletionUtil.castToClass(String.class, map.get("policyStatus"));
                policyStatus = StringUtils.isEmpty((CharSequence)obj) ? "70" : obj;
                businessNo = (String)DataCompletionUtil.castToClass(String.class, map.get("businessNo"));
                if ("0".equals(requestMainDTO.getJFeeFlag())) {
                    if ("1".equals(requestMainDTO.getStepFlag())) {
                        policySubmitResponse = this.coreInsureApi.policySubmit(this.dataCompletionUtil.packagePolicyConfirmRequestData(mainDTO, request, businessNo, "P"));
                        BaseApisParamUtil.verificationResponse((StanderResponse)policySubmitResponse, (String)"policySubmitResponse");
                        businessNo = policySubmitResponse.getPolicySubmitResponse().getResponseBody().getBusinessNo();
                        if (StringUtils.isEmpty((CharSequence)businessNo) || businessNo.startsWith("T")) {
                            businessNo = (String)DataCompletionUtil.castToClass(String.class, map.get("businessNo"));
                        }
                        policyStatus = StringUtils.isNotEmpty((CharSequence)requestMainDTO.getOutPaymentType()) && "1".equals(mainDTO.getJFeeFlag()) ? "70" : ("1".equals(prePayFlag = policySubmitResponse.getPolicySubmitResponse().getResponseBody().getPrePayFlag()) || "0".equals(mainDTO.getJFeeFlag()) ? "70" : "60");
                    }
                } else if ("1".equals(requestMainDTO.getJFeeFlag()) && "1".equals(requestMainDTO.getStepFlag())) {
                    policySubmitResponse = this.coreInsureApi.policySubmit(this.dataCompletionUtil.packagePolicyConfirmRequestData(mainDTO, request, (String)DataCompletionUtil.castToClass(String.class, map.get("businessNo")), "P"));
                    BaseApisParamUtil.verificationResponse((StanderResponse)policySubmitResponse, (String)"policySubmitResponse");
                    businessNo = policySubmitResponse.getPolicySubmitResponse().getResponseBody().getBusinessNo();
                    if (StringUtils.isEmpty((CharSequence)businessNo) || businessNo.startsWith("T")) {
                        businessNo = (String)DataCompletionUtil.castToClass(String.class, map.get("businessNo"));
                    }
                    policyStatus = StringUtils.isNotEmpty((CharSequence)requestMainDTO.getOutPaymentType()) && "1".equals(mainDTO.getJFeeFlag()) ? "70" : ("1".equals(prePayFlag = policySubmitResponse.getPolicySubmitResponse().getResponseBody().getPrePayFlag()) || "0".equals(mainDTO.getJFeeFlag()) ? "70" : "60");
                }
                if (StringUtils.isNotEmpty((CharSequence)businessNo)) {
                    apisBusinessChannelOrder.setPolicyNo(businessNo);
                    apisBusinessChannelOrder.setPolicyTime(LocalDateTime.now());
                    if ("70".equals(policyStatus)) {
                        apisBusinessChannelOrder.setStatus("04");
                    }
                    if (ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPayPlanList()) && request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPayPlanList().size() > 1) {
                        this.dataCompletionUtil.insertInstallmentOrder(request, businessNo);
                    }
                    if (ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getIsThyriod()) && request.getQuotePriceServiceRequest().getRequestBody().getIsThyriod().booleanValue()) {
                        this.thyroidUtil.updateAddressMsg(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getFLThyroidDTO().getSerialNumber(), request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getRiskInfo(), businessNo);
                    }
                }
                ResponseHeadDTO responseHeadDTO = ResponseHeadDTO.builder().build();
                responseHeadDTO.setConsumerSeqNo(request.getQuotePriceServiceRequest().getRequestHead().getConsumerSeqNo());
                QuotePriceServiceResponseDTO responseBody = QuotePriceServiceResponseDTO.builder().build();
                if (StringUtils.isNotEmpty((CharSequence)businessNo)) {
                    responseBody.setPolicyStatus(policyStatus);
                    responseBody.setTotalPremium(sumPremium);
                    responseBody.setComCode(comCode);
                    String agencyPolicyRef = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getOrderNo();
                    responseBody.setAgencyPolicyRef(agencyPolicyRef);
                    responseBody.setBusinessNo(businessNo);
                    responseBody.setProposalNo(mainDTO.getProposalNo());
                    responseBody.setInsuredPremiumList(this.dataCompletionUtil.packagedInsuredPremiumList(request));
                    if (ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCompanyInfo())) {
                        responseBody.setCompanyInfo(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCompanyInfo());
                    }
                    if (ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPayPlanList()) && request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPayPlanList().size() > 1) {
                        responseBody.setPayPlanList(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPayPlanList());
                    }
                    responseBody.setEffectiveDate(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getStartDate());
                    responseBody.setExpireDate(request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getEndDate());
                    quotePriceServiceResponse.setResponseBody(responseBody);
                    responseHeadDTO.setStatus(1);
                    quotePriceServiceResponse.setResponseHead(responseHeadDTO);
                    this.dataCompletionUtil.insertReqMsg(request, quotePriceServiceResponse, businessNo, "2");
                    if (policyStatus.equals("70")) {
                        this.apisBusiReqmsgLogMapper.deleteApisBusiReqmsgLog(businessNo, "1");
                    }
                    break block29;
                }
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10054.getValue(), ChannelErrorCodeEnum.ERR_C10054.getKey());
            }
            catch (ApisBusinessException e) {
                String errMsg = e.getMessage();
                if (errMsg.indexOf(CLAUSE_LIABILITY_KEY_WORD) != -1) {
                    String rationCode = ((ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getGoodsCode();
                    String rationName = ((ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getGoodsName();
                    errMsg = "" + rationName + "\u3010" + rationCode + "\u3011\u4ea7\u54c1\u6b63\u5feb\u9a6c\u52a0\u97ad\u4e0a\u67b6\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8d2d\u4e70\u3002";
                }
                throw new ApisBusinessException(errMsg, e.getErrorCode());
            }
            finally {
                apisBusinessChannelOrder.setFinishedTime(LocalDateTime.now());
                if (ObjectUtil.isNotEmpty(sumPremium)) {
                    apisBusinessChannelOrder.setPremium(new BigDecimal(sumPremium));
                }
                if (ObjectUtil.isNotEmpty((Object)mainDTO.getSumAmount())) {
                    apisBusinessChannelOrder.setAmount(new BigDecimal(mainDTO.getSumAmount()));
                }
                Date startDate = new Date();
                this.dataCompletionUtil.insertApisBusinessChannelOrder(request, apisBusinessChannelOrder);
                QuotePriceDTO quotePriceDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
                if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getMain().getInRemark()) || ObjectUtil.isNotEmpty((Object)quotePriceDTO.getMain().getHandlerLoc())) {
                    this.dataCompletionUtil.insertApisBusinessChannelOrderExt(request, apisBusinessChannelOrder);
                }
                this.log.warn("\u65b0\u589e\u6e20\u9053\u8ba2\u5355\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
            }
        }
        return StanderResponse.builder().header(request.getHeader()).quotePriceServiceResponse(quotePriceServiceResponse).build();
    }

    public Map policyNoGetService(ApisBusiChannelOrder apisBusiChannelOrder, StanderRequest request, MainDTO mainDTO) throws ApisBusinessException {
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        String businessNo = "";
        if (StringUtils.isNotEmpty((CharSequence)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getPolicyRef())) {
            businessNo = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getPolicyRef();
        } else {
            StanderResponse policyNoGetResponse = this.coreInsureApi.policyNoGet(StanderRequest.builder().header(request.getHeader()).policyNoGetRequest(PolicyNoGetRequest.builder().requestHead(request.getQuotePriceServiceRequest().getRequestHead()).requestBody(PolicyNoGetRequestDTO.builder().proposalNo(mainDTO.getProposalNo()).build()).build()).build());
            BaseApisParamUtil.verificationResponse((StanderResponse)policyNoGetResponse, (String)"policyNoGetResponse");
            businessNo = policyNoGetResponse.getPolicyNoGetResponse().getResponseBody().getPrePolicyNo();
        }
        apisBusiChannelOrder.setStatus("05");
        resultMap.put("businessNo", businessNo);
        if ("1".equals(mainDTO.getJFeeFlag())) {
            resultMap.put("policyStatus", "60");
        } else {
            resultMap.put("policyStatus", "30");
        }
        this.dataCompletionUtil.insertReqMsg(request, null, businessNo, "1");
        return resultMap;
    }

    public String policyConfirm(String proposalNo, String bizType) throws ApisBusinessException {
        PolicyPaymentNotifyRequest policyPaymentNotifyRequest = PolicyPaymentNotifyRequest.builder().build();
        policyPaymentNotifyRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        policyPaymentNotifyRequest.setRequestBody(PolicyPaymentNotifyResultRequestParams.builder().businessNo(proposalNo).businessType(bizType).build());
        PolicyPaymentNotifyResult result = (PolicyPaymentNotifyResult)this.httpRequestService.convertAndSend("policyPaymentNotify", "policyPaymentNotify", (Object)policyPaymentNotifyRequest, PolicyPaymentNotifyResult.class);
        if (ObjectUtil.isNotEmpty((Object)result) && 1 == result.getResponseHead().getStatus()) {
            return result.getResponseBody().getBizNo();
        }
        this.log.error("\u7f34\u8d39\u901a\u77e5\u5931\u8d25\uff0c{}", (Object)proposalNo);
        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10054.getValue(), ChannelErrorCodeEnum.ERR_C10054.getKey());
    }

    public void validAfterQuotePrice(StanderRequest request) {
    }
}

