/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.BusinessConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CancellationInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RefundCalculateObjectDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RefundCalculateServiceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PolicyRefundConfirmQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PolicyRefundQueryRequestBodyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDetailResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.RefundCalculateServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.RefundCalculateServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.payment.RefundConfirmQueryResponseVo;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelInstallmentOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelInstallmentOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelConfigsMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class StanderRefundCalculateHandler
implements BusinessHandler {
    private static Logger log = LoggerFactory.getLogger(StanderRefundCalculateHandler.class);
    @Autowired
    private CoreInsureApi coreInsureApi;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    ApisBusiChannelInstallmentOrderService apisBusiChannelInstallmentOrderService;
    @Autowired
    ApisBusinessService apisBusinessService;
    @Autowired
    private ApisChannelConfigsMapper apisChannelConfigsMapper;
    private static final String WECHAT_OFF_CODE = "wechatOffCode";
    private static final String APP_CODE = "0";
    private static final String APP_MESSAGE = "\u6ca1\u6709\u67e5\u8be2\u51fa\u8bb0\u5f55";
    private static final String CURRENCY = "RMB";
    private static final String POLICY_STATUS_TRANS_SUCCESS = "04";
    private static final String VALUE_ADD_TYPE_CONFIG = "value_add_type_config";
    private static final String CANCEL_FLAG_A = "A";
    private static final String CANCEL_FLAG_P = "P";
    private static final String CANCEL_TYPE = "0";
    private static final String CANCEL_TYPE_ALL = "1";
    private static final String CANCEL_TYPE_CURRENT = "2";
    private static final Double FEE_RATE = 0.25;
    private static final Double OTI_FEE_RATE = 0.1;
    private static final Double NO_FEE_RATE = 0.0;
    private static final String POLICY_DETAIL_SERVICE_RESPONSE = "policyDetailResponse";
    private static final String REFUND_CALCULATE_SERVICE_REQUEST = "refundCalculateServiceRequest";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        log.warn("==============\u9000\u4fdd\u4fdd\u8d39\u8ba1\u7b97\u63a5\u53e3\u5f00\u59cb==================");
        TimeInterval timer = DateUtil.timer();
        BaseApisParamUtil.verificationRequest((StanderRequest)request, (String)"refundCalculateServiceRequest");
        PolicyDTO policyDTO = this.policyDetailConfirm(request);
        log.warn("\u9000\u4fdd\u8bd5\u7b97\u63a5\u53e3\u83b7\u53d6\u4fdd\u5355\u8be6\u60c5\u7528\u65f6:{}", (Object)timer.intervalRestart());
        request.getRefundCalculateServiceRequest().getRequestBody().setPolicyDetail(policyDTO);
        log.warn("\u9000\u4fdd\u8bd5\u7b97\u63a5\u53e3\u8bd5\u7b97\u524d :{}", (Object)JSON.toJSONString((Object)request));
        this.executeRefundCalculateBeforeProcess(request, policyDTO);
        log.warn("\u9000\u4fdd\u8bd5\u7b97\u63a5\u53e3\u8bd5\u7b97\u540e :{}", (Object)JSON.toJSONString((Object)request));
        log.warn("\u9000\u4fdd\u8bd5\u7b97\u63a5\u53e3\u53c2\u6570\u8865\u5168\u7528\u65f6:{}", (Object)timer.intervalRestart());
        return request;
    }

    public StanderRequest executeRefundCalculateBeforeProcess(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        this.checkPolicyStatus(policyDTO, request);
        this.validateRequest(request, policyDTO);
        List installmentOrderList = null;
        if (policyDTO.getMain().getPayTimes() > 1) {
            installmentOrderList = this.getInstallmentOrder(policyDTO);
        }
        this.requestDataCompletion(request, policyDTO, installmentOrderList);
        RefundCalculateObjectDTO refundCalculateObject = this.refundCalculateCompletion(request, policyDTO, installmentOrderList);
        request.getRefundCalculateServiceRequest().getRequestBody().setRefundCalculateObject(refundCalculateObject);
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        RefundCalculateServiceResponse refundCalculateResponse;
        TimeInterval timer = DateUtil.timer();
        try {
            refundCalculateResponse = this.refundCalculate(request);
            log.warn("\u6267\u884c\u9000\u4fdd\u8bd5\u7b97\u7528\u65f6:{}", (Object)timer.intervalRestart());
        }
        catch (Exception e) {
            log.error("error:", (Throwable)e);
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10197.getValue(), ChannelErrorCodeEnum.ERR_C10197.getKey());
        }
        return StanderResponse.builder().header(request.getHeader()).refundCalculateResponse(refundCalculateResponse).build();
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) {
        PolicyDTO policyDetail;
        log.warn("\u9000\u4fdd\u8bd5\u7b97\u63a5\u53e3\u8ba1\u7b97\u540e :{}", (Object)JSON.toJSONString((Object)response));
        RefundCalculateServiceResponseDTO responseBody = response.getRefundCalculateResponse().getResponseBody();
        Double premium = request.getRefundCalculateServiceRequest().getRequestBody().getRefundCalculateObject().getPremium();
        BigDecimal refundPremium = responseBody.getRefundPremium();
        if (responseBody.getInstallRefundPremium() != null && responseBody.getInstallRefundPremium().compareTo(BigDecimal.ZERO) != 0) {
            refundPremium = responseBody.getInstallRefundPremium();
        }
        Double policyChgPremium = ObjectUtil.isEmpty((Object)(policyDetail = request.getRefundCalculateServiceRequest().getRequestBody().getPolicyDetail()).getMain().getChgPemium()) ? 0.0 : policyDetail.getMain().getChgPemium();
        Double chgPremium = policyChgPremium + refundPremium.doubleValue();
        responseBody.setChgPremium(new BigDecimal(chgPremium).setScale(2, RoundingMode.HALF_UP));
        if ("SSP_USER".equals(request.getHeader().getUserCode()) && "1".equals(this.getWeChatOffCode())) {
            this.refundQueryConfirm(responseBody, policyDetail);
        }
        if (refundPremium.doubleValue() > 1000.0 || chgPremium > 10000.0) {
            responseBody.setNeedUploadIDFile("Y");
        } else {
            responseBody.setNeedUploadIDFile("N");
        }
        if (refundPremium.doubleValue() > 1000.0 || chgPremium > 10000.0) {
            responseBody.setNeedUploadIDFileForRefundTotal("Y");
        } else {
            responseBody.setNeedUploadIDFileForRefundTotal("N");
        }
        return response;
    }

    private void checkPolicyStatus(PolicyDTO policyDTO, StanderRequest request) throws ApisBusinessException {
        if ("2".equals(policyDTO.getMain().getPolicyStatus())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10127.getValue(), ChannelErrorCodeEnum.ERR_C10127.getKey());
        }
        String userCode = policyDTO.getMain().getOperateCode();
        String rationCode = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        ApisChannelConfigs noRefundAllowed = new ApisChannelConfigs();
        noRefundAllowed.setUserCode(userCode);
        noRefundAllowed.setRationCode(rationCode);
        noRefundAllowed.setConfigCode("no_refund_allowed");
        noRefundAllowed.setDeleted(ApisChannelConfigs.DELETE_FLAG_FALSE);
        noRefundAllowed = this.apisChannelConfigsService.getChannelConfig(noRefundAllowed);
        if (ObjectUtil.isNotEmpty((Object)noRefundAllowed)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10307.getValue(), ChannelErrorCodeEnum.ERR_C10307.getKey());
        }
        ApisChannelConfigs selfHelpPlatform = this.dataCompletionUtil.getConfig(request.getHeader().getUserCode(), "self_help_platform");
        boolean isSelfHelpPlatform = ObjectUtil.isNotEmpty((Object)selfHelpPlatform);
        if ("1".equals(policyDTO.getMain().getJFeeFlag()) && policyDTO.getMain().getPayTimes() > 1 && !isSelfHelpPlatform) {
            log.error("\u6682\u4e0d\u652f\u6301\u6b64\u7c7b\u4e1a\u52a1\u9000\u4fdd\uff01");
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10485.getValue(), ChannelErrorCodeEnum.ERR_C10485.getKey());
        }
    }

    private RefundCalculateObjectDTO refundCalculateCompletion(StanderRequest request, PolicyDTO policyDTO, List<ApisBusiChannelInstallmentOrder> installmentOrderList) throws ApisBusinessException {
        RefundCalculateObjectDTO refundCalculateObject = RefundCalculateObjectDTO.builder().build();
        MainDTO main = policyDTO.getMain();
        refundCalculateObject.setPolicyNo(main.getPolicyNo());
        refundCalculateObject.setPolicyStatus(main.getPolicyStatus());
        refundCalculateObject.setPayTimes(main.getPayTimes());
        refundCalculateObject.setStartDate(main.getStartDate());
        refundCalculateObject.setEndDate(main.getEndDate());
        refundCalculateObject.setJFeeFlag(main.getJFeeFlag());
        refundCalculateObject.setRiskCode(main.getRiskCode());
        refundCalculateObject.setPremium(main.getSumPremium());
        refundCalculateObject.setChannelCode(policyDTO.getSalesList().getAgentCode());
        refundCalculateObject.setClassCode(main.getClassCode());
        if (ObjectUtil.isNotEmpty((Object)policyDTO.getCoverage()) && ObjectUtil.isNotEmpty((Object)policyDTO.getCoverage().getItemList())) {
            ItemMainDTO itemMainDTO = (ItemMainDTO)policyDTO.getCoverage().getItemList().get(0);
            refundCalculateObject.setPlanCode(itemMainDTO.getPlanCode());
            refundCalculateObject.setGoodsCode(itemMainDTO.getGoodsCode());
        }
        Double feeRate = this.getFeeRate(request, policyDTO);
        refundCalculateObject.setFeeRate(feeRate);
        this.getPayFeeInfo(request, policyDTO, refundCalculateObject, installmentOrderList);
        return refundCalculateObject;
    }

    private void checkCancelEffFlag(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        String cancelType = request.getRefundCalculateServiceRequest().getRequestBody().getCancellationInfo().getCancelType();
        String riskCode = policyDTO.getMain().getRiskCode();
        String userCode = policyDTO.getMain().getOperateCode();
        Integer payTimes = policyDTO.getMain().getPayTimes();
        String classCode = policyDTO.getMain().getClassCode();
        String rationCode = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        CancellationInfoDTO cancellationInfo = request.getRefundCalculateServiceRequest().getRequestBody().getCancellationInfo();
        if ("1".equals(cancelType)) {
            ApisChannelConfigs selfHelpPlatform = new ApisChannelConfigs();
            selfHelpPlatform.setUserCode(userCode);
            selfHelpPlatform.setConfigCode("self_help_platform");
            selfHelpPlatform.setDeleted(ApisChannelConfigs.DELETE_FLAG_FALSE);
            selfHelpPlatform = this.apisChannelConfigsService.getChannelConfig(selfHelpPlatform);
            if (ObjectUtil.isNotEmpty((Object)selfHelpPlatform) && ("07".equals(classCode) || "09".equals(classCode))) {
                if ("P070002".equals(riskCode)) {
                    if (!"\u4e0d\u7b26\u5408\u5065\u5eb7\u544a\u77e5".equals(cancellationInfo.getReasonRemark())) {
                        throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B90001.getValue(), ErrorBisCodeEnum.ERR_B90001.getKey());
                    }
                } else if (!"\u7b7e\u8bc1\u62d2\u7b7e".equals(cancellationInfo.getReasonRemark())) {
                    throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B90002.getValue(), ErrorBisCodeEnum.ERR_B90002.getKey());
                }
            }
        }
    }

    private void getPayFeeInfo(StanderRequest request, PolicyDTO policy, RefundCalculateObjectDTO refundCalculateObject, List<ApisBusiChannelInstallmentOrder> installmentOrderList) throws ApisBusinessException {
        Double residualPremium = 0.0;
        Double currentPremium = 0.0;
        Double realPremium = 0.0;
        Double unpaidPremium = 0.0;
        Date planStartDate = null;
        Date planEndDate = null;
        Integer payTimes = policy.getMain().getPayTimes();
        Date cancelDate = request.getRefundCalculateServiceRequest().getRequestBody().getPolicy().getCancelDate();
        if (payTimes <= 1) {
            realPremium = policy.getMain().getSumPremium();
        } else {
            String jFeeFlag = refundCalculateObject.getJFeeFlag();
            String userCode = request.getHeader().getUserCode();
            ApisChannelConfigs selfHelpPlatform = this.dataCompletionUtil.getConfig(userCode, "self_help_platform");
            boolean isSelfHelpPlatform = ObjectUtil.isNotEmpty((Object)selfHelpPlatform);
            if ("1".equals(jFeeFlag) && !isSelfHelpPlatform) {
                log.error("\u6682\u4e0d\u652f\u6301\u6b64\u7c7b\u4e1a\u52a1\u9000\u4fdd\uff01");
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10485.getValue(), ChannelErrorCodeEnum.ERR_C10485.getKey());
            }
            for (ApisBusiChannelInstallmentOrder order : installmentOrderList) {
                if (ObjectUtil.isNotEmpty((Object)order.getPayTime()) && (StringUtils.isBlank((CharSequence)order.getPayStatus()) || "SUCCESS".equals(order.getPayStatus()))) {
                    realPremium = realPremium + order.getCurrentPremium().doubleValue();
                    Date orderStartDate = Date.from(order.getStartDate().toInstant(ZoneOffset.of("+8")));
                    Date orderEndDate = Date.from(order.getEndDate().toInstant(ZoneOffset.of("+8")));
                    if (orderStartDate.getTime() < cancelDate.getTime() && orderEndDate.getTime() > cancelDate.getTime()) {
                        currentPremium = order.getCurrentPremium().doubleValue();
                        planStartDate = orderStartDate;
                        planEndDate = orderEndDate;
                        continue;
                    }
                    if (orderStartDate.getTime() < cancelDate.getTime()) continue;
                    residualPremium = residualPremium + order.getCurrentPremium().doubleValue();
                    continue;
                }
                unpaidPremium = unpaidPremium + order.getCurrentPremium().doubleValue();
            }
            if (currentPremium > 0.0 && "P".equals(request.getRefundCalculateServiceRequest().getRequestBody().getCancellationInfo().getCancelFlag())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10450.getValue(), ChannelErrorCodeEnum.ERR_C10450.getKey());
            }
        }
        refundCalculateObject.setRealPremium(realPremium);
        refundCalculateObject.setUnpaidPremium(unpaidPremium);
        refundCalculateObject.setCurrentPremium(currentPremium);
        refundCalculateObject.setResidualPremium(residualPremium);
        refundCalculateObject.setPlanStartDate(planStartDate);
        refundCalculateObject.setPlanEndDate(planEndDate);
    }

    private List<ApisBusiChannelInstallmentOrder> getInstallmentOrder(PolicyDTO policyDTO) throws ApisBusinessException {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"policy_no", (Object)policyDTO.getMain().getPolicyNo());
        queryWrapper.eq((Object)"deleted", (Object)ApisBusiChannelInstallmentOrder.DELETE_FLAG_FALSE);
        List list = this.apisBusiChannelInstallmentOrderService.list((Wrapper)queryWrapper);
        if (ObjectUtil.isEmpty((Object)list)) {
            throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B11002.getValue(), ErrorBisCodeEnum.ERR_B11002.getKey());
        }
        return list;
    }

    private void requestDataCompletion(StanderRequest request, PolicyDTO policyDTO, List<ApisBusiChannelInstallmentOrder> installmentOrder) {
        ApisChannelConfigs selfHelpPlatform;
        RefundCalculateServiceRequestDTO requestBody = request.getRefundCalculateServiceRequest().getRequestBody();
        CancellationInfoDTO cancellationInfo = requestBody.getCancellationInfo();
        if (ObjectUtil.isEmpty((Object)requestBody.getCancellationInfo().getCancelFlag())) {
            requestBody.getCancellationInfo().setCancelFlag("A");
        }
        String userCode = policyDTO.getMain().getOperateCode();
        String rationCode = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        String classCode = policyDTO.getMain().getClassCode();
        Integer payTimes = policyDTO.getMain().getPayTimes();
        String riskCode = policyDTO.getMain().getRiskCode();
        ApisChannelConfigs cancelEffPolicy = this.dataCompletionUtil.getConfig(userCode, "cancel_eff_policy", rationCode);
        boolean isAll = true;
        if (ObjectUtil.isNotEmpty((Object)cancelEffPolicy) && ObjectUtil.isNotEmpty((Object)cancelEffPolicy.getConfigValue())) {
            int graceDay = Integer.valueOf(cancelEffPolicy.getConfigValue());
            Date graceDate = new Date(policyDTO.getMain().getStartDate().getTime());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(graceDate);
            calendar.add(5, graceDay);
            graceDate = calendar.getTime();
            if (this.getCancelDate(request, policyDTO).getTime() >= graceDate.getTime()) {
                isAll = false;
                log.warn("\u547d\u4e2d\u5168\u989d\u9000\u6b3e");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)cancelEffPolicy) && isAll) {
            requestBody.getCancellationInfo().setCancelType("1");
        } else if (ObjectUtil.isEmpty((Object)requestBody.getCancellationInfo().getCancelType())) {
            requestBody.getCancellationInfo().setCancelType("0");
        }
        if (("07".equals(classCode) || "09".equals(classCode)) && payTimes <= 1 && ObjectUtil.isNotEmpty((Object)(selfHelpPlatform = this.dataCompletionUtil.getConfig(request.getHeader().getUserCode(), "self_help_platform")))) {
            if ("P070002".equals(riskCode)) {
                if ("\u4e0d\u7b26\u5408\u5065\u5eb7\u544a\u77e5".equals(cancellationInfo.getReasonRemark())) {
                    requestBody.getCancellationInfo().setCancelType("1");
                }
            } else if ("\u7b7e\u8bc1\u62d2\u7b7e".equals(cancellationInfo.getReasonRemark())) {
                requestBody.getCancellationInfo().setCancelType("1");
            }
        }
        Date cancelDate = this.cancelDateProcess(request, policyDTO, installmentOrder);
        request.getRefundCalculateServiceRequest().getRequestBody().getPolicy().setCancelDate(cancelDate);
    }

    private Date getCancelDate(StanderRequest request, PolicyDTO policyDTO) {
        int payTime = policyDTO.getMain().getPayTimes();
        Date cancelDate = request.getRefundCalculateServiceRequest().getRequestBody().getPolicy().getCancelDate();
        if (ObjectUtil.isNotEmpty((Object)cancelDate)) {
            ApisChannelConfigs refundCancelDate;
            if (payTime == 1 && ObjectUtil.isEmpty((Object)(refundCancelDate = this.dataCompletionUtil.getConfig(policyDTO.getMain().getOperateCode(), "refund_cancelDate")))) {
                cancelDate = new Date();
            }
        } else {
            cancelDate = new Date();
        }
        return cancelDate;
    }

    private Date cancelDateProcess(StanderRequest request, PolicyDTO policyDTO, List<ApisBusiChannelInstallmentOrder> installmentOrderList) {
        String cancelType = request.getRefundCalculateServiceRequest().getRequestBody().getCancellationInfo().getCancelType();
        String cancelFlag = request.getRefundCalculateServiceRequest().getRequestBody().getCancellationInfo().getCancelFlag();
        int payTime = policyDTO.getMain().getPayTimes();
        Date startDate = policyDTO.getMain().getStartDate();
        Date cancelDate = request.getRefundCalculateServiceRequest().getRequestBody().getPolicy().getCancelDate();
        if (ObjectUtil.isNotEmpty((Object)cancelDate)) {
            ApisChannelConfigs refundCancelDate;
            if (payTime == 1 && ObjectUtil.isEmpty((Object)(refundCancelDate = this.dataCompletionUtil.getConfig(policyDTO.getMain().getOperateCode(), "refund_cancelDate")))) {
                cancelDate = new Date();
            }
        } else {
            cancelDate = new Date();
        }
        if ("A".equals(cancelFlag)) {
            if (cancelDate.getTime() <= startDate.getTime()) {
                return startDate;
            }
            if ("1".equals(cancelType)) {
                return startDate;
            }
            if ("2".equals(cancelType)) {
                if (payTime > 1) {
                    for (ApisBusiChannelInstallmentOrder order : installmentOrderList) {
                        Date orderStartDate = Date.from(order.getStartDate().toInstant(ZoneOffset.of("+8")));
                        Date orderEndDate = Date.from(order.getEndDate().toInstant(ZoneOffset.of("+8")));
                        if (orderStartDate.getTime() > cancelDate.getTime() || orderEndDate.getTime() <= cancelDate.getTime()) continue;
                        return orderStartDate;
                    }
                } else {
                    return startDate;
                }
            }
        }
        return cancelDate;
    }

    private void validateRequest(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        this.validatePolicy(request, policyDTO);
        this.validateCancellationInfo(request, policyDTO);
    }

    private void validateCancellationInfo(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        if (ObjectUtil.isNotEmpty((Object)request.getRefundCalculateServiceRequest().getRequestBody().getCancellationInfo())) {
            CancellationInfoDTO cancellationInfo = request.getRefundCalculateServiceRequest().getRequestBody().getCancellationInfo();
            if (ObjectUtil.isEmpty((Object)cancellationInfo.getCancelFlag())) {
                if (policyDTO.getMain().getPayTimes() > 1) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10338.getValue(), ChannelErrorCodeEnum.ERR_C10338.getKey());
                }
            } else if (!"A".equals(cancellationInfo.getCancelFlag()) && !"P".equals(cancellationInfo.getCancelFlag())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10340.getValue(), ChannelErrorCodeEnum.ERR_C10340.getKey());
            }
            if (ObjectUtil.isNotEmpty((Object)cancellationInfo.getCancelType())) {
                if (("1".equals(cancellationInfo.getCancelType()) || "2".equals(cancellationInfo.getCancelType())) && "P".equals(cancellationInfo.getCancelFlag())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10345.getValue(), ChannelErrorCodeEnum.ERR_C10345.getKey());
                }
                if ("2".equals(cancellationInfo.getCancelType()) && policyDTO.getMain().getPayTimes() == 1) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10451.getValue(), ChannelErrorCodeEnum.ERR_C10451.getKey());
                }
            }
        } else if (policyDTO.getMain().getPayTimes() > 1) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10338.getValue(), ChannelErrorCodeEnum.ERR_C10338.getKey());
        }
    }

    private void validatePolicy(StanderRequest request, PolicyDTO policyDTO) throws ApisBusinessException {
        MainDTO main = policyDTO.getMain();
        Date endDate = policyDTO.getMain().getEndDate();
        Date cancelDate = request.getRefundCalculateServiceRequest().getRequestBody().getPolicy().getCancelDate();
        if (ObjectUtil.isNotEmpty((Object)cancelDate) && cancelDate.getTime() >= endDate.getTime()) {
            throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B11001.getValue(), ErrorBisCodeEnum.ERR_B11001.getKey());
        }
    }

    private PolicyDTO policyDetailConfirm(StanderRequest request) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)request.getRefundCalculateServiceRequest().getRequestBody()) || ObjectUtil.isEmpty((Object)request.getRefundCalculateServiceRequest().getRequestBody().getPolicy()) || ObjectUtil.isEmpty((Object)request.getRefundCalculateServiceRequest().getRequestBody().getPolicy().getPolicyRef())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u3010\u4fdd\u5355\u53f7\u3011"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        String userCode = request.getHeader().getUserCode();
        PolicyDetailServiceRequest policyDetailServiceRequest = PolicyDetailServiceRequest.builder().build();
        String policyNo = request.getRefundCalculateServiceRequest().getRequestBody().getPolicy().getPolicyRef();
        log.warn("\u9000\u4fdd\u4fdd\u8d39\u8ba1\u7b97\u63a5\u53e3\u300b\u300b\u300b\u4fdd\u5355\u53f7\uff1a{}", (Object)policyNo);
        PolicyDetailRequestDTO policyDetailRequestDTO = PolicyDetailRequestDTO.builder().policyNo(policyNo).businessNature2("all").operateCode(userCode).build();
        policyDetailServiceRequest.setRequestBody(policyDetailRequestDTO);
        policyDetailServiceRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        request.setPolicyDetailServiceRequest(policyDetailServiceRequest);
        StanderResponse standerResponse = this.apisBusinessService.execute("policyDetail", request);
        BaseApisParamUtil.verificationResponse((StanderResponse)standerResponse, (String)"policyDetailResponse");
        PolicyDetailResponse policyDetailResponse = standerResponse.getPolicyDetailResponse();
        String appCode = policyDetailResponse.getResponseHead().getAppCode();
        String appMessage = policyDetailResponse.getResponseHead().getAppMessage();
        if (1 != policyDetailResponse.getResponseHead().getStatus() || ObjectUtil.isEmpty((Object)policyDetailResponse.getResponseBody().getPolicy()) || ObjectUtil.isEmpty((Object)policyDetailResponse.getResponseBody().getPolicy().getMain())) {
            throw new ApisBusinessException(appMessage, appCode);
        }
        return policyDetailResponse.getResponseBody().getPolicy();
    }

    public RefundCalculateServiceResponse refundCalculate(StanderRequest request) throws ApisBusinessException {
        double refundPremium;
        int payTimes = request.getRefundCalculateServiceRequest().getRequestBody().getRefundCalculateObject().getPayTimes();
        String policyNo = request.getRefundCalculateServiceRequest().getRequestBody().getPolicy().getPolicyRef();
        Date cancelDate = request.getRefundCalculateServiceRequest().getRequestBody().getPolicy().getCancelDate();
        RefundCalculateServiceResponse refundCalculateResponse = RefundCalculateServiceResponse.builder().build();
        RefundCalculateServiceResponseDTO refundCalculate = RefundCalculateServiceResponseDTO.builder().build();
        if (payTimes <= 1) {
            refundPremium = this.noSagesPremiumCalculation(request);
            refundCalculate.setRefundPremium(new BigDecimal(refundPremium).setScale(2, 4));
        } else {
            refundPremium = this.sagesPremiumCalculation(request);
            refundCalculate.setInstallRefundPremium(new BigDecimal(refundPremium).setScale(2, 4));
            double unpaidPremium = request.getRefundCalculateServiceRequest().getRequestBody().getRefundCalculateObject().getUnpaidPremium();
            refundCalculate.setRefundPremium(refundCalculate.getInstallRefundPremium().add(new BigDecimal(unpaidPremium)).setScale(2, 4));
        }
        if (refundPremium < 0.0) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10197.getValue(), ChannelErrorCodeEnum.ERR_C10197.getKey());
        }
        refundCalculate.setPolicyRef(policyNo);
        refundCalculate.setCancelDate(cancelDate);
        refundCalculateResponse.setResponseBody(refundCalculate);
        return refundCalculateResponse;
    }

    private Double getFeeRate(StanderRequest request, PolicyDTO policy) {
        Date startDate = policy.getMain().getStartDate();
        String riskCode = policy.getMain().getRiskCode();
        String userCode = policy.getMain().getOperateCode();
        String rationCode = ((ItemMainDTO)policy.getCoverage().getItemList().get(0)).getGoodsCode();
        Date cancelDate = request.getRefundCalculateServiceRequest().getRequestBody().getPolicy().getCancelDate();
        if (cancelDate.getTime() <= startDate.getTime()) {
            return NO_FEE_RATE;
        }
        double feeRate = 0.0;
        String jFeeFlag = policy.getMain().getJFeeFlag();
        Integer payTimes = policy.getMain().getPayTimes();
        ApisChannelConfigs refundWithoutCharge = new ApisChannelConfigs();
        refundWithoutCharge.setUserCode(userCode);
        refundWithoutCharge.setRationCode(rationCode);
        refundWithoutCharge.setConfigCode("REFUND_WITHOUT_CHARGE");
        refundWithoutCharge.setDeleted(ApisChannelConfigs.DELETE_FLAG_FALSE);
        refundWithoutCharge = this.apisChannelConfigsService.getChannelConfig(refundWithoutCharge);
        if (ObjectUtil.isNotEmpty((Object)refundWithoutCharge)) {
            return 0.0;
        }
        ApisChannelConfigs refundChargeRate = new ApisChannelConfigs();
        refundChargeRate.setUserCode(userCode);
        refundChargeRate.setRationCode(rationCode);
        refundChargeRate.setConfigCode("REFUND_CHARGE_RATE");
        refundChargeRate.setDeleted(ApisChannelConfigs.DELETE_FLAG_FALSE);
        refundChargeRate = this.apisChannelConfigsService.getChannelConfig(refundChargeRate);
        if (refundChargeRate != null && refundChargeRate.getConfigValue() != null) {
            feeRate = Double.parseDouble(refundChargeRate.getConfigValue());
        } else {
            boolean isAccidentAndHealth;
            String classCode = policy.getMain().getClassCode();
            boolean isDrivingAccident = "P070008".equals(riskCode);
            boolean bl = isAccidentAndHealth = ("07".equals(classCode) || "09".equals(classCode)) && !isDrivingAccident;
            feeRate = isAccidentAndHealth ? OTI_FEE_RATE : ("P090001".equals(riskCode) ? NO_FEE_RATE.doubleValue() : FEE_RATE.doubleValue());
        }
        return feeRate;
    }

    public Double sagesPremiumCalculation(StanderRequest request) throws ApisBusinessException {
        Double refundPremium = 0.0;
        RefundCalculateObjectDTO refundCalculateObject = request.getRefundCalculateServiceRequest().getRequestBody().getRefundCalculateObject();
        CancellationInfoDTO cancellationInfo = request.getRefundCalculateServiceRequest().getRequestBody().getCancellationInfo();
        Date cancelDate = request.getRefundCalculateServiceRequest().getRequestBody().getPolicy().getCancelDate();
        Date startDate = refundCalculateObject.getStartDate();
        Date planStartDate = refundCalculateObject.getPlanStartDate();
        Date planEndDate = refundCalculateObject.getPlanEndDate();
        Double realPremium = refundCalculateObject.getRealPremium();
        Double currentPremium = refundCalculateObject.getCurrentPremium();
        Double residualPremium = refundCalculateObject.getResidualPremium();
        Double feeRate = refundCalculateObject.getFeeRate();
        if (cancelDate.getTime() <= startDate.getTime()) {
            return realPremium;
        }
        if (realPremium <= 0.0) {
            return refundPremium;
        }
        if (ObjectUtil.isEmpty((Object)planStartDate) && ObjectUtil.isEmpty((Object)planEndDate)) {
            return residualPremium;
        }
        if ("A".equals(cancellationInfo.getCancelFlag())) {
            refundPremium = "1".equals(cancellationInfo.getCancelType()) ? realPremium : ("2".equals(cancellationInfo.getCancelType()) ? Double.valueOf(currentPremium + residualPremium) : StanderRefundCalculateHandler.sagesStanderCalculate((double)currentPremium, (double)residualPremium, (Date)planStartDate, (Date)planEndDate, (Date)cancelDate, (double)feeRate));
        } else if ("P".equals(cancellationInfo.getCancelFlag())) {
            refundPremium = StanderRefundCalculateHandler.sagesStanderCalculate((double)currentPremium, (double)residualPremium, (Date)planStartDate, (Date)planEndDate, (Date)cancelDate, (double)feeRate);
        }
        return refundPremium;
    }

    public Double noSagesPremiumCalculation(StanderRequest request) throws ApisBusinessException {
        Double refundPremium = 0.0;
        RefundCalculateObjectDTO refundCalculateObject = request.getRefundCalculateServiceRequest().getRequestBody().getRefundCalculateObject();
        CancellationInfoDTO cancellationInfo = request.getRefundCalculateServiceRequest().getRequestBody().getCancellationInfo();
        Date cancelDate = request.getRefundCalculateServiceRequest().getRequestBody().getPolicy().getCancelDate();
        String riskCode = refundCalculateObject.getRiskCode();
        Date startDate = refundCalculateObject.getStartDate();
        Date endDate = refundCalculateObject.getEndDate();
        Double realPremium = refundCalculateObject.getRealPremium();
        Double feeRate = refundCalculateObject.getFeeRate();
        if (realPremium <= 0.0) {
            return refundPremium;
        }
        if ("1".equals(cancellationInfo.getCancelType())) {
            return realPremium;
        }
        refundPremium = Arrays.asList(BusinessConstants.NO_SAGES_RISK_CODE).contains(riskCode) ? StanderRefundCalculateHandler.noSagesStanderCalculate((double)realPremium, (Date)startDate, (Date)endDate, (Date)cancelDate) : ("P070006".equals(riskCode) || "P070004".equals(riskCode) ? StanderRefundCalculateHandler.travelCalculate((double)realPremium, (Date)cancelDate, (Date)endDate) : ("P070002".equals(riskCode) || "P070005".equals(riskCode) ? StanderRefundCalculateHandler.noSagesStanderCalculate((double)realPremium, (Date)startDate, (Date)endDate, (Date)cancelDate, (double)feeRate) : StanderRefundCalculateHandler.noSagesStanderCalculate((double)realPremium, (Date)startDate, (Date)endDate, (Date)cancelDate, (double)feeRate)));
        if (cancelDate.getTime() <= startDate.getTime()) {
            refundPremium = realPremium;
        }
        refundPremium = this.valueAddTypehandl(request, refundPremium, realPremium);
        return refundPremium;
    }

    private static Double travelCalculate(double realPremium, Date cancelDate, Date endDate) {
        int days = StanderRefundCalculateHandler.betweenDays((Date)cancelDate, (Date)endDate, (boolean)false);
        double refundPremium = days >= 300 ? realPremium * 0.6 : (days >= 270 ? realPremium * 0.5 : (days >= 240 ? realPremium * 0.4 : (days >= 210 ? realPremium * 0.3 : (days >= 180 ? realPremium * 0.25 : 0.0))));
        return refundPremium;
    }

    public static Double noSagesStanderCalculate(double premium, Date startDate, Date endDate, Date cancelDate, double feeRate) {
        double days = StanderRefundCalculateHandler.betweenDays((Date)startDate, (Date)endDate, (boolean)true);
        double pastDay = StanderRefundCalculateHandler.betweenDays((Date)startDate, (Date)cancelDate, (boolean)true);
        return premium * (1.0 - pastDay / days) * (1.0 - feeRate);
    }

    public static Double noSagesStanderCalculate(double premium, Date startDate, Date endDate, Date cancelDate) {
        double days = StanderRefundCalculateHandler.betweenDays((Date)startDate, (Date)endDate, (boolean)true);
        double pastDay = StanderRefundCalculateHandler.betweenDays((Date)startDate, (Date)cancelDate, (boolean)true);
        return premium * (1.0 - pastDay / days);
    }

    public static Double sagesStanderCalculate(double premium, double residualPremium, Date startDate, Date endDate, Date cancelDate, double feeRate) {
        double days = StanderRefundCalculateHandler.betweenDays((Date)startDate, (Date)endDate, (boolean)true);
        double pastDay = StanderRefundCalculateHandler.betweenDays((Date)startDate, (Date)cancelDate, (boolean)true);
        return premium * (1.0 - pastDay / days) * (1.0 - feeRate) + residualPremium;
    }

    public static Double petCalculate(double premium, Date cancelDate, Date endDate) {
        double refundPremium;
        endDate = DateUtil.offset((Date)endDate, (DateField)DateField.MINUTE, (int)1);
        int month = (int)DateUtil.betweenMonth((Date)cancelDate, (Date)endDate, (boolean)false);
        switch (month) {
            case 1: {
                refundPremium = premium * 0.1;
                break;
            }
            case 2: {
                refundPremium = premium * 0.2;
                break;
            }
            case 3: {
                refundPremium = premium * 0.3;
                break;
            }
            case 4: {
                refundPremium = premium * 0.4;
                break;
            }
            case 5: {
                refundPremium = premium * 0.5;
                break;
            }
            case 6: {
                refundPremium = premium * 0.6;
                break;
            }
            case 7: {
                refundPremium = premium * 0.7;
                break;
            }
            case 8: {
                refundPremium = premium * 0.8;
                break;
            }
            case 9: {
                refundPremium = premium * 0.85;
                break;
            }
            case 10: {
                refundPremium = premium * 0.9;
                break;
            }
            case 11: {
                refundPremium = premium * 0.95;
                break;
            }
            case 12: {
                refundPremium = premium * 1.0;
                break;
            }
            default: {
                refundPremium = 0.0;
            }
        }
        return refundPremium;
    }

    public static int betweenDays(Date startDate, Date endDate, boolean isCeil) {
        double days = (double)(endDate.getTime() - startDate.getTime()) / (double)DateUnit.DAY.getMillis();
        if (isCeil) {
            days = Math.ceil(days);
        }
        return (int)days;
    }

    private void refundQueryConfirm(RefundCalculateServiceResponseDTO response, PolicyDTO policyDTO) {
        PolicyRefundConfirmQueryRequest policyRefundQueryRequest = new PolicyRefundConfirmQueryRequest();
        policyRefundQueryRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        PolicyRefundQueryRequestBodyDTO bodyDTO = PolicyRefundQueryRequestBodyDTO.builder().build();
        bodyDTO.setPolicyNo(policyDTO.getMain().getPolicyNo());
        policyRefundQueryRequest.setRefundQueryBody(bodyDTO);
        try {
            RefundConfirmQueryResponseVo responseVo = this.coreInsureApi.refundQueryConfirm(policyRefundQueryRequest);
            if (ObjectUtil.isNotEmpty((Object)responseVo) && ObjectUtil.isNotEmpty((Object)responseVo.getResponseBody())) {
                response.setPayWay(responseVo.getResponseBody().getPayWay());
                response.setFlag(responseVo.getResponseBody().getFlag());
                response.setRemark(responseVo.getResponseBody().getRemark());
            }
        }
        catch (Exception e) {
            log.error("\u9000\u4fdd\u8ba1\u7b97{}\u8c03\u7528\u6536\u4ed8\u539f\u8def\u9000\u6b3e\u67e5\u8be2\u786e\u8ba4\u63a5\u53e3\u62a5\u9519\uff1a", (Object)policyDTO.getMain().getPolicyNo(), (Object)e);
        }
    }

    private double valueAddTypehandl(StanderRequest request, Double refundPremium, Double realPremium) throws ApisBusinessException {
        if (request.getRefundCalculateServiceRequest().getRequestBody().getPolicyDetail() == null) {
            if (request.getPolicyDetail() != null) {
                request.getRefundCalculateServiceRequest().getRequestBody().setPolicyDetail(request.getPolicyDetail());
            } else {
                PolicyDTO policyDTO = this.policyDetailConfirm(request);
                request.getRefundCalculateServiceRequest().getRequestBody().setPolicyDetail(policyDTO);
            }
        }
        List itemMainDTOS = request.getRefundCalculateServiceRequest().getRequestBody().getPolicyDetail().getCoverage().getItemList();
        String riskCode = request.getRefundCalculateServiceRequest().getRequestBody().getPolicyDetail().getMain().getRiskCode();
        List configs = this.getValueAddTypeConfig(riskCode);
        if (configs == null || configs.size() == 0) {
            return refundPremium;
        }
        try {
            if (ObjectUtils.isNotEmpty((Object)itemMainDTOS) && itemMainDTOS.size() > 0) {
                for (ItemMainDTO itemMainDTO : itemMainDTOS) {
                    String[] valueaddTypeArr;
                    String valueAddServiceFlag = itemMainDTO.getValueAddServiceFlag();
                    String valueaddType = itemMainDTO.getValueaddType();
                    if (!StringUtils.isNotBlank((CharSequence)valueAddServiceFlag) || !"1".equals(valueAddServiceFlag) || !StringUtils.isNotBlank((CharSequence)valueaddType)) continue;
                    for (String valueaddTypeSub : valueaddTypeArr = valueaddType.split(",")) {
                        for (ApisChannelConfigs config : configs) {
                            if (!valueaddTypeSub.equals(config.getRationCode())) continue;
                            log.warn("\u589e\u503c\u670d\u52a1\u7c7b\u578b{}\u5339\u914d,\u9000\u4fdd\u989d\u5916\u6263\u8d39 {}", (Object)valueaddTypeSub, (Object)(Double.valueOf(config.getConfigValue()) * 100.0 + "%"));
                            if (!((refundPremium = Double.valueOf(refundPremium - realPremium * Double.valueOf(config.getConfigValue()))) < 0.0)) continue;
                            refundPremium = 0.0;
                        }
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            log.error("\u9000\u4fdd\u8ba1\u7b97\u589e\u503c\u670d\u52a1\u914d\u7f6e\u9519\u8bef,\u8bf7\u68c0\u67e5", (Throwable)e);
        }
        return refundPremium;
    }

    public String getWeChatOffCode() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"config_code", (Object)"wechatOffCode");
        ApisChannelConfigs configs = (ApisChannelConfigs)this.apisChannelConfigsMapper.selectOne((Wrapper)queryWrapper);
        if (configs == null) {
            return "0";
        }
        return configs.getConfigValue();
    }

    public List<ApisChannelConfigs> getValueAddTypeConfig(String riskCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"config_code", (Object)"value_add_type_config");
        queryWrapper.eq((Object)"deleted", (Object)ApisChannelConfigs.DELETE_FLAG_FALSE);
        queryWrapper.eq((Object)"value_type", (Object)riskCode);
        List configs = this.apisChannelConfigsMapper.selectList((Wrapper)queryWrapper);
        return configs;
    }
}

