/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.lang.UUID;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.ExaminatInfomationUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PolicyRefundConfirmQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.PolicyRefundQueryRequestBodyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.payment.RefundConfirmQueryResponseVo;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderRefundQueryHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderRefundQueryHandler.class);
    @Autowired
    private CoreInsureApi coreInsureApi;
    @Autowired
    private ExaminatInfomationUtil examinatInfomationUtil;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        request.getHeader().setBusinessKey(UUID.fastUUID().toString().replaceAll("-", ""));
        this.verifyNull(request);
        this.examinatInfomationUtil.verifPolicy(request, request.getOriginalRefundQuerytRequest().getPolicyNo(), request.getHeader().getUserCode());
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        String policyNo = request.getOriginalRefundQuerytRequest().getPolicyNo();
        PolicyRefundConfirmQueryRequest policyRefundQueryRequest = new PolicyRefundConfirmQueryRequest();
        policyRefundQueryRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        PolicyRefundQueryRequestBodyDTO bodyDTO = PolicyRefundQueryRequestBodyDTO.builder().build();
        bodyDTO.setPolicyNo(policyNo);
        policyRefundQueryRequest.setRefundQueryBody(bodyDTO);
        RefundConfirmQueryResponseVo responseVo = this.coreInsureApi.refundQueryConfirm(policyRefundQueryRequest);
        if (ObjectUtils.isEmpty((Object)responseVo)) {
            throw ApisDataCompletionException.builder().errorCode(ErrorNullValueCodeEnum.ERR_N00002.getKey()).message(ErrorNullValueCodeEnum.ERR_N00002.getValue()).build();
        }
        return StanderResponse.builder().header(request.getHeader()).responseBody(responseVo.getResponseBody()).build();
    }

    public void verifyNull(StanderRequest request) throws ApisBusinessException {
        String policyNo = request.getOriginalRefundQuerytRequest().getPolicyNo();
        if (StringUtils.isBlank((CharSequence)policyNo)) {
            throw ApisDataCompletionException.builder().errorCode(ErrorNullValueCodeEnum.ERR_N90003.getKey()).message(ErrorNullValueCodeEnum.ERR_N90003.getValue()).build();
        }
    }
}

