/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl.PaymentServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PaymentGatewayChannelDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PaymentGatewayRequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.RenewalContractRequest;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiPayContract;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiPayContractService;
import com.jdaz.sinosoftgz.apis.commons.model.constant.ModelConstants;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.payment.PaymentGatewayApi;
import com.sinosoft.epay.sdk.EpaySign;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class StanderRenewalContractHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(StanderRenewalContractHandler.class);
    @Autowired
    PaymentGatewayApi paymentGatewayApi;
    @Value(value="${payment.privateKey}")
    private String privateKey;
    @Autowired
    ApisBusiPayContractService apisBusiPayContractService;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    ApisBusinessService apisBusinessService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)request.getRenewalContractRequest())) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00001.getValue(), ErrorNullValueCodeEnum.ERR_N00001.getKey());
        }
        PaymentGatewayRequestHeadDTO head = request.getRenewalContractRequest().getHead();
        head.setTimestamp(String.valueOf(DateUtil.current()));
        this.completionContractDisplayAccount(request);
        JSONObject headMap = JSON.parseObject((String)JSON.toJSONString((Object)head));
        JSONObject bodyMap = JSON.parseObject((String)JSON.toJSONString((Object)request.getRenewalContractRequest().getBody()));
        EpaySign epaySignClient = EpaySign.newInstance(null, (String)this.privateKey, (Boolean)false);
        String sign = epaySignClient.requestSign((Map)headMap, (Map)bodyMap);
        head.setSign(sign);
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        StanderResponse response = this.paymentGatewayApi.renewalContract(request);
        return response;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)response) || ObjectUtil.isEmpty((Object)response.getRenewalContractResponse())) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00002.getValue(), ErrorNullValueCodeEnum.ERR_N00002.getKey());
        }
        if ((long)ModelConstants.INT_VALUE_NO.intValue() != response.getRenewalContractResponse().getHead().getCode()) {
            throw new ApisBusinessException(response.getRenewalContractResponse().getHead().getMessage(), String.valueOf(response.getRenewalContractResponse().getHead().getCode()));
        }
        this.savePayContractRecord(request, response);
        return response;
    }

    private void savePayContractRecord(StanderRequest request, StanderResponse response) {
        RenewalContractRequest renewalContractRequest = request.getRenewalContractRequest();
        String payMethod = request.getRenewalContractRequest().getBody().getPayMethod();
        payMethod = (String)PaymentServiceImpl.peyMethodMap.get(payMethod);
        Boolean isMobile = PaymentServiceImpl.isMobile((PaymentGatewayChannelDTO)PaymentGatewayChannelDTO.builder().paymentMethod(payMethod).build());
        ApisBusiPayContract apisBusiPayContract = new ApisBusiPayContract();
        apisBusiPayContract.setAgencyCode(request.getHeader().getChannelCode());
        apisBusiPayContract.setPaymentMethod(payMethod);
        apisBusiPayContract.setContractCode(response.getRenewalContractResponse().getBody().getContractCode());
        apisBusiPayContract.setIsMobile(isMobile != false ? "1" : "0");
        apisBusiPayContract.setBusinessType("RC");
        apisBusiPayContract.setBusinessNo(renewalContractRequest.getBody().getBusinessNo());
        apisBusiPayContract.setContractReturnUrl(renewalContractRequest.getBody().getReturnUrl());
        apisBusiPayContract.setContractNotifyUrl(renewalContractRequest.getBody().getThirdContractCallUrl());
        this.apisBusiPayContractService.saveOrUpdate((Object)apisBusiPayContract);
    }

    private void completionContractDisplayAccount(StanderRequest request) throws ApisBusinessException {
        String policyNo = request.getRenewalContractRequest().getBody().getBusinessNo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"policy_no", (Object)policyNo);
        ApisBusiChannelOrder apisBusiChannelOrder = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper, false);
        String rationName = "";
        if (ObjectUtil.isNotEmpty((Object)apisBusiChannelOrder)) {
            rationName = apisBusiChannelOrder.getPlanName();
        } else {
            PolicyDetailServiceRequest policyDetailServiceRequest = PolicyDetailServiceRequest.builder().build();
            policyDetailServiceRequest.setRequestHead(request.getDebitNoteRequest().getRequestHead());
            PolicyDetailRequestDTO requestBody = PolicyDetailRequestDTO.builder().build();
            requestBody.setPolicyNo(policyNo);
            requestBody.setBusinessNature2("all");
            requestBody.setOperateCode(request.getHeader().getUserCode());
            policyDetailServiceRequest.setRequestBody(requestBody);
            request.setPolicyDetailServiceRequest(policyDetailServiceRequest);
            StanderResponse policyDetail = this.apisBusinessService.execute("policyDetail", request);
            if (ObjectUtil.isNotEmpty((Object)policyDetail) && 1 == policyDetail.getPolicyDetailResponse().getResponseHead().getStatus()) {
                rationName = ((ItemMainDTO)policyDetail.getPolicyDetailResponse().getResponseBody().getPolicy().getCoverage().getItemList().get(0)).getGoodsName();
            }
        }
        request.getRenewalContractRequest().getBody().setContractDisplayAccount(rationName);
    }
}

