/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelUserService;
import com.jdaz.sinosoftgz.apis.commons.service.constants.CommonConstant;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreCorrectApi;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderRenewalPolicyQueryHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(StanderRenewalPolicyQueryHandler.class);
    @Autowired
    CoreCorrectApi coreCorrectApi;
    @Autowired
    private ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    private ApisChannelUserService apisChannelUserService;
    @Autowired
    private DataCompletionUtil dataCompletionUtil;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        request.getHeader().setBusinessKey(UUID.fastUUID().toString().replaceAll("-", ""));
        request.getRenewalPolicyQueryRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        String userCode = request.getHeader().getUserCode();
        if (StringUtils.isEmpty((CharSequence)userCode)) {
            throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10145.getKey()).message(ChannelErrorCodeEnum.ERR_C10145.getValue()).build();
        }
        request.getRenewalPolicyQueryRequest().getRequestBody().setOperateCode(request.getHeader().getUserCode());
        if (ObjectUtil.isEmpty((Object)request.getRenewalPolicyQueryRequest().getRequestBody().getPageIndex())) {
            request.getRenewalPolicyQueryRequest().getRequestBody().setPageSize(Integer.valueOf(50));
            request.getRenewalPolicyQueryRequest().getRequestBody().setPageIndex(Integer.valueOf(1));
        } else if (request.getRenewalPolicyQueryRequest().getRequestBody().getPageSize() > 50 && this.dataCompletionUtil.isQueryPageSizeOpen()) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10640.getValue(), ChannelErrorCodeEnum.ERR_C10640.getKey());
        }
        ApisChannelUser apisChannelUser = new ApisChannelUser();
        apisChannelUser.setUserCode(request.getHeader().getUserCode());
        QueryWrapper apisChannelUserWrapper = new QueryWrapper((Object)apisChannelUser);
        List channelUserList = this.apisChannelUserService.list((Wrapper)apisChannelUserWrapper);
        if (!ObjectUtils.isNotEmpty((Object)channelUserList) || channelUserList.size() <= 0) {
            throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10174.getKey()).message(ChannelErrorCodeEnum.ERR_C10174.getValue()).build();
        }
        request.getRenewalPolicyQueryRequest().getRequestBody().setChannelCode(((ApisChannelUser)channelUserList.get(0)).getChannelCode());
        request.getHeader().setChannelCode(((ApisChannelUser)channelUserList.get(0)).getChannelCode());
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        String renewalDateStr = request.getRenewalPolicyQueryRequest().getRequestBody().getRenewalDate();
        Date renewalDate = null;
        if (renewalDateStr != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            try {
                renewalDate = sdf.parse(renewalDateStr);
                this.controlQuery(renewalDate);
            }
            catch (ParseException e) {
                log.error("error:", (Throwable)e);
            }
            sdf = new SimpleDateFormat("yyyy-MM-dd");
            renewalDateStr = sdf.format(renewalDate);
            request.getRenewalPolicyQueryRequest().getRequestBody().setRenewalDate(renewalDateStr);
        }
        return this.coreCorrectApi.renewalPolicyQuery(request);
    }

    private void controlQuery(Date renewalDate) throws ApisBusinessException {
        int renewalDateNum;
        if (this.isQueryOpen() && (renewalDateNum = Integer.parseInt(DateUtil.format((Date)renewalDate, (String)"yyyyMMdd"))) >= 20201011 && renewalDateNum <= 20201021) {
            throw new ApisBusinessException("10\u670811\u65e5-10\u670821\u65e5\u7eed\u4fdd\u5355\u6682\u4e0d\u652f\u6301\u67e5\u8be2\uff0c\u8bf7\u8054\u7cfb\u4e1a\u52a1\u652f\u6301", "5138");
        }
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        if (response == null || response.getRenewalPolicyQueryResponse() == null) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00002.getKey(), ErrorNullValueCodeEnum.ERR_N00002.getValue());
        }
        if (response.getRenewalPolicyQueryResponse().getResponseHead() == null || response.getRenewalPolicyQueryResponse().getResponseBody() == null || response.getRenewalPolicyQueryResponse().getResponseHead().getStatus() == CommonConstant.FccbResponseCode.FAIL.intValue() || response.getRenewalPolicyQueryResponse().getResponseBody().getRenewalList() == null || response.getRenewalPolicyQueryResponse().getResponseBody().getRenewalList().size() == 0) {
            ResponseHeadDTO responseHeadDTO = ResponseHeadDTO.builder().build();
            responseHeadDTO.setAppCode(ChannelErrorCodeEnum.ERR_C10014.getKey());
            responseHeadDTO.setAppMessage(ChannelErrorCodeEnum.ERR_C10014.getValue());
            response.getRenewalPolicyQueryResponse().setResponseHead(responseHeadDTO);
            return response;
        }
        response.getRenewalPolicyQueryResponse().getResponseHead().setAppCode(ChannelErrorCodeEnum.ERR_C10002.getKey());
        response.getRenewalPolicyQueryResponse().getResponseHead().setAppMessage(ChannelErrorCodeEnum.ERR_C10002.getValue());
        return response;
    }

    private boolean isQueryOpen() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"config_code", (Object)"is_renewalPolicy_query_open");
        ApisChannelConfigs apisChannelConfigs = (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)queryWrapper);
        return ObjectUtil.isNotEmpty((Object)apisChannelConfigs) && "1".equals(apisChannelConfigs.getConfigValue());
    }
}

