/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RedisTemplateUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.ClaimListQueryServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.ClaimQueryInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.response.ClaimListInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PlanDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PlanDetailQueryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PlanDetailQueryRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredIdvDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.Renewal;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.sale.request.CommissionQueryDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.sale.request.resp.AgentQueryResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisBusiRenewal;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfsInsuredTypeMapper;
import com.jdaz.sinosoftgz.apis.commons.service.constants.CommonConstant;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationMainService;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.impl.ApisBusiRenewalServiceImpl;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.impl.ApisPfpKindClaimExchangeServiceImpl;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.impl.ApisPfpProductMainServiceImpl;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreCorrectApi;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderRenewalQueryRapidHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderRenewalQueryRapidHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    CoreCorrectApi coreCorrectApi;
    @Autowired
    ApisPfsInsuredTypeMapper apisPfsInsuredTypeMapper;
    private static final String RENEWAL_FLAG_Y = "Y";
    private static final String RENEWAL_FLAG_N = "N";
    @Autowired
    ApisPfpProductMainServiceImpl apisPfpProductMainServiceImpl;
    @Autowired
    ApisPfpKindClaimExchangeServiceImpl apisPfpKindClaimExchangeServiceImpl;
    @Autowired
    ApisBusiRenewalServiceImpl apisBusiRenewalService;
    @Autowired
    private ApisBusinessService apisBusinessService;
    @Autowired
    private ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    private ApisPfpRationMainService apisPfpRationMainService;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    private RedisTemplateUtil redisTemplateUtil;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        long time = System.currentTimeMillis();
        if (request == null || request.getPolicyDetailServiceRequest() == null || request.getPolicyDetailServiceRequest().getRequestBody() == null) {
            throw new ApisDataCompletionException(ErrorNullValueCodeEnum.ERR_N00001.getValue(), ErrorNullValueCodeEnum.ERR_N00001.getKey());
        }
        String userCode = request.getHeader().getUserCode();
        if (StringUtils.isEmpty((CharSequence)userCode)) {
            throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10145.getKey()).message(ChannelErrorCodeEnum.ERR_C10145.getValue()).build();
        }
        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
        apisChannelConfigs.setUserCode(userCode);
        apisChannelConfigs.setConfigCode("policy_query_range");
        ApisChannelConfigs channelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
        if (channelConfigs != null) {
            request.getPolicyDetailServiceRequest().getRequestBody().setOperateCode("all");
            request.getPolicyDetailServiceRequest().getRequestBody().setBusinessNature2("all");
        } else {
            String[] userArr = userCode.split("_");
            if (userArr.length > 1 && "00".equals(userArr[1])) {
                request.getPolicyDetailServiceRequest().getRequestBody().setOperateCode("all");
                request.getPolicyDetailServiceRequest().getRequestBody().setBusinessNature2(userArr[0]);
            } else {
                request.getPolicyDetailServiceRequest().getRequestBody().setOperateCode("all");
                request.getPolicyDetailServiceRequest().getRequestBody().setBusinessNature2("all");
            }
        }
        request.getPolicyDetailServiceRequest().setRequestHead(com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO.initRequestHead());
        this.log.warn("\u7eed\u4fdd\u67e5\u8be2\u5feb\u901f\u7248\u4fdd\u5355\u53f7\uff1a{},\u8865\u5168\u7ed3\u675f\u8017\u65f6\uff1a{}", (Object)request.getPolicyDetailServiceRequest().getRequestBody().getPolicyNo(), (Object)(System.currentTimeMillis() - time));
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        long time = System.currentTimeMillis();
        this.log.warn("\u6838\u5fc3\u4fdd\u5355\u8be6\u60c5\u63a5\u53e3\u67e5\u8be2\uff1a{}", (Object)request.getHeader().getUserCode());
        StanderResponse standerResponse = this.coreInsureApi.policyDetail(request);
        if (ObjectUtils.isEmpty((Object)standerResponse) || ObjectUtils.isEmpty((Object)standerResponse.getPolicyDetailResponse())) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00002.getValue(), ErrorNullValueCodeEnum.ERR_N00002.getKey());
        }
        this.log.warn("\u7eed\u4fdd\u67e5\u8be2\u5feb\u901f\u7248\u67e5\u8be2\u4fdd\u5355:{},\u8be6\u60c5\u8017\u65f6\uff1a{}", (Object)standerResponse.getPolicyDetailResponse().getResponseBody().getPolicy().getMain().getPolicyNo(), (Object)(System.currentTimeMillis() - time));
        return standerResponse;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        long time = System.currentTimeMillis();
        if (response == null || response.getPolicyDetailResponse() == null) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00002.getKey(), ErrorNullValueCodeEnum.ERR_N00002.getValue());
        }
        if (response.getPolicyDetailResponse().getResponseHead() == null || response.getPolicyDetailResponse().getResponseBody() == null || response.getPolicyDetailResponse().getResponseHead().getStatus() == CommonConstant.FccbResponseCode.FAIL.intValue() || response.getPolicyDetailResponse().getResponseBody().getPolicy() == null) {
            ResponseHeadDTO responseHeadDTO = ResponseHeadDTO.builder().build();
            responseHeadDTO.setAppCode(ChannelErrorCodeEnum.ERR_C10014.getKey());
            responseHeadDTO.setAppMessage(ChannelErrorCodeEnum.ERR_C10014.getValue());
            response.getPolicyDetailResponse().setResponseHead(responseHeadDTO);
            this.log.warn("\u7eed\u4fdd\u67e5\u8be2\uff1a\u7eed\u4fdd\u8be6\u60c5\u6ca1\u6709\u67e5\u51fa\u8bb0\u5f55\uff0c\u4fdd\u5355\uff1a{} \u4e0d\u5b58\u5728\uff01", (Object)request.getPolicyDetailServiceRequest().getRequestBody().getPolicyNo());
        } else {
            response.getPolicyDetailResponse().getResponseHead().setAppCode(ChannelErrorCodeEnum.ERR_C10002.getKey());
            response.getPolicyDetailResponse().getResponseHead().setAppMessage(ChannelErrorCodeEnum.ERR_C10002.getValue());
            this.completeRenewal(response.getPolicyDetailResponse().getResponseBody().getPolicy(), request);
            this.log.warn("\u7eed\u4fdd\u67e5\u8be2\u5feb\u901f\u7248beforeReturn\u4fdd\u5355:{},\u8017\u65f6\uff1a{}", (Object)response.getPolicyDetailResponse().getResponseBody().getPolicy().getMain().getPolicyNo(), (Object)(System.currentTimeMillis() - time));
            PolicyDTO policy = PolicyDTO.builder().renewal(Renewal.builder().renewableFlag(response.getPolicyDetailResponse().getResponseBody().getPolicy().getRenewal().getRenewableFlag()).build()).build();
            response.getPolicyDetailResponse().getResponseBody().setPolicy(policy);
        }
        return response;
    }

    private void completeClaimFlag(PolicyDTO policyDTO, StanderRequest request) throws ApisBusinessException {
        StanderResponse response = null;
        ClaimListQueryServiceRequest claimListQueryServiceRequest = ClaimListQueryServiceRequest.builder().build();
        RequestHeadDTO requestHeadDTO = RequestHeadDTO.builder().build();
        ClaimQueryInfoDTO claimQueryInfoDTO = ClaimQueryInfoDTO.builder().build();
        if (StringUtils.isEmpty((CharSequence)policyDTO.getMain().getPolicyNo())) {
            return;
        }
        claimQueryInfoDTO.setPolicyNo(policyDTO.getMain().getPolicyNo());
        claimListQueryServiceRequest.setHead(requestHeadDTO);
        claimListQueryServiceRequest.setBody(claimQueryInfoDTO);
        request.setClaimListQueryServiceRequest(claimListQueryServiceRequest);
        response = this.apisBusinessService.execute("claimQuery", request);
        if (response == null || response.getClaimListQueryResponse() == null || response.getClaimListQueryResponse().getBody() == null || response.getClaimListQueryResponse().getHead() == null) {
            return;
        }
        if (response.getClaimListQueryResponse().getBody().getClaimInfoList().size() > 0) {
            int claimNum = 0;
            BigDecimal sumRealPayCny = new BigDecimal(0);
            for (ClaimListInfo claimListInfo : response.getClaimListQueryResponse().getBody().getClaimInfoList()) {
                if (ObjectUtil.isNotEmpty((Object)claimListInfo.getCanceloRejectTime()) || !ObjectUtil.isNotEmpty((Object)claimListInfo.getClaimTime())) continue;
                ++claimNum;
                sumRealPayCny = sumRealPayCny.add(new BigDecimal(claimListInfo.getSumRealPayCny() == null ? 0.0 : claimListInfo.getSumRealPayCny())).setScale(2, 4);
            }
            int limitClaimNum = 2;
            double limitRealPayCny = 3000.0;
            this.log.warn("\u4fdd\u5355\u53f7\uff1a{},\u7406\u8d54\u6b21\u6570\uff1a{},\u603b\u8d54\u6b3e\uff1a{}", new Object[]{policyDTO.getMain().getPolicyNo(), claimNum, sumRealPayCny});
            if (claimNum >= limitClaimNum && sumRealPayCny.doubleValue() >= limitRealPayCny) {
                this.log.error(ChannelErrorCodeEnum.ERR_C10361.getValue());
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10361.getValue(), ChannelErrorCodeEnum.ERR_C10361.getKey());
            }
            policyDTO.getMain().setClaimFlag(RENEWAL_FLAG_Y);
        } else {
            policyDTO.getMain().setClaimFlag(RENEWAL_FLAG_N);
        }
    }

    private void completeRenewal(PolicyDTO policyDTO, StanderRequest request) throws ApisBusinessException {
        policyDTO.setRenewal(Renewal.builder().build());
        ArrayList planDTOS = new ArrayList();
        List renewalGoodsList = new ArrayList();
        this.dataCompletionUtil.checkPolicy(policyDTO);
        ApisChannelConfigs selfHelpPlatform = this.dataCompletionUtil.getConfig(request.getHeader().getUserCode(), "self_help_platform");
        boolean isSelfHelpPlatform = ObjectUtil.isNotEmpty((Object)selfHelpPlatform);
        if (!isSelfHelpPlatform) {
            this.dataCompletionUtil.renewalAcrossAccounts(request, policyDTO);
        }
        this.dataCompletionUtil.policyVerify(request, policyDTO, "1001");
        this.completeClaimFlag(policyDTO, request);
        renewalGoodsList = this.apisBusiRenewalService.getApisBusiRenewals(((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode());
        this.log.warn("\u5546\u54c1\u8868size():{}", (Object)renewalGoodsList.size());
        if (ObjectUtils.isNotEmpty(renewalGoodsList) || renewalGoodsList.size() > 0) {
            this.log.warn("\u5546\u54c1\u53ef\u7eed\u4fdd");
            policyDTO.getRenewal().setRenewableFlag(RENEWAL_FLAG_Y);
            policyDTO.getRenewal().setQuestionnaireFlagWhenPlanPromote(((ApisBusiRenewal)renewalGoodsList.get(0)).getRequiredNoticeFlag());
            ApisPfpRationMain apisPfpRationMain = new ApisPfpRationMain();
            QueryWrapper queryWrapper = new QueryWrapper((Object)apisPfpRationMain);
            ArrayList<String> rationCodes = new ArrayList<String>();
            String socialSecurityFlag = ((InsuredIdvDTO)((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getInsuredIdvList().get(0)).getSocialSecurityFlag();
            this.log.warn("\u793e\u4fdd\u6807\u5fd7:{}", (Object)socialSecurityFlag);
            if (StringUtils.isBlank((CharSequence)request.getPolicyDetailServiceRequest().getRequestBody().getFastRenewalFlag()) || RENEWAL_FLAG_N.equals(request.getPolicyDetailServiceRequest().getRequestBody().getFastRenewalFlag())) {
                List apisPfpRationMainList;
                if (StringUtils.isNotBlank((CharSequence)((ApisBusiRenewal)renewalGoodsList.get(0)).getOutSeciInsuDefUpgGosCods())) {
                    String[] outSeciInsuDefUpgGosCods = ((ApisBusiRenewal)renewalGoodsList.get(0)).getOutSeciInsuDefUpgGosCods().split(",");
                    rationCodes.addAll(new ArrayList<String>(Arrays.asList(outSeciInsuDefUpgGosCods)));
                    apisPfpRationMainList = this.apisPfpRationMainService.findRationInfoByRationCodes(rationCodes);
                    this.setPlanDTO(planDTOS, apisPfpRationMainList, RENEWAL_FLAG_N, policyDTO);
                }
                if (StringUtils.isNotBlank((CharSequence)((ApisBusiRenewal)renewalGoodsList.get(0)).getInSeciInsuDefUpgGosCods())) {
                    String[] inSeciInsuDefUpgGosCods = ((ApisBusiRenewal)renewalGoodsList.get(0)).getInSeciInsuDefUpgGosCods().split(",");
                    rationCodes.addAll(new ArrayList<String>(Arrays.asList(inSeciInsuDefUpgGosCods)));
                    apisPfpRationMainList = this.apisPfpRationMainService.findRationInfoByRationCodes(rationCodes);
                    this.setPlanDTO(planDTOS, apisPfpRationMainList, RENEWAL_FLAG_Y, policyDTO);
                }
            } else if (RENEWAL_FLAG_Y.equals(request.getPolicyDetailServiceRequest().getRequestBody().getFastRenewalFlag())) {
                List apisPfpRationMainList;
                boolean isOpen;
                String configValue = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("RQ_QRY_COMMISSION_CLOSE", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
                boolean bl = isOpen = !"1".equals(configValue);
                if (StringUtils.isNotBlank((CharSequence)((ApisBusiRenewal)renewalGoodsList.get(0)).getOutSeciInsuSelUpgGosCods())) {
                    String[] outSeciInsuSelUpgGosCods = ((ApisBusiRenewal)renewalGoodsList.get(0)).getOutSeciInsuSelUpgGosCods().split(",");
                    rationCodes.addAll(new ArrayList<String>(Arrays.asList(outSeciInsuSelUpgGosCods)));
                    apisPfpRationMainList = this.apisPfpRationMainService.findRationInfoByRationCodes(rationCodes);
                    if (isOpen && ObjectUtil.isNotEmpty((Object)apisPfpRationMainList)) {
                        apisPfpRationMainList = this.commissionQueryByRationCodes(apisPfpRationMainList, StringUtils.isNotBlank((CharSequence)policyDTO.getSalesList().getAgentCode()) ? policyDTO.getSalesList().getAgentCode() : request.getHeader().getChannelCode());
                    }
                    this.setPlanDTO(planDTOS, apisPfpRationMainList, RENEWAL_FLAG_N, policyDTO);
                }
                if (StringUtils.isNotBlank((CharSequence)((ApisBusiRenewal)renewalGoodsList.get(0)).getInSeciInsuSelUpgGosCods())) {
                    String[] inSeciInsuSelUpgGosCods = ((ApisBusiRenewal)renewalGoodsList.get(0)).getInSeciInsuSelUpgGosCods().split(",");
                    rationCodes.addAll(new ArrayList<String>(Arrays.asList(inSeciInsuSelUpgGosCods)));
                    apisPfpRationMainList = this.apisPfpRationMainService.findRationInfoByRationCodes(rationCodes);
                    if (isOpen && ObjectUtil.isNotEmpty((Object)apisPfpRationMainList)) {
                        apisPfpRationMainList = this.commissionQueryByRationCodes(apisPfpRationMainList, StringUtils.isNotBlank((CharSequence)policyDTO.getSalesList().getAgentCode()) ? policyDTO.getSalesList().getAgentCode() : request.getHeader().getChannelCode());
                    }
                    this.setPlanDTO(planDTOS, apisPfpRationMainList, RENEWAL_FLAG_Y, policyDTO);
                }
                if (ObjectUtil.isNotEmpty(planDTOS)) {
                    String goodsCode = ((ApisBusiRenewal)renewalGoodsList.get(0)).getGoodsCode();
                    List originPlanCodeList = planDTOS.stream().filter(pd -> null != pd && goodsCode.contains(pd.getGoodsCode())).collect(Collectors.toList());
                    if (ObjectUtil.isNotEmpty(originPlanCodeList)) {
                        planDTOS.remove(originPlanCodeList.get(0));
                        planDTOS.add(0, originPlanCodeList.get(0));
                    }
                }
            }
            if (ObjectUtil.isEmpty(planDTOS) || planDTOS.size() == 0) {
                policyDTO.getRenewal().setRenewableFlag(RENEWAL_FLAG_N);
            }
        } else {
            policyDTO.getRenewal().setRenewableFlag(RENEWAL_FLAG_N);
            this.log.warn("\u5546\u54c1:{} \u4e0d\u53ef\u7eed\u4fdd", (Object)((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode());
            return;
        }
        if (ObjectUtils.isNotEmpty(planDTOS) && planDTOS.size() > 0) {
            policyDTO.getRenewal().setRenewablePlanList(planDTOS);
        }
    }

    private void setPlanDTO(List<PlanDTO> planDTOS, List<ApisPfpRationMain> apisPfpRationMainList, String n, PolicyDTO policyDetail) throws ApisBusinessException {
        if (ObjectUtils.isNotEmpty(apisPfpRationMainList) && apisPfpRationMainList.size() > 0) {
            for (ApisPfpRationMain apisPfpRationMain1 : apisPfpRationMainList) {
                boolean ageFlag = this.verifyAge(policyDetail, apisPfpRationMain1);
                if (!ageFlag) continue;
                PlanDTO planDTO = PlanDTO.builder().build();
                planDTO.setGoodsCode(apisPfpRationMain1.getRationCode());
                planDTO.setGoodsName(apisPfpRationMain1.getRationName());
                planDTO.setGroupPlanName(apisPfpRationMain1.getProductName());
                planDTO.setSocialInsuranceFlag(n);
                planDTOS.add(planDTO);
            }
        }
    }

    private boolean verifyAge(PolicyDTO policyDetail, ApisPfpRationMain apisPfpRationMainInfo) throws ApisBusinessException {
        List insuredIdvList = ((ItemMainDTO)policyDetail.getCoverage().getItemList().get(0)).getInsuredIdvList();
        for (InsuredIdvDTO insured : insuredIdvList) {
            long age = this.getInsuredIdvAge(insured, policyDetail);
            if (!(apisPfpRationMainInfo.getRenewableMaxAge() != null && !apisPfpRationMainInfo.getRenewableMaxAge().equals(0) ? age > (long)Integer.valueOf(apisPfpRationMainInfo.getRenewableMaxAge()).intValue() : age > (long)Integer.valueOf(apisPfpRationMainInfo.getAgeMax()).intValue())) continue;
            return false;
        }
        return true;
    }

    private long getInsuredIdvAge(InsuredIdvDTO insured, PolicyDTO policyDetail) throws ApisBusinessException {
        long age = 0L;
        try {
            if (ObjectUtil.isEmpty((Object)insured.getAge())) {
                Date newStartDate;
                DateTime startDate;
                Date maxDate = new Date();
                if (ObjectUtil.isNotEmpty((Object)policyDetail.getMain()) && ObjectUtil.isNotEmpty((Object)policyDetail.getMain().getStartDateStr()) && ObjectUtil.isNotEmpty((Object)(startDate = DateUtil.parse((CharSequence)policyDetail.getMain().getStartDateStr(), (String)"yyyy-MM-dd HH:mm:ss"))) && (newStartDate = DateUtils.addYears((Date)startDate, (int)1)).after(maxDate)) {
                    this.log.warn("\u7eed\u4fdd\u4fdd\u5355\u7684\u8d77\u4fdd\u65f6\u95f4\u5927\u4e8e\u5f53\u524d\u65f6\u95f4");
                    maxDate = newStartDate;
                }
                if (ObjectUtil.isNotEmpty((Object)insured.getBirthday())) {
                    age = DateUtil.betweenYear((Date)insured.getBirthday(), (Date)maxDate, (boolean)false);
                } else if (ObjectUtil.isNotEmpty((Object)insured.getIdentifyNumber()) && "01".equals(insured.getIdentifyType())) {
                    String birthdayStr = insured.getIdentifyNumber().substring(6, 14);
                    Date birthday = DateUtil.parse((CharSequence)birthdayStr, (String)"yyyyMMdd").toJdkDate();
                    age = DateUtil.betweenYear((Date)birthday, (Date)maxDate, (boolean)false);
                }
            } else {
                age = insured.getAge() + 1;
            }
        }
        catch (Exception e) {
            this.log.error("\u7eed\u4fdd\u89c4\u5219\u6821\u9a8c--\u300b\u8ba1\u7b97\u88ab\u4fdd\u4eba\u5e74\u9f84\u5931\u8d25\u3002", (Throwable)e);
        }
        return age;
    }

    public boolean isRenewableFlag(StanderRequest request) {
        StanderResponse resp = null;
        try {
            resp = this.apisBusinessService.execute("renewablePolicyListQuery", request);
            if (resp == null || resp.getHeader() == null || resp.getRenewablePolicyListQueryResponse() == null || resp.getRenewablePolicyListQueryResponse().getResponseBody() == null || resp.getRenewablePolicyListQueryResponse().getResponseHead() == null) {
                this.log.error("\u8c03\u7528\u53ef\u7eed\u4fdd\u6e05\u5355\u63a5\u53e3\u9519\u8bef");
                return false;
            }
            if (ObjectUtils.isNotEmpty((Object)resp.getRenewablePolicyListQueryResponse().getResponseBody().getPolicyList()) && resp.getRenewablePolicyListQueryResponse().getResponseBody().getPolicyList().size() > 0) {
                return true;
            }
        }
        catch (ApisBusinessException e) {
            this.log.error("\u8c03\u7528\u53ef\u7eed\u4fdd\u6e05\u5355\u63a5\u53e3\u9519\u8bef", (Throwable)e);
        }
        return false;
    }

    private void completePlanDetail(PolicyDTO policyDTO, StanderRequest request) {
        String goodsCode = ((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        if (StringUtils.isEmpty((CharSequence)goodsCode)) {
            this.log.error("\u4fdd\u5355\u6ca1\u6709\u8ba1\u5212 \uff1a{}");
            return;
        }
        PlanDetailQueryRequest planDetailQueryRequest = PlanDetailQueryRequest.builder().build();
        PlanDetailQueryRequestDTO planDetailQueryRequestDTO = PlanDetailQueryRequestDTO.builder().build();
        planDetailQueryRequestDTO.setPlanCode(goodsCode);
        planDetailQueryRequest.setRequestBody(planDetailQueryRequestDTO);
        request.setPlanDetailQueryRequest(planDetailQueryRequest);
        try {
            TimeInterval timer = DateUtil.timer();
            StanderResponse resp = this.apisBusinessService.execute("planDetailQuery", request);
            this.log.warn("\u8c03\u7528\u8ba1\u5212\u660e\u7ec6\u63a5\u53e3\u7528\u65f6{}", (Object)timer.intervalRestart());
            if (ObjectUtils.isNotEmpty((Object)resp) && ObjectUtils.isNotEmpty((Object)resp.getPlanDetailQueryResponse())) {
                policyDTO.setPlanDetail(resp.getPlanDetailQueryResponse().getResponseBody());
            } else {
                this.log.error("\u6ca1\u6709\u5bf9\u5e94\u8ba1\u5212\u7684\u8ba1\u5212\u660e\u7ec6 :{}");
            }
        }
        catch (ApisBusinessException e) {
            this.log.warn("\u83b7\u53d6\u8ba1\u5212\u660e\u7ec6\u62a5\u9519 :{}", (Object)e.getMessage());
        }
    }

    private List<ApisPfpRationMain> commissionQueryByRationCodes(List<ApisPfpRationMain> rationCodes, String agencyCode) {
        ArrayList<ApisPfpRationMain> ret = null;
        if (rationCodes.size() > 0) {
            CommissionQueryDTO commissionQueryDTO = new CommissionQueryDTO();
            commissionQueryDTO.setAgentCode(agencyCode);
            ret = new ArrayList<ApisPfpRationMain>();
            for (int i = 0; i < rationCodes.size(); ++i) {
                ApisPfpRationMain rc = rationCodes.get(i);
                this.log.warn("\u6e20\u9053\u4ee3\u7801:{}, \u8ba1\u5212\u4ee3\u7801\uff1a{}, \u4ea7\u54c1\u4ee3\u7801\uff1a{}\uff0crelateRationCode\uff1a{}", new Object[]{agencyCode, rc.getRationCode(), rc.getProductCode(), rc.getRelateRationCode()});
                commissionQueryDTO.setPlanCode(rc.getRationCode());
                commissionQueryDTO.setProductCode(rc.getRelateRationCode());
                commissionQueryDTO.setRiskCode(rc.getProductCode());
                AgentQueryResponseDTO commissionQueryResponseDTO = this.coreInsureApi.commissionQuery(commissionQueryDTO);
                if (ObjectUtil.isEmpty((Object)commissionQueryResponseDTO) || !"0000".equals(commissionQueryResponseDTO.getHead().getAppCode()) || ObjectUtils.isEmpty((Object)commissionQueryResponseDTO.getData())) {
                    if (ObjectUtil.isNotEmpty((Object)commissionQueryResponseDTO) && ObjectUtils.isNotEmpty((Object)commissionQueryResponseDTO.getHead())) {
                        this.log.error("\u8c03\u7528\u9500\u7ba1\u63a5\u53e3\u51fa\u9519\uff1a{}", (Object)commissionQueryResponseDTO.getHead().getAppMessage());
                        continue;
                    }
                    this.log.error("\u8c03\u7528\u9500\u7ba1\u63a5\u53e3\u51fa\u9519\uff1a{}", (Object)ErrorNullValueCodeEnum.ERR_N10002.getValue());
                    continue;
                }
                ret.add(rc);
            }
        }
        return ret;
    }
}

