/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.lang.UUID;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RenewalShortLikeServiceHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RenewalShortLikeServiceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.RenewalShortLikeResponse;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelUserService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class StanderRenewalShortLikeHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderRenewalShortLikeHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    private ApisChannelUserService apisChannelUserService;
    @Value(value="${apis.coreapi.serv.renewalShortLike.userName}")
    private String userName;
    @Value(value="${apis.coreapi.serv.renewalShortLike.passWord}")
    private String passWord;
    private static final String STATUS_SUCCESS = "0000";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        request.getHeader().setBusinessKey(UUID.fastUUID().toString().replaceAll("-", ""));
        this.verifyNull(request);
        this.requestCompletion(request);
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        RenewalShortLikeResponse responseVo = this.coreInsureApi.renewalShortLike(request.getRenewalShortLikeServiceRequest());
        if (ObjectUtils.isEmpty((Object)responseVo)) {
            throw new ApisBusinessException(responseVo.getDesc(), responseVo.getCode());
        }
        if (!STATUS_SUCCESS.equals(responseVo.getCode())) {
            throw new ApisBusinessException(responseVo.getDesc(), responseVo.getCode());
        }
        responseVo.setPolicyNo(request.getRenewalShortLikeServiceRequest().getRenewalShortUrlReq().getPolicyNo());
        return StanderResponse.builder().renewalShortLikeResponse(responseVo).build();
    }

    public void verifyNull(StanderRequest request) throws ApisBusinessException {
        RenewalShortLikeServiceRequestDTO renewalShortLikeServiceRequestDTO = request.getRenewalShortLikeServiceRequest().getRenewalShortUrlReq();
        if (StringUtils.isBlank((CharSequence)renewalShortLikeServiceRequestDTO.getPolicyNo())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u3010\u4fdd\u5355\u53f7\u3011"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
    }

    public void requestCompletion(StanderRequest request) throws ApisBusinessException {
        String userCode = request.getHeader().getUserCode();
        RenewalShortLikeServiceRequestDTO renewalShortLikeServiceRequestDTO = request.getRenewalShortLikeServiceRequest().getRenewalShortUrlReq();
        RenewalShortLikeServiceHeadDTO renewalShortLikeServiceHeadDTO = RenewalShortLikeServiceHeadDTO.builder().password(this.passWord).userName(this.userName).build();
        request.getRenewalShortLikeServiceRequest().setHead(renewalShortLikeServiceHeadDTO);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10145.getKey()).message(ChannelErrorCodeEnum.ERR_C10145.getValue()).build();
        }
        ApisChannelUser apisChannelUser = new ApisChannelUser();
        apisChannelUser.setUserCode(userCode);
        QueryWrapper apisChannelUserWrapper = new QueryWrapper((Object)apisChannelUser);
        List channelUserList = this.apisChannelUserService.list((Wrapper)apisChannelUserWrapper);
        if (ObjectUtils.isNotEmpty((Object)channelUserList)) {
            renewalShortLikeServiceRequestDTO.setAgencyCode(((ApisChannelUser)channelUserList.get(0)).getChannelCode());
        }
    }
}

