/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.BaseResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.RulingResultRequest;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderRulingsUpdateHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(StanderRulingsUpdateHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    ApisBusinessService apisBusinessService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)request.getRulingResultRequest())) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00001.getValue(), ErrorNullValueCodeEnum.ERR_N00001.getKey());
        }
        request.getRulingResultRequest().setHead(RequestHeadDTO.initRequestHead());
        this.verifyNull(request.getRulingResultRequest());
        this.verifyPolicy(request);
        return request;
    }

    private void verifyNull(RulingResultRequest rulingResultRequest) throws ApisBusinessException {
        if (StrUtil.isEmpty((CharSequence)rulingResultRequest.getBody().getRulingResultDto().getBdh())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u4fdd\u5355\u53f7"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StrUtil.isEmpty((CharSequence)rulingResultRequest.getBody().getRulingResultDto().getCdjg())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u88c1\u5b9a\u7ed3\u679c"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)rulingResultRequest.getBody().getRulingResultDto().getCdsj())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u88c1\u5b9a\u65f6\u95f4"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
    }

    private void verifyPolicy(StanderRequest request) throws ApisBusinessException {
        StanderHeader header = StanderHeader.builder().userCode("DEYU").bussinessType("policyDetail").build();
        request.setHeader(header);
        String policyNo = request.getRulingResultRequest().getBody().getRulingResultDto().getBdh();
        PolicyDetailServiceRequest policyDetailServiceRequest = PolicyDetailServiceRequest.builder().build();
        policyDetailServiceRequest.setRequestHead(RequestHeadDTO.initRequestHead());
        PolicyDetailRequestDTO requestBody = PolicyDetailRequestDTO.builder().build();
        requestBody.setPolicyNo(policyNo);
        requestBody.setBusinessNature2("all");
        requestBody.setOperateCode("DEYU");
        policyDetailServiceRequest.setRequestBody(requestBody);
        request.setPolicyDetailServiceRequest(policyDetailServiceRequest);
        StanderResponse policyDetail = this.apisBusinessService.execute("policyDetail", request);
        if (ObjectUtil.isNotEmpty((Object)policyDetail) && 1 == policyDetail.getPolicyDetailResponse().getResponseHead().getStatus()) {
            if (ObjectUtil.isNotEmpty((Object)policyDetail.getPolicyDetailResponse().getResponseBody().getPolicy())) {
                String policyStatus = policyDetail.getPolicyDetailResponse().getResponseBody().getPolicy().getMain().getPolicyStatus();
                if ("2".equals(policyStatus)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10127.getValue(), ChannelErrorCodeEnum.ERR_C10127.getKey());
                }
                if ("3".equals(policyStatus)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10025.getValue(), ChannelErrorCodeEnum.ERR_C10025.getKey());
                }
            }
        } else {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10695.getValue(), ChannelErrorCodeEnum.ERR_C10695.getKey());
        }
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        BaseResponse response = this.coreInsureApi.rulingsUpdate(request);
        return StanderResponse.builder().litigationResponse(response).build();
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)response) || ObjectUtil.isEmpty((Object)response.getLitigationResponse())) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00002.getValue(), ErrorNullValueCodeEnum.ERR_N00002.getKey());
        }
        if (!"200".equals(response.getLitigationResponse().getCode())) {
            throw new ApisBusinessException(response.getLitigationResponse().getMsg(), response.getLitigationResponse().getCode());
        }
        return response;
    }
}

