/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.UnderWriteQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.UnderWriteQueryResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiCorrectOrderService;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderUnderWriteQueryHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderUnderWriteQueryHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    ApisBusiCorrectOrderService apisBusiCorrectOrderService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        request.getUnderWriteQueryRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        String policyNo = request.getUnderWriteQueryRequest().getRequestBody().getPolicyNo();
        if (StringUtils.isBlank((CharSequence)policyNo)) {
            throw ApisDataCompletionException.builder().errorCode(ErrorNullValueCodeEnum.ERR_N90003.getKey()).message(ErrorNullValueCodeEnum.ERR_N90003.getValue()).build();
        }
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        QueryWrapper queryWrapper = new QueryWrapper();
        String policyNo = request.getUnderWriteQueryRequest().getRequestBody().getPolicyNo();
        String payType = "";
        queryWrapper.eq((Object)"policy_no", (Object)policyNo);
        ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
        request.getUnderWriteQueryRequest().getRequestBody().setProposalNo(order.getProposalNo());
        UnderWriteQueryResponse underWriteQueryResponse = this.coreInsureApi.underWriteQuery(request.getUnderWriteQueryRequest());
        UnderWriteQueryResponseDTO underWriteQueryResponseDTO = underWriteQueryResponse.getResponseBody();
        underWriteQueryResponseDTO.setExpireDate(order.getEndDate());
        underWriteQueryResponseDTO.setEffectiveDate(order.getStartDate());
        underWriteQueryResponseDTO.setTotalPremium(order.getPremium());
        underWriteQueryResponseDTO.setAgencyPolicyRef(order.getOrderNo());
        payType = order.getPayType();
        String underWriteFlag = underWriteQueryResponse.getResponseBody().getUnderwriteFlag();
        if ("1".equals(underWriteFlag) || "3".equals(underWriteFlag)) {
            if ("0".equals(payType)) {
                underWriteQueryResponseDTO.setPolicyStatus("70");
            } else {
                underWriteQueryResponseDTO.setPolicyStatus("60");
            }
        } else if ("4".equals(underWriteFlag)) {
            underWriteQueryResponseDTO.setPolicyStatus("14");
        } else if ("2".equals(underWriteFlag)) {
            underWriteQueryResponseDTO.setPolicyStatus("12");
        } else if ("5".equals(underWriteFlag)) {
            underWriteQueryResponseDTO.setPolicyStatus("15");
        }
        return StanderResponse.builder().underWriteQueryResponse(underWriteQueryResponse).header(request.getHeader()).build();
    }
}

