/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.executor.CommonsValidateUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.FxqCustomerCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.QuotePriceValidate;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.RiskManagementCheckUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyListQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyUnderwritResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyUnderwritResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.RiskManagementScenesEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderUnderwritHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(StanderUnderwritHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    QuotePriceValidate quotePriceValidate;
    @Autowired
    private RiskManagementCheckUtil riskManagementCheckUtil;
    @Autowired
    private FxqCustomerCheckUtil fxqCustomerCheckUtil;
    @Autowired
    private ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    private CommonsValidateUtil commonsValidateUtil;
    private final String REQUEST_ENTITY_UNDERWRITE = "policyUnderwritRequest";
    private final String RESPONSE_ENTITY_UNDERWRITE = "policyListQueryResponse";
    private static final String CLAUSE_LIABILITY_KEY_WORD = "\u6761\u6b3e\u8d23\u4efb\u4fe1\u606f\u4e2d\u6761\u6b3e";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        request.getPolicyUnderwritRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        BaseApisParamUtil.verificationRequest((StanderRequest)request, (String)"policyUnderwritRequest");
        QuotePriceServiceRequest quotePriceServiceRequest = QuotePriceServiceRequest.builder().build();
        BeanUtils.copyProperties((Object)request.getPolicyUnderwritRequest(), (Object)quotePriceServiceRequest);
        request.setQuotePriceServiceRequest(quotePriceServiceRequest);
        this.dataCompletionUtil.dataCompletion(request);
        this.quotePriceValidate.validateRquest(request);
        QuotePriceDTO quotePriceDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        if (StringUtils.isNotEmpty((CharSequence)quotePriceDTO.getMain().getRenewalPolicyNo())) {
            quotePriceDTO.getMain().setRenewalFlag("1");
            if (ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getSelfHelpPlatform()) && request.getQuotePriceServiceRequest().getRequestBody().getSelfHelpPlatform().booleanValue()) {
                quotePriceDTO.getSales().setRenewalType("2");
            } else {
                quotePriceDTO.getSales().setRenewalType("1");
            }
        }
        this.dataCompletionUtil.calculateTotalPremium(request);
        BeanUtils.copyProperties((Object)request.getQuotePriceServiceRequest(), (Object)request.getPolicyUnderwritRequest());
        this.riskManagementCheckUtil.riskManagementData(request, null, RiskManagementScenesEnum.UNDERWRITING.getCode(), request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getPolicyType());
        this.fxqCustomerCheckUtil.fxqCustomerData(request, null);
        boolean isAddZybx = true;
        if ("riskUnderwrit".equals(request.getHeader().getBussinessType())) {
            isAddZybx = false;
        }
        this.commonsValidateUtil.executorValidate(request, Boolean.valueOf(isAddZybx), Boolean.valueOf(true), Boolean.valueOf(true));
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        PolicyListQueryResponse policyListQueryResponse = PolicyListQueryResponse.builder().build();
        String rationCode = ((ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getGoodsCode();
        MainDTO requestMainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        try {
            if (!"0".equals(requestMainDTO.getJdUserVerifyFlag())) {
                if ("riskUnderwrit".equals(request.getHeader().getBussinessType())) {
                    policyListQueryResponse.setResponseHead(ResponseHeadDTO.builder().appCode(ChannelErrorCodeEnum.ERR_C10002.getKey()).appMessage(ChannelErrorCodeEnum.ERR_C10002.getValue()).build());
                } else {
                    StanderResponse quotePriceResponse = this.coreInsureApi.policyUnderWrite(request);
                    BaseApisParamUtil.verificationResponse((StanderResponse)quotePriceResponse, (String)"policyListQueryResponse");
                    policyListQueryResponse = quotePriceResponse.getPolicyListQueryResponse();
                    MainDTO mainDTO = policyListQueryResponse.getResponseBody().getMain();
                    if (StringUtils.isNotEmpty((CharSequence)mainDTO.getProposalNo()) && 1 == policyListQueryResponse.getResponseHead().getStatus()) {
                        policyListQueryResponse.getResponseHead().setAppCode(ChannelErrorCodeEnum.ERR_C10002.getKey());
                        policyListQueryResponse.getResponseHead().setAppMessage(ChannelErrorCodeEnum.ERR_C10002.getValue());
                    }
                }
            } else {
                policyListQueryResponse.getResponseHead().setAppCode(ChannelErrorCodeEnum.ERR_C10363.getKey());
                policyListQueryResponse.getResponseHead().setAppMessage(ChannelErrorCodeEnum.ERR_C10363.getValue());
            }
        }
        catch (ApisBusinessException e) {
            String errMsg = e.getMessage();
            if (errMsg.indexOf(CLAUSE_LIABILITY_KEY_WORD) != -1) {
                String rationName = ((ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getGoodsName();
                errMsg = "" + rationName + "\u3010" + rationCode + "\u3011\u4ea7\u54c1\u6b63\u5feb\u9a6c\u52a0\u97ad\u4e0a\u67b6\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8d2d\u4e70\u3002";
            }
            throw new ApisBusinessException(errMsg, e.getErrorCode());
        }
        PolicyUnderwritResponseDTO policyUnderwritResponseDTO = PolicyUnderwritResponseDTO.builder().build();
        if (ObjectUtil.isNotEmpty((Object)requestMainDTO.getJdUserVerifyFlag())) {
            List insuredPremiumDTOList = this.dataCompletionUtil.packagedInsuredPremiumList(request);
            policyUnderwritResponseDTO.setInsuredPremiumList(insuredPremiumDTOList);
        }
        return StanderResponse.builder().header(request.getHeader()).policyUnderwritResponse(PolicyUnderwritResponse.builder().responseHead(policyListQueryResponse.getResponseHead()).responseBody(policyUnderwritResponseDTO).build()).build();
    }
}

