/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PaymentContractServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PaymentGatewayRequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.WithholdingContractRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PaymentContractResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.WithholdingContractServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.WithholdingContractServiceResponseBodyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiPaySignupLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiChannelOrderMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiPaySignupLogMapper;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import com.jdaz.sinosoftgz.coreapi.payment.PaymentGatewayApi;
import com.sinosoft.epay.sdk.EpaySign;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class StanderWithholdingContractHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderWithholdingContractHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    PaymentGatewayApi paymentGatewayApi;
    @Autowired
    ApisBusiChannelOrderMapper apisBusinessChannelOrderMapper;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    ApisBusiPaySignupLogMapper apisBusiPaySignupLogMapper;
    @Value(value="${paymentWithHold.privateKey}")
    private String privateKey;
    @Value(value="${paymentWithHold.publicKey}")
    private String publicKey;
    private static final String DEFAULT_VERSION = "1.0";
    private static final String SYSTEM_CODE = "01";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        this.validDate(request);
        request.getWithholdingContractRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        QueryWrapper apisBusiChannelOrderQueryWrapper = new QueryWrapper();
        apisBusiChannelOrderQueryWrapper.eq((Object)"policy_no", (Object)request.getWithholdingContractRequest().getRequestBody().getPolicyNo());
        ApisBusiChannelOrder order = (ApisBusiChannelOrder)this.apisBusinessChannelOrderMapper.selectOne((Wrapper)apisBusiChannelOrderQueryWrapper);
        if (ObjectUtil.isEmpty((Object)order)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10669.getValue(), ChannelErrorCodeEnum.ERR_C10669.getKey());
        }
        request.getWithholdingContractRequest().getRequestBody().setBusinessNo(order.getProposalNo());
        return request;
    }

    public void validDate(StanderRequest request) throws ApisBusinessException {
        WithholdingContractRequestDTO dto = request.getWithholdingContractRequest().getRequestBody();
        if (StringUtils.isEmpty((CharSequence)dto.getSuccessUrl())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u3010\u5546\u6237\u524d\u53f0\u901a\u77e5URL\u3011"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPolicyNo())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u3010\u4fdd\u5355\u53f7\u3011"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        WithholdingContractServiceResponse response = WithholdingContractServiceResponse.builder().build();
        WithholdingContractServiceResponseBodyDTO bodyDTO = WithholdingContractServiceResponseBodyDTO.builder().build();
        PaymentGatewayRequestHeadDTO head = PaymentGatewayRequestHeadDTO.builder().build();
        head.setMsgtype("JDTrade");
        head.setVersion(DEFAULT_VERSION);
        head.setSystemCode(SYSTEM_CODE);
        head.setTimestamp(String.valueOf(DateUtil.current()));
        head.setSign("");
        JSONObject headMap = JSON.parseObject((String)JSON.toJSONString((Object)head));
        JSONObject bodyMap = JSON.parseObject((String)JSON.toJSONString((Object)request.getWithholdingContractRequest().getRequestBody()));
        EpaySign epaySignClient = EpaySign.newInstance((String)this.publicKey, (String)this.privateKey, (Boolean)false);
        String content = epaySignClient.requestSign((Map)headMap, (Map)bodyMap);
        this.log.warn("\u652f\u4ed8\u7f51\u5173\uff0c\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\uff0c \u8bf7\u6c42\u53c2\u6570sign\uff1a{}", (Object)content);
        head.setSign(content);
        PaymentContractServiceRequest req = PaymentContractServiceRequest.builder().build();
        req.setHead(head);
        req.setBody(request.getWithholdingContractRequest().getRequestBody());
        request.setPaymentContractServiceRequest(req);
        PaymentContractResponse resp = null;
        try {
            this.log.warn("\u8c03\u7528\u652f\u4ed8\u6838\u5fc3\u6838\u5fc3\u63a5\u53e3\u8bf7\u6c42\uff1a{}", (Object)JSON.toJSONString((Object)request));
            resp = this.paymentGatewayApi.paymentContract(request);
            this.log.warn("\u8c03\u7528\u6838\u5fc3\u63a5\u53e3\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)resp));
        }
        catch (Exception e) {
            this.log.error("\u652f\u4ed8\u7f51\u5173\uff0c\u8c03\u7528\u6838\u5fc3\u652f\u4ed8\u4ee3\u6263\u7b7e\u7ea6\u63a5\u53e3\u62a5\u9519\uff0c\u4e1a\u52a1\u53f7{}", (Object)request.getWithholdingContractRequest().getRequestBody().getPolicyNo());
            throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B40002.getValue(), ErrorBisCodeEnum.ERR_B40002.getKey());
        }
        ApisBusiPaySignupLog apisBusiPaySignupLog = new ApisBusiPaySignupLog();
        apisBusiPaySignupLog.setBusinessNo(request.getWithholdingContractRequest().getRequestBody().getBusinessNo());
        apisBusiPaySignupLog.setResultCode(String.valueOf(resp.getHead().getCode()));
        if (resp != null && 0L != resp.getHead().getCode()) {
            this.log.error("\u652f\u4ed8\u7f51\u5173\uff0c\u8c03\u7528\u6838\u5fc3\u652f\u4ed8\u4ee3\u6263\u7b7e\u7ea6\u63a5\u53e3\u62a5\u9519\uff0c\u4e1a\u52a1\u53f7{},\u9519\u8bef\u4fe1\u606f:{}", (Object)request.getWithholdingContractRequest().getRequestBody().getPolicyNo(), (Object)resp.getHead().getMessage());
            String message = ErrorBisCodeEnum.ERR_B40002.getValue();
            if (StrUtil.isNotEmpty((CharSequence)resp.getHead().getMessage())) {
                message = resp.getHead().getMessage();
            }
            apisBusiPaySignupLog.setMsg(message);
            this.apisBusiPaySignupLogMapper.insert((Object)apisBusiPaySignupLog);
            throw new ApisBusinessException(message, ErrorBisCodeEnum.ERR_B40002.getKey());
        }
        apisBusiPaySignupLog.setMsg(resp.getHead().getMessage());
        apisBusiPaySignupLog.setPayApplyNo(resp.getBody().getPayApplyNo());
        apisBusiPaySignupLog.setOutTradeNo(resp.getBody().getOutTradeNo());
        apisBusiPaySignupLog.setRequestUrl(resp.getBody().getRequestUrl());
        this.apisBusiPaySignupLogMapper.insert((Object)apisBusiPaySignupLog);
        BeanUtils.copyProperties((Object)resp.getBody(), (Object)bodyDTO);
        response.setBody(bodyDTO);
        return StanderResponse.builder().header(request.getHeader()).withholdingContractServiceResponse(response).build();
    }
}

