/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl.StanderImgBatchUploadHandler;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.EmailCommonUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.LitigationQuotePriceValidate;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.LitigationUtils;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.MediaUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.QuotePriceValidate;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyNoGetRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyNoGetRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.QuotePriceServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiGuaranteeUnderwriteResultLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiGuaranteeUnderwriteResultLogService;
import com.jdaz.sinosoftgz.apis.commons.model.constant.ModelConstants;
import com.jdaz.sinosoftgz.apis.constants.ApisCommonConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class StanderlitigationQuotePriceHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(StanderlitigationQuotePriceHandler.class);
    @Value(value="${litigation.minPremium}")
    private BigDecimal minPremium;
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    MediaUploadUtil mediaUploadUtil;
    @Autowired
    HttpRequestService httpRequestService;
    @Autowired
    QuotePriceValidate quotePriceValidate;
    @Autowired
    StanderImgBatchUploadHandler standerImgBatchUploadHandler;
    @Autowired
    LitigationQuotePriceValidate litigationQuotePriceValidate;
    @Autowired
    private EmailCommonUtil emailCommonUtil;
    @Autowired
    private LitigationUtils litigationUtils;
    @Autowired
    ApisBusiGuaranteeUnderwriteResultLogService apisBusiGuaranteeUnderwriteResultLogService;
    private final String REQUEST_ENTITY_QUOTEPRICE = "quotePriceServiceRequest";
    private final String RESPONSE_ENTITY_QUOTEPRICE = "policyListQueryResponse";
    private final String RESPONSE_ENTITY_PLOICYNOGET = "policyNoGetResponse";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        TimeInterval timer = DateUtil.timer();
        request.getQuotePriceServiceRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        BaseApisParamUtil.verificationRequest((StanderRequest)request, (String)"quotePriceServiceRequest");
        this.dataCompletionUtil.dataCompletion(request);
        this.log.warn("\u6570\u636e\u8865\u5168\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        MainDTO mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(mainDTO.getInputDate());
        calendar.add(5, 1);
        mainDTO.setStartDate(calendar.getTime());
        calendar.setTime(mainDTO.getStartDate());
        calendar.add(1, 1);
        mainDTO.setEndDate(calendar.getTime());
        Integer reapplyFlag = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getReapplyFlag();
        if (ModelConstants.INT_VALUE_YES.equals(reapplyFlag)) {
            request.getQuotePriceServiceRequest().getRequestHead().setConsumerSeqNo(UUID.randomUUID().toString());
        } else {
            request.getQuotePriceServiceRequest().getRequestHead().setConsumerSeqNo(request.getHeader().getUserCode() + mainDTO.getOrderNo());
        }
        this.litigationQuotePriceValidate.validateRquest(request);
        this.log.warn("\u51fa\u5355\u89c4\u5219\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.calculateTotalPremium(request);
        this.log.warn("\u4fdd\u8d39\u8ba1\u7b97\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        ApisBusiChannelOrder apisBusinessChannelOrder = new ApisBusiChannelOrder();
        apisBusinessChannelOrder.setRequestTime(LocalDateTime.now());
        QuotePriceServiceResponse quotePriceServiceResponse = QuotePriceServiceResponse.builder().build();
        Double sumPremium = null;
        MainDTO mainDTO = MainDTO.builder().build();
        try {
            apisBusinessChannelOrder.setStatus("01");
            String businessNo = "";
            StanderResponse quotePriceResponse = this.coreInsureApi.quotePrice(request);
            BaseApisParamUtil.verificationResponse((StanderResponse)quotePriceResponse, (String)"policyListQueryResponse");
            mainDTO = quotePriceResponse.getPolicyListQueryResponse().getResponseBody().getMain();
            apisBusinessChannelOrder.setPayType(mainDTO.getJFeeFlag());
            sumPremium = mainDTO.getSumPremium();
            apisBusinessChannelOrder.setProposalTime(LocalDateTime.now());
            apisBusinessChannelOrder.setProposalNo(mainDTO.getProposalNo());
            ImgBatchUploadServiceRequest imgBatchUploadServiceRequest = ImgBatchUploadServiceRequest.builder().build();
            ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = ImgBatchUploadRequestDTO.builder().build();
            imgBatchUploadRequestDTO.setLinkNo(mainDTO.getProposalNo());
            imgBatchUploadRequestDTO.setOrderNo(mainDTO.getOrderNo());
            imgBatchUploadServiceRequest.setRequestBody(imgBatchUploadRequestDTO);
            request.setImgBatchUploadServiceRequest(imgBatchUploadServiceRequest);
            this.mediaUploadUtil.syncUploadGuaranteeMaterial(request);
            apisBusinessChannelOrder.setStatus("02");
            Map map = this.policyNoGetService(apisBusinessChannelOrder, request, mainDTO);
            businessNo = (String)DataCompletionUtil.castToClass(String.class, map.get("businessNo"));
            StanderRequest policySubmitRequest = this.dataCompletionUtil.packagePolicyConfirmRequestData(mainDTO, request, businessNo, "P");
            policySubmitRequest.getPolicySubmitRequest().getRequestBody().setPaymentFlag("3");
            String orderNo = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getOrderNo();
            Integer reapplyFlag = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getReapplyFlag();
            if (ModelConstants.INT_VALUE_YES.equals(reapplyFlag)) {
                policySubmitRequest.getPolicySubmitRequest().getRequestBody().setBeforeNoList(this.getBeforeNoListByOrderNo(orderNo));
            } else {
                policySubmitRequest.getPolicySubmitRequest().getRequestBody().setBeforeNoList(new String[0]);
            }
            if (this.underWriteTypeIsEx(request)) {
                policySubmitRequest.getPolicySubmitRequest().getRequestBody().setUnderWriteType("EX");
            } else {
                policySubmitRequest.getPolicySubmitRequest().getRequestBody().setUnderWriteType("BH");
            }
            this.coreInsureApi.policySubmit(policySubmitRequest);
            if (StringUtils.isNotEmpty((CharSequence)businessNo)) {
                apisBusinessChannelOrder.setPolicyNo(businessNo);
                apisBusinessChannelOrder.setPolicyTime(LocalDateTime.now());
                apisBusinessChannelOrder.setStatus("05");
            }
            ResponseHeadDTO responseHeadDTO = ResponseHeadDTO.builder().build();
            responseHeadDTO.setConsumerSeqNo(request.getQuotePriceServiceRequest().getRequestHead().getConsumerSeqNo());
            QuotePriceServiceResponseDTO responseBody = QuotePriceServiceResponseDTO.builder().build();
            if (!StringUtils.isNotEmpty((CharSequence)businessNo)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10054.getValue(), ChannelErrorCodeEnum.ERR_C10054.getKey());
            }
            String agencyPolicyRef = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getOrderNo();
            responseBody.setAgencyPolicyRef(agencyPolicyRef);
            quotePriceServiceResponse.setResponseBody(responseBody);
            responseHeadDTO.setStatus(1);
            quotePriceServiceResponse.setResponseHead(responseHeadDTO);
            this.dataCompletionUtil.insertReqMsg(request, quotePriceServiceResponse, businessNo, "2");
            this.litigationUtils.updateClerk(mainDTO.getOrderNo());
            if (!this.underWriteTypeIsEx(request)) {
                StringBuilder applyName = new StringBuilder();
                for (AppliClientDTO appliClientDTO : request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getAppliClient()) {
                    applyName.append(appliClientDTO.getInsuredName()).append(",");
                }
                applyName = new StringBuilder(applyName.substring(0, applyName.length() - 1));
                String planCode = ((ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getGoodsCode();
                this.emailCommonUtil.saveLitigationApplyEmailSend(planCode, applyName.toString(), apisBusinessChannelOrder.getProposalNo(), mainDTO.getOrderNo());
            }
        }
        catch (ApisBusinessException e) {
            throw new ApisBusinessException(e.getMessage(), e.getErrorCode());
        }
        finally {
            apisBusinessChannelOrder.setFinishedTime(LocalDateTime.now());
            if (ObjectUtil.isNotEmpty(sumPremium)) {
                apisBusinessChannelOrder.setPremium(new BigDecimal(sumPremium));
            }
            if (ObjectUtil.isNotEmpty((Object)mainDTO.getSumAmount())) {
                apisBusinessChannelOrder.setAmount(new BigDecimal(mainDTO.getSumAmount()));
            }
            Date startDate = new Date();
            this.dataCompletionUtil.insertApisBusinessChannelOrder(request, apisBusinessChannelOrder);
            this.log.warn("\u65b0\u589e\u6e20\u9053\u8ba2\u5355\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
        }
        return StanderResponse.builder().header(request.getHeader()).quotePriceServiceResponse(quotePriceServiceResponse).build();
    }

    public Map policyNoGetService(ApisBusiChannelOrder apisBusiChannelOrder, StanderRequest request, MainDTO mainDTO) throws ApisBusinessException {
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        StanderResponse policyNoGetResponse = this.coreInsureApi.policyNoGet(StanderRequest.builder().header(request.getHeader()).policyNoGetRequest(PolicyNoGetRequest.builder().requestHead(request.getQuotePriceServiceRequest().getRequestHead()).requestBody(PolicyNoGetRequestDTO.builder().proposalNo(mainDTO.getProposalNo()).build()).build()).build());
        BaseApisParamUtil.verificationResponse((StanderResponse)policyNoGetResponse, (String)"policyNoGetResponse");
        String businessNo = policyNoGetResponse.getPolicyNoGetResponse().getResponseBody().getPrePolicyNo();
        apisBusiChannelOrder.setStatus("05");
        resultMap.put("businessNo", businessNo);
        resultMap.put("policyStatus", "60");
        return resultMap;
    }

    public void calculateTotalPremium(StanderRequest request) {
        MainDTO mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        ItemMainDTO itemMainDTO = (ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0);
        Double amout = itemMainDTO.getSumInsured();
        BigDecimal rate = this.getRate(new BigDecimal(amout));
        Double sumPremium = null;
        sumPremium = rate.compareTo(this.minPremium) == 0 ? Double.valueOf(this.minPremium.setScale(2, 4).doubleValue()) : Double.valueOf(new BigDecimal(amout).multiply(rate).setScale(2, 4).doubleValue());
        mainDTO.setSumPremium(sumPremium);
        mainDTO.setSumAmount(amout);
    }

    private BigDecimal getRate(BigDecimal amount) {
        if (amount.compareTo(new BigDecimal(3000000)) >= 0) {
            return new BigDecimal(0.001);
        }
        if (amount.compareTo(new BigDecimal(200000)) >= 0) {
            return new BigDecimal(0.0015);
        }
        if (amount.compareTo(new BigDecimal(90000)) >= 0) {
            return new BigDecimal(0.001);
        }
        return this.minPremium;
    }

    private boolean underWriteTypeIsEx(StanderRequest request) {
        Double exSumAmount = 1000000.0;
        Double sumAmount = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getSumAmount();
        String preservationType = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getRiskInfo().getPreservationType();
        ArrayList<String> preservationList = new ArrayList<String>();
        preservationList.add(ApisCommonConstantsEnum.PRESERVATION_CURRENCY_CASH.getKey());
        preservationList.add(ApisCommonConstantsEnum.PRESERVATION_DEPOSIT.getKey());
        preservationList.add(ApisCommonConstantsEnum.PRESERVATION_HOUSE_PROPERTY.getKey());
        return exSumAmount.compareTo(sumAmount) > 0 && preservationList.contains(preservationType);
    }

    private String[] getBeforeNoListByOrderNo(String orderNo) {
        this.log.warn("\u67e5\u8be2\u8ba2\u5355\u53f7\uff1a{}\u5ba1\u6838\u672a\u901a\u8fc7\u7684\u6295\u4fdd\u5355\u53f7", (Object)orderNo);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_no", (Object)orderNo);
        queryWrapper.eq((Object)"underwrite_flag", (Object)"2");
        queryWrapper.eq((Object)"deleted", (Object)ApisBusiGuaranteeUnderwriteResultLog.DELETE_FLAG_FALSE);
        queryWrapper.isNotNull((Object)"proposalNo");
        List underwriteResultLogList = this.apisBusiGuaranteeUnderwriteResultLogService.list((Wrapper)queryWrapper);
        return (String[])underwriteResultLogList.stream().map(ApisBusiGuaranteeUnderwriteResultLog::getProposalNo).filter(ObjectUtil::isNotEmpty).toArray(String[]::new);
    }
}

