/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationRateRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationRateResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationRateResponseDTO;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Value;

public class StanderlitigationRateHandler
implements BusinessHandler {
    @Value(value="${litigation.minPremium}")
    private BigDecimal minPremium;
    @Value(value="${litigation.maxApplyAmount}")
    private BigDecimal maxApplyAmount;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        request.getLitigationRateRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        LitigationRateResponse litigationRateResponse = LitigationRateResponse.builder().build();
        LitigationRateResponseDTO responseBody = LitigationRateResponseDTO.builder().build();
        LitigationRateRequest litigationRateRequest = request.getLitigationRateRequest();
        BigDecimal amount = litigationRateRequest.getRequestBody().getNDbje();
        BigDecimal rate = this.getRate(amount);
        BigDecimal premium = null;
        if (rate.compareTo(this.minPremium) == 0) {
            rate = new BigDecimal(0.001);
            premium = this.minPremium;
        } else {
            premium = amount.multiply(rate).setScale(2, 4);
        }
        responseBody.setMinRate(Double.valueOf(rate.doubleValue()));
        responseBody.setMaxRate(Double.valueOf(rate.doubleValue()));
        responseBody.setMaxAmount(premium);
        responseBody.setMinAmount(premium);
        responseBody.setMinPremium(this.minPremium.setScale(2));
        responseBody.setMaxApplyAmount(this.maxApplyAmount.setScale(2));
        litigationRateResponse.setResponseBody(responseBody);
        return StanderResponse.builder().header(request.getHeader()).litigationRateResponse(litigationRateResponse).build();
    }

    private BigDecimal getRate(BigDecimal amount) {
        if (amount.compareTo(new BigDecimal(3000000)) >= 0) {
            return new BigDecimal(0.001);
        }
        if (amount.compareTo(new BigDecimal(200000)) >= 0) {
            return new BigDecimal(0.0015);
        }
        if (amount.compareTo(new BigDecimal(90000)) >= 0) {
            return new BigDecimal(0.001);
        }
        return this.minPremium;
    }
}

