/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl.EPolicyDownServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.BaseApisParamUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.DeclarationVoucherRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.DeclarationVoucherRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.GoodDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.GroupPlanDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceServiceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.VoucherInformationDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredIdvDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiDeclarationVoucher;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiDeclarationVoucherService;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationMainService;
import com.jdaz.sinosoftgz.apis.constants.ApisCommonConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorCode;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ThirdpDeclarationVoucherHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(ThirdpDeclarationVoucherHandler.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    private DataCompletionUtil dataCompletionUtil;
    @Autowired
    private ApisPfpRationMainService apisPfpRationMainService;
    @Autowired
    private EPolicyDownServiceImpl ePolicyDownService;
    @Autowired
    private ApisBusiDeclarationVoucherService apisBusiDeclarationVoucherService;
    @Autowired
    private ApisBusinessService apisBusinessService;
    private static HashMap<String, String> voucherInfoPropMap = new /* Unavailable Anonymous Inner Class!! */;
    private static Map<String, String> insuredRelationMap = new /* Unavailable Anonymous Inner Class!! */;
    private static final String APIS_SYMBOL = "Apis";
    private static final String APIS_GROUP_CORRECT_SYMBOL = "HW_G002_";
    private static final String DECLARATION_VOUCHERREQUEST = "declarationVoucherRequest";
    private static final String DEFAULT_CHANGE_DESC = "\u534e\u4e3a\u7533\u62a5\u51ed\u8bc1\uff1a\u6279\u589e\u4eba\u5458\u4fe1\u606f\u3002";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        ArrayList<VoucherInformationDTO> voucherList;
        BaseApisParamUtil.verificationRequest((StanderRequest)request, (String)DECLARATION_VOUCHERREQUEST);
        if (ObjectUtil.isEmpty((Object)request.getHeader())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "header"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)request.getHeader().getChannelCode())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "channelCode"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)request.getHeader().getUserCode())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "userCode"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)request.getHeader().getBusinessKey())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "businessKey"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        DeclarationVoucherRequest dvRequest = request.getDeclarationVoucherRequest();
        DeclarationVoucherRequestDTO dvRequestBody = dvRequest.getRequestBody();
        if (ObjectUtil.isEmpty((Object)dvRequestBody.getApplicantInformation())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "applicantInformation"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)dvRequestBody.getVoucherInformation())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "voucherInformation"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (dvRequestBody.getApplicantInformation().size() > 1) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10013.getValue().replaceFirst("##", "applicantInformation"), ChannelErrorCodeEnum.ERR_C10013.getKey());
        }
        if (dvRequestBody.getVoucherInformation().size() > 1) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10013.getValue().replaceFirst("##", "voucherInformation"), ChannelErrorCodeEnum.ERR_C10013.getKey());
        }
        for (VoucherInformationDTO voucherInformationDTO : dvRequestBody.getVoucherInformation()) {
            BaseApisParamUtil.checkFieldThrowExp((Object)voucherInformationDTO, (HashMap)voucherInfoPropMap, (ErrorCode)ChannelErrorCodeEnum.ERR_C10664);
        }
        HashMap<String, ArrayList<VoucherInformationDTO>> addInsuredMap = new HashMap<String, ArrayList<VoucherInformationDTO>>();
        ArrayList<InsuredDTO> insuredDTOList = new ArrayList<InsuredDTO>();
        ArrayList<String> rationCodes = new ArrayList<String>();
        for (VoucherInformationDTO voucherInformationDTO : dvRequestBody.getVoucherInformation()) {
            List policyPlanList = this.getDeclarationVoucherInfoList(voucherInformationDTO);
            if (ObjectUtil.isNotEmpty((Object)policyPlanList)) {
                ApisBusiDeclarationVoucher apisBusiDeclarationVoucher = (ApisBusiDeclarationVoucher)policyPlanList.get(0);
                if (ObjectUtil.isEmpty((Object)apisBusiDeclarationVoucher.getPolicyNo()) || ObjectUtil.isEmpty((Object)apisBusiDeclarationVoucher.getPlanCode())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10665.getValue(), ChannelErrorCodeEnum.ERR_C10665.getKey());
                }
                if (!rationCodes.contains(apisBusiDeclarationVoucher.getPlanCode())) {
                    rationCodes.add(apisBusiDeclarationVoucher.getPlanCode());
                }
                InsuredDTO insuredDTO = InsuredDTO.builder().identifyNumber(voucherInformationDTO.getIdentifyNumber()).identifyType(voucherInformationDTO.getIdentifyType()).insuredName(voucherInformationDTO.getInsuredName()).insuredEname(voucherInformationDTO.getInsuredEname()).build();
                insuredDTOList.add(insuredDTO);
                voucherInformationDTO.setTmpGoodsCode(apisBusiDeclarationVoucher.getPlanCode());
                voucherList = (ArrayList<VoucherInformationDTO>)addInsuredMap.get(apisBusiDeclarationVoucher.getPolicyNo());
                if (null == voucherList) {
                    voucherList = new ArrayList<VoucherInformationDTO>();
                    addInsuredMap.put(apisBusiDeclarationVoucher.getPolicyNo(), voucherList);
                }
                voucherList.add(voucherInformationDTO);
                continue;
            }
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10665.getValue(), ChannelErrorCodeEnum.ERR_C10665.getKey());
        }
        dvRequestBody.setInsuredList(insuredDTOList);
        List apisPfpRationMainList = this.apisPfpRationMainService.findRationInfoByRationCodes(rationCodes);
        if (ObjectUtil.isEmpty((Object)apisPfpRationMainList)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10656.getValue().replaceFirst("##", Arrays.toString(rationCodes.toArray())), ChannelErrorCodeEnum.ERR_C10656.getKey());
        }
        String errorPlanCodes = "";
        ArrayList<GoodDTO> goodsList = new ArrayList<GoodDTO>();
        for (String rationCode : rationCodes) {
            List apisPfpRationMains = apisPfpRationMainList.stream().filter(rationMain -> rationCode.equals(rationMain.getRationCode())).collect(Collectors.toList());
            if (ObjectUtil.isEmpty(apisPfpRationMains)) {
                errorPlanCodes = errorPlanCodes + rationCode + ",";
                continue;
            }
            GoodDTO goodDTO = GoodDTO.builder().planCode(((ApisPfpRationMain)apisPfpRationMains.get(0)).getProductCode()).planName(((ApisPfpRationMain)apisPfpRationMains.get(0)).getProductName()).planType(((ApisPfpRationMain)apisPfpRationMains.get(0)).getRationType()).goodsCode(((ApisPfpRationMain)apisPfpRationMains.get(0)).getRationCode()).goodsName(((ApisPfpRationMain)apisPfpRationMains.get(0)).getRationName()).build();
            goodsList.add(goodDTO);
        }
        if (ObjectUtil.isNotEmpty((Object)errorPlanCodes)) {
            errorPlanCodes = "[" + errorPlanCodes.substring(0, errorPlanCodes.length() - 1) + "]";
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10656.getValue().replaceFirst("##", errorPlanCodes), ChannelErrorCodeEnum.ERR_C10656.getKey());
        }
        dvRequestBody.setGoodsList(goodsList);
        if (ObjectUtil.isNotEmpty(addInsuredMap)) {
            String policyNoStr = "";
            for (Map.Entry entry : addInsuredMap.entrySet()) {
                String policyNo = (String)entry.getKey();
                policyNoStr = policyNoStr + policyNo + ",";
                voucherList = (List)entry.getValue();
                boolean isAnyInsureNotInPolicy = false;
                StanderRequest groupCorrectRequest = null;
                for (VoucherInformationDTO voucherDTO : voucherList) {
                    PolicyDTO policyDTO = this.dataCompletionUtil.getPolicyDetailByInsureds(request, policyNo, voucherDTO.getInsuredName(), voucherDTO.getIdentifyNumber(), null, false);
                    if (this.isInsureNotExistInPolicy(policyDTO)) {
                        if (!isAnyInsureNotInPolicy) {
                            groupCorrectRequest = StanderRequest.builder().build();
                            this.dataCompleteGroupCorrectReqHead(groupCorrectRequest, request.getHeader().getChannelCode(), request.getHeader().getUserCode(), APIS_GROUP_CORRECT_SYMBOL + request.getHeader().getBusinessKey());
                            this.dataCompleteQuotePriceMain(groupCorrectRequest, policyDTO, APIS_GROUP_CORRECT_SYMBOL + request.getHeader().getBusinessKey());
                            isAnyInsureNotInPolicy = true;
                        }
                        this.dataCompletePlanInsureInfo(groupCorrectRequest, policyDTO, (AppliClientDTO)dvRequestBody.getApplicantInformation().get(0), voucherDTO);
                    }
                    voucherDTO.setTmpGoodsCode(null);
                }
                if (!isAnyInsureNotInPolicy) continue;
                String userCode = request.getHeader().getUserCode();
                try {
                    TimeInterval timer = DateUtil.timer();
                    this.apisBusinessService.execute("groupCorrect", groupCorrectRequest);
                    request.getHeader().setUserCode(userCode);
                    this.dataCompletionUtil.unLock(groupCorrectRequest);
                    this.log.warn("\u7533\u8bf7\u51ed\u8bc1\uff0c\u8c03\u7528\u56e2\u9669\u6279\u6539\u603b\u7528\u65f6, {}", (Object)timer.intervalRestart());
                }
                catch (ApisBusinessException ae) {
                    this.log.warn("\u7533\u8bf7\u51ed\u8bc1\u6279\u589e\u88ab\u4fdd\u9669\u4eba\u51fa\u9519\u4fe1\u606f\uff1a{}-{}", (Object)ae.getErrorCode(), (Object)ae.getMessage());
                    request.getHeader().setUserCode(userCode);
                    this.dataCompletionUtil.unLock(groupCorrectRequest);
                    StringBuilder sb = new StringBuilder();
                    sb.append(ChannelErrorCodeEnum.ERR_C10666.getValue()).append("-");
                    sb.append(ae.getMessage());
                    throw new ApisBusinessException(sb.toString(), ChannelErrorCodeEnum.ERR_C10666.getKey());
                }
                catch (Exception e) {
                    request.getHeader().setUserCode(userCode);
                    this.dataCompletionUtil.unLock(groupCorrectRequest);
                    throw e;
                }
            }
            policyNoStr = policyNoStr.substring(0, policyNoStr.length() - 1);
            dvRequestBody.setPolicyNo(policyNoStr);
        }
        request.getDeclarationVoucherRequest().setRequestHead(RequestHeadDTO.initRequestHead());
        if (StrUtil.isBlank((CharSequence)dvRequestBody.getSystemSource())) {
            dvRequestBody.setSystemSource(APIS_SYMBOL);
        }
        return request;
    }

    private List<ApisBusiDeclarationVoucher> getDeclarationVoucherInfoList(VoucherInformationDTO voucherInformationDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"plan_person_type", (Object)voucherInformationDTO.getRelation());
        if (!ApisCommonConstantsEnum.ASSURED_INSURER_RELATION_PERSONAL.getKey().equals(voucherInformationDTO.getRelation())) {
            queryWrapper.eq((Object)"plan_risk_info", (Object)voucherInformationDTO.getIsHardArea());
        }
        queryWrapper.eq((Object)"deleted", (Object)ApisBusiDeclarationVoucher.DELETE_FLAG_FALSE);
        queryWrapper.le((Object)"start_date", (Object)voucherInformationDTO.getStartDate());
        queryWrapper.ge((Object)"end_date", (Object)voucherInformationDTO.getStartDate());
        List retList = this.apisBusiDeclarationVoucherService.list((Wrapper)queryWrapper);
        return retList;
    }

    private boolean isInsureNotExistInPolicy(PolicyDTO policyDTO) {
        boolean isInsureNotExistInPolicy = true;
        if (ObjectUtil.isNotEmpty((Object)policyDTO.getCoverage().getItemList())) {
            for (ItemMainDTO itemMainDTO : policyDTO.getCoverage().getItemList()) {
                if (!ObjectUtil.isNotEmpty((Object)itemMainDTO.getInsuredIdvList())) continue;
                isInsureNotExistInPolicy = false;
                break;
            }
        }
        return isInsureNotExistInPolicy;
    }

    private void dataCompleteQuotePriceMain(StanderRequest request, PolicyDTO policyDTO, String businessKey) {
        MainDTO mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        mainDTO.setOrderNo(businessKey);
        mainDTO.setPolicyNo(policyDTO.getMain().getPolicyNo());
        mainDTO.setIssueFlag("Y");
        mainDTO.setStartDate(policyDTO.getMain().getStartDate());
        mainDTO.setEndDate(policyDTO.getMain().getEndDate());
        mainDTO.setOperateCode("JXX9048");
        mainDTO.setChangeDesc(DEFAULT_CHANGE_DESC);
    }

    private void dataCompletePlanInsureInfo(StanderRequest request, PolicyDTO policyDTO, AppliClientDTO appliClientDTO, VoucherInformationDTO voucherInformationDTO) {
        InsuredIdvDTO insuredIdvDTO = InsuredIdvDTO.builder().insuredName(voucherInformationDTO.getInsuredName()).insuredEname(voucherInformationDTO.getInsuredEname()).startDate(policyDTO.getMain().getStartDate()).endDate(policyDTO.getMain().getEndDate()).identifyType(voucherInformationDTO.getIdentifyType()).identifyNumber(voucherInformationDTO.getIdentifyNumber()).birthday(voucherInformationDTO.getBirthday()).mobile(voucherInformationDTO.getMobile()).email(voucherInformationDTO.getEmail()).sex(voucherInformationDTO.getSex()).benefitModeCode("1").benefitOrder("4").operatorType("A").insuredId(APIS_SYMBOL + UUID.fastUUID().toString().replaceAll("-", "")).insuredType("1").build();
        if (!ApisCommonConstantsEnum.ASSURED_INSURER_RELATION_PERSONAL.getKey().equals(voucherInformationDTO.getRelation())) {
            insuredIdvDTO.setMainInsuredName(appliClientDTO.getInsuredName());
            insuredIdvDTO.setMainInsuredIdNumber(appliClientDTO.getIdentifyNumber());
            insuredIdvDTO.setMainInsuredIdType(appliClientDTO.getIdentifyType());
            insuredIdvDTO.setRelationToInsured((String)insuredRelationMap.get(voucherInformationDTO.getRelation()));
        }
        List groupPlanDTOList = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getPlanList();
        List goodsCodeInsList = groupPlanDTOList.stream().filter(dto -> voucherInformationDTO.getTmpGoodsCode().equals(dto.getPlanCode())).collect(Collectors.toList());
        GroupPlanDTO groupPlanDTO = null;
        if (ObjectUtil.isEmpty(goodsCodeInsList)) {
            groupPlanDTO = GroupPlanDTO.builder().planCode(voucherInformationDTO.getTmpGoodsCode()).insuredIdvList(new ArrayList()).build();
            groupPlanDTOList.add(groupPlanDTO);
        } else {
            groupPlanDTO = (GroupPlanDTO)goodsCodeInsList.get(0);
        }
        List insuredIdvDTOList = groupPlanDTO.getInsuredIdvList();
        insuredIdvDTOList.add(insuredIdvDTO);
    }

    private void dataCompleteGroupCorrectReqHead(StanderRequest request, String channelCode, String userCode, String businessKey) {
        StanderHeader header = StanderHeader.builder().bussinessType("groupCorrect").channelCode(channelCode).userCode(userCode).businessKey(businessKey).build();
        MainDTO mainDTO = MainDTO.builder().build();
        ArrayList planList = new ArrayList();
        QuotePriceDTO quotePriceDTO = QuotePriceDTO.builder().main(mainDTO).planList(planList).build();
        QuotePriceServiceRequestDTO requestBody = QuotePriceServiceRequestDTO.builder().quotePrice(quotePriceDTO).build();
        QuotePriceServiceRequest quotePriceServiceRequest = QuotePriceServiceRequest.builder().requestBody(requestBody).build();
        request.setHeader(header);
        request.setQuotePriceServiceRequest(quotePriceServiceRequest);
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        return this.coreInsureApi.declarationVoucher(request);
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        if (response == null || response.getDeclarationVoucherResponse() == null) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00002.getKey(), ErrorNullValueCodeEnum.ERR_N00002.getValue());
        }
        if (ObjectUtil.isNotEmpty((Object)response.getDeclarationVoucherResponse().getResponseBody())) {
            response.getDeclarationVoucherResponse().getResponseBody().setVoucherUrl(this.ePolicyDownService.aesEncryptVoucherUrl(response.getDeclarationVoucherResponse().getResponseBody().getVoucherNo(), response.getDeclarationVoucherResponse().getResponseBody().getVoucherUrl()));
        }
        return response;
    }
}

