/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.ThyroidAddressService;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.ThyroidUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ThyroidAddressDataRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ThyroidAddressRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.thyroid.ThyroidAddressResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiThyroidAddressLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiThyroidAddressLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelUserService;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfpRationMainMapper;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.mysql.cj.util.StringUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

public class ThyroidAddressHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(ThyroidAddressHandler.class);
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    ThyroidAddressService thyroidAddressService;
    @Autowired
    ApisPfpRationMainMapper apisPfpRationMainMapper;
    @Autowired
    ApisChannelUserService apisChannelUserService;
    @Autowired
    ThyroidUtil thyroidUtil;
    @Autowired
    ApisBusiThyroidAddressLogService apisBusiThyroidAddressLogService;
    private static final String DEFAULT_VERSION = "1.0";
    private static final String PRODUCT_NAME = "\u4e2a\u4eba\u610f\u5916\u4fdd\u9669";

    public StanderRequest dataCompletion(StanderRequest request) throws ApisDataCompletionException {
        if (request == null || request.getThyroidAddressRequest() == null) {
            throw new ApisDataCompletionException(ErrorNullValueCodeEnum.ERR_N00001.getValue(), ErrorNullValueCodeEnum.ERR_N00001.getKey());
        }
        this.isRepeat(request);
        this.defaultValue(request);
        return request;
    }

    private void defaultValue(StanderRequest request) throws ApisDataCompletionException {
        ApisPfpRationMain apisPfpRationMain;
        request.getThyroidAddressRequest().getThyroidAddressBody().setVersion(DEFAULT_VERSION);
        request.getThyroidAddressRequest().getThyroidAddressBody().setApiCode("thyroidEvaluate");
        request.getThyroidAddressRequest().getThyroidAddressBody().getData().setCpCode("Allianz");
        request.getThyroidAddressRequest().getThyroidAddressBody().getData().setCpName("\u4eac\u4e1c\u5b89\u8054");
        request.getThyroidAddressRequest().getThyroidAddressBody().setAppId(this.thyroidUtil.getAppId());
        request.getThyroidAddressRequest().getThyroidAddressBody().setAppKey(this.thyroidUtil.getAppKey());
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"user_code", (Object)request.getHeader().getUserCode())).eq((Object)"deleted", (Object)ApisChannelUser.DELETE_FLAG_FALSE);
        List apisChannelUserList = this.apisChannelUserService.list((Wrapper)queryWrapper);
        if (apisChannelUserList.size() <= 0) {
            throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10473.getValue(), ChannelErrorCodeEnum.ERR_C10473.getKey());
        }
        ApisChannelUser apisChannelUser = (ApisChannelUser)apisChannelUserList.get(0);
        if (!BeanUtil.isEmpty((Object)apisChannelUser, (String[])new String[0])) {
            request.getThyroidAddressRequest().getThyroidAddressBody().getData().setChannelName(apisChannelUser.getChannelName());
            request.getThyroidAddressRequest().getThyroidAddressBody().getData().setChannelCode(apisChannelUser.getChannelCode());
        }
        if (!BeanUtil.isEmpty((Object)(apisPfpRationMain = this.apisPfpRationMainMapper.getApisPfpRationMainByPlanCode(request.getThyroidAddressRequest().getThyroidAddressBody().getData().getPlanCode())), (String[])new String[0])) {
            request.getThyroidAddressRequest().getThyroidAddressBody().getData().setProductName(apisPfpRationMain.getProductName());
            request.getThyroidAddressRequest().getThyroidAddressBody().getData().setBenefitCode(apisPfpRationMain.getProductCode());
        }
        if (StringUtils.isNullOrEmpty((String)request.getThyroidAddressRequest().getThyroidAddressBody().getData().getProductName())) {
            request.getThyroidAddressRequest().getThyroidAddressBody().getData().setProductName(PRODUCT_NAME);
        }
        try {
            request.getThyroidAddressRequest().getThyroidAddressBody().setSign(this.getSign(request.getThyroidAddressRequest().getThyroidAddressBody()));
        }
        catch (Exception e) {
            throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10383.getValue() + e.getMessage(), ChannelErrorCodeEnum.ERR_C10383.getKey());
        }
    }

    private void isRepeat(StanderRequest request) throws ApisDataCompletionException {
        boolean isSet = this.setRedisKey(request.getThyroidAddressRequest().getThyroidAddressBody().getData().getBzId());
        if (!isSet) {
            throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10469.getValue(), ChannelErrorCodeEnum.ERR_C10469.getKey());
        }
    }

    private boolean setRedisKey(String key) {
        boolean isSet = this.redisTemplate.opsForValue().setIfAbsent((Object)("thAddress:" + key), (Object)1);
        if (isSet) {
            this.redisTemplate.expire((Object)("thAddress:" + key), 3L, TimeUnit.SECONDS);
        }
        return isSet;
    }

    public StanderResponse execute(StanderRequest request) {
        String url = this.thyroidUtil.getUrl();
        ThyroidAddressRequestDTO thyroidAddressRequestDTO = request.getThyroidAddressRequest().getThyroidAddressBody();
        ThyroidAddressResponse responseDTO = (ThyroidAddressResponse)this.thyroidAddressService.thyroidSend(url, (Object)thyroidAddressRequestDTO, ThyroidAddressResponse.class);
        StanderResponse response = StanderResponse.builder().header(request.getHeader()).thyroidAddressResponse(responseDTO).build();
        return response;
    }

    private String getSign(ThyroidAddressRequestDTO thyroidAddressRequestDTO) throws Exception {
        String content = JSON.toJSONString((Object)thyroidAddressRequestDTO.getData(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField});
        content.replaceAll("\n", "");
        String sign = this.thyroidUtil.createMD5Sign(content);
        return sign;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        if (response == null || response.getThyroidAddressResponse() == null) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00002.getValue(), ErrorNullValueCodeEnum.ERR_N00002.getKey());
        }
        if (!ChannelErrorCodeEnum.ERR_C10002.getKey().equals(response.getThyroidAddressResponse().getCode())) {
            throw new ApisBusinessException(response.getThyroidAddressResponse().getDesc(), ErrorNullValueCodeEnum.ERR_N50001.getKey());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"serialNumber", (Object)response.getThyroidAddressResponse().getData().getSerialNumber())).eq((Object)"deleted", (Object)ApisChannelUser.DELETE_FLAG_FALSE);
        List apisBusiThyroidAddressLogList = this.apisBusiThyroidAddressLogService.list((Wrapper)queryWrapper);
        if (apisBusiThyroidAddressLogList.size() <= 0) {
            ThyroidAddressDataRequestDTO data = request.getThyroidAddressRequest().getThyroidAddressBody().getData();
            ApisBusiThyroidAddressLog apisBusiThyroidAddressLog = new ApisBusiThyroidAddressLog();
            apisBusiThyroidAddressLog.setBzID(data.getBzId());
            apisBusiThyroidAddressLog.setChannelCode(data.getChannelCode());
            apisBusiThyroidAddressLog.setGender(Integer.valueOf(Integer.parseInt(data.getGender())));
            apisBusiThyroidAddressLog.setGuId(data.getGuId());
            apisBusiThyroidAddressLog.setPlanCode(data.getPlanCode());
            apisBusiThyroidAddressLog.setProductCode(data.getBenefitCode());
            apisBusiThyroidAddressLog.setCallbackUrl(request.getThyroidAddressRequest().getThyroidAddressBody().getCallbackUrl());
            apisBusiThyroidAddressLog.setSerialNumber(response.getThyroidAddressResponse().getData().getSerialNumber());
            this.apisBusiThyroidAddressLogService.save((Object)apisBusiThyroidAddressLog);
            log.warn("\u56de\u8c03url\u4e3a:{}", (Object)apisBusiThyroidAddressLog.getCallbackUrl());
        }
        return response;
    }
}

