/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.ThyroidAddressService;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.ThyroidUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ThyroidInquiryRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ThyroidNoticeDataRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ThyroidNoticeRequest;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiThyroidAddressLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiThyroidAddressLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiThyroidResultLogService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ThyroidNoticeHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(ThyroidNoticeHandler.class);
    @Autowired
    ThyroidAddressService thyroidAddressService;
    @Autowired
    ThyroidUtil tyroidUtil;
    @Autowired
    ApisBusiThyroidResultLogService apisBusiThyroidResultLogService;
    @Autowired
    ApisBusiThyroidAddressLogService apisBusiThyroidAddressLogService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisDataCompletionException {
        if (request == null || request.getThyroidNoticeRequest() == null) {
            throw new ApisDataCompletionException(ErrorNullValueCodeEnum.ERR_N00001.getValue(), ErrorNullValueCodeEnum.ERR_N00001.getKey());
        }
        String content = JSON.toJSONString((Object)request.getThyroidNoticeRequest().getData());
        log.warn("\u7532\u72b6\u817a\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)JSONObject.toJSONString((Object)request.getThyroidNoticeRequest()));
        log.warn("content \uff1a{}sign: {}", (Object)content, (Object)request.getThyroidNoticeRequest().getSign());
        try {
            boolean check = this.tyroidUtil.verifyMD5Sign(content, request.getThyroidNoticeRequest().getSign());
            if (!check) {
                log.warn("\u6570\u5b57\u7b7e\u540d\u4e0d\u901a\u8fc7");
                throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10383.getValue(), ChannelErrorCodeEnum.ERR_C10383.getKey());
            }
        }
        catch (Exception e) {
            log.warn("\u6570\u636e\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10383.getValue() + e.getMessage(), ChannelErrorCodeEnum.ERR_C10383.getKey());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"serialNumber", (Object)request.getThyroidNoticeRequest().getData().getSerialNumber());
        List apisThyroidResultList = this.apisBusiThyroidResultLogService.list((Wrapper)queryWrapper);
        if (apisThyroidResultList.size() > 0) {
            throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10699.getValue(), ChannelErrorCodeEnum.ERR_C10699.getKey());
        }
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisDataCompletionException {
        ThyroidNoticeRequest thyroidNoticeRequest = request.getThyroidNoticeRequest();
        ThyroidNoticeDataRequestDTO thyroidNoticeDataRequestDTO = thyroidNoticeRequest.getData();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"bzID", (Object)thyroidNoticeRequest.getData().getBzId())).eq((Object)"deleted", (Object)ApisBusiThyroidAddressLog.DELETE_FLAG_FALSE);
        List apisThyroidAddressList = this.apisBusiThyroidAddressLogService.list((Wrapper)queryWrapper);
        if (apisThyroidAddressList.size() <= 0 || StringUtils.isEmpty((CharSequence)((ApisBusiThyroidAddressLog)apisThyroidAddressList.get(0)).getCallbackUrl())) {
            throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10700.getValue(), ChannelErrorCodeEnum.ERR_C10700.getKey());
        }
        log.warn("\u5f02\u6b65\u901a\u77e5\u6e20\u9053\uff0c\u5730\u5740\u4e3a{}", (Object)((ApisBusiThyroidAddressLog)apisThyroidAddressList.get(0)).getCallbackUrl());
        this.tyroidUtil.syncNotice(thyroidNoticeDataRequestDTO, ((ApisBusiThyroidAddressLog)apisThyroidAddressList.get(0)).getCallbackUrl());
        return null;
    }

    private String getSign(ThyroidInquiryRequest thyroidInquiryRequest) throws Exception {
        String content = JSON.toJSONString((Object)thyroidInquiryRequest.getData());
        String sign = this.tyroidUtil.createMD5Sign(content);
        return sign;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        this.tyroidUtil.inserResultLog(request.getThyroidNoticeRequest().getData());
        QueryWrapper apisBusiThyroidAddressLogQueryWrapper = new QueryWrapper();
        apisBusiThyroidAddressLogQueryWrapper.eq((Object)"serialNumber", (Object)request.getThyroidNoticeRequest().getData().getSerialNumber());
        ApisBusiThyroidAddressLog addressLog = (ApisBusiThyroidAddressLog)this.apisBusiThyroidAddressLogService.getOne((Wrapper)apisBusiThyroidAddressLogQueryWrapper);
        addressLog.setIsCallback(Integer.valueOf(1));
        this.apisBusiThyroidAddressLogService.updateById((Object)addressLog);
        return response;
    }
}

