/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.ManUnderwriteService;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.DesUtils;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.ValidatorsUtils;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.ManUnderwriteResultFromZzRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.ZhizhenReqHead;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.zhizhen.ZhizhenRequest;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwInsured;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwResult;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUwSupport;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwInsuredService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwResultService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUwSupportService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ZzErrorCodeEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ZhiZhenManUnderwriteResultHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(ZhiZhenManUnderwriteResultHandler.class);
    @Autowired
    ApisBusiUwSupportService apisBusiUwSupportService;
    @Autowired
    ValidatorsUtils validatorsUtils;
    @Autowired
    ApisBusiUwOrderService apisBusiUwOrderService;
    @Autowired
    ApisBusiUwInsuredService apisBusiUwInsuredService;
    @Autowired
    ApisBusiUwResultService apisBusiUwResultService;
    @Autowired
    ManUnderwriteService manUnderwriteService;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        this.decrypyBody(request);
        try {
            this.validatorsUtils.valid((Object)request.getZzResultRequest());
            this.validatorsUtils.valid(request.getZzResultRequest().getBody());
        }
        catch (ApisBusinessException e) {
            throw new ApisBusinessException(e.getMessage(), ZzErrorCodeEnum.ERR_STAT_2.getKey() + "");
        }
        if (ObjectUtils.isEmpty((Object)((ManUnderwriteResultFromZzRequest)request.getZzResultRequest().getBody()).getInsuredList())) {
            throw new ApisBusinessException("\u88ab\u4fdd\u9669\u4eba\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a", ZzErrorCodeEnum.ERR_STAT_2.getKey() + "");
        }
        this.checkSign(request.getZzResultRequest());
        this.checkIdempotent((ManUnderwriteResultFromZzRequest)request.getZzResultRequest().getBody());
        return request;
    }

    private void decrypyBody(StanderRequest request) throws ApisBusinessException {
        ApisBusiUwSupport support = this.apisBusiUwSupportService.getEnableSupport("ZZ");
        DesUtils utils = new DesUtils(support.getSecret());
        String encodeBody = utils.decrypt((String)request.getZzRequest().getBody());
        if (StringUtils.isBlank((CharSequence)encodeBody)) {
            throw new ApisBusinessException(ZzErrorCodeEnum.ERR_STAT_2.getValue(), ZzErrorCodeEnum.ERR_STAT_2.getKey() + "");
        }
        ManUnderwriteResultFromZzRequest body = (ManUnderwriteResultFromZzRequest)JSON.parseObject((String)encodeBody, ManUnderwriteResultFromZzRequest.class);
        if (ObjectUtils.isEmpty((Object)body)) {
            throw new ApisBusinessException(ZzErrorCodeEnum.ERR_STAT_2.getValue(), ZzErrorCodeEnum.ERR_STAT_2.getKey() + "");
        }
        ZhizhenReqHead head = new ZhizhenReqHead();
        BeanUtil.copyProperties((Object)request.getZzRequest().getHead(), (Object)head, (String[])new String[0]);
        ZhizhenRequest zzResultRequest = new ZhizhenRequest();
        zzResultRequest.setHead(head);
        zzResultRequest.setBody((Object)body);
        log.warn("\u81f3\u81fb-\u7ed3\u679c\u901a\u77e5\u63a5\u53e3\u89e3\u5bc6\u540e\u8bf7\u6c42\u62a5\u6587: {}", (Object)JSON.toJSONString((Object)zzResultRequest));
        request.setZzResultRequest(zzResultRequest);
    }

    private void checkIdempotent(ManUnderwriteResultFromZzRequest body) throws ApisBusinessException {
        ApisBusiUwOrder order = this.apisBusiUwOrderService.getByOrderNo(body.getReqOrderNo());
        if (ObjectUtils.isEmpty((Object)order)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10717.getValue(), ZzErrorCodeEnum.ERR_STAT_2.getKey() + "");
        }
        if (!order.getStatus().equals("4") && !order.getStatus().equals("9")) {
            throw new ApisBusinessException(ZzErrorCodeEnum.ERR_STAT_4.getValue(), ZzErrorCodeEnum.ERR_STAT_4.getKey() + "");
        }
        List insuredList = this.apisBusiUwInsuredService.listByOrderNo(body.getReqOrderNo());
        List dbIdList = insuredList.stream().map(ApisBusiUwInsured::getIdNo).collect(Collectors.toList());
        List notExistIds = body.getInsuredList().stream().filter(input -> !dbIdList.contains(input.getIdNo())).map(insured -> "\u88ab\u4fdd\u4eba\uff1a" + insured.getName() + "\u3010" + insured.getIdNo() + "\u3011").collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(notExistIds)) {
            String notExistIdsStr = String.join((CharSequence)",", notExistIds);
            String errMsg = "\u8ba2\u5355\u53f7\u3010" + body.getReqOrderNo() + "\u3011,\u4e0d\u5b58\u5728" + notExistIdsStr;
            throw new ApisBusinessException(errMsg, ZzErrorCodeEnum.ERR_STAT_2.getKey() + "");
        }
    }

    private void checkSign(ZhizhenRequest<ManUnderwriteResultFromZzRequest> zzResultRequest) throws ApisBusinessException {
        ApisBusiUwSupport support = this.apisBusiUwSupportService.getEnableSupport("ZZ");
        ZhizhenReqHead head = zzResultRequest.getHead();
        String key = SecureUtil.md5((String)(head.getAccount() + support.getPassword() + head.getReqTime()));
        if (!key.equals(head.getKey())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10383.getValue(), ZzErrorCodeEnum.ERR_STAT_2.getKey() + "");
        }
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        try {
            ManUnderwriteResultFromZzRequest body = (ManUnderwriteResultFromZzRequest)request.getZzResultRequest().getBody();
            String orderNo = body.getReqOrderNo();
            List insuredList = this.apisBusiUwInsuredService.listByOrderNo(orderNo);
            List uwIds = insuredList.stream().map(ApisBusiUwInsured::getUwId).collect(Collectors.toList());
            List resultList = this.apisBusiUwResultService.listByUwIds(uwIds);
            List results = this.convertResult(body, insuredList);
            if (ObjectUtils.isNotEmpty((Object)results)) {
                ArrayList shouldSaveList = new ArrayList();
                for (List result : results) {
                    shouldSaveList.addAll(result);
                }
                List notSupplyResults = shouldSaveList.stream().filter(r -> !"0".equals(r.getUwRsCode())).collect(Collectors.toList());
                this.apisBusiUwResultService.saveBatch(notSupplyResults);
                if (ObjectUtils.isNotEmpty((Object)resultList)) {
                    log.warn("\u62fc\u63a5BMI\u5408\u683c\u7684\u88ab\u4fdd\u4eba\uff1a{}", (Object)JSON.toJSONString((Object)resultList));
                    shouldSaveList.addAll(resultList);
                }
                this.updateOrderAndInsuredStatus(body, shouldSaveList);
                this.manUnderwriteService.convertAndPushAgent(request, shouldSaveList);
            }
        }
        catch (Exception e) {
            log.error("\u81f3\u81fb-\u7ed3\u679c\u901a\u77e5\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            throw new ApisBusinessException(ZzErrorCodeEnum.ERR_STAT_1.getValue(), ZzErrorCodeEnum.ERR_STAT_1.getKey() + "");
        }
        return StanderResponse.builder().build();
    }

    private void updateOrderAndInsuredStatus(ManUnderwriteResultFromZzRequest body, List<ApisBusiUwResult> shouldSaveList) {
        if (shouldSaveList.stream().anyMatch(r -> "0".equals(r.getUwRsCode()))) {
            this.apisBusiUwOrderService.updateStatus(body.getReqOrderNo(), "5");
        } else {
            this.apisBusiUwOrderService.updateStatus(body.getReqOrderNo(), "10");
        }
        List insureds = shouldSaveList.stream().filter(r -> "1".equals(r.getMain())).map(r -> {
            ApisBusiUwInsured insured = new ApisBusiUwInsured();
            insured.setUwId(r.getUwId());
            if ("0".equals(r.getUwRsCode())) {
                insured.setStatus("5");
            } else {
                insured.setStatus("10");
            }
            return insured;
        }).collect(Collectors.toList());
        this.apisBusiUwInsuredService.updateBatchAddInfoAndStatus(insureds);
    }

    private List<List<ApisBusiUwResult>> convertResult(ManUnderwriteResultFromZzRequest body, List<ApisBusiUwInsured> insuredList) {
        return body.getInsuredList().stream().map(insured -> {
            List insuredResults = insured.getUwResultList().stream().map(uwResult -> {
                ApisBusiUwResult result = new ApisBusiUwResult();
                ApisBusiUwInsured uwInsured = insuredList.stream().filter(data -> data.getIdNo().equals(insured.getIdNo())).findFirst().orElse(null);
                result.setUwId(uwInsured == null ? null : uwInsured.getUwId());
                result.setUwRsCode(uwResult.getUwResultCode());
                result.setMain("0");
                return result;
            }).collect(Collectors.toList());
            for (int i = 0; i < insuredResults.size(); ++i) {
                if (i != 0) continue;
                ApisBusiUwResult result = (ApisBusiUwResult)insuredResults.get(0);
                result.setMain("1");
                result.setPsRs(insured.getPsRs());
                result.setUwRsReason(insured.getUwRsReason());
                result.setExceptReason(insured.getExceptReason());
                result.setAddFeeRate(insured.getAddFeeRate());
                result.setUwExpireTime(LocalDateTimeUtil.of((Date)insured.getUwExpireTime()));
                result.setName(insured.getName());
                result.setIdNo(insured.getIdNo());
                ApisChannelCode code = this.apisChannelCodeService.getByChannelValue("ZZ_ZJLX", insured.getIdType());
                if (!ObjectUtils.isNotEmpty((Object)code)) continue;
                ApisChannelCode channelCode = this.apisChannelCodeService.getByValue("UW_ZJLX", code.getValue());
                result.setIdType(ObjectUtils.isEmpty((Object)code) ? null : channelCode.getChannelValue());
            }
            return insuredResults;
        }).collect(Collectors.toList());
    }
}

