/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl.groupPolicy;

import cn.hutool.core.util.StrUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.handler.impl.StanderPolicyDetailHandler;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicySubmitRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.policyActivate.PolicyActivateResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.policyActivate.PolicyActivateResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.policyActivate.PolicyConfirmResult;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiChannelOrderMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import com.jdaz.sinosoftgz.coreapi.common.utils.SpringContextHolder;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import com.jdaz.sinosoftgz.coreapi.insure.impl.CoreInsureApiImpl;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderGroupCorrectActivationHandler
implements BusinessHandler {
    private static Logger log = LoggerFactory.getLogger(StanderGroupCorrectActivationHandler.class);
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    StanderPolicyDetailHandler standerPolicyDetailHandler;
    @Autowired
    ApisBusiChannelOrderMapper apisBusiChannelOrderMapper;
    @Autowired
    ApisBusinessService apisBusinessService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        String policyNo = request.getPolicyActivateServiceRequest().getRequestBody().getBusinessNo();
        if (StrUtil.isEmpty((CharSequence)policyNo)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10406.getValue(), ChannelErrorCodeEnum.ERR_C10406.getKey());
        }
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        String applyNo = request.getPolicyActivateServiceRequest().getRequestBody().getApplyNo();
        String policyNo = request.getPolicyActivateServiceRequest().getRequestBody().getBusinessNo();
        CoreInsureApiImpl coreInsureApi = (CoreInsureApiImpl)DataCompletionUtil.castToClass(CoreInsureApiImpl.class, (Object)SpringContextHolder.getBean(CoreInsureApi.class), (boolean)false);
        PolicySubmitRequest submitRequest = coreInsureApi.policyActivateRequestBeforeProcess(request);
        HttpRequestService httpRequestService = (HttpRequestService)SpringContextHolder.getBean(HttpRequestService.class);
        submitRequest.getRequestBody().setBusinessNo(applyNo);
        submitRequest.getRequestBody().setBusinessType("E");
        PolicyConfirmResult result = (PolicyConfirmResult)httpRequestService.convertAndSend("policyConfirm", null, (Object)submitRequest, PolicyConfirmResult.class);
        PolicyActivateResponse policyActivateResponse = PolicyActivateResponse.builder().build();
        policyActivateResponse.setResponseHead(result.getResponseHead());
        PolicyActivateResponseDTO responseBody = PolicyActivateResponseDTO.builder().build();
        responseBody.setBusinessNo(policyNo);
        policyActivateResponse.setResponseBody(responseBody);
        return StanderResponse.builder().header(request.getHeader()).policyActivateResponse(policyActivateResponse).build();
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        BigDecimal totalPremium = request.getPolicyActivateServiceRequest().getRequestBody().getTotalPremium();
        BigDecimal adjustmentPremium = request.getPolicyActivateServiceRequest().getRequestBody().getAdjustmentPremium();
        response.getPolicyActivateResponse().getResponseBody().setAdjustmentPremium(adjustmentPremium);
        response.getPolicyActivateResponse().getResponseBody().setTotalPremium(totalPremium);
        response.getPolicyActivateResponse().getResponseBody().setPremium(totalPremium);
        response.getPolicyActivateResponse().getResponseBody().setPolicyStatus("70");
        return response;
    }
}

