/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.jms;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.EmailCommonUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiAsyncOrderMqLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiAsyncOrderMqLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import java.util.List;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.apache.rocketmq.spring.core.RocketMQPushConsumerLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
@RocketMQMessageListener(topic="apis-async-quotePrice", consumerGroup="apis-group", selectorExpression="quotePrice")
public class AsyncQuotePriceTopicsListener
implements RocketMQListener<String>,
RocketMQPushConsumerLifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(AsyncQuotePriceTopicsListener.class);
    @Autowired
    EmailCommonUtil emailCommonUtil;
    @Autowired
    ApisBusinessService apisBusinessService;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    ApisBusiAsyncOrderMqLogService apisBusiAsyncOrderMqLogService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;

    public void onMessage(String s) {
        StanderRequest standerRequest = null;
        try {
            standerRequest = (StanderRequest)JSON.parseObject((String)s, StanderRequest.class);
            if (standerRequest == null || standerRequest.getQuotePriceServiceRequest() == null) {
                throw new RuntimeException("\u5f02\u6b65\u51fa\u5355\uff0c\u63a5\u6536\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38:" + s);
            }
            StanderResponse response = this.apisBusinessService.execute("quotePrice", standerRequest);
            this.updateMQMessage(standerRequest, ApisBusiAsyncOrderMqLog.MESSAGE_STATUS_CONSUME_SUCCESS, "\u5f02\u6b65\u51fa\u5355\u6d88\u8d39\u6210\u529f");
        }
        catch (ApisBusinessException e) {
            String orderNo = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getOrderNo();
            this.redisTemplate.delete((Object)orderNo);
            String errorCode = e.getErrorCode();
            String errorMessage = e.getMessage();
            String emailTemplate = "\u5f02\u6b65\u51fa\u5355\u5904\u7406\u5f02\u5e38,errorCode:%s,errorMessage:%s\n" + s;
            String emailContent = String.format(emailTemplate, errorCode, errorMessage);
            this.sendErrorHandleEmail(emailContent);
            this.updateMQMessage(standerRequest, ApisBusiAsyncOrderMqLog.MESSAGE_STATUS_CONSUME_FAIL, "\u5f02\u6b65\u51fa\u5355\u6d88\u8d39\u5931\u8d25,errorCode:" + errorCode + "errorMessage:" + errorMessage);
        }
        catch (Exception e) {
            String emailContent = "\u5f02\u6b65\u51fa\u5355\u5904\u7406\u5f02\u5e38:\n" + s;
            this.sendErrorHandleEmail(emailContent);
            this.updateMQMessage(standerRequest, ApisBusiAsyncOrderMqLog.MESSAGE_STATUS_CONSUME_FAIL, "\u5f02\u6b65\u51fa\u5355\u6d88\u8d39\u5931\u8d25");
        }
    }

    public void prepareStart(DefaultMQPushConsumer defaultMQPushConsumer) {
        defaultMQPushConsumer.setMaxReconsumeTimes(1);
    }

    public void sendErrorHandleEmail(String content) {
        String subject = "\u5f02\u6b65\u51fa\u5355\u5904\u7406\u5931\u8d25\u901a\u77e5";
        String mailTo = "391506647@qq.com";
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"config_code", (Object)"EMAIL_ADDRESS_APIS_TEAM");
        ApisChannelConfigs apisChannelConfigs = (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs) && StrUtil.isNotEmpty((CharSequence)apisChannelConfigs.getConfigValue())) {
            mailTo = apisChannelConfigs.getConfigValue().replaceAll(";", ",");
        }
        this.emailCommonUtil.sendEmail(subject, content, mailTo, null);
    }

    private void updateMQMessage(StanderRequest standerRequest, String status, String remark) {
        String policyNo = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getPolicyRef();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"policy_no", (Object)policyNo);
        List list = this.apisBusiAsyncOrderMqLogService.list((Wrapper)queryWrapper);
        if (list.size() > 0) {
            ApisBusiAsyncOrderMqLog apisBusiAsyncOrderMqLog = (ApisBusiAsyncOrderMqLog)list.get(0);
            apisBusiAsyncOrderMqLog.setStatus(status);
            apisBusiAsyncOrderMqLog.setRemark(remark);
            this.apisBusiAsyncOrderMqLogService.saveOrUpdate((Object)apisBusiAsyncOrderMqLog);
        }
    }
}

