/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.jms;

import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.InsureCancelAutoDeductionPushUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.payment.CancelAutoDeductionMqDTO;
import com.jdaz.sinosoftgz.apis.commons.model.constant.MqConstants;
import com.jdaz.sinosoftgz.apis.commons.model.msg.entity.ApisMsgMqlogs;
import com.jdaz.sinosoftgz.apis.commons.service.msg.service.ApisMsgMqlogsService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@RocketMQMessageListener(topic="cancelAutoDeductTopic", selectorExpression="cancelAutoDeductTag", consumerGroup="cancelAutoDeductConsumerGroup")
public class InsureCancelAutoDeductionTopicsListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(InsureCancelAutoDeductionTopicsListener.class);
    @Autowired
    ApisMsgMqlogsService apisMsgMqlogsService;
    @Autowired
    InsureCancelAutoDeductionPushUtil insureCancelAutoDeductionPushUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        log.warn("received cancelAutoDeductTopic message: {}", (Object)message);
        Date startDate = new Date();
        String flag = "0";
        try {
            List dtoList = JSON.parseArray((String)message, CancelAutoDeductionMqDTO.class);
            this.verifyData(dtoList);
            this.insureCancelAutoDeductionPushUtil.pushCancelAutoDeduction(dtoList);
        }
        catch (Exception e) {
            flag = "1";
            log.error("InsureCancelAutoDeductionTopicsListener \u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
            apisMsgMqlogs.setCreateTime(startDate);
            apisMsgMqlogs.setMessage(message);
            apisMsgMqlogs.setTopic("cancelAutoDeductTopic:cancelAutoDeductTag");
            apisMsgMqlogs.setConsumerGroup("cancelAutoDeductConsumerGroup");
            apisMsgMqlogs.setErrorFlag(flag);
            apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
            this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
        }
    }

    private void verifyData(List<CancelAutoDeductionMqDTO> dtoList) throws ApisBusinessException {
        if (ObjectUtils.isEmpty(dtoList)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u4f20\u5165\u6d88\u606f"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        for (CancelAutoDeductionMqDTO deduction : dtoList) {
            if (StringUtils.isBlank((CharSequence)deduction.getPolicyNo())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u4fdd\u5355\u53f7policyNo"), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isBlank((CharSequence)deduction.getPolicyStatus())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u4fdd\u5355\u72b6\u6001policyStatus").concat(",\u4fdd\u5355\u53f7\uff1a").concat(deduction.getPolicyNo()), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isBlank((CharSequence)deduction.getCancelType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u89e3\u7ea6\u7c7b\u578bcancelType").concat(",\u4fdd\u5355\u53f7\uff1a").concat(deduction.getPolicyNo()), ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (MqConstants.CancelType.contains((String)deduction.getCancelType())) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10013.getValue().replace("##", "\u89e3\u7ea6\u7c7b\u578bcancelType").concat(",\u4fdd\u5355\u53f7\uff1a").concat(deduction.getPolicyNo()), ChannelErrorCodeEnum.ERR_C10013.getKey());
        }
    }
}

