/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.jms;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationOffLinePolicyMsgDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiGuaranteeOffLineOrderLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiGuaranteeOffLineOrderLogService;
import com.jdaz.sinosoftgz.apis.commons.model.msg.entity.ApisMsgMqlogs;
import com.jdaz.sinosoftgz.apis.commons.service.msg.service.ApisMsgMqlogsService;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@RocketMQMessageListener(topic="salesPolicyTopic", consumerGroup="fccbSales")
public class LitigationOffLineInsureTopicsListener
implements RocketMQListener<String> {
    private static Logger log = LoggerFactory.getLogger(LitigationOffLineInsureTopicsListener.class);
    @Autowired
    ApisBusiGuaranteeOffLineOrderLogService apisBusiGuaranteeOffLineOrderLogService;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    ApisMsgMqlogsService apisMsgMqlogsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        String flag = "0";
        Boolean isOffLineInsure = false;
        try {
            ApisBusiChannelOrder order;
            log.warn("\u9ad8\u9662\u8bc9\u8d23\u9669\u7ebf\u4e0b\u6295\u4fdd\u6d88\u606f\u63a5\u6536 received message: {}", (Object)message);
            LitigationOffLinePolicyMsgDTO litigationOffLinePolicyMsgDTO = (LitigationOffLinePolicyMsgDTO)JSON.parseObject((String)message, LitigationOffLinePolicyMsgDTO.class);
            log.warn("\u9ad8\u9662\u8bc9\u8d23\u9669\u7ebf\u4e0b\u6295\u4fdd\u6d88\u606f\u5b9e\u4f53\uff0clitigationOffLinePolicyMsgDTo={}", (Object)litigationOffLinePolicyMsgDTO);
            if ("P080016".equals(litigationOffLinePolicyMsgDTO.getRiskCode()) && ObjectUtil.isEmpty((Object)litigationOffLinePolicyMsgDTO.getEndorType()) && ObjectUtil.isEmpty((Object)(order = this.getOrder(litigationOffLinePolicyMsgDTO)))) {
                this.saveOffLineOrder(litigationOffLinePolicyMsgDTO);
                isOffLineInsure = true;
            }
        }
        catch (Exception e) {
            flag = "1";
            log.error("\u9ad8\u9662\u8bc9\u8d23\u9669\u7ebf\u4e0b\u6295\u4fdd\u63a5\u6536\u5f02\u5e38=============", (Throwable)e);
        }
        finally {
            if (isOffLineInsure.booleanValue()) {
                ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
                apisMsgMqlogs.setMessage(message);
                apisMsgMqlogs.setTopic("OffLineInsure");
                apisMsgMqlogs.setConsumerGroup("OffLineInsure");
                apisMsgMqlogs.setErrorFlag(flag);
                this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
            }
        }
    }

    private void saveOffLineOrder(LitigationOffLinePolicyMsgDTO msg) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"policy_no", (Object)msg.getPolicyNo());
        int count = this.apisBusiGuaranteeOffLineOrderLogService.count((Wrapper)queryWrapper);
        if (count <= 0) {
            ApisBusiGuaranteeOffLineOrderLog apisBusiOffLineOrder = new ApisBusiGuaranteeOffLineOrderLog();
            apisBusiOffLineOrder.setPolicyNo(msg.getPolicyNo());
            apisBusiOffLineOrder.setProposalNo(msg.getCertiNo());
            apisBusiOffLineOrder.setRiskCode(msg.getRiskCode());
            apisBusiOffLineOrder.setPlanCode(msg.getPlanCode());
            apisBusiOffLineOrder.setStartDate(LocalDateTime.ofInstant(msg.getStartDate().toInstant(), ZoneId.systemDefault()));
            apisBusiOffLineOrder.setEndDate(LocalDateTime.ofInstant(msg.getEndDate().toInstant(), ZoneId.systemDefault()));
            apisBusiOffLineOrder.setSignDate(LocalDateTime.ofInstant(msg.getSignDate().toInstant(), ZoneId.systemDefault()));
            apisBusiOffLineOrder.setUnderwriteTime(LocalDateTime.ofInstant(msg.getUnderWriteEndDate().toInstant(), ZoneId.systemDefault()));
            apisBusiOffLineOrder.setPremium(msg.getSumPremium());
            apisBusiOffLineOrder.setPushStep(Integer.valueOf(0));
            apisBusiOffLineOrder.setPushStatus("0");
            this.apisBusiGuaranteeOffLineOrderLogService.save((Object)apisBusiOffLineOrder);
        }
    }

    private ApisBusiChannelOrder getOrder(LitigationOffLinePolicyMsgDTO msg) {
        ApisBusiChannelOrder order = null;
        if (ObjectUtil.isNotEmpty((Object)msg) && ObjectUtil.isNotEmpty((Object)msg.getPolicyNo())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"policy_no", (Object)msg.getPolicyNo());
            queryWrapper.eq((Object)"plan_code", (Object)"ZR-SSBQ-FY-2C");
            order = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
        }
        return order;
    }
}

