/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.jms;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.CoreGuaranteeApi;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.LitigationCoreGuaranteeApi;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl.EPolicyDownServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.service.impl.PaymentServiceImpl;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.HttpClientJsonUtil;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.JDHNotifyUtils;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.LitigationUtils;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.OkHttpUtils;
import com.jdaz.sinosoftgz.apis.business.app.insureapp.utils.QiHuNotifyUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.BusinessConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiBudgetRequest;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiBudgetRequestService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.EmployeeInformationDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemEmployeeDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.BaseResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.CPayUrlDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.EmpUwresultBodyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.EmpUwresultDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.EmpUwresultErrorDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.EmpUwresultHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.EmpUwresultMsgDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationPaymentUrlDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationPaymentUrlRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationUwRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.litigation.LitigationUwResultMsgDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiCorrectOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiGuaranteeOffLineOrderLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiGuaranteeUnderwriteResultLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiLitigationPushLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiLitigationPushLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiCorrectOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiGuaranteeOffLineOrderLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiGuaranteeUnderwriteResultLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.msg.entity.ApisMsgMqlogs;
import com.jdaz.sinosoftgz.apis.commons.service.msg.service.ApisMsgMqlogsService;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.PfpMessageService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.RiskCodeEnum;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import okhttp3.FormBody;
import okhttp3.Request;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@RocketMQMessageListener(topic="apisTopic", consumerGroup="fccbApisUndwResultTest")
public class LitigationUwResultTopicsListener
implements RocketMQListener<String> {
    private static Logger log = LoggerFactory.getLogger(LitigationUwResultTopicsListener.class);
    @Autowired
    PfpMessageService pfpMessageService;
    @Autowired
    ApisMsgMqlogsService apisMsgMqlogsService;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    ApisBusiGuaranteeOffLineOrderLogService apisBusiGuaranteeOffLineOrderLogService;
    @Autowired
    ApisBusiGuaranteeUnderwriteResultLogService apisBusiGuaranteeUnderwriteResultLogService;
    @Autowired
    PaymentServiceImpl paymentService;
    @Autowired
    CoreGuaranteeApi coreGuaranteeApi;
    @Autowired
    LitigationCoreGuaranteeApi litigationCoreGuaranteeApi;
    @Autowired
    private ApisBusiLitigationPushLogMapper apisBusiLitigationPushLogMapper;
    @Autowired
    private LitigationUtils litigationUtils;
    @Autowired
    private ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    ApisBusiCorrectOrderService apisBusiCorrectOrderService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    HttpClientJsonUtil httpClientJsonUtil;
    @Autowired
    private EPolicyDownServiceImpl ePolicyDownService;
    @Autowired
    private JDHNotifyUtils jdhNotifyUtils;
    @Autowired
    private QiHuNotifyUtil qiHuNotifyUtil;
    @Autowired
    private DataCompletionUtil dataCompletionUtil;
    @Autowired
    private ApisBusiBudgetRequestService apisBusiBudgetRequestService;
    private static String BUSS_TYPE_T = "T";
    private static String REQUEST_TYPE = "GZ0002";
    private static String REQUEST_FLAG_Y = "0000";
    private static String REQUEST_FLAG_Y_MSG = "\u6210\u529f";
    private static String REQUEST_FLAG_N = "1234";
    private static String REQUEST_FLAG_N_MSG = "\u5931\u8d25";
    private static String BUSS_TYPE_E = "E";
    private static String BUSS_TYPE_EH = "EH";
    private static String BUSS_TYPE_P = "P";
    private static List<String> defaultPlanCode = Arrays.asList("ZR-SSBQ-FY-2C");
    private static List<String> defaultJDHGoodsCode = Arrays.asList("PHYYX(SE)", "PHYYX(ZQN)", "PHYYX(LNAZZS)", "JYBBWYL(0-60)", "JYBBWYL(0-70)");
    @Value(value="${apis.coreapi.serv.iYunBaoNotify.url}")
    private String iYunBaoNotifyUrl;

    public void onMessage(String message) {
        this.testMqMsg(message);
        log.warn("\u8bc9\u8d23\u9669\u6d88\u606f\u63a5\u6536=============");
        log.warn("received message: {}", (Object)message);
        LitigationUwResultMsgDTO msg = null;
        msg = (LitigationUwResultMsgDTO)JSON.parseObject((String)message, LitigationUwResultMsgDTO.class);
        if (ObjectUtil.isNotEmpty((Object)msg.getActualRefPremium())) {
            msg.setActualRefPremium(msg.getActualRefPremium().abs());
        }
        if (RiskCodeEnum.RISK_0016.getCode().equals(msg.getRiskCode())) {
            if ("Y".equals(msg.getIsPrePrice())) {
                this.budgetResultNotifyEmp(msg, message);
            } else if (BusinessConstants.UW_FLAG_Y.equals(msg.getOtherPaymentFlag())) {
                this.litigationPushEmp(msg, message);
            } else {
                this.uwResultNotifyEmp(msg, message);
            }
        } else if (this.isJDHGoodCode(msg.getGoodsCode()).booleanValue()) {
            this.jdhNotifyUtils.messageDeal(message, msg);
        } else if (this.isQiHuGoodCode(msg.getGoodsCode()).booleanValue()) {
            this.qiHuNotifyUtil.messageDeal(message, msg);
        } else if ("P080016".equals(msg.getRiskCode())) {
            if (BUSS_TYPE_T.equals(msg.getMsgType())) {
                this.uwResultNotify(msg, message);
            } else if (BUSS_TYPE_E.equals(msg.getMsgType())) {
                if (ObjectUtil.isNotEmpty((Object)msg.getEndorseType()) && "01".equals(msg.getEndorseType()) && "ZR-SSBQ-FY-2C".equals(msg.getPlanCode())) {
                    this.litigationUtils.pushPolicySurrender(msg, message);
                } else if (ObjectUtil.isNotEmpty((Object)msg.getEndorseType()) && "06".equals(msg.getEndorseType()) && "1".equals(msg.getOnLineFlag()) && "ZR-SSBQ-FY-2C".equals(msg.getPlanCode())) {
                    this.litigationUtils.saveGeneralCorrectTask(msg);
                } else if (!ObjectUtil.isNotEmpty((Object)msg.getUnderwriteFlag()) || "1".equals(msg.getUnderwriteFlag())) {
                    this.litigationPush(msg, message);
                }
            } else if (BUSS_TYPE_EH.equals(msg.getMsgType())) {
                if (ObjectUtil.isNotEmpty((Object)msg.getEndorseType()) && "06".equals(msg.getEndorseType()) && "1".equals(msg.getOnLineFlag()) && "ZR-SSBQ-FY-2C".equals(msg.getPlanCode())) {
                    this.litigationUtils.generalUwResultNotify(msg, new ApisBusiTaskLog());
                } else if (!(ObjectUtil.isNotEmpty((Object)msg.getEndorseType()) && "06".equals(msg.getEndorseType()) && "0".equals(msg.getOnLineFlag()) && "ZR-SSBQ-FY-2C".equals(msg.getPlanCode()) && !"1".equals(msg.getUnderwriteFlag()))) {
                    // empty if block
                }
            }
        }
    }

    private void testMqMsg(String message) {
        ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
        apisMsgMqlogs.setCreateTime((Date)DateUtil.date());
        apisMsgMqlogs.setMessage(message);
        apisMsgMqlogs.setTopic("apisTopicTset");
        apisMsgMqlogs.setConsumerGroup("fccbApisUndwResultTest");
        apisMsgMqlogs.setErrorFlag("0");
        this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
    }

    private Boolean isQiHuGoodCode(String goodCode) {
        if (ObjectUtil.isEmpty((Object)goodCode)) {
            return false;
        }
        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
        apisChannelConfigs.setConfigCode("360GoodCodes");
        apisChannelConfigs.setRationCode(goodCode);
        ApisChannelConfigs accs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
        return ObjectUtil.isNotEmpty((Object)accs);
    }

    private Boolean isJDHGoodCode(String goodCode) {
        if (ObjectUtil.isEmpty((Object)goodCode)) {
            return false;
        }
        ApisChannelConfigs channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setConfigCode("JDHGoodCode");
        channelConfigsCondition.setRationCode(goodCode);
        ApisChannelConfigs accs = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        return ObjectUtil.isNotEmpty((Object)accs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void litigationPush(LitigationUwResultMsgDTO msg, String message) {
        String flag = "0";
        Boolean isOffLineInsure = false;
        ApisBusiChannelOrder order = null;
        try {
            order = this.getCorrectOrder(msg);
            Boolean isApisOrderFlag = ObjectUtil.isNotEmpty((Object)order);
            if (isApisOrderFlag.booleanValue()) {
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                order.setStartDate(LocalDateTime.parse(msg.getStartDate(), df));
                order.setEndDate(LocalDateTime.parse(msg.getEndDate(), df));
                this.apisBusiChannelOrderService.updateById((Object)order);
            }
            if (ObjectUtil.isEmpty((Object)(order = this.getOrder(msg)))) {
                this.saveOffLineOrder(msg);
                isOffLineInsure = true;
            } else {
                this.savePushOrder(msg, order);
                isOffLineInsure = true;
            }
        }
        catch (Exception e) {
            flag = "1";
            log.error("\u9ad8\u9662\u8bc9\u8d23\u9669\u7ebf\u4e0b\u6295\u4fdd\u63a5\u6536\u5f02\u5e38=============", (Throwable)e);
        }
        finally {
            if (isOffLineInsure.booleanValue()) {
                ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
                apisMsgMqlogs.setMessage(message);
                apisMsgMqlogs.setTopic("apisTopic");
                apisMsgMqlogs.setConsumerGroup("PushInsure");
                apisMsgMqlogs.setErrorFlag(flag);
                this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void litigationPushEmp(LitigationUwResultMsgDTO msg, String message) {
        block18: {
            block17: {
                msg.setUnderwriteFlag(BusinessConstants.UW_FLAG_Y);
                order = null;
                orderE = null;
                orderNo = "";
                reqJson = "";
                flag = "0";
                policyNo = "";
                requestBody = null;
                empUwresultMsgDTO = EmpUwresultMsgDTO.builder().build();
                empUwresultMsgDTO.setStatus("70");
                if (!LitigationUwResultTopicsListener.BUSS_TYPE_P.equals(msg.getMsgType())) ** GOTO lbl33
                order = this.getUwResultOrder(msg);
                if (this.dataCompletionUtil.isIyunBaoAgency(order.getChannelCode())) break block17;
                this.saveLog(message, flag);
                this.saveTaskLog(StringUtils.isNotBlank((CharSequence)msg.getApplyNo()) != false ? msg.getApplyNo() : msg.getPolicyNo(), msg, reqJson, flag, this.iYunBaoNotifyUrl, BusinessConstants.UW_FLAG_Y);
                if (ObjectUtils.isNotEmpty((Object)order)) {
                    this.updateChannelOrderEmp(msg, order, "60");
                }
                if (ObjectUtils.isNotEmpty((Object)orderE)) {
                    this.updateCorrectlOrderEmp(msg, orderE, "70");
                }
                return;
            }
            empUwresultMsgDTO.setAgencyCode(order.getChannelCode());
            empUwresultMsgDTO.setTotalPremium(order.getPremium());
            empUwresultMsgDTO.setType(BusinessConstants.UW_FLAG_Y);
            empUwresultMsgDTO.setPolicyRef(order.getPolicyNo());
            empUwresultMsgDTO.setAdjustmentPremium(BigDecimal.ZERO);
            msg.setSumAmount(order.getAmount());
            msg.setSumPremium(order.getPremium());
            requestBody = new FormBody.Builder().add("agencyCode", empUwresultMsgDTO.getAgencyCode()).add("totalPremium", empUwresultMsgDTO.getTotalPremium().toString()).add("type", BusinessConstants.UW_FLAG_N).add("policyRef", empUwresultMsgDTO.getPolicyRef()).add("status", "70").build();
            ** GOTO lbl56
lbl33:
            // 1 sources

            if (!LitigationUwResultTopicsListener.BUSS_TYPE_E.equals(msg.getMsgType())) ** GOTO lbl56
            orderE = this.getUwResultOrderEmp(msg);
            if (this.dataCompletionUtil.isIyunBaoAgency(orderE.getChannelCode())) break block18;
            this.saveLog(message, flag);
            this.saveTaskLog(StringUtils.isNotBlank((CharSequence)msg.getApplyNo()) != false ? msg.getApplyNo() : msg.getPolicyNo(), msg, reqJson, flag, this.iYunBaoNotifyUrl, BusinessConstants.UW_FLAG_Y);
            if (ObjectUtils.isNotEmpty((Object)order)) {
                this.updateChannelOrderEmp(msg, order, "60");
            }
            if (ObjectUtils.isNotEmpty((Object)orderE)) {
                this.updateCorrectlOrderEmp(msg, orderE, "70");
            }
            return;
        }
        try {
            empUwresultMsgDTO.setAgencyCode(orderE.getChannelCode());
            empUwresultMsgDTO.setTotalPremium(orderE.getPremium());
            empUwresultMsgDTO.setEndorseNo(msg.getEndorseNo());
            empUwresultMsgDTO.setPolicyRef(orderE.getPayeeAccount());
            empUwresultMsgDTO.setType(BusinessConstants.UW_FLAG_N);
            empUwresultMsgDTO.setApplyNo(msg.getApplyNo());
            if (orderE.getRefundPremium() == null) {
                orderE.setRefundPremium(BigDecimal.ZERO);
            }
            empUwresultMsgDTO.setAdjustmentPremium(orderE.getRefundPremium());
            requestBody = new FormBody.Builder().add("agencyCode", empUwresultMsgDTO.getAgencyCode()).add("totalPremium", empUwresultMsgDTO.getTotalPremium().toString()).add("endorseNo", msg.getEndorseNo()).add("applyNo", msg.getApplyNo()).add("type", BusinessConstants.UW_FLAG_N).add("adjustmentPremium", empUwresultMsgDTO.getAdjustmentPremium().toString()).add("policyRef", empUwresultMsgDTO.getPolicyRef()).add("status", "70").build();
lbl56:
            // 3 sources

            reqJson = JSON.toJSONString((Object)empUwresultMsgDTO);
            client = OkHttpUtils.getSslHttpsClient();
            req = new Request.Builder().url(this.iYunBaoNotifyUrl).post(requestBody).build();
            resp = client.newCall(req).execute();
            flag = resp != null && resp.isSuccessful() != false ? "0" : "1";
            LitigationUwResultTopicsListener.log.warn("\u96c7\u4e3b\u8d23\u4efb\u9669\u4fdd\u6279\u5355\u901a\u77e5\u8fd4\u56de{}", (Object)resp.body().toString());
        }
        catch (Exception e) {
            try {
                LitigationUwResultTopicsListener.log.error("\u96c7\u4e3b\u8d23\u4efb\u9669\u4fdd\u6279\u5355\u901a\u77e5\u5931\u8d25{}", (Object)msg.getProposalNo());
                flag = "1";
            }
            catch (Throwable var14_15) {
                this.saveLog(message, flag);
                this.saveTaskLog(StringUtils.isNotBlank((CharSequence)msg.getApplyNo()) != false ? msg.getApplyNo() : msg.getPolicyNo(), msg, reqJson, flag, this.iYunBaoNotifyUrl, BusinessConstants.UW_FLAG_Y);
                if (ObjectUtils.isNotEmpty((Object)order)) {
                    this.updateChannelOrderEmp(msg, order, "60");
                }
                if (ObjectUtils.isNotEmpty((Object)orderE)) {
                    this.updateCorrectlOrderEmp(msg, orderE, "70");
                }
                throw var14_15;
            }
            this.saveLog(message, flag);
            this.saveTaskLog(StringUtils.isNotBlank((CharSequence)msg.getApplyNo()) != false ? msg.getApplyNo() : msg.getPolicyNo(), msg, reqJson, flag, this.iYunBaoNotifyUrl, BusinessConstants.UW_FLAG_Y);
            if (ObjectUtils.isNotEmpty((Object)order)) {
                this.updateChannelOrderEmp(msg, order, "60");
            }
            if (ObjectUtils.isNotEmpty((Object)orderE)) {
                this.updateCorrectlOrderEmp(msg, orderE, "70");
            } else {
                ** GOTO lbl88
            }
        }
        this.saveLog(message, flag);
        this.saveTaskLog(StringUtils.isNotBlank((CharSequence)msg.getApplyNo()) != false ? msg.getApplyNo() : msg.getPolicyNo(), msg, reqJson, flag, this.iYunBaoNotifyUrl, BusinessConstants.UW_FLAG_Y);
        if (ObjectUtils.isNotEmpty((Object)order)) {
            this.updateChannelOrderEmp(msg, order, "60");
        }
        if (ObjectUtils.isNotEmpty((Object)orderE)) {
            this.updateCorrectlOrderEmp(msg, orderE, "70");
        }
    }

    private void savePushOrder(LitigationUwResultMsgDTO msg, ApisBusiChannelOrder order) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        ApisBusiLitigationPushLog log = new ApisBusiLitigationPushLog();
        log.setPushStep(Integer.valueOf(1));
        log.setLastPushTime(new Date());
        log.setPolicyRef(msg.getPolicyNo());
        log.setPaymentMethod(order.getPayType());
        log.setPayTime(df.format(order.getPayTime()));
        log.setAgencyCode(order.getAgentCode());
        log.setPushStatus("0");
        this.apisBusiLitigationPushLogMapper.insert((Object)log);
    }

    private void saveOffLineOrder(LitigationUwResultMsgDTO msg) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        DateTimeFormatter df1 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        ApisBusiGuaranteeOffLineOrderLog apisBusiOffLineOrder = new ApisBusiGuaranteeOffLineOrderLog();
        apisBusiOffLineOrder.setPolicyNo(msg.getPolicyNo());
        apisBusiOffLineOrder.setProposalNo(msg.getProposalNo());
        apisBusiOffLineOrder.setRiskCode(msg.getRiskCode());
        apisBusiOffLineOrder.setPlanCode(msg.getPlanCode());
        apisBusiOffLineOrder.setStartDate(LocalDateTime.parse(msg.getStartDate(), df));
        apisBusiOffLineOrder.setEndDate(LocalDateTime.parse(msg.getEndDate(), df));
        apisBusiOffLineOrder.setSignDate(LocalDate.parse(msg.getSignDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd")).atStartOfDay());
        apisBusiOffLineOrder.setUnderwriteTime(LocalDateTime.ofInstant(msg.getUnderWriteEndDate().toInstant(), ZoneId.systemDefault()));
        apisBusiOffLineOrder.setPremium(msg.getSumPremium());
        apisBusiOffLineOrder.setPushStep(Integer.valueOf(0));
        apisBusiOffLineOrder.setPushStatus("0");
        this.apisBusiGuaranteeOffLineOrderLogService.save((Object)apisBusiOffLineOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void uwResultNotifyEmp(LitigationUwResultMsgDTO msg, String message) {
        ApisBusiChannelOrder order = null;
        ApisBusiCorrectOrder orderE = null;
        String flag = "0";
        String notifyUrl = "";
        boolean isApisOrderFlag = false;
        String bussNo = "";
        String json = null;
        String status = null;
        String policyNo = null;
        String channelCode = null;
        try {
            if (BUSS_TYPE_T.equals(msg.getMsgType())) {
                order = this.getUwResultOrder(msg);
                isApisOrderFlag = ObjectUtil.isNotEmpty((Object)order);
                notifyUrl = order.getNotifyUrl();
                msg.setAgencyPolicyRef(order.getOrderNo());
                msg.setPolicyNo(order.getPolicyNo());
                bussNo = msg.getProposalNo();
                policyNo = order.getPolicyNo();
                channelCode = order.getChannelCode();
            } else if (BUSS_TYPE_E.equals(msg.getMsgType())) {
                orderE = this.getUwResultOrderEmp(msg);
                isApisOrderFlag = ObjectUtil.isNotEmpty((Object)orderE);
                notifyUrl = orderE.getErrMsg();
                msg.setAgencyPolicyRef(orderE.getReason());
                bussNo = msg.getApplyNo();
                policyNo = orderE.getPayeeAccount();
                channelCode = orderE.getChannelCode();
            }
            if (this.dataCompletionUtil.isIyunBaoAgency(channelCode)) {
                Object var13_13 = null;
                if (isApisOrderFlag) {
                    if (StringUtils.isNotBlank((CharSequence)msg.getImgId())) {
                        String employeeJson = this.httpClientJsonUtil.request(msg.getImgId());
                        EmployeeInformationDTO employeeInformationDTO = (EmployeeInformationDTO)JSON.parseObject((String)employeeJson, EmployeeInformationDTO.class);
                        msg.setEmployeeInformationDTO(employeeInformationDTO);
                        msg.setUnderwriteFlag(BusinessConstants.UW_FLAG_N);
                        msg.setImgId(null);
                    } else if (!"3".equals(msg.getUnderwriteFlag()) && !"1".equals(msg.getUnderwriteFlag())) {
                        msg.setUnderwriteFlag(BusinessConstants.UW_FLAG_N);
                    } else {
                        msg.setUnderwriteFlag(BusinessConstants.UW_FLAG_Y);
                    }
                    if (BusinessConstants.UW_FLAG_N.equals(msg.getIsToBePaid()) && BUSS_TYPE_E.equals(msg.getMsgType())) {
                        status = "70";
                    } else if (BusinessConstants.UW_FLAG_Y.equals(msg.getIsToBePaid()) && BUSS_TYPE_E.equals(msg.getMsgType())) {
                        status = "60";
                    } else if ("3".equals(msg.getIsToBePaid()) && BUSS_TYPE_E.equals(msg.getMsgType())) {
                        status = "60";
                    }
                    EmpUwresultMsgDTO empUwresultMsgDTO = EmpUwresultMsgDTO.builder().build();
                    if (ObjectUtils.isNotEmpty((Object)msg.getPolicyNo())) {
                        empUwresultMsgDTO.setPolicyRef(msg.getPolicyNo());
                    }
                    empUwresultMsgDTO.setEmployeeInformationDTO(msg.getEmployeeInformationDTO());
                    empUwresultMsgDTO.setStatus(status);
                    empUwresultMsgDTO.setMsgType(msg.getMsgType());
                    if (ObjectUtils.isNotEmpty((Object)msg.getChgSumPremium())) {
                        empUwresultMsgDTO.setAdjustmentPremium(msg.getChgSumPremium());
                    }
                    if (StringUtils.isNotBlank((CharSequence)msg.getPolicyNo())) {
                        empUwresultMsgDTO.setPolicyNo(msg.getPolicyNo());
                    } else {
                        empUwresultMsgDTO.setPolicyNo(policyNo);
                    }
                    empUwresultMsgDTO.setTotalPremium(msg.getSumPremium());
                    empUwresultMsgDTO.setSumAmount(msg.getSumAmount());
                    empUwresultMsgDTO.setAgencyPolicyRef(msg.getAgencyPolicyRef());
                    empUwresultMsgDTO.setUnderwriteFlag(msg.getUnderwriteFlag());
                    empUwresultMsgDTO.setUnderwritemsg(msg.getUnderwritemsg());
                    empUwresultMsgDTO.setProposalNo(msg.getProposalNo());
                    if (ObjectUtils.isNotEmpty((Object)msg.getApplyNo())) {
                        empUwresultMsgDTO.setApplyNo(msg.getApplyNo());
                    }
                    if (ObjectUtils.isNotEmpty((Object)msg.getEndorseNo())) {
                        empUwresultMsgDTO.setEndorseNo(msg.getEndorseNo());
                    }
                    if (BusinessConstants.UW_FLAG_N.equals(msg.getUnderwriteFlag()) && BUSS_TYPE_T.equals(msg.getMsgType())) {
                        status = "12";
                    } else if (BusinessConstants.UW_FLAG_Y.equals(msg.getUnderwriteFlag()) && BUSS_TYPE_T.equals(msg.getMsgType())) {
                        status = "60";
                    }
                    empUwresultMsgDTO.setPolicyStatus(status);
                    json = JSON.toJSONString((Object)empUwresultMsgDTO);
                }
            } else {
                EmpUwresultDTO empUwresultDTO = EmpUwresultDTO.builder().build();
                EmpUwresultHeadDTO empUwresultHeadDTO = EmpUwresultHeadDTO.builder().build();
                empUwresultHeadDTO.setRequestId(UUID.randomUUID().toString().replace("-", ""));
                empUwresultHeadDTO.setRequestType(REQUEST_TYPE);
                EmpUwresultBodyDTO empUwresultBodyDTO = EmpUwresultBodyDTO.builder().build();
                empUwresultDTO.setBody(empUwresultBodyDTO);
                empUwresultDTO.setHead(empUwresultHeadDTO);
                empUwresultBodyDTO.setPolicyRef(policyNo);
                empUwresultBodyDTO.setAgencyPolicyRef(msg.getAgencyPolicyRef());
                empUwresultBodyDTO.setTotalPremium(msg.getSumPremium());
                if (ObjectUtils.isNotEmpty((Object)msg.getEndorseNo())) {
                    empUwresultBodyDTO.setPolicyRef(msg.getEndorseNo());
                }
                if (isApisOrderFlag) {
                    EmployeeInformationDTO employeeInformationDTO = null;
                    if (StringUtils.isNotBlank((CharSequence)msg.getImgId())) {
                        String employeeJson = this.httpClientJsonUtil.request(msg.getImgId());
                        employeeInformationDTO = (EmployeeInformationDTO)JSON.parseObject((String)employeeJson, EmployeeInformationDTO.class);
                        msg.setEmployeeInformationDTO(employeeInformationDTO);
                        msg.setUnderwriteFlag(BusinessConstants.UW_FLAG_N);
                        msg.setImgId(null);
                    } else if (!"3".equals(msg.getUnderwriteFlag()) && !"1".equals(msg.getUnderwriteFlag())) {
                        msg.setUnderwriteFlag(BusinessConstants.UW_FLAG_N);
                    } else {
                        msg.setUnderwriteFlag(BusinessConstants.UW_FLAG_Y);
                    }
                    if (ObjectUtils.isNotEmpty((Object)msg.getApplyNo())) {
                        empUwresultBodyDTO.setEndorseApplyNo(msg.getApplyNo());
                    }
                    if (ObjectUtils.isNotEmpty((Object)msg.getChgSumPremium())) {
                        empUwresultBodyDTO.setAdjustmentPremium(msg.getChgSumPremium());
                    }
                    if (BusinessConstants.UW_FLAG_Y.equals(msg.getUnderwriteFlag())) {
                        empUwresultHeadDTO.setErrorCode(REQUEST_FLAG_Y);
                        empUwresultHeadDTO.setErrorMessage(REQUEST_FLAG_Y_MSG);
                        status = BusinessConstants.UW_FLAG_N.equals(msg.getIsToBePaid()) ? "70" : (BusinessConstants.UW_FLAG_Y.equals(msg.getIsToBePaid()) ? "60" : "60");
                        empUwresultBodyDTO.setPolicyStatus(status);
                    } else {
                        empUwresultHeadDTO.setErrorCode(REQUEST_FLAG_N);
                        empUwresultHeadDTO.setErrorMessage(REQUEST_FLAG_N_MSG);
                        empUwresultBodyDTO.setPolicyStatus("12");
                    }
                    ArrayList<EmpUwresultErrorDTO> empUwresultMsgDTOs = new ArrayList<EmpUwresultErrorDTO>();
                    if (ObjectUtils.isNotEmpty((Object)employeeInformationDTO)) {
                        EmpUwresultErrorDTO empUwresultErrorDTO = null;
                        for (ItemEmployeeDTO itemEmployeeDTO : employeeInformationDTO.getEmployeeInformationList()) {
                            empUwresultErrorDTO = new EmpUwresultErrorDTO();
                            empUwresultErrorDTO.setErrorCode(REQUEST_FLAG_N);
                            if (ObjectUtils.isNotEmpty((Object)itemEmployeeDTO.getInsuredName())) {
                                empUwresultErrorDTO.setErrorMessage(itemEmployeeDTO.getInsuredName() + itemEmployeeDTO.getErrorMsg());
                            } else {
                                empUwresultErrorDTO.setErrorMessage(itemEmployeeDTO.getIdentifyNumber() + itemEmployeeDTO.getErrorMsg());
                            }
                            empUwresultMsgDTOs.add(empUwresultErrorDTO);
                        }
                    }
                    if (ObjectUtils.isNotEmpty(empUwresultMsgDTOs)) {
                        empUwresultBodyDTO.setErrorList(empUwresultMsgDTOs);
                    }
                    json = JSON.toJSONString((Object)empUwresultDTO);
                }
            }
            log.warn("\u96c7\u4e3b\u8d23\u4efb\u9669\u6838\u4fdd\u7ed3\u679c\u63a8\u9001\u62a5\u6587============={}", json);
            String string = this.httpClientJsonUtil.requestJson(json, notifyUrl);
            if (!isApisOrderFlag) return;
        }
        catch (Throwable throwable) {
            try {
                flag = BusinessConstants.UW_FLAG_Y;
                log.error("\u96c7\u4e3b\u8d23\u4efb\u9669\u6838\u4fdd\u7ed3\u679c\u63a8\u9001\u5f02\u5e38=============", throwable);
                return;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (isApisOrderFlag) {
                    this.saveLog(message, flag);
                    this.saveTaskLog(bussNo, msg, json, flag, notifyUrl, BusinessConstants.UW_FLAG_N);
                    if (ObjectUtils.isNotEmpty((Object)order)) {
                        this.updateChannelOrderEmp(msg, order, "70");
                    }
                    if (ObjectUtils.isNotEmpty((Object)orderE)) {
                        this.updateCorrectlOrderEmp(msg, orderE, status);
                    }
                }
            }
        }
        this.saveLog(message, flag);
        this.saveTaskLog(bussNo, msg, json, flag, notifyUrl, BusinessConstants.UW_FLAG_N);
        if (ObjectUtils.isNotEmpty((Object)order)) {
            this.updateChannelOrderEmp(msg, order, "70");
        }
        if (!ObjectUtils.isNotEmpty((Object)orderE)) return;
        this.updateCorrectlOrderEmp(msg, orderE, status);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uwResultNotify(LitigationUwResultMsgDTO msg, String message) {
        ApisBusiChannelOrder order = null;
        boolean isApisOrderFlag = false;
        String flag = "0";
        try {
            order = this.getUwResultOrder(msg);
            isApisOrderFlag = ObjectUtil.isNotEmpty((Object)order);
            if (isApisOrderFlag) {
                this.updateChannelOrder(msg, order);
                LitigationUwRequest requestDTO = this.beforeRequestProcess(msg, order);
                BaseResponse response = this.push(requestDTO, order);
                if (!"200".equals(response.getCode())) {
                    log.error("\u8bc9\u8d23\u9669\u6838\u4fdd\u6d88\u606f\u63a8\u9001>>\u8bf7\u6c42\u62c5\u4fdd\u7cfb\u7edf\u5f02\u5e38:{}", (Object)response.getMsg());
                    flag = "1";
                }
            }
        }
        catch (Throwable e) {
            flag = "1";
            log.error("\u8bc9\u8d23\u9669\u6838\u4fdd\u6d88\u606f\u63a8\u9001\u5f02\u5e38=============", e);
        }
        finally {
            if (isApisOrderFlag) {
                this.saveLog(message, flag);
                this.saveUnderwrite(msg, order, flag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void budgetResultNotifyEmp(LitigationUwResultMsgDTO msg, String message) {
        ApisBusiBudgetRequest budgetRequest = null;
        String flag = "0";
        String notifyUrl = "";
        boolean isApisOrderFlag = false;
        String bussNo = "";
        String json = null;
        String policyNo = null;
        String channelCode = null;
        try {
            Object empUwresultDTO;
            budgetRequest = this.getBudgetRequest(msg);
            budgetRequest.setIsPrePrice(msg.getIsPrePrice());
            isApisOrderFlag = ObjectUtil.isNotEmpty((Object)budgetRequest);
            notifyUrl = budgetRequest.getNotifyUrl();
            msg.setAgencyPolicyRef(budgetRequest.getBusinessKey());
            msg.setPolicyNo(budgetRequest.getPolicyNo());
            bussNo = budgetRequest.getBusinessKey();
            policyNo = budgetRequest.getPolicyNo();
            channelCode = budgetRequest.getChannelCode();
            if (this.dataCompletionUtil.isIyunBaoAgency(channelCode)) {
                EmployeeInformationDTO employeeInformationDTO = null;
                if (isApisOrderFlag) {
                    budgetRequest.setStatus(DataCompletionUtil.POLICY_STAUTS_1);
                    budgetRequest.setImgId(msg.getImgId());
                    if (StringUtils.isNotBlank((CharSequence)msg.getImgId())) {
                        String employeeJson = this.httpClientJsonUtil.request(msg.getImgId());
                        employeeInformationDTO = (EmployeeInformationDTO)JSON.parseObject((String)employeeJson, EmployeeInformationDTO.class);
                        msg.setEmployeeInformationDTO(employeeInformationDTO);
                        msg.setImgId(null);
                    }
                    EmpUwresultMsgDTO empUwresultMsgDTO = EmpUwresultMsgDTO.builder().build();
                    empUwresultMsgDTO.setPolicyRef(policyNo);
                    empUwresultMsgDTO.setEmployeeInformationDTO(msg.getEmployeeInformationDTO());
                    empUwresultMsgDTO.setMsgType(msg.getMsgType());
                    if (ObjectUtils.isNotEmpty((Object)msg.getChgSumPremium())) {
                        budgetRequest.setSumPremiumChg(msg.getChgSumPremium());
                        empUwresultMsgDTO.setAdjustmentPremium(msg.getChgSumPremium());
                    }
                    empUwresultMsgDTO.setPolicyNo(policyNo);
                    empUwresultMsgDTO.setTotalPremium(msg.getSumPremium());
                    empUwresultMsgDTO.setSumAmount(msg.getSumAmount());
                    empUwresultMsgDTO.setAgencyPolicyRef(msg.getAgencyPolicyRef());
                    budgetRequest.setSumPremium(msg.getSumPremium());
                    budgetRequest.setSumAmount(msg.getSumAmount());
                    budgetRequest.setUnderwriteFlag(msg.getUnderwriteFlag());
                    json = JSON.toJSONString((Object)empUwresultMsgDTO);
                }
            } else {
                empUwresultDTO = EmpUwresultDTO.builder().build();
                EmpUwresultHeadDTO empUwresultHeadDTO = EmpUwresultHeadDTO.builder().build();
                empUwresultHeadDTO.setRequestId(UUID.randomUUID().toString().replace("-", ""));
                empUwresultHeadDTO.setRequestType("GZUW0009");
                EmpUwresultBodyDTO empUwresultBodyDTO = EmpUwresultBodyDTO.builder().build();
                empUwresultDTO.setBody(empUwresultBodyDTO);
                empUwresultDTO.setHead(empUwresultHeadDTO);
                empUwresultBodyDTO.setPolicyRef(policyNo);
                empUwresultBodyDTO.setAgencyPolicyRef(msg.getAgencyPolicyRef());
                empUwresultBodyDTO.setTotalPremium(msg.getSumPremium());
                budgetRequest.setSumPremium(msg.getSumPremium());
                budgetRequest.setSumAmount(msg.getSumAmount());
                if (isApisOrderFlag) {
                    budgetRequest.setStatus(DataCompletionUtil.POLICY_STAUTS_1);
                    budgetRequest.setImgId(msg.getImgId());
                    EmployeeInformationDTO employeeInformationDTO = null;
                    if (StringUtils.isNotBlank((CharSequence)msg.getImgId())) {
                        String employeeJson = this.httpClientJsonUtil.request(msg.getImgId());
                        employeeInformationDTO = (EmployeeInformationDTO)JSON.parseObject((String)employeeJson, EmployeeInformationDTO.class);
                        msg.setEmployeeInformationDTO(employeeInformationDTO);
                        msg.setUnderwriteFlag(BusinessConstants.UW_FLAG_N);
                        msg.setImgId(null);
                    } else if (!"3".equals(msg.getUnderwriteFlag()) && !"1".equals(msg.getUnderwriteFlag())) {
                        msg.setUnderwriteFlag(BusinessConstants.UW_FLAG_N);
                    } else {
                        msg.setUnderwriteFlag(BusinessConstants.UW_FLAG_Y);
                    }
                    if (ObjectUtils.isNotEmpty((Object)msg.getChgSumPremium())) {
                        budgetRequest.setSumPremiumChg(msg.getChgSumPremium());
                        empUwresultBodyDTO.setAdjustmentPremium(msg.getChgSumPremium());
                    }
                    budgetRequest.setUnderwriteFlag(msg.getUnderwriteFlag());
                    if (BusinessConstants.UW_FLAG_Y.equals(msg.getUnderwriteFlag())) {
                        empUwresultHeadDTO.setErrorCode(REQUEST_FLAG_Y);
                        empUwresultHeadDTO.setErrorMessage(REQUEST_FLAG_Y_MSG);
                    } else {
                        empUwresultHeadDTO.setErrorCode(REQUEST_FLAG_N);
                        empUwresultHeadDTO.setErrorMessage(REQUEST_FLAG_N_MSG);
                    }
                    ArrayList<EmpUwresultErrorDTO> empUwresultMsgDTOs = new ArrayList<EmpUwresultErrorDTO>();
                    if (ObjectUtils.isNotEmpty((Object)employeeInformationDTO)) {
                        EmpUwresultErrorDTO empUwresultErrorDTO = null;
                        for (ItemEmployeeDTO itemEmployeeDTO : employeeInformationDTO.getEmployeeInformationList()) {
                            empUwresultErrorDTO = new EmpUwresultErrorDTO();
                            empUwresultErrorDTO.setErrorCode(REQUEST_FLAG_N);
                            if (ObjectUtils.isNotEmpty((Object)itemEmployeeDTO.getInsuredName())) {
                                empUwresultErrorDTO.setErrorMessage(itemEmployeeDTO.getInsuredName() + itemEmployeeDTO.getErrorMsg());
                            } else {
                                empUwresultErrorDTO.setErrorMessage(itemEmployeeDTO.getIdentifyNumber() + itemEmployeeDTO.getErrorMsg());
                            }
                            empUwresultMsgDTOs.add(empUwresultErrorDTO);
                        }
                    }
                    if (ObjectUtils.isNotEmpty(empUwresultMsgDTOs)) {
                        empUwresultBodyDTO.setErrorList(empUwresultMsgDTOs);
                    }
                    json = JSON.toJSONString((Object)empUwresultDTO);
                }
            }
            log.warn("\u96c7\u4e3b\u8d23\u4efb\u9669\u9884\u8bd5\u7b97\u7ed3\u679c\u63a8\u9001\u62a5\u6587============={}", json);
            empUwresultDTO = this.httpClientJsonUtil.requestJson(json, notifyUrl);
        }
        catch (Throwable e) {
            flag = BusinessConstants.UW_FLAG_Y;
            log.error("\u96c7\u4e3b\u8d23\u4efb\u9669\u9884\u8bd5\u7b97\u7ed3\u679c\u63a8\u9001\u5f02\u5e38=============", e);
        }
        finally {
            if (isApisOrderFlag) {
                this.saveLog(message, flag);
                this.saveTaskLog(bussNo, msg, json, flag, notifyUrl, BusinessConstants.UW_FLAG_N, ApisAutoTaskConstantsEnum.CORRECT_BUDGET_NOTIFY_CALLBACK.getValue());
                if (ObjectUtils.isNotEmpty((Object)budgetRequest)) {
                    this.apisBusiBudgetRequestService.updateById((Object)budgetRequest);
                }
            }
        }
    }

    private void saveLog(String message, String flag) {
        ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
        apisMsgMqlogs.setMessage(message);
        apisMsgMqlogs.setTopic("apisTopic");
        apisMsgMqlogs.setConsumerGroup("fccbApisAsynPolicytoemp");
        apisMsgMqlogs.setErrorFlag(flag);
        apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
        this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
    }

    private void saveUnderwrite(LitigationUwResultMsgDTO msg, ApisBusiChannelOrder order, String flag) {
        if (ObjectUtil.isEmpty((Object)msg)) {
            return;
        }
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"proposalNo", (Object)msg.getProposalNo());
            queryWrapper.eq((Object)"deleted", (Object)ApisBusiGuaranteeUnderwriteResultLog.DELETE_FLAG_FALSE);
            ApisBusiGuaranteeUnderwriteResultLog apisBusiGuaranteeUnderwriteResultLog = (ApisBusiGuaranteeUnderwriteResultLog)this.apisBusiGuaranteeUnderwriteResultLogService.getOne((Wrapper)queryWrapper);
            if (ObjectUtil.isEmpty((Object)apisBusiGuaranteeUnderwriteResultLog)) {
                apisBusiGuaranteeUnderwriteResultLog = new ApisBusiGuaranteeUnderwriteResultLog();
                apisBusiGuaranteeUnderwriteResultLog.setPushStep(Integer.valueOf(1));
            } else {
                apisBusiGuaranteeUnderwriteResultLog.setPushStep(Integer.valueOf(apisBusiGuaranteeUnderwriteResultLog.getPushStep() + 1));
            }
            apisBusiGuaranteeUnderwriteResultLog.setOrderNo(order.getOrderNo());
            apisBusiGuaranteeUnderwriteResultLog.setProposalNo(msg.getProposalNo());
            apisBusiGuaranteeUnderwriteResultLog.setUnderwriteFlag(msg.getUnderwriteFlag());
            apisBusiGuaranteeUnderwriteResultLog.setUnderwriteMsg(msg.getUnderwritemsg());
            LocalDateTime dateTime = ObjectUtil.isNotEmpty((Object)msg.getUnderwriteTime()) ? LocalDateTime.ofInstant(msg.getUnderwriteTime().toInstant(), ZoneId.systemDefault()) : LocalDateTime.now();
            apisBusiGuaranteeUnderwriteResultLog.setUnderwriteTime(dateTime);
            if ("0".equals(flag)) {
                apisBusiGuaranteeUnderwriteResultLog.setPushStatus("1");
                QueryWrapper queryWrapper2 = new QueryWrapper();
                queryWrapper2.eq((Object)"business_key", (Object)msg.getProposalNo());
                queryWrapper2.eq((Object)"push_type", (Object)ApisAutoTaskConstantsEnum.UWRESULT_PAYURL_TO_GY.getValue());
                ApisBusiTaskLog log = (ApisBusiTaskLog)this.apisBusiTaskLogService.getOne((Wrapper)queryWrapper2);
                if (ObjectUtil.isNotEmpty((Object)log)) {
                    log.setPushStatus(apisBusiGuaranteeUnderwriteResultLog.getPushStatus());
                    log.setPushStep(Integer.valueOf(1));
                    log.setLastPushTime(LocalDateTime.now());
                    this.apisBusiTaskLogService.updateById((Object)log);
                } else {
                    ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
                    apisBusiTaskLog.setBusinessKey(msg.getProposalNo());
                    apisBusiTaskLog.setPushStatus(apisBusiGuaranteeUnderwriteResultLog.getPushStatus());
                    apisBusiTaskLog.setPushType(ApisAutoTaskConstantsEnum.UWRESULT_PAYURL_TO_GY.getValue());
                    apisBusiTaskLog.setPushStep(Integer.valueOf(1));
                    apisBusiTaskLog.setLastPushTime(LocalDateTime.now());
                    apisBusiTaskLog.setErrMsg(msg.getUnderwritemsg());
                    this.apisBusiTaskLogService.save((Object)apisBusiTaskLog);
                }
            } else {
                apisBusiGuaranteeUnderwriteResultLog.setPushStatus("0");
            }
            this.apisBusiGuaranteeUnderwriteResultLogService.saveOrUpdate((Object)apisBusiGuaranteeUnderwriteResultLog);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u6838\u4fdd\u7ed3\u679c\u51fa\u9519\uff1a", (Throwable)e);
        }
    }

    private void saveTaskLog(String businessKey, LitigationUwResultMsgDTO msg, String reqJson, String flag, String url, String remark) {
        if (ObjectUtil.isEmpty((Object)msg)) {
            return;
        }
        if (ObjectUtil.isEmpty((Object)reqJson)) {
            reqJson = JSON.toJSONString((Object)msg);
        }
        ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
        apisBusiTaskLog.setBusinessKey(businessKey);
        apisBusiTaskLog.setPushStatus("4");
        if ("0".equals(flag)) {
            apisBusiTaskLog.setPushStatus("1");
        }
        apisBusiTaskLog.setPushType(ApisAutoTaskConstantsEnum.IYUNBAO_EMPLOYEE_NOTIFY_CALLBACK.getValue());
        apisBusiTaskLog.setPushStep(Integer.valueOf(0));
        apisBusiTaskLog.setRemark(remark);
        apisBusiTaskLog.setPushTargetUrl(url);
        apisBusiTaskLog.setPushContent(reqJson);
        apisBusiTaskLog.setErrMsg(msg.getUnderwritemsg());
        this.apisBusiTaskLogService.save((Object)apisBusiTaskLog);
    }

    private void saveTaskLog(String businessKey, LitigationUwResultMsgDTO msg, String reqJson, String flag, String url, String remark, String pushType) {
        ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
        apisBusiTaskLog.setBusinessKey(businessKey);
        apisBusiTaskLog.setPushStatus("4");
        if ("0".equals(flag)) {
            apisBusiTaskLog.setPushStatus("1");
        }
        apisBusiTaskLog.setPushType(pushType);
        apisBusiTaskLog.setPushStep(Integer.valueOf(0));
        apisBusiTaskLog.setRemark(remark);
        apisBusiTaskLog.setPushTargetUrl(url);
        apisBusiTaskLog.setPushContent(reqJson);
        apisBusiTaskLog.setErrMsg(msg.getUnderwritemsg());
        this.apisBusiTaskLogService.save((Object)apisBusiTaskLog);
    }

    private void updateChannelOrder(LitigationUwResultMsgDTO msg, ApisBusiChannelOrder order) {
        if (BusinessConstants.UW_FLAG_Y.equals(msg.getUnderwriteFlag()) && !"04".equals(order.getStatus())) {
            order.setAmount(msg.getSumAmount());
            order.setPremium(msg.getSumPremium());
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            order.setStartDate(LocalDateTime.parse(msg.getStartDate(), df));
            order.setEndDate(LocalDateTime.parse(msg.getEndDate(), df));
            this.apisBusiChannelOrderService.updateById((Object)order);
        }
    }

    private void updateChannelOrderEmp(LitigationUwResultMsgDTO msg, ApisBusiChannelOrder order, String status) {
        if (BusinessConstants.UW_FLAG_Y.equals(msg.getUnderwriteFlag())) {
            order.setAmount(msg.getSumAmount());
            order.setPremium(msg.getSumPremium());
            order.setStatus(status);
            order.setPolicyNo(msg.getPolicyNo());
            this.apisBusiChannelOrderService.updateById((Object)order);
        }
    }

    private void updateCorrectlOrderEmp(LitigationUwResultMsgDTO msg, ApisBusiCorrectOrder order, String status) {
        if (BusinessConstants.UW_FLAG_Y.equals(msg.getUnderwriteFlag())) {
            order.setPremium(msg.getSumPremium());
            order.setRefundPremium(msg.getChgSumPremium());
            order.setCancelFlag(status);
            order.setPayeeAccount(msg.getPolicyNo());
            this.apisBusiCorrectOrderService.updateById((Object)order);
        } else {
            this.apisBusiCorrectOrderService.removeById((Serializable)order);
        }
    }

    private BaseResponse push(LitigationUwRequest requestDTO, ApisBusiChannelOrder order) {
        BaseResponse baseResponse;
        if (BusinessConstants.UW_FLAG_Y.equals(requestDTO.getNShjg())) {
            if ("ZR-SSBQ-FY-2C".equals(order.getPlanCode())) {
                if (this.litigationUtils.appletFlag()) {
                    requestDTO.setCPayUrls(null);
                    baseResponse = this.coreGuaranteeApi.pushUwResult(requestDTO);
                } else {
                    baseResponse = this.coreGuaranteeApi.pushUwResultAndPayUrl(requestDTO);
                }
            } else {
                log.warn("\u65b0\u8d23\u4efb\u9669\u8c03\u5ba1\u6838\u7ed3\u679c\u548c\u4ea4\u8d39\u94fe\u63a5\u63a5\u53e3");
                baseResponse = this.litigationCoreGuaranteeApi.pushUwResultAndPayUrl(requestDTO, order);
            }
        } else if ("ZR-SSBQ-FY-2C".equals(order.getPlanCode())) {
            baseResponse = this.coreGuaranteeApi.pushUwResult(requestDTO);
        } else {
            log.warn("\u65b0\u8d23\u4efb\u9669\u8c03\u5ba1\u6838\u7ed3\u679c\u548c\u4ea4\u8d39\u94fe\u63a5\u63a5\u53e3");
            baseResponse = this.litigationCoreGuaranteeApi.pushUwResult(requestDTO, order);
        }
        return baseResponse;
    }

    private LitigationUwRequest beforeRequestProcess(LitigationUwResultMsgDTO msg, ApisBusiChannelOrder order) {
        LitigationUwRequest requestDTO = LitigationUwRequest.builder().build();
        requestDTO.setCDbid(order.getOrderNo());
        requestDTO.setNShjg(msg.getUnderwriteFlag());
        requestDTO.setCShyj(msg.getUnderwritemsg());
        requestDTO.setDtShsj(msg.getUnderwriteTime());
        if (BusinessConstants.UW_FLAG_Y.equals(msg.getUnderwriteFlag())) {
            LitigationPaymentUrlDTO litigationPaymentUrlDTO = LitigationPaymentUrlDTO.builder().orderNo(order.getOrderNo()).cPoint("2").build();
            StanderRequest standerRequest = StanderRequest.builder().header(StanderHeader.builder().build()).build();
            LitigationPaymentUrlRequest litigationPaymentUrlRequest = LitigationPaymentUrlRequest.builder().requestHead(RequestHeadDTO.initRequestHead()).requestBody(litigationPaymentUrlDTO).build();
            standerRequest.setLitigationPaymentUrlRequest(litigationPaymentUrlRequest);
            WebResponse webResponse = this.paymentService.wrapPaymentUrl(standerRequest);
            HashMap result = (HashMap)webResponse.getResult();
            CPayUrlDTO cPayUrlDTO = CPayUrlDTO.builder().cPoint(result.get("cPoint") instanceof String ? (String)result.get("cPoint") : null).expiry(result.get("expire") instanceof Date ? (Date)result.get("expire") : null).cPayUrl(result.get("payUrl") instanceof String ? (String)result.get("payUrl") : null).build();
            ArrayList<CPayUrlDTO> payUrlList = new ArrayList<CPayUrlDTO>();
            payUrlList.add(cPayUrlDTO);
            requestDTO.setCPayUrls(payUrlList);
        }
        return requestDTO;
    }

    private ApisBusiChannelOrder getUwResultOrder(LitigationUwResultMsgDTO msg) throws ApisBusinessException {
        ApisBusiChannelOrder order = null;
        if (ObjectUtil.isNotEmpty((Object)msg) && ObjectUtil.isNotEmpty((Object)msg.getPolicyNo())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"policy_no", (Object)msg.getPolicyNo());
            order = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
        } else if (ObjectUtil.isNotEmpty((Object)msg) && ObjectUtil.isNotEmpty((Object)msg.getProposalNo())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"proposal_no", (Object)msg.getProposalNo());
            order = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
        } else {
            log.error("\u8bc9\u8d23\u9669\u5ba1\u6838\u6d88\u606f\u63a8\u9001\u5931\u8d25-\u300b\u4fdd\u5355\u53f7\u4e3a\u7a7a\u3002");
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10005.getValue(), ChannelErrorCodeEnum.ERR_C10005.getKey());
        }
        return order;
    }

    private ApisBusiCorrectOrder getUwResultOrderEmp(LitigationUwResultMsgDTO msg) throws ApisBusinessException {
        ApisBusiCorrectOrder order = null;
        if (!ObjectUtil.isNotEmpty((Object)msg) || !ObjectUtil.isNotEmpty((Object)msg.getApplyNo())) {
            log.error("\u96c7\u4e3b\u8d23\u4efb\u9669\u5ba1\u6838\u6d88\u606f\u63a8\u9001\u5931\u8d25-\u300b\u6295\u4fdd\u5355\u53f7\u4e3a\u7a7a\u3002");
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10005.getValue(), ChannelErrorCodeEnum.ERR_C10005.getKey());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"policy_no", (Object)msg.getApplyNo());
        order = (ApisBusiCorrectOrder)this.apisBusiCorrectOrderService.getOne((Wrapper)queryWrapper);
        return order;
    }

    private ApisBusiChannelOrder getCorrectOrder(LitigationUwResultMsgDTO msg) throws ApisBusinessException {
        ApisBusiChannelOrder order = null;
        if (!ObjectUtil.isNotEmpty((Object)msg) || !ObjectUtil.isNotEmpty((Object)msg.getPolicyNo())) {
            log.error("\u8bc9\u8d23\u9669\u6279\u6539\u6d88\u606f\u63a8\u9001\u5931\u8d25-\u300b\u4fdd\u5355\u53f7\u4e3a\u7a7a\u3002");
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10005.getValue(), ChannelErrorCodeEnum.ERR_C10005.getKey());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"policy_no", (Object)msg.getPolicyNo());
        order = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
        return order;
    }

    private ApisBusiBudgetRequest getBudgetRequest(LitigationUwResultMsgDTO msg) throws ApisBusinessException {
        ApisBusiBudgetRequest budgetRequest = null;
        if (!ObjectUtil.isNotEmpty((Object)msg) || !ObjectUtil.isNotEmpty((Object)msg.getPolicyNo())) {
            log.error("\u8bc9\u8d23\u9669\u9884\u8bd5\u7b97\u6d88\u606f\u63a8\u9001\u5931\u8d25-\u300b\u4fdd\u5355\u53f7\u4e3a\u7a7a\u3002\u4fdd\u5355\u53f7\uff1a{}\uff0c \u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a{}", (Object)msg.getApplyNo(), (Object)msg.getConsumerSeqNo());
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10005.getValue(), ChannelErrorCodeEnum.ERR_C10005.getKey());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"policy_no", (Object)msg.getApplyNo());
        queryWrapper.eq((Object)"consumer_seq_no", (Object)msg.getConsumerSeqNo());
        queryWrapper.eq((Object)"deleted", (Object)0);
        budgetRequest = (ApisBusiBudgetRequest)this.apisBusiBudgetRequestService.getOne((Wrapper)queryWrapper);
        return budgetRequest;
    }

    private ApisBusiChannelOrder getOrder(LitigationUwResultMsgDTO msg) {
        ApisBusiChannelOrder order = null;
        if (ObjectUtil.isNotEmpty((Object)msg) && ObjectUtil.isNotEmpty((Object)msg.getPolicyNo())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"policy_no", (Object)msg.getPolicyNo());
            queryWrapper.eq((Object)"plan_code", (Object)"ZR-SSBQ-FY-2C");
            order = (ApisBusiChannelOrder)this.apisBusiChannelOrderService.getOne((Wrapper)queryWrapper);
        }
        return order;
    }
}

