/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.insureapp.jms;

import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.commons.model.msg.entity.ApisMsgMqlogs;
import com.jdaz.sinosoftgz.apis.commons.service.msg.service.ApisMsgMqlogsService;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.dto.message.PfpRationSyncDto;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.PfpMessageService;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@RocketMQMessageListener(topic="RationTopics", consumerGroup="ration")
public class PfpRationTopicsListener
implements RocketMQListener<String> {
    private static Logger log = LoggerFactory.getLogger(PfpRationTopicsListener.class);
    @Autowired
    PfpMessageService pfpMessageService;
    @Autowired
    ApisMsgMqlogsService apisMsgMqlogsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        log.warn("received ration message: {}", (Object)message);
        Date startDate = new Date();
        String flag = "0";
        try {
            PfpRationSyncDto dto = (PfpRationSyncDto)JSON.parseObject((String)message, PfpRationSyncDto.class);
            this.pfpMessageService.handleRationMsg(dto);
        }
        catch (Throwable e) {
            flag = "1";
            log.error("MQ\u6d88\u606f\u63a8\u9001\u5f02\u5e38=============", e);
        }
        finally {
            ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
            apisMsgMqlogs.setCreateTime(startDate);
            apisMsgMqlogs.setMessage(message);
            apisMsgMqlogs.setTopic("RationTopics");
            apisMsgMqlogs.setConsumerGroup("apis-insure-app");
            apisMsgMqlogs.setErrorFlag(flag);
            apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
            this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
        }
    }
}

